package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.CourseBlockAndAssignment;
import com.ustadmobile.lib.db.composites.CourseBlockAndDbEntities;
import com.ustadmobile.lib.db.composites.CourseBlockAndDisplayDetails;
import com.ustadmobile.lib.db.composites.CourseBlockAndGradebookDisplayDetails;
import com.ustadmobile.lib.db.composites.CourseBlockAndPicture;
import com.ustadmobile.lib.db.composites.CourseBlockUidAndClazzUid;
import com.ustadmobile.lib.db.entities.ClazzAssignment;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryPicture2;
import com.ustadmobile.lib.db.entities.CourseBlock;
import com.ustadmobile.lib.db.entities.CourseBlockPicture;
import com.ustadmobile.lib.db.entities.Language;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Float;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseBlockDao_Impl extends CourseBlockDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseBlock> __insertionAdapterOfCourseBlock;

  private final EntityInsertionAdapter<CourseBlock> __insertionAdapterOfCourseBlock_1;

  private final EntityDeletionOrUpdateAdapter<CourseBlock> __updateAdapterOfCourseBlock;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  private final SharedSQLiteStatement __preparedStmtOfUpdateFromLineItem;

  public CourseBlockDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseBlock = new EntityInsertionAdapter<CourseBlock>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `CourseBlock` (`cbUid`,`cbType`,`cbIndentLevel`,`cbModuleParentBlockUid`,`cbTitle`,`cbDescription`,`cbCompletionCriteria`,`cbHideUntilDate`,`cbDeadlineDate`,`cbLateSubmissionPenalty`,`cbGracePeriodDate`,`cbMaxPoints`,`cbMinPoints`,`cbIndex`,`cbClazzUid`,`cbClazzSourcedId`,`cbActive`,`cbHidden`,`cbEntityUid`,`cbLct`,`cbSourcedId`,`cbMetadata`,`cbCreatedByAppId`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseBlock entity) {
        statement.bindLong(1, entity.getCbUid());
        statement.bindLong(2, entity.getCbType());
        statement.bindLong(3, entity.getCbIndentLevel());
        statement.bindLong(4, entity.getCbModuleParentBlockUid());
        if (entity.getCbTitle() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getCbTitle());
        }
        if (entity.getCbDescription() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCbDescription());
        }
        statement.bindLong(7, entity.getCbCompletionCriteria());
        statement.bindLong(8, entity.getCbHideUntilDate());
        statement.bindLong(9, entity.getCbDeadlineDate());
        statement.bindLong(10, entity.getCbLateSubmissionPenalty());
        statement.bindLong(11, entity.getCbGracePeriodDate());
        if (entity.getCbMaxPoints() == null) {
          statement.bindNull(12);
        } else {
          statement.bindDouble(12, entity.getCbMaxPoints());
        }
        if (entity.getCbMinPoints() == null) {
          statement.bindNull(13);
        } else {
          statement.bindDouble(13, entity.getCbMinPoints());
        }
        statement.bindLong(14, entity.getCbIndex());
        statement.bindLong(15, entity.getCbClazzUid());
        if (entity.getCbClazzSourcedId() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getCbClazzSourcedId());
        }
        final int _tmp = entity.getCbActive() ? 1 : 0;
        statement.bindLong(17, _tmp);
        final int _tmp_1 = entity.getCbHidden() ? 1 : 0;
        statement.bindLong(18, _tmp_1);
        statement.bindLong(19, entity.getCbEntityUid());
        statement.bindLong(20, entity.getCbLct());
        if (entity.getCbSourcedId() == null) {
          statement.bindNull(21);
        } else {
          statement.bindString(21, entity.getCbSourcedId());
        }
        if (entity.getCbMetadata() == null) {
          statement.bindNull(22);
        } else {
          statement.bindString(22, entity.getCbMetadata());
        }
        if (entity.getCbCreatedByAppId() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getCbCreatedByAppId());
        }
      }
    };
    this.__insertionAdapterOfCourseBlock_1 = new EntityInsertionAdapter<CourseBlock>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `CourseBlock` (`cbUid`,`cbType`,`cbIndentLevel`,`cbModuleParentBlockUid`,`cbTitle`,`cbDescription`,`cbCompletionCriteria`,`cbHideUntilDate`,`cbDeadlineDate`,`cbLateSubmissionPenalty`,`cbGracePeriodDate`,`cbMaxPoints`,`cbMinPoints`,`cbIndex`,`cbClazzUid`,`cbClazzSourcedId`,`cbActive`,`cbHidden`,`cbEntityUid`,`cbLct`,`cbSourcedId`,`cbMetadata`,`cbCreatedByAppId`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseBlock entity) {
        statement.bindLong(1, entity.getCbUid());
        statement.bindLong(2, entity.getCbType());
        statement.bindLong(3, entity.getCbIndentLevel());
        statement.bindLong(4, entity.getCbModuleParentBlockUid());
        if (entity.getCbTitle() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getCbTitle());
        }
        if (entity.getCbDescription() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCbDescription());
        }
        statement.bindLong(7, entity.getCbCompletionCriteria());
        statement.bindLong(8, entity.getCbHideUntilDate());
        statement.bindLong(9, entity.getCbDeadlineDate());
        statement.bindLong(10, entity.getCbLateSubmissionPenalty());
        statement.bindLong(11, entity.getCbGracePeriodDate());
        if (entity.getCbMaxPoints() == null) {
          statement.bindNull(12);
        } else {
          statement.bindDouble(12, entity.getCbMaxPoints());
        }
        if (entity.getCbMinPoints() == null) {
          statement.bindNull(13);
        } else {
          statement.bindDouble(13, entity.getCbMinPoints());
        }
        statement.bindLong(14, entity.getCbIndex());
        statement.bindLong(15, entity.getCbClazzUid());
        if (entity.getCbClazzSourcedId() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getCbClazzSourcedId());
        }
        final int _tmp = entity.getCbActive() ? 1 : 0;
        statement.bindLong(17, _tmp);
        final int _tmp_1 = entity.getCbHidden() ? 1 : 0;
        statement.bindLong(18, _tmp_1);
        statement.bindLong(19, entity.getCbEntityUid());
        statement.bindLong(20, entity.getCbLct());
        if (entity.getCbSourcedId() == null) {
          statement.bindNull(21);
        } else {
          statement.bindString(21, entity.getCbSourcedId());
        }
        if (entity.getCbMetadata() == null) {
          statement.bindNull(22);
        } else {
          statement.bindString(22, entity.getCbMetadata());
        }
        if (entity.getCbCreatedByAppId() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getCbCreatedByAppId());
        }
      }
    };
    this.__updateAdapterOfCourseBlock = new EntityDeletionOrUpdateAdapter<CourseBlock>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `CourseBlock` SET `cbUid` = ?,`cbType` = ?,`cbIndentLevel` = ?,`cbModuleParentBlockUid` = ?,`cbTitle` = ?,`cbDescription` = ?,`cbCompletionCriteria` = ?,`cbHideUntilDate` = ?,`cbDeadlineDate` = ?,`cbLateSubmissionPenalty` = ?,`cbGracePeriodDate` = ?,`cbMaxPoints` = ?,`cbMinPoints` = ?,`cbIndex` = ?,`cbClazzUid` = ?,`cbClazzSourcedId` = ?,`cbActive` = ?,`cbHidden` = ?,`cbEntityUid` = ?,`cbLct` = ?,`cbSourcedId` = ?,`cbMetadata` = ?,`cbCreatedByAppId` = ? WHERE `cbUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseBlock entity) {
        statement.bindLong(1, entity.getCbUid());
        statement.bindLong(2, entity.getCbType());
        statement.bindLong(3, entity.getCbIndentLevel());
        statement.bindLong(4, entity.getCbModuleParentBlockUid());
        if (entity.getCbTitle() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getCbTitle());
        }
        if (entity.getCbDescription() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCbDescription());
        }
        statement.bindLong(7, entity.getCbCompletionCriteria());
        statement.bindLong(8, entity.getCbHideUntilDate());
        statement.bindLong(9, entity.getCbDeadlineDate());
        statement.bindLong(10, entity.getCbLateSubmissionPenalty());
        statement.bindLong(11, entity.getCbGracePeriodDate());
        if (entity.getCbMaxPoints() == null) {
          statement.bindNull(12);
        } else {
          statement.bindDouble(12, entity.getCbMaxPoints());
        }
        if (entity.getCbMinPoints() == null) {
          statement.bindNull(13);
        } else {
          statement.bindDouble(13, entity.getCbMinPoints());
        }
        statement.bindLong(14, entity.getCbIndex());
        statement.bindLong(15, entity.getCbClazzUid());
        if (entity.getCbClazzSourcedId() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getCbClazzSourcedId());
        }
        final int _tmp = entity.getCbActive() ? 1 : 0;
        statement.bindLong(17, _tmp);
        final int _tmp_1 = entity.getCbHidden() ? 1 : 0;
        statement.bindLong(18, _tmp_1);
        statement.bindLong(19, entity.getCbEntityUid());
        statement.bindLong(20, entity.getCbLct());
        if (entity.getCbSourcedId() == null) {
          statement.bindNull(21);
        } else {
          statement.bindString(21, entity.getCbSourcedId());
        }
        if (entity.getCbMetadata() == null) {
          statement.bindNull(22);
        } else {
          statement.bindString(22, entity.getCbMetadata());
        }
        if (entity.getCbCreatedByAppId() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getCbCreatedByAppId());
        }
        statement.bindLong(24, entity.getCbUid());
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CourseBlock \n"
                + "           SET cbActive = ?, \n"
                + "               cbLct = ?\n"
                + "         WHERE cbUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateFromLineItem = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CourseBlock\n"
                + "           SET cbActive = ?,\n"
                + "               cbLct = ?,\n"
                + "               cbTitle = ?,\n"
                + "               cbDescription = ?,\n"
                + "               cbHideUntilDate = ?,\n"
                + "               cbDeadlineDate = ?,\n"
                + "               cbMinPoints = ?,\n"
                + "               cbMaxPoints = ?\n"
                + "         WHERE cbUid = ?      \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final CourseBlock entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfCourseBlock.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseBlock entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfCourseBlock.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends CourseBlock> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseBlock.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends CourseBlock> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseBlock.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object replaceListAsync(final List<CourseBlock> list,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseBlock_1.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertListAsync(final List<CourseBlock> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseBlock_1.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final CourseBlock entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseBlock.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends CourseBlock> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfCourseBlock.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateAsync(final CourseBlock entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfCourseBlock.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateActiveByUid(final long cbUid, final boolean active, final long changeTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cbUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateActiveByUid.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object updateFromLineItem(final long cbUid, final boolean active,
      final long dateLastModified, final String title, final String description,
      final long assignDate, final long dueDate, final float resultValueMin,
      final float resultValueMax, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateFromLineItem.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, dateLastModified);
        _argIndex = 3;
        _stmt.bindString(_argIndex, title);
        _argIndex = 4;
        _stmt.bindString(_argIndex, description);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, assignDate);
        _argIndex = 6;
        _stmt.bindLong(_argIndex, dueDate);
        _argIndex = 7;
        _stmt.bindDouble(_argIndex, resultValueMin);
        _argIndex = 8;
        _stmt.bindDouble(_argIndex, resultValueMax);
        _argIndex = 9;
        _stmt.bindLong(_argIndex, cbUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateFromLineItem.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super CourseBlock> $completion) {
    final String _sql = "SELECT * FROM CourseBlock WHERE cbUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseBlock>() {
      @Override
      @Nullable
      public CourseBlock call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final CourseBlock _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCbUid;
            _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
            final int _tmpCbType;
            _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
            final int _tmpCbIndentLevel;
            _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
            final long _tmpCbModuleParentBlockUid;
            _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
            final String _tmpCbTitle;
            if (_cursor.isNull(_cursorIndexOfCbTitle)) {
              _tmpCbTitle = null;
            } else {
              _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
            }
            final String _tmpCbDescription;
            if (_cursor.isNull(_cursorIndexOfCbDescription)) {
              _tmpCbDescription = null;
            } else {
              _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
            }
            final int _tmpCbCompletionCriteria;
            _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
            final long _tmpCbHideUntilDate;
            _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
            final long _tmpCbDeadlineDate;
            _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
            final int _tmpCbLateSubmissionPenalty;
            _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
            final long _tmpCbGracePeriodDate;
            _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
            final Float _tmpCbMaxPoints;
            if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
              _tmpCbMaxPoints = null;
            } else {
              _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
            }
            final Float _tmpCbMinPoints;
            if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
              _tmpCbMinPoints = null;
            } else {
              _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
            }
            final int _tmpCbIndex;
            _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
            final long _tmpCbClazzUid;
            _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
            final String _tmpCbClazzSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
              _tmpCbClazzSourcedId = null;
            } else {
              _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
            }
            final boolean _tmpCbActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCbActive);
            _tmpCbActive = _tmp != 0;
            final boolean _tmpCbHidden;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
            _tmpCbHidden = _tmp_1 != 0;
            final long _tmpCbEntityUid;
            _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
            final long _tmpCbLct;
            _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
            final String _tmpCbSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
              _tmpCbSourcedId = null;
            } else {
              _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
            }
            final String _tmpCbMetadata;
            if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
              _tmpCbMetadata = null;
            } else {
              _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
            }
            final String _tmpCbCreatedByAppId;
            if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
              _tmpCbCreatedByAppId = null;
            } else {
              _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
            }
            _result = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object existsByUid(final long cbUid, final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT EXISTS(\n"
            + "               SELECT CourseBlock.cbUid\n"
            + "                 FROM CourseBlock\n"
            + "                WHERE CourseBlock.cbUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, cbUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<CourseBlock> findByUidAsyncAsFlow(final long uid) {
    final String _sql = "SELECT * FROM CourseBlock WHERE cbUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseBlock"}, new Callable<CourseBlock>() {
      @Override
      @Nullable
      public CourseBlock call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final CourseBlock _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCbUid;
            _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
            final int _tmpCbType;
            _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
            final int _tmpCbIndentLevel;
            _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
            final long _tmpCbModuleParentBlockUid;
            _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
            final String _tmpCbTitle;
            if (_cursor.isNull(_cursorIndexOfCbTitle)) {
              _tmpCbTitle = null;
            } else {
              _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
            }
            final String _tmpCbDescription;
            if (_cursor.isNull(_cursorIndexOfCbDescription)) {
              _tmpCbDescription = null;
            } else {
              _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
            }
            final int _tmpCbCompletionCriteria;
            _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
            final long _tmpCbHideUntilDate;
            _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
            final long _tmpCbDeadlineDate;
            _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
            final int _tmpCbLateSubmissionPenalty;
            _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
            final long _tmpCbGracePeriodDate;
            _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
            final Float _tmpCbMaxPoints;
            if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
              _tmpCbMaxPoints = null;
            } else {
              _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
            }
            final Float _tmpCbMinPoints;
            if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
              _tmpCbMinPoints = null;
            } else {
              _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
            }
            final int _tmpCbIndex;
            _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
            final long _tmpCbClazzUid;
            _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
            final String _tmpCbClazzSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
              _tmpCbClazzSourcedId = null;
            } else {
              _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
            }
            final boolean _tmpCbActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCbActive);
            _tmpCbActive = _tmp != 0;
            final boolean _tmpCbHidden;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
            _tmpCbHidden = _tmp_1 != 0;
            final long _tmpCbEntityUid;
            _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
            final long _tmpCbLct;
            _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
            final String _tmpCbSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
              _tmpCbSourcedId = null;
            } else {
              _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
            }
            final String _tmpCbMetadata;
            if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
              _tmpCbMetadata = null;
            } else {
              _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
            }
            final String _tmpCbCreatedByAppId;
            if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
              _tmpCbCreatedByAppId = null;
            } else {
              _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
            }
            _result = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<CourseBlockAndPicture> findByUidWithPictureAsFlow(final long uid) {
    final String _sql = "\n"
            + "        SELECT CourseBlock.*, CourseBlockPicture.*\n"
            + "          FROM CourseBlock\n"
            + "               LEFT JOIN CourseBlockPicture \n"
            + "                         ON CourseBlockPicture.cbpUid = ?\n"
            + "         WHERE CourseBlock.cbUid = ?                \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseBlock",
        "CourseBlockPicture"}, new Callable<CourseBlockAndPicture>() {
      @Override
      @Nullable
      public CourseBlockAndPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpUid");
          final int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpLct");
          final int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpPictureUri");
          final int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpThumbnailUri");
          final CourseBlockAndPicture _result;
          if (_cursor.moveToFirst()) {
            final CourseBlock _tmpBlock;
            if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
              final long _tmpCbUid;
              _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
              final int _tmpCbType;
              _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (_cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
              }
              final String _tmpCbDescription;
              if (_cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
              }
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              final Float _tmpCbMaxPoints;
              if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
                _tmpCbMaxPoints = null;
              } else {
                _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
              }
              final Float _tmpCbMinPoints;
              if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
                _tmpCbMinPoints = null;
              } else {
                _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
              }
              final int _tmpCbIndex;
              _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
              final String _tmpCbClazzSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
                _tmpCbClazzSourcedId = null;
              } else {
                _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
              }
              final boolean _tmpCbActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp != 0;
              final boolean _tmpCbHidden;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_1 != 0;
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
              final String _tmpCbSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
                _tmpCbSourcedId = null;
              } else {
                _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
              }
              final String _tmpCbMetadata;
              if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
                _tmpCbMetadata = null;
              } else {
                _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
              }
              final String _tmpCbCreatedByAppId;
              if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
                _tmpCbCreatedByAppId = null;
              } else {
                _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
              }
              _tmpBlock = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
            } else {
              _tmpBlock = null;
            }
            final CourseBlockPicture _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
              final long _tmpCbpUid;
              _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
              final long _tmpCbpLct;
              _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
              final String _tmpCbpPictureUri;
              if (_cursor.isNull(_cursorIndexOfCbpPictureUri)) {
                _tmpCbpPictureUri = null;
              } else {
                _tmpCbpPictureUri = _cursor.getString(_cursorIndexOfCbpPictureUri);
              }
              final String _tmpCbpThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCbpThumbnailUri)) {
                _tmpCbpThumbnailUri = null;
              } else {
                _tmpCbpThumbnailUri = _cursor.getString(_cursorIndexOfCbpThumbnailUri);
              }
              _tmpPicture = new CourseBlockPicture(_tmpCbpUid,_tmpCbpLct,_tmpCbpPictureUri,_tmpCbpThumbnailUri);
            } else {
              _tmpPicture = null;
            }
            _result = new CourseBlockAndPicture(_tmpBlock,_tmpPicture);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findAllCourseBlockByClazzUidAsync(final long clazzUid,
      final boolean includeInactive,
      final Continuation<? super List<CourseBlockAndDbEntities>> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseBlock.*, Assignment.*, Entry.*, Language.*, CourseBlockPicture.*,\n"
            + "               (SELECT CourseGroupSet.cgsName\n"
            + "                  FROM CourseGroupSet\n"
            + "                 WHERE CourseBlock.cbType = 103\n"
            + "                   AND assignment.caGroupUid != 0\n"
            + "                   AND CourseGroupSet.cgsUid = assignment.caGroupUid) AS assignmentCourseGroupSetName\n"
            + "          FROM CourseBlock \n"
            + "               LEFT JOIN ClazzAssignment AS Assignment\n"
            + "                         ON assignment.caUid = CourseBlock.cbEntityUid\n"
            + "                            AND CourseBlock.cbType = 103\n"
            + "               LEFT JOIN ContentEntry AS Entry\n"
            + "                         ON entry.contentEntryUid = CourseBlock.cbEntityUid\n"
            + "                            AND CourseBlock.cbType = 104\n"
            + "               LEFT JOIN Language\n"
            + "                         ON Language.langUid = Entry.primaryLanguageUid\n"
            + "                            AND CourseBlock.cbType = 104\n"
            + "               LEFT JOIN CourseBlockPicture\n"
            + "                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    \n"
            + "         WHERE CourseBlock.cbClazzUid = ?\n"
            + "           AND (CAST(? AS INTEGER) = 1 OR CourseBlock.cbActive)\n"
            + "           AND (CourseBlock.cbType != 300)\n"
            + "      ORDER BY CourseBlock.cbIndex\n"
            + "          ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    final int _tmp = includeInactive ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseBlockAndDbEntities>>() {
      @Override
      @NonNull
      public List<CourseBlockAndDbEntities> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpUid");
          final int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpLct");
          final int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpPictureUri");
          final int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpThumbnailUri");
          final int _cursorIndexOfAssignmentCourseGroupSetName = CursorUtil.getColumnIndexOrThrow(_cursor, "assignmentCourseGroupSetName");
          final List<CourseBlockAndDbEntities> _result = new ArrayList<CourseBlockAndDbEntities>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseBlockAndDbEntities _item;
            final String _tmpAssignmentCourseGroupSetName;
            if (_cursor.isNull(_cursorIndexOfAssignmentCourseGroupSetName)) {
              _tmpAssignmentCourseGroupSetName = null;
            } else {
              _tmpAssignmentCourseGroupSetName = _cursor.getString(_cursorIndexOfAssignmentCourseGroupSetName);
            }
            final CourseBlock _tmpCourseBlock;
            if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
              final long _tmpCbUid;
              _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
              final int _tmpCbType;
              _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (_cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
              }
              final String _tmpCbDescription;
              if (_cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
              }
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              final Float _tmpCbMaxPoints;
              if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
                _tmpCbMaxPoints = null;
              } else {
                _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
              }
              final Float _tmpCbMinPoints;
              if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
                _tmpCbMinPoints = null;
              } else {
                _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
              }
              final int _tmpCbIndex;
              _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
              final String _tmpCbClazzSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
                _tmpCbClazzSourcedId = null;
              } else {
                _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
              }
              final boolean _tmpCbActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp_1 != 0;
              final boolean _tmpCbHidden;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_2 != 0;
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
              final String _tmpCbSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
                _tmpCbSourcedId = null;
              } else {
                _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
              }
              final String _tmpCbMetadata;
              if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
                _tmpCbMetadata = null;
              } else {
                _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
              }
              final String _tmpCbCreatedByAppId;
              if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
                _tmpCbCreatedByAppId = null;
              } else {
                _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
              }
              _tmpCourseBlock = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
            } else {
              _tmpCourseBlock = null;
            }
            final ClazzAssignment _tmpAssignment;
            if (!(_cursor.isNull(_cursorIndexOfCaUid) && _cursor.isNull(_cursorIndexOfCaTitle) && _cursor.isNull(_cursorIndexOfCaDescription) && _cursor.isNull(_cursorIndexOfCaGroupUid) && _cursor.isNull(_cursorIndexOfCaActive) && _cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && _cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && _cursor.isNull(_cursorIndexOfCaCompletionCriteria) && _cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && _cursor.isNull(_cursorIndexOfCaFileType) && _cursor.isNull(_cursorIndexOfCaSizeLimit) && _cursor.isNull(_cursorIndexOfCaNumberOfFiles) && _cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && _cursor.isNull(_cursorIndexOfCaMarkingType) && _cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && _cursor.isNull(_cursorIndexOfCaTextLimitType) && _cursor.isNull(_cursorIndexOfCaTextLimit) && _cursor.isNull(_cursorIndexOfCaXObjectUid) && _cursor.isNull(_cursorIndexOfCaClazzUid) && _cursor.isNull(_cursorIndexOfCaPeerReviewerCount) && _cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaLastChangedBy) && _cursor.isNull(_cursorIndexOfCaLct))) {
              final long _tmpCaUid;
              _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
              final String _tmpCaTitle;
              if (_cursor.isNull(_cursorIndexOfCaTitle)) {
                _tmpCaTitle = null;
              } else {
                _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
              }
              final String _tmpCaDescription;
              if (_cursor.isNull(_cursorIndexOfCaDescription)) {
                _tmpCaDescription = null;
              } else {
                _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
              }
              final long _tmpCaGroupUid;
              _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
              final boolean _tmpCaActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCaActive);
              _tmpCaActive = _tmp_3 != 0;
              final boolean _tmpCaClassCommentEnabled;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
              _tmpCaClassCommentEnabled = _tmp_4 != 0;
              final boolean _tmpCaPrivateCommentsEnabled;
              final int _tmp_5;
              _tmp_5 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
              _tmpCaPrivateCommentsEnabled = _tmp_5 != 0;
              final int _tmpCaCompletionCriteria;
              _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
              final boolean _tmpCaRequireFileSubmission;
              final int _tmp_6;
              _tmp_6 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
              _tmpCaRequireFileSubmission = _tmp_6 != 0;
              final int _tmpCaFileType;
              _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
              final int _tmpCaSizeLimit;
              _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
              final int _tmpCaNumberOfFiles;
              _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
              final int _tmpCaSubmissionPolicy;
              _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
              final int _tmpCaMarkingType;
              _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
              final boolean _tmpCaRequireTextSubmission;
              final int _tmp_7;
              _tmp_7 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
              _tmpCaRequireTextSubmission = _tmp_7 != 0;
              final int _tmpCaTextLimitType;
              _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
              final int _tmpCaTextLimit;
              _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
              final long _tmpCaXObjectUid;
              _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
              final long _tmpCaClazzUid;
              _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
              final int _tmpCaPeerReviewerCount;
              _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
              final long _tmpCaLocalChangeSeqNum;
              _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
              final long _tmpCaMasterChangeSeqNum;
              _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
              final int _tmpCaLastChangedBy;
              _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
              final long _tmpCaLct;
              _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
              _tmpAssignment = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
            } else {
              _tmpAssignment = null;
            }
            final ContentEntry _tmpContentEntry;
            if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
              _tmpContentEntry = new ContentEntry();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
              _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (_cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
              }
              _tmpContentEntry.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (_cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
              }
              _tmpContentEntry.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (_cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
              }
              _tmpContentEntry.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (_cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
              }
              _tmpContentEntry.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (_cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
              }
              _tmpContentEntry.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
              _tmpContentEntry.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (_cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
              }
              _tmpContentEntry.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
              }
              _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
              _tmpContentEntry.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
              _tmpContentEntry.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp_8;
              _tmp_8 = _cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp_8 != 0;
              _tmpContentEntry.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_9;
              _tmp_9 = _cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_9 != 0;
              _tmpContentEntry.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_10;
              _tmp_10 = _cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_10 != 0;
              _tmpContentEntry.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
              _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
              _tmpContentEntry.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
              _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
              _tmpContentEntry.setContentOwner(_tmpContentOwner);
              final int _tmpContentOwnerType;
              _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
              _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
              _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
            } else {
              _tmpContentEntry = null;
            }
            final Language _tmpContentEntryLang;
            if (!(_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
              _tmpContentEntryLang = new Language();
              final long _tmpLangUid;
              _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
              _tmpContentEntryLang.setLangUid(_tmpLangUid);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              _tmpContentEntryLang.setName(_tmpName);
              final String _tmpIso_639_1_standard;
              if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
                _tmpIso_639_1_standard = null;
              } else {
                _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
              }
              _tmpContentEntryLang.setIso_639_1_standard(_tmpIso_639_1_standard);
              final String _tmpIso_639_2_standard;
              if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
                _tmpIso_639_2_standard = null;
              } else {
                _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
              }
              _tmpContentEntryLang.setIso_639_2_standard(_tmpIso_639_2_standard);
              final String _tmpIso_639_3_standard;
              if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
                _tmpIso_639_3_standard = null;
              } else {
                _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
              }
              _tmpContentEntryLang.setIso_639_3_standard(_tmpIso_639_3_standard);
              final String _tmpLanguage_Type;
              if (_cursor.isNull(_cursorIndexOfLanguageType)) {
                _tmpLanguage_Type = null;
              } else {
                _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
              }
              _tmpContentEntryLang.setLanguage_Type(_tmpLanguage_Type);
              final boolean _tmpLanguageActive;
              final int _tmp_11;
              _tmp_11 = _cursor.getInt(_cursorIndexOfLanguageActive);
              _tmpLanguageActive = _tmp_11 != 0;
              _tmpContentEntryLang.setLanguageActive(_tmpLanguageActive);
              final long _tmpLangLocalChangeSeqNum;
              _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
              _tmpContentEntryLang.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
              final long _tmpLangMasterChangeSeqNum;
              _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
              _tmpContentEntryLang.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
              final int _tmpLangLastChangedBy;
              _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
              _tmpContentEntryLang.setLangLastChangedBy(_tmpLangLastChangedBy);
              final long _tmpLangLct;
              _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
              _tmpContentEntryLang.setLangLct(_tmpLangLct);
            } else {
              _tmpContentEntryLang = null;
            }
            final CourseBlockPicture _tmpCourseBlockPicture;
            if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
              final long _tmpCbpUid;
              _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
              final long _tmpCbpLct;
              _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
              final String _tmpCbpPictureUri;
              if (_cursor.isNull(_cursorIndexOfCbpPictureUri)) {
                _tmpCbpPictureUri = null;
              } else {
                _tmpCbpPictureUri = _cursor.getString(_cursorIndexOfCbpPictureUri);
              }
              final String _tmpCbpThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCbpThumbnailUri)) {
                _tmpCbpThumbnailUri = null;
              } else {
                _tmpCbpThumbnailUri = _cursor.getString(_cursorIndexOfCbpThumbnailUri);
              }
              _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid,_tmpCbpLct,_tmpCbpPictureUri,_tmpCbpThumbnailUri);
            } else {
              _tmpCourseBlockPicture = null;
            }
            _item = new CourseBlockAndDbEntities(_tmpCourseBlock,_tmpCourseBlockPicture,_tmpContentEntry,_tmpContentEntryLang,_tmpAssignment,_tmpAssignmentCourseGroupSetName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<CourseBlockAndDisplayDetails>> findAllCourseBlockByClazzUidAsFlow(
      final long clazzUid, final boolean includeInactive, final boolean includeHidden,
      final long hideUntilFilterTime, final long accountPersonUid) {
    final String _sql = "\n"
            + "        SELECT CourseBlock.*, ContentEntry.*, CourseBlockPicture.*, ContentEntryPicture2.*\n"
            + "          FROM CourseBlock\n"
            + "               LEFT JOIN ContentEntry\n"
            + "                         ON CourseBlock.cbType = 104\n"
            + "                            AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n"
            + "               LEFT JOIN CourseBlockPicture\n"
            + "                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    \n"
            + "               LEFT JOIN ContentEntryPicture2\n"
            + "                         ON CourseBlock.cbType = 104\n"
            + "                            AND ContentEntryPicture2.cepUid = CourseBlock.cbEntityUid\n"
            + "         WHERE CourseBlock.cbClazzUid = ?\n"
            + "           AND (CAST(? AS INTEGER) = 1 OR CourseBlock.cbActive)\n"
            + "           AND (CAST(? AS INTEGER) = 1 OR NOT CourseBlock.cbHidden)\n"
            + "           AND (? >= CourseBlock.cbHideUntilDate)\n"
            + "           AND (? >= COALESCE(\n"
            + "                (SELECT CourseBlockParent.cbHideUntilDate\n"
            + "                   FROM CourseBlock CourseBlockParent\n"
            + "                  WHERE CourseBlockParent.cbUid = CourseBlock.cbModuleParentBlockUid), 0))\n"
            + "           AND (CourseBlock.cbType != 300)\n"
            + "           AND ? = ?        \n"
            + "      ORDER BY CourseBlock.cbIndex       \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 7);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    final int _tmp = includeInactive ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 3;
    final int _tmp_1 = includeHidden ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp_1);
    _argIndex = 4;
    _statement.bindLong(_argIndex, hideUntilFilterTime);
    _argIndex = 5;
    _statement.bindLong(_argIndex, hideUntilFilterTime);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseBlock", "ContentEntry",
        "CourseBlockPicture",
        "ContentEntryPicture2"}, new Callable<List<CourseBlockAndDisplayDetails>>() {
      @Override
      @NonNull
      public List<CourseBlockAndDisplayDetails> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpUid");
          final int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpLct");
          final int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpPictureUri");
          final int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpThumbnailUri");
          final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUid");
          final int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepLct");
          final int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepPictureUri");
          final int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepThumbnailUri");
          final List<CourseBlockAndDisplayDetails> _result = new ArrayList<CourseBlockAndDisplayDetails>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseBlockAndDisplayDetails _item;
            final CourseBlock _tmpCourseBlock;
            if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
              final long _tmpCbUid;
              _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
              final int _tmpCbType;
              _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (_cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
              }
              final String _tmpCbDescription;
              if (_cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
              }
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              final Float _tmpCbMaxPoints;
              if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
                _tmpCbMaxPoints = null;
              } else {
                _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
              }
              final Float _tmpCbMinPoints;
              if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
                _tmpCbMinPoints = null;
              } else {
                _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
              }
              final int _tmpCbIndex;
              _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
              final String _tmpCbClazzSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
                _tmpCbClazzSourcedId = null;
              } else {
                _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
              }
              final boolean _tmpCbActive;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp_2 != 0;
              final boolean _tmpCbHidden;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_3 != 0;
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
              final String _tmpCbSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
                _tmpCbSourcedId = null;
              } else {
                _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
              }
              final String _tmpCbMetadata;
              if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
                _tmpCbMetadata = null;
              } else {
                _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
              }
              final String _tmpCbCreatedByAppId;
              if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
                _tmpCbCreatedByAppId = null;
              } else {
                _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
              }
              _tmpCourseBlock = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
            } else {
              _tmpCourseBlock = null;
            }
            final ContentEntry _tmpContentEntry;
            if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
              _tmpContentEntry = new ContentEntry();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
              _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (_cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
              }
              _tmpContentEntry.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (_cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
              }
              _tmpContentEntry.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (_cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
              }
              _tmpContentEntry.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (_cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
              }
              _tmpContentEntry.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (_cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
              }
              _tmpContentEntry.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
              _tmpContentEntry.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (_cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
              }
              _tmpContentEntry.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
              }
              _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
              _tmpContentEntry.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
              _tmpContentEntry.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp_4 != 0;
              _tmpContentEntry.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_5;
              _tmp_5 = _cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_5 != 0;
              _tmpContentEntry.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_6;
              _tmp_6 = _cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_6 != 0;
              _tmpContentEntry.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
              _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
              _tmpContentEntry.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
              _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
              _tmpContentEntry.setContentOwner(_tmpContentOwner);
              final int _tmpContentOwnerType;
              _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
              _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
              _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
            } else {
              _tmpContentEntry = null;
            }
            final CourseBlockPicture _tmpCourseBlockPicture;
            if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
              final long _tmpCbpUid;
              _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
              final long _tmpCbpLct;
              _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
              final String _tmpCbpPictureUri;
              if (_cursor.isNull(_cursorIndexOfCbpPictureUri)) {
                _tmpCbpPictureUri = null;
              } else {
                _tmpCbpPictureUri = _cursor.getString(_cursorIndexOfCbpPictureUri);
              }
              final String _tmpCbpThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCbpThumbnailUri)) {
                _tmpCbpThumbnailUri = null;
              } else {
                _tmpCbpThumbnailUri = _cursor.getString(_cursorIndexOfCbpThumbnailUri);
              }
              _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid,_tmpCbpLct,_tmpCbpPictureUri,_tmpCbpThumbnailUri);
            } else {
              _tmpCourseBlockPicture = null;
            }
            final ContentEntryPicture2 _tmpContentEntryPicture2;
            if (!(_cursor.isNull(_cursorIndexOfCepUid) && _cursor.isNull(_cursorIndexOfCepLct) && _cursor.isNull(_cursorIndexOfCepPictureUri) && _cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
              final long _tmpCepUid;
              _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
              final long _tmpCepLct;
              _tmpCepLct = _cursor.getLong(_cursorIndexOfCepLct);
              final String _tmpCepPictureUri;
              if (_cursor.isNull(_cursorIndexOfCepPictureUri)) {
                _tmpCepPictureUri = null;
              } else {
                _tmpCepPictureUri = _cursor.getString(_cursorIndexOfCepPictureUri);
              }
              final String _tmpCepThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCepThumbnailUri)) {
                _tmpCepThumbnailUri = null;
              } else {
                _tmpCepThumbnailUri = _cursor.getString(_cursorIndexOfCepThumbnailUri);
              }
              _tmpContentEntryPicture2 = new ContentEntryPicture2(_tmpCepUid,_tmpCepLct,_tmpCepPictureUri,_tmpCepThumbnailUri);
            } else {
              _tmpContentEntryPicture2 = null;
            }
            _item = new CourseBlockAndDisplayDetails(_tmpCourseBlock,_tmpCourseBlockPicture,_tmpContentEntry,_tmpContentEntryPicture2);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public PagingSource<Integer, CourseBlockAndDisplayDetails> findAllCourseBlockByClazzUidAsPagingSource(
      final long clazzUid, final List<Long> collapseList, final boolean includeInactive,
      final boolean includeHidden, final long hideUntilFilterTime, final long accountPersonUid) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT CourseBlock.*, ContentEntry.*, CourseBlockPicture.*, ContentEntryPicture2.*,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CourseBlock.cbUid NOT IN(");
    final int _inputSize = collapseList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(") AS expanded");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM CourseBlock");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN ContentEntry");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON CourseBlock.cbType = 104");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN CourseBlockPicture");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN ContentEntryPicture2");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON CourseBlock.cbType = 104");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            AND ContentEntryPicture2.cepUid = CourseBlock.cbEntityUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE CourseBlock.cbClazzUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND CourseBlock.cbModuleParentBlockUid NOT IN(");
    final int _inputSize_1 = collapseList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize_1);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (CAST(");
    _stringBuilder.append("?");
    _stringBuilder.append(" AS INTEGER) = 1 OR CourseBlock.cbActive)");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (CAST(");
    _stringBuilder.append("?");
    _stringBuilder.append(" AS INTEGER) = 1 OR NOT CourseBlock.cbHidden)");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" >= CourseBlock.cbHideUntilDate)");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("?");
    _stringBuilder.append(" >= COALESCE(");
    _stringBuilder.append("\n");
    _stringBuilder.append("                (SELECT CourseBlockParent.cbHideUntilDate");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   FROM CourseBlock CourseBlockParent");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  WHERE CourseBlockParent.cbUid = CourseBlock.cbModuleParentBlockUid), 0))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (CourseBlock.cbType != 300) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = ");
    _stringBuilder.append("?");
    _stringBuilder.append("       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("      ORDER BY CourseBlock.cbIndex       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 7 + _inputSize + _inputSize_1;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : collapseList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    _argIndex = 1 + _inputSize;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2 + _inputSize;
    for (long _item_1 : collapseList) {
      _statement.bindLong(_argIndex, _item_1);
      _argIndex++;
    }
    _argIndex = 2 + _inputSize + _inputSize;
    final int _tmp = includeInactive ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 3 + _inputSize + _inputSize;
    final int _tmp_1 = includeHidden ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp_1);
    _argIndex = 4 + _inputSize + _inputSize;
    _statement.bindLong(_argIndex, hideUntilFilterTime);
    _argIndex = 5 + _inputSize + _inputSize;
    _statement.bindLong(_argIndex, hideUntilFilterTime);
    _argIndex = 6 + _inputSize + _inputSize;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7 + _inputSize + _inputSize;
    _statement.bindLong(_argIndex, accountPersonUid);
    return new LimitOffsetPagingSource<CourseBlockAndDisplayDetails>(_statement, __db, "CourseBlock", "ContentEntry", "CourseBlockPicture", "ContentEntryPicture2") {
      @Override
      @NonNull
      protected List<CourseBlockAndDisplayDetails> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(cursor, "cbUid");
        final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(cursor, "cbType");
        final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(cursor, "cbIndentLevel");
        final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(cursor, "cbModuleParentBlockUid");
        final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(cursor, "cbTitle");
        final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(cursor, "cbDescription");
        final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "cbCompletionCriteria");
        final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(cursor, "cbHideUntilDate");
        final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(cursor, "cbDeadlineDate");
        final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(cursor, "cbLateSubmissionPenalty");
        final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(cursor, "cbGracePeriodDate");
        final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(cursor, "cbMaxPoints");
        final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(cursor, "cbMinPoints");
        final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(cursor, "cbIndex");
        final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "cbClazzUid");
        final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(cursor, "cbClazzSourcedId");
        final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(cursor, "cbActive");
        final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(cursor, "cbHidden");
        final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "cbEntityUid");
        final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(cursor, "cbLct");
        final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(cursor, "cbSourcedId");
        final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(cursor, "cbMetadata");
        final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(cursor, "cbCreatedByAppId");
        final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
        final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
        final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
        final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
        final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
        final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
        final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
        final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
        final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
        final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
        final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
        final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
        final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
        final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
        final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
        final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
        final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
        final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
        final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
        final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
        final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
        final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
        final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwnerType");
        final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
        final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
        final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
        final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
        final int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow(cursor, "cbpUid");
        final int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow(cursor, "cbpLct");
        final int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "cbpPictureUri");
        final int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "cbpThumbnailUri");
        final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepUid");
        final int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepLct");
        final int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "cepPictureUri");
        final int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "cepThumbnailUri");
        final List<CourseBlockAndDisplayDetails> _result = new ArrayList<CourseBlockAndDisplayDetails>(cursor.getCount());
        while (cursor.moveToNext()) {
          final CourseBlockAndDisplayDetails _item_2;
          final CourseBlock _tmpCourseBlock;
          if (!(cursor.isNull(_cursorIndexOfCbUid) && cursor.isNull(_cursorIndexOfCbType) && cursor.isNull(_cursorIndexOfCbIndentLevel) && cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && cursor.isNull(_cursorIndexOfCbTitle) && cursor.isNull(_cursorIndexOfCbDescription) && cursor.isNull(_cursorIndexOfCbCompletionCriteria) && cursor.isNull(_cursorIndexOfCbHideUntilDate) && cursor.isNull(_cursorIndexOfCbDeadlineDate) && cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && cursor.isNull(_cursorIndexOfCbGracePeriodDate) && cursor.isNull(_cursorIndexOfCbMaxPoints) && cursor.isNull(_cursorIndexOfCbMinPoints) && cursor.isNull(_cursorIndexOfCbIndex) && cursor.isNull(_cursorIndexOfCbClazzUid) && cursor.isNull(_cursorIndexOfCbClazzSourcedId) && cursor.isNull(_cursorIndexOfCbActive) && cursor.isNull(_cursorIndexOfCbHidden) && cursor.isNull(_cursorIndexOfCbEntityUid) && cursor.isNull(_cursorIndexOfCbLct) && cursor.isNull(_cursorIndexOfCbSourcedId) && cursor.isNull(_cursorIndexOfCbMetadata) && cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
            final long _tmpCbUid;
            _tmpCbUid = cursor.getLong(_cursorIndexOfCbUid);
            final int _tmpCbType;
            _tmpCbType = cursor.getInt(_cursorIndexOfCbType);
            final int _tmpCbIndentLevel;
            _tmpCbIndentLevel = cursor.getInt(_cursorIndexOfCbIndentLevel);
            final long _tmpCbModuleParentBlockUid;
            _tmpCbModuleParentBlockUid = cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
            final String _tmpCbTitle;
            if (cursor.isNull(_cursorIndexOfCbTitle)) {
              _tmpCbTitle = null;
            } else {
              _tmpCbTitle = cursor.getString(_cursorIndexOfCbTitle);
            }
            final String _tmpCbDescription;
            if (cursor.isNull(_cursorIndexOfCbDescription)) {
              _tmpCbDescription = null;
            } else {
              _tmpCbDescription = cursor.getString(_cursorIndexOfCbDescription);
            }
            final int _tmpCbCompletionCriteria;
            _tmpCbCompletionCriteria = cursor.getInt(_cursorIndexOfCbCompletionCriteria);
            final long _tmpCbHideUntilDate;
            _tmpCbHideUntilDate = cursor.getLong(_cursorIndexOfCbHideUntilDate);
            final long _tmpCbDeadlineDate;
            _tmpCbDeadlineDate = cursor.getLong(_cursorIndexOfCbDeadlineDate);
            final int _tmpCbLateSubmissionPenalty;
            _tmpCbLateSubmissionPenalty = cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
            final long _tmpCbGracePeriodDate;
            _tmpCbGracePeriodDate = cursor.getLong(_cursorIndexOfCbGracePeriodDate);
            final Float _tmpCbMaxPoints;
            if (cursor.isNull(_cursorIndexOfCbMaxPoints)) {
              _tmpCbMaxPoints = null;
            } else {
              _tmpCbMaxPoints = cursor.getFloat(_cursorIndexOfCbMaxPoints);
            }
            final Float _tmpCbMinPoints;
            if (cursor.isNull(_cursorIndexOfCbMinPoints)) {
              _tmpCbMinPoints = null;
            } else {
              _tmpCbMinPoints = cursor.getFloat(_cursorIndexOfCbMinPoints);
            }
            final int _tmpCbIndex;
            _tmpCbIndex = cursor.getInt(_cursorIndexOfCbIndex);
            final long _tmpCbClazzUid;
            _tmpCbClazzUid = cursor.getLong(_cursorIndexOfCbClazzUid);
            final String _tmpCbClazzSourcedId;
            if (cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
              _tmpCbClazzSourcedId = null;
            } else {
              _tmpCbClazzSourcedId = cursor.getString(_cursorIndexOfCbClazzSourcedId);
            }
            final boolean _tmpCbActive;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfCbActive);
            _tmpCbActive = _tmp_2 != 0;
            final boolean _tmpCbHidden;
            final int _tmp_3;
            _tmp_3 = cursor.getInt(_cursorIndexOfCbHidden);
            _tmpCbHidden = _tmp_3 != 0;
            final long _tmpCbEntityUid;
            _tmpCbEntityUid = cursor.getLong(_cursorIndexOfCbEntityUid);
            final long _tmpCbLct;
            _tmpCbLct = cursor.getLong(_cursorIndexOfCbLct);
            final String _tmpCbSourcedId;
            if (cursor.isNull(_cursorIndexOfCbSourcedId)) {
              _tmpCbSourcedId = null;
            } else {
              _tmpCbSourcedId = cursor.getString(_cursorIndexOfCbSourcedId);
            }
            final String _tmpCbMetadata;
            if (cursor.isNull(_cursorIndexOfCbMetadata)) {
              _tmpCbMetadata = null;
            } else {
              _tmpCbMetadata = cursor.getString(_cursorIndexOfCbMetadata);
            }
            final String _tmpCbCreatedByAppId;
            if (cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
              _tmpCbCreatedByAppId = null;
            } else {
              _tmpCbCreatedByAppId = cursor.getString(_cursorIndexOfCbCreatedByAppId);
            }
            _tmpCourseBlock = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
          } else {
            _tmpCourseBlock = null;
          }
          final ContentEntry _tmpContentEntry;
          if (!(cursor.isNull(_cursorIndexOfContentEntryUid) && cursor.isNull(_cursorIndexOfTitle) && cursor.isNull(_cursorIndexOfDescription) && cursor.isNull(_cursorIndexOfEntryId) && cursor.isNull(_cursorIndexOfAuthor) && cursor.isNull(_cursorIndexOfPublisher) && cursor.isNull(_cursorIndexOfLicenseType) && cursor.isNull(_cursorIndexOfLicenseName) && cursor.isNull(_cursorIndexOfLicenseUrl) && cursor.isNull(_cursorIndexOfSourceUrl) && cursor.isNull(_cursorIndexOfThumbnailUrl) && cursor.isNull(_cursorIndexOfLastModified) && cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && cursor.isNull(_cursorIndexOfLanguageVariantUid) && cursor.isNull(_cursorIndexOfContentFlags) && cursor.isNull(_cursorIndexOfLeaf) && cursor.isNull(_cursorIndexOfPublik) && cursor.isNull(_cursorIndexOfCeInactive) && cursor.isNull(_cursorIndexOfCompletionCriteria) && cursor.isNull(_cursorIndexOfMinScore) && cursor.isNull(_cursorIndexOfContentTypeFlag) && cursor.isNull(_cursorIndexOfContentOwner) && cursor.isNull(_cursorIndexOfContentOwnerType) && cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && cursor.isNull(_cursorIndexOfContentEntryLct))) {
            _tmpContentEntry = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
            _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = cursor.getString(_cursorIndexOfTitle);
            }
            _tmpContentEntry.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = cursor.getString(_cursorIndexOfDescription);
            }
            _tmpContentEntry.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
            }
            _tmpContentEntry.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
            }
            _tmpContentEntry.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
            }
            _tmpContentEntry.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
            _tmpContentEntry.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
            }
            _tmpContentEntry.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
            }
            _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
            _tmpContentEntry.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
            _tmpContentEntry.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_4;
            _tmp_4 = cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_4 != 0;
            _tmpContentEntry.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_5;
            _tmp_5 = cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_5 != 0;
            _tmpContentEntry.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_6;
            _tmp_6 = cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_6 != 0;
            _tmpContentEntry.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
            _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
            _tmpContentEntry.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
            _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
            _tmpContentEntry.setContentOwner(_tmpContentOwner);
            final int _tmpContentOwnerType;
            _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
            _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
            _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _tmpContentEntry = null;
          }
          final CourseBlockPicture _tmpCourseBlockPicture;
          if (!(cursor.isNull(_cursorIndexOfCbpUid) && cursor.isNull(_cursorIndexOfCbpLct) && cursor.isNull(_cursorIndexOfCbpPictureUri) && cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
            final long _tmpCbpUid;
            _tmpCbpUid = cursor.getLong(_cursorIndexOfCbpUid);
            final long _tmpCbpLct;
            _tmpCbpLct = cursor.getLong(_cursorIndexOfCbpLct);
            final String _tmpCbpPictureUri;
            if (cursor.isNull(_cursorIndexOfCbpPictureUri)) {
              _tmpCbpPictureUri = null;
            } else {
              _tmpCbpPictureUri = cursor.getString(_cursorIndexOfCbpPictureUri);
            }
            final String _tmpCbpThumbnailUri;
            if (cursor.isNull(_cursorIndexOfCbpThumbnailUri)) {
              _tmpCbpThumbnailUri = null;
            } else {
              _tmpCbpThumbnailUri = cursor.getString(_cursorIndexOfCbpThumbnailUri);
            }
            _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid,_tmpCbpLct,_tmpCbpPictureUri,_tmpCbpThumbnailUri);
          } else {
            _tmpCourseBlockPicture = null;
          }
          final ContentEntryPicture2 _tmpContentEntryPicture2;
          if (!(cursor.isNull(_cursorIndexOfCepUid) && cursor.isNull(_cursorIndexOfCepLct) && cursor.isNull(_cursorIndexOfCepPictureUri) && cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
            final long _tmpCepUid;
            _tmpCepUid = cursor.getLong(_cursorIndexOfCepUid);
            final long _tmpCepLct;
            _tmpCepLct = cursor.getLong(_cursorIndexOfCepLct);
            final String _tmpCepPictureUri;
            if (cursor.isNull(_cursorIndexOfCepPictureUri)) {
              _tmpCepPictureUri = null;
            } else {
              _tmpCepPictureUri = cursor.getString(_cursorIndexOfCepPictureUri);
            }
            final String _tmpCepThumbnailUri;
            if (cursor.isNull(_cursorIndexOfCepThumbnailUri)) {
              _tmpCepThumbnailUri = null;
            } else {
              _tmpCepThumbnailUri = cursor.getString(_cursorIndexOfCepThumbnailUri);
            }
            _tmpContentEntryPicture2 = new ContentEntryPicture2(_tmpCepUid,_tmpCepLct,_tmpCepPictureUri,_tmpCepThumbnailUri);
          } else {
            _tmpContentEntryPicture2 = null;
          }
          _item_2 = new CourseBlockAndDisplayDetails(_tmpCourseBlock,_tmpCourseBlockPicture,_tmpContentEntry,_tmpContentEntryPicture2);
          _result.add(_item_2);
        }
        return _result;
      }
    };
  }

  @Override
  public Flow<String> getTitleByAssignmentUid(final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT CourseBlock.cbTitle\n"
            + "          FROM CourseBlock \n"
            + "         WHERE CourseBlock.cbEntityUid = ?\n"
            + "           AND CourseBlock.cbType = 103\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseBlock"}, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<CourseBlock> findByUidAsFlow(final long courseBlockUid) {
    final String _sql = "\n"
            + "        SELECT CourseBlock.*\n"
            + "          FROM CourseBlock\n"
            + "         WHERE CourseBlock.cbUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, courseBlockUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseBlock"}, new Callable<CourseBlock>() {
      @Override
      @Nullable
      public CourseBlock call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final CourseBlock _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCbUid;
            _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
            final int _tmpCbType;
            _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
            final int _tmpCbIndentLevel;
            _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
            final long _tmpCbModuleParentBlockUid;
            _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
            final String _tmpCbTitle;
            if (_cursor.isNull(_cursorIndexOfCbTitle)) {
              _tmpCbTitle = null;
            } else {
              _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
            }
            final String _tmpCbDescription;
            if (_cursor.isNull(_cursorIndexOfCbDescription)) {
              _tmpCbDescription = null;
            } else {
              _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
            }
            final int _tmpCbCompletionCriteria;
            _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
            final long _tmpCbHideUntilDate;
            _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
            final long _tmpCbDeadlineDate;
            _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
            final int _tmpCbLateSubmissionPenalty;
            _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
            final long _tmpCbGracePeriodDate;
            _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
            final Float _tmpCbMaxPoints;
            if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
              _tmpCbMaxPoints = null;
            } else {
              _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
            }
            final Float _tmpCbMinPoints;
            if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
              _tmpCbMinPoints = null;
            } else {
              _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
            }
            final int _tmpCbIndex;
            _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
            final long _tmpCbClazzUid;
            _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
            final String _tmpCbClazzSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
              _tmpCbClazzSourcedId = null;
            } else {
              _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
            }
            final boolean _tmpCbActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCbActive);
            _tmpCbActive = _tmp != 0;
            final boolean _tmpCbHidden;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
            _tmpCbHidden = _tmp_1 != 0;
            final long _tmpCbEntityUid;
            _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
            final long _tmpCbLct;
            _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
            final String _tmpCbSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
              _tmpCbSourcedId = null;
            } else {
              _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
            }
            final String _tmpCbMetadata;
            if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
              _tmpCbMetadata = null;
            } else {
              _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
            }
            final String _tmpCbCreatedByAppId;
            if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
              _tmpCbCreatedByAppId = null;
            } else {
              _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
            }
            _result = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findCourseBlockAndClazzUidByDiscussionPostUid(final long postUid,
      final Continuation<? super CourseBlockUidAndClazzUid> $completion) {
    final String _sql = "\n"
            + "        SELECT COALESCE(CourseBlock.cbUid, 0) AS courseBlockUid,\n"
            + "               COALESCE(CourseBlock.cbClazzUid, 0) AS clazzUid\n"
            + "          FROM CourseBlock\n"
            + "         WHERE CourseBlock.cbUid = \n"
            + "               (SELECT DiscussionPost.discussionPostCourseBlockUid \n"
            + "                  FROM DiscussionPost\n"
            + "                 WHERE DiscussionPost.discussionPostUid = ?)\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, postUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseBlockUidAndClazzUid>() {
      @Override
      @Nullable
      public CourseBlockUidAndClazzUid call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCourseBlockUid = 0;
          final int _cursorIndexOfClazzUid = 1;
          final CourseBlockUidAndClazzUid _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCourseBlockUid;
            _tmpCourseBlockUid = _cursor.getLong(_cursorIndexOfCourseBlockUid);
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result = new CourseBlockUidAndClazzUid(_tmpClazzUid,_tmpCourseBlockUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findCourseBlockByDiscussionPostUid(final long postUid,
      final Continuation<? super CourseBlock> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseBlock.*\n"
            + "          FROM CourseBlock\n"
            + "         WHERE CourseBlock.cbUid = \n"
            + "               (SELECT DiscussionPost.discussionPostCourseBlockUid \n"
            + "                  FROM DiscussionPost\n"
            + "                 WHERE DiscussionPost.discussionPostUid = ?) \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, postUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseBlock>() {
      @Override
      @Nullable
      public CourseBlock call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final CourseBlock _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCbUid;
            _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
            final int _tmpCbType;
            _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
            final int _tmpCbIndentLevel;
            _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
            final long _tmpCbModuleParentBlockUid;
            _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
            final String _tmpCbTitle;
            if (_cursor.isNull(_cursorIndexOfCbTitle)) {
              _tmpCbTitle = null;
            } else {
              _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
            }
            final String _tmpCbDescription;
            if (_cursor.isNull(_cursorIndexOfCbDescription)) {
              _tmpCbDescription = null;
            } else {
              _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
            }
            final int _tmpCbCompletionCriteria;
            _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
            final long _tmpCbHideUntilDate;
            _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
            final long _tmpCbDeadlineDate;
            _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
            final int _tmpCbLateSubmissionPenalty;
            _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
            final long _tmpCbGracePeriodDate;
            _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
            final Float _tmpCbMaxPoints;
            if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
              _tmpCbMaxPoints = null;
            } else {
              _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
            }
            final Float _tmpCbMinPoints;
            if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
              _tmpCbMinPoints = null;
            } else {
              _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
            }
            final int _tmpCbIndex;
            _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
            final long _tmpCbClazzUid;
            _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
            final String _tmpCbClazzSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
              _tmpCbClazzSourcedId = null;
            } else {
              _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
            }
            final boolean _tmpCbActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCbActive);
            _tmpCbActive = _tmp != 0;
            final boolean _tmpCbHidden;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
            _tmpCbHidden = _tmp_1 != 0;
            final long _tmpCbEntityUid;
            _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
            final long _tmpCbLct;
            _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
            final String _tmpCbSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
              _tmpCbSourcedId = null;
            } else {
              _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
            }
            final String _tmpCbMetadata;
            if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
              _tmpCbMetadata = null;
            } else {
              _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
            }
            final String _tmpCbCreatedByAppId;
            if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
              _tmpCbCreatedByAppId = null;
            } else {
              _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
            }
            _result = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findClazzUidByCourseBlockUid(final long courseBlockUid,
      final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "        SELECT COALESCE(CourseBlock.cbClazzUid, 0) AS clazzUid\n"
            + "          FROM CourseBlock\n"
            + "         WHERE CourseBlock.cbUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, courseBlockUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<CourseBlockAndAssignment> findCourseBlockByAssignmentUid(final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT ClazzAssignment.*, CourseBlock.* \n"
            + "          FROM ClazzAssignment\n"
            + "               JOIN CourseBlock \n"
            + "                    ON CourseBlock.cbEntityUid = ?\n"
            + "         WHERE ClazzAssignment.caUid = ?\n"
            + "         LIMIT 1 \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, assignmentUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzAssignment",
        "CourseBlock"}, new Callable<CourseBlockAndAssignment>() {
      @Override
      @Nullable
      public CourseBlockAndAssignment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caUid");
          final int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "caTitle");
          final int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "caDescription");
          final int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caGroupUid");
          final int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow(_cursor, "caActive");
          final int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caClassCommentEnabled");
          final int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "caPrivateCommentsEnabled");
          final int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "caCompletionCriteria");
          final int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireFileSubmission");
          final int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow(_cursor, "caFileType");
          final int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caSizeLimit");
          final int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow(_cursor, "caNumberOfFiles");
          final int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "caSubmissionPolicy");
          final int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow(_cursor, "caMarkingType");
          final int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow(_cursor, "caRequireTextSubmission");
          final int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimitType");
          final int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow(_cursor, "caTextLimit");
          final int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caXObjectUid");
          final int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "caClazzUid");
          final int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow(_cursor, "caPeerReviewerCount");
          final int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caLocalChangeSeqNum");
          final int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "caMasterChangeSeqNum");
          final int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "caLastChangedBy");
          final int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "caLct");
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final CourseBlockAndAssignment _result;
          if (_cursor.moveToFirst()) {
            final ClazzAssignment _tmpAssignment;
            if (!(_cursor.isNull(_cursorIndexOfCaUid) && _cursor.isNull(_cursorIndexOfCaTitle) && _cursor.isNull(_cursorIndexOfCaDescription) && _cursor.isNull(_cursorIndexOfCaGroupUid) && _cursor.isNull(_cursorIndexOfCaActive) && _cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && _cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && _cursor.isNull(_cursorIndexOfCaCompletionCriteria) && _cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && _cursor.isNull(_cursorIndexOfCaFileType) && _cursor.isNull(_cursorIndexOfCaSizeLimit) && _cursor.isNull(_cursorIndexOfCaNumberOfFiles) && _cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && _cursor.isNull(_cursorIndexOfCaMarkingType) && _cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && _cursor.isNull(_cursorIndexOfCaTextLimitType) && _cursor.isNull(_cursorIndexOfCaTextLimit) && _cursor.isNull(_cursorIndexOfCaXObjectUid) && _cursor.isNull(_cursorIndexOfCaClazzUid) && _cursor.isNull(_cursorIndexOfCaPeerReviewerCount) && _cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaLastChangedBy) && _cursor.isNull(_cursorIndexOfCaLct))) {
              final long _tmpCaUid;
              _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
              final String _tmpCaTitle;
              if (_cursor.isNull(_cursorIndexOfCaTitle)) {
                _tmpCaTitle = null;
              } else {
                _tmpCaTitle = _cursor.getString(_cursorIndexOfCaTitle);
              }
              final String _tmpCaDescription;
              if (_cursor.isNull(_cursorIndexOfCaDescription)) {
                _tmpCaDescription = null;
              } else {
                _tmpCaDescription = _cursor.getString(_cursorIndexOfCaDescription);
              }
              final long _tmpCaGroupUid;
              _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
              final boolean _tmpCaActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCaActive);
              _tmpCaActive = _tmp != 0;
              final boolean _tmpCaClassCommentEnabled;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
              _tmpCaClassCommentEnabled = _tmp_1 != 0;
              final boolean _tmpCaPrivateCommentsEnabled;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
              _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
              final int _tmpCaCompletionCriteria;
              _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
              final boolean _tmpCaRequireFileSubmission;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
              _tmpCaRequireFileSubmission = _tmp_3 != 0;
              final int _tmpCaFileType;
              _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
              final int _tmpCaSizeLimit;
              _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
              final int _tmpCaNumberOfFiles;
              _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
              final int _tmpCaSubmissionPolicy;
              _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
              final int _tmpCaMarkingType;
              _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
              final boolean _tmpCaRequireTextSubmission;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
              _tmpCaRequireTextSubmission = _tmp_4 != 0;
              final int _tmpCaTextLimitType;
              _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
              final int _tmpCaTextLimit;
              _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
              final long _tmpCaXObjectUid;
              _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
              final long _tmpCaClazzUid;
              _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
              final int _tmpCaPeerReviewerCount;
              _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
              final long _tmpCaLocalChangeSeqNum;
              _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
              final long _tmpCaMasterChangeSeqNum;
              _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
              final int _tmpCaLastChangedBy;
              _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
              final long _tmpCaLct;
              _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
              _tmpAssignment = new ClazzAssignment(_tmpCaUid,_tmpCaTitle,_tmpCaDescription,_tmpCaGroupUid,_tmpCaActive,_tmpCaClassCommentEnabled,_tmpCaPrivateCommentsEnabled,_tmpCaCompletionCriteria,_tmpCaRequireFileSubmission,_tmpCaFileType,_tmpCaSizeLimit,_tmpCaNumberOfFiles,_tmpCaSubmissionPolicy,_tmpCaMarkingType,_tmpCaRequireTextSubmission,_tmpCaTextLimitType,_tmpCaTextLimit,_tmpCaXObjectUid,_tmpCaClazzUid,_tmpCaPeerReviewerCount,_tmpCaLocalChangeSeqNum,_tmpCaMasterChangeSeqNum,_tmpCaLastChangedBy,_tmpCaLct);
            } else {
              _tmpAssignment = null;
            }
            final CourseBlock _tmpCourseBlock;
            if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
              final long _tmpCbUid;
              _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
              final int _tmpCbType;
              _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (_cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
              }
              final String _tmpCbDescription;
              if (_cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
              }
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              final Float _tmpCbMaxPoints;
              if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
                _tmpCbMaxPoints = null;
              } else {
                _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
              }
              final Float _tmpCbMinPoints;
              if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
                _tmpCbMinPoints = null;
              } else {
                _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
              }
              final int _tmpCbIndex;
              _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
              final String _tmpCbClazzSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
                _tmpCbClazzSourcedId = null;
              } else {
                _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
              }
              final boolean _tmpCbActive;
              final int _tmp_5;
              _tmp_5 = _cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp_5 != 0;
              final boolean _tmpCbHidden;
              final int _tmp_6;
              _tmp_6 = _cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_6 != 0;
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
              final String _tmpCbSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
                _tmpCbSourcedId = null;
              } else {
                _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
              }
              final String _tmpCbMetadata;
              if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
                _tmpCbMetadata = null;
              } else {
                _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
              }
              final String _tmpCbCreatedByAppId;
              if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
                _tmpCbCreatedByAppId = null;
              } else {
                _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
              }
              _tmpCourseBlock = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
            } else {
              _tmpCourseBlock = null;
            }
            _result = new CourseBlockAndAssignment(_tmpCourseBlock,_tmpAssignment);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findBySourcedId(final String sourcedId, final long accountPersonUid,
      final Continuation<? super CourseBlock> $completion) {
    final String _sql = "\n"
            + "            SELECT CourseBlock.*\n"
            + "              FROM CourseBlock\n"
            + "             WHERE CAST(cbUid AS TEXT) = ?\n"
            + "                OR cbSourcedId = ?\n"
            + "               AND ? != 0 \n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindString(_argIndex, sourcedId);
    _argIndex = 2;
    _statement.bindString(_argIndex, sourcedId);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseBlock>() {
      @Override
      @Nullable
      public CourseBlock call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final CourseBlock _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCbUid;
            _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
            final int _tmpCbType;
            _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
            final int _tmpCbIndentLevel;
            _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
            final long _tmpCbModuleParentBlockUid;
            _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
            final String _tmpCbTitle;
            if (_cursor.isNull(_cursorIndexOfCbTitle)) {
              _tmpCbTitle = null;
            } else {
              _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
            }
            final String _tmpCbDescription;
            if (_cursor.isNull(_cursorIndexOfCbDescription)) {
              _tmpCbDescription = null;
            } else {
              _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
            }
            final int _tmpCbCompletionCriteria;
            _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
            final long _tmpCbHideUntilDate;
            _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
            final long _tmpCbDeadlineDate;
            _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
            final int _tmpCbLateSubmissionPenalty;
            _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
            final long _tmpCbGracePeriodDate;
            _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
            final Float _tmpCbMaxPoints;
            if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
              _tmpCbMaxPoints = null;
            } else {
              _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
            }
            final Float _tmpCbMinPoints;
            if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
              _tmpCbMinPoints = null;
            } else {
              _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
            }
            final int _tmpCbIndex;
            _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
            final long _tmpCbClazzUid;
            _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
            final String _tmpCbClazzSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
              _tmpCbClazzSourcedId = null;
            } else {
              _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
            }
            final boolean _tmpCbActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCbActive);
            _tmpCbActive = _tmp != 0;
            final boolean _tmpCbHidden;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
            _tmpCbHidden = _tmp_1 != 0;
            final long _tmpCbEntityUid;
            _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
            final long _tmpCbLct;
            _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
            final String _tmpCbSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
              _tmpCbSourcedId = null;
            } else {
              _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
            }
            final String _tmpCbMetadata;
            if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
              _tmpCbMetadata = null;
            } else {
              _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
            }
            final String _tmpCbCreatedByAppId;
            if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
              _tmpCbCreatedByAppId = null;
            } else {
              _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
            }
            _result = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByClazzUid(final long clazzUid,
      final Continuation<? super List<CourseBlock>> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseBlock.*\n"
            + "          FROM CourseBlock\n"
            + "         WHERE CourseBlock.cbClazzUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseBlock>>() {
      @Override
      @NonNull
      public List<CourseBlock> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final List<CourseBlock> _result = new ArrayList<CourseBlock>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseBlock _item;
            final long _tmpCbUid;
            _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
            final int _tmpCbType;
            _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
            final int _tmpCbIndentLevel;
            _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
            final long _tmpCbModuleParentBlockUid;
            _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
            final String _tmpCbTitle;
            if (_cursor.isNull(_cursorIndexOfCbTitle)) {
              _tmpCbTitle = null;
            } else {
              _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
            }
            final String _tmpCbDescription;
            if (_cursor.isNull(_cursorIndexOfCbDescription)) {
              _tmpCbDescription = null;
            } else {
              _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
            }
            final int _tmpCbCompletionCriteria;
            _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
            final long _tmpCbHideUntilDate;
            _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
            final long _tmpCbDeadlineDate;
            _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
            final int _tmpCbLateSubmissionPenalty;
            _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
            final long _tmpCbGracePeriodDate;
            _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
            final Float _tmpCbMaxPoints;
            if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
              _tmpCbMaxPoints = null;
            } else {
              _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
            }
            final Float _tmpCbMinPoints;
            if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
              _tmpCbMinPoints = null;
            } else {
              _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
            }
            final int _tmpCbIndex;
            _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
            final long _tmpCbClazzUid;
            _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
            final String _tmpCbClazzSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
              _tmpCbClazzSourcedId = null;
            } else {
              _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
            }
            final boolean _tmpCbActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCbActive);
            _tmpCbActive = _tmp != 0;
            final boolean _tmpCbHidden;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
            _tmpCbHidden = _tmp_1 != 0;
            final long _tmpCbEntityUid;
            _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
            final long _tmpCbLct;
            _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
            final String _tmpCbSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
              _tmpCbSourcedId = null;
            } else {
              _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
            }
            final String _tmpCbMetadata;
            if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
              _tmpCbMetadata = null;
            } else {
              _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
            }
            final String _tmpCbCreatedByAppId;
            if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
              _tmpCbCreatedByAppId = null;
            } else {
              _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
            }
            _item = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<CourseBlockAndGradebookDisplayDetails>> findByClazzUidAsFlow(
      final long clazzUid) {
    final String _sql = "\n"
            + "        SELECT CourseBlock.*, ContentEntry.*, CourseBlockPicture.*, ContentEntryPicture2.*\n"
            + "          FROM CourseBlock\n"
            + "               LEFT JOIN ContentEntry\n"
            + "                         ON CourseBlock.cbType = 104\n"
            + "                            AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n"
            + "               LEFT JOIN CourseBlockPicture\n"
            + "                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    \n"
            + "               LEFT JOIN ContentEntryPicture2\n"
            + "                         ON CourseBlock.cbType = 104\n"
            + "                            AND ContentEntryPicture2.cepUid = CourseBlock.cbEntityUid\n"
            + "         WHERE CourseBlock.cbClazzUid = ?\n"
            + "           AND CAST(CourseBlock.cbActive AS INTEGER) = 1\n"
            + "      ORDER BY CourseBlock.cbIndex\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseBlock", "ContentEntry",
        "CourseBlockPicture",
        "ContentEntryPicture2"}, new Callable<List<CourseBlockAndGradebookDisplayDetails>>() {
      @Override
      @NonNull
      public List<CourseBlockAndGradebookDisplayDetails> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzSourcedId");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMetadata");
          final int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCreatedByAppId");
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwnerType");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpUid");
          final int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpLct");
          final int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpPictureUri");
          final int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cbpThumbnailUri");
          final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUid");
          final int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepLct");
          final int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepPictureUri");
          final int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepThumbnailUri");
          final List<CourseBlockAndGradebookDisplayDetails> _result = new ArrayList<CourseBlockAndGradebookDisplayDetails>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseBlockAndGradebookDisplayDetails _item;
            final CourseBlock _tmpBlock;
            if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
              final long _tmpCbUid;
              _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
              final int _tmpCbType;
              _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (_cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
              }
              final String _tmpCbDescription;
              if (_cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
              }
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              final Float _tmpCbMaxPoints;
              if (_cursor.isNull(_cursorIndexOfCbMaxPoints)) {
                _tmpCbMaxPoints = null;
              } else {
                _tmpCbMaxPoints = _cursor.getFloat(_cursorIndexOfCbMaxPoints);
              }
              final Float _tmpCbMinPoints;
              if (_cursor.isNull(_cursorIndexOfCbMinPoints)) {
                _tmpCbMinPoints = null;
              } else {
                _tmpCbMinPoints = _cursor.getFloat(_cursorIndexOfCbMinPoints);
              }
              final int _tmpCbIndex;
              _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
              final String _tmpCbClazzSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbClazzSourcedId)) {
                _tmpCbClazzSourcedId = null;
              } else {
                _tmpCbClazzSourcedId = _cursor.getString(_cursorIndexOfCbClazzSourcedId);
              }
              final boolean _tmpCbActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp != 0;
              final boolean _tmpCbHidden;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_1 != 0;
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
              final String _tmpCbSourcedId;
              if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
                _tmpCbSourcedId = null;
              } else {
                _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
              }
              final String _tmpCbMetadata;
              if (_cursor.isNull(_cursorIndexOfCbMetadata)) {
                _tmpCbMetadata = null;
              } else {
                _tmpCbMetadata = _cursor.getString(_cursorIndexOfCbMetadata);
              }
              final String _tmpCbCreatedByAppId;
              if (_cursor.isNull(_cursorIndexOfCbCreatedByAppId)) {
                _tmpCbCreatedByAppId = null;
              } else {
                _tmpCbCreatedByAppId = _cursor.getString(_cursorIndexOfCbCreatedByAppId);
              }
              _tmpBlock = new CourseBlock(_tmpCbUid,_tmpCbType,_tmpCbIndentLevel,_tmpCbModuleParentBlockUid,_tmpCbTitle,_tmpCbDescription,_tmpCbCompletionCriteria,_tmpCbHideUntilDate,_tmpCbDeadlineDate,_tmpCbLateSubmissionPenalty,_tmpCbGracePeriodDate,_tmpCbMaxPoints,_tmpCbMinPoints,_tmpCbIndex,_tmpCbClazzUid,_tmpCbClazzSourcedId,_tmpCbActive,_tmpCbHidden,_tmpCbEntityUid,_tmpCbLct,_tmpCbSourcedId,_tmpCbMetadata,_tmpCbCreatedByAppId);
            } else {
              _tmpBlock = null;
            }
            final ContentEntry _tmpContentEntry;
            if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
              _tmpContentEntry = new ContentEntry();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
              _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (_cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
              }
              _tmpContentEntry.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (_cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
              }
              _tmpContentEntry.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (_cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
              }
              _tmpContentEntry.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (_cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
              }
              _tmpContentEntry.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (_cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
              }
              _tmpContentEntry.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
              _tmpContentEntry.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (_cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
              }
              _tmpContentEntry.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
              }
              _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
              _tmpContentEntry.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
              _tmpContentEntry.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp_2 != 0;
              _tmpContentEntry.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_3 != 0;
              _tmpContentEntry.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_4 != 0;
              _tmpContentEntry.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
              _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
              _tmpContentEntry.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
              _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
              _tmpContentEntry.setContentOwner(_tmpContentOwner);
              final int _tmpContentOwnerType;
              _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
              _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
              _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
            } else {
              _tmpContentEntry = null;
            }
            final CourseBlockPicture _tmpCourseBlockPicture;
            if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
              final long _tmpCbpUid;
              _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
              final long _tmpCbpLct;
              _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
              final String _tmpCbpPictureUri;
              if (_cursor.isNull(_cursorIndexOfCbpPictureUri)) {
                _tmpCbpPictureUri = null;
              } else {
                _tmpCbpPictureUri = _cursor.getString(_cursorIndexOfCbpPictureUri);
              }
              final String _tmpCbpThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCbpThumbnailUri)) {
                _tmpCbpThumbnailUri = null;
              } else {
                _tmpCbpThumbnailUri = _cursor.getString(_cursorIndexOfCbpThumbnailUri);
              }
              _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid,_tmpCbpLct,_tmpCbpPictureUri,_tmpCbpThumbnailUri);
            } else {
              _tmpCourseBlockPicture = null;
            }
            final ContentEntryPicture2 _tmpContentEntryPicture2;
            if (!(_cursor.isNull(_cursorIndexOfCepUid) && _cursor.isNull(_cursorIndexOfCepLct) && _cursor.isNull(_cursorIndexOfCepPictureUri) && _cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
              final long _tmpCepUid;
              _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
              final long _tmpCepLct;
              _tmpCepLct = _cursor.getLong(_cursorIndexOfCepLct);
              final String _tmpCepPictureUri;
              if (_cursor.isNull(_cursorIndexOfCepPictureUri)) {
                _tmpCepPictureUri = null;
              } else {
                _tmpCepPictureUri = _cursor.getString(_cursorIndexOfCepPictureUri);
              }
              final String _tmpCepThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCepThumbnailUri)) {
                _tmpCepThumbnailUri = null;
              } else {
                _tmpCepThumbnailUri = _cursor.getString(_cursorIndexOfCepThumbnailUri);
              }
              _tmpContentEntryPicture2 = new ContentEntryPicture2(_tmpCepUid,_tmpCepLct,_tmpCepPictureUri,_tmpCepThumbnailUri);
            } else {
              _tmpContentEntryPicture2 = null;
            }
            _item = new CourseBlockAndGradebookDisplayDetails(_tmpBlock,_tmpCourseBlockPicture,_tmpContentEntry,_tmpContentEntryPicture2);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findCourseBlockAndClazzUidByCbUid(final long cbUid, final long accountPersonUid,
      final Continuation<? super CourseBlockUidAndClazzUid> $completion) {
    final String _sql = "\n"
            + "        SELECT CourseBlock.cbUid AS courseBlockUid, \n"
            + "               CourseBlock.cbClazzUid AS clazzUid\n"
            + "          FROM CourseBlock\n"
            + "         WHERE cbUid = ?\n"
            + "           AND ? != 0     \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, cbUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseBlockUidAndClazzUid>() {
      @Override
      @Nullable
      public CourseBlockUidAndClazzUid call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCourseBlockUid = 0;
          final int _cursorIndexOfClazzUid = 1;
          final CourseBlockUidAndClazzUid _result;
          if (_cursor.moveToFirst()) {
            final long _tmpCourseBlockUid;
            _tmpCourseBlockUid = _cursor.getLong(_cursorIndexOfCourseBlockUid);
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result = new CourseBlockUidAndClazzUid(_tmpClazzUid,_tmpCourseBlockUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
