package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.StatementContextActivityJoin;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class StatementContextActivityJoinDao_Impl extends StatementContextActivityJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<StatementContextActivityJoin> __insertionAdapterOfStatementContextActivityJoin;

  public StatementContextActivityJoinDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfStatementContextActivityJoin = new EntityInsertionAdapter<StatementContextActivityJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `StatementContextActivityJoin` (`scajFromStatementIdHi`,`scajFromStatementIdLo`,`scajToHash`,`scajContextType`,`scajToActivityUid`,`scajToActivityId`,`scajEtag`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final StatementContextActivityJoin entity) {
        statement.bindLong(1, entity.getScajFromStatementIdHi());
        statement.bindLong(2, entity.getScajFromStatementIdLo());
        statement.bindLong(3, entity.getScajToHash());
        statement.bindLong(4, entity.getScajContextType());
        statement.bindLong(5, entity.getScajToActivityUid());
        if (entity.getScajToActivityId() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getScajToActivityId());
        }
        statement.bindLong(7, entity.getScajEtag());
      }
    };
  }

  @Override
  public Object insertOrIgnoreListAsync(final List<StatementContextActivityJoin> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfStatementContextActivityJoin.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllByStatementId(final long statementIdHi, final long statementIdLo,
      final int scajContextType,
      final Continuation<? super List<StatementContextActivityJoin>> $completion) {
    final String _sql = "\n"
            + "        SELECT StatementContextActivityJoin.*\n"
            + "          FROM StatementContextActivityJoin\n"
            + "         WHERE StatementContextActivityJoin.scajFromStatementIdHi = ?\n"
            + "           AND StatementContextActivityJoin.scajFromStatementIdLo = ?\n"
            + "           AND StatementContextActivityJoin.scajContextType = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, statementIdHi);
    _argIndex = 2;
    _statement.bindLong(_argIndex, statementIdLo);
    _argIndex = 3;
    _statement.bindLong(_argIndex, scajContextType);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementContextActivityJoin>>() {
      @Override
      @NonNull
      public List<StatementContextActivityJoin> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfScajFromStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "scajFromStatementIdHi");
          final int _cursorIndexOfScajFromStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "scajFromStatementIdLo");
          final int _cursorIndexOfScajToHash = CursorUtil.getColumnIndexOrThrow(_cursor, "scajToHash");
          final int _cursorIndexOfScajContextType = CursorUtil.getColumnIndexOrThrow(_cursor, "scajContextType");
          final int _cursorIndexOfScajToActivityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scajToActivityUid");
          final int _cursorIndexOfScajToActivityId = CursorUtil.getColumnIndexOrThrow(_cursor, "scajToActivityId");
          final int _cursorIndexOfScajEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "scajEtag");
          final List<StatementContextActivityJoin> _result = new ArrayList<StatementContextActivityJoin>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StatementContextActivityJoin _item;
            final long _tmpScajFromStatementIdHi;
            _tmpScajFromStatementIdHi = _cursor.getLong(_cursorIndexOfScajFromStatementIdHi);
            final long _tmpScajFromStatementIdLo;
            _tmpScajFromStatementIdLo = _cursor.getLong(_cursorIndexOfScajFromStatementIdLo);
            final long _tmpScajToHash;
            _tmpScajToHash = _cursor.getLong(_cursorIndexOfScajToHash);
            final int _tmpScajContextType;
            _tmpScajContextType = _cursor.getInt(_cursorIndexOfScajContextType);
            final long _tmpScajToActivityUid;
            _tmpScajToActivityUid = _cursor.getLong(_cursorIndexOfScajToActivityUid);
            final String _tmpScajToActivityId;
            if (_cursor.isNull(_cursorIndexOfScajToActivityId)) {
              _tmpScajToActivityId = null;
            } else {
              _tmpScajToActivityId = _cursor.getString(_cursorIndexOfScajToActivityId);
            }
            final long _tmpScajEtag;
            _tmpScajEtag = _cursor.getLong(_cursorIndexOfScajEtag);
            _item = new StatementContextActivityJoin(_tmpScajFromStatementIdHi,_tmpScajFromStatementIdLo,_tmpScajToHash,_tmpScajContextType,_tmpScajToActivityUid,_tmpScajToActivityId,_tmpScajEtag);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
