/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.composites.ClazzEnrolmentAndPerson;
import com.ustadmobile.lib.db.composites.ClazzEnrolmentAndPersonDetailDetails;
import com.ustadmobile.lib.db.composites.CourseNameAndPersonName;
import com.ustadmobile.lib.db.composites.PersonAndClazzMemberListDetails;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithClazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithLeavingReason;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithPerson;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J`\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u00152\u0006\u0010\u0016\u001a\u00020\bH'J$\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00050\u00152\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH'J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u0016\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u001eJ$\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00050\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH'J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\"JX\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH'JP\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH'J\u0018\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010)\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00152\u0006\u0010)\u001a\u00020\bH'J$\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\"J\u0018\u0010,\u001a\u0004\u0018\u00010\u00022\u0006\u0010-\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010.\u001a\u0004\u0018\u00010 2\u0006\u0010/\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u001cJ$\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\"J4\u00102\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u00103Jh\u00104\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u00105J6\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\n2\b\b\u0002\u0010:\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u00103J,\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010<\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010=J \u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\"J\u0016\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H'J\u0016\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010EJ \u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\b2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\bH'J&\u0010K\u001a\u00020A2\u0006\u0010-\u001a\u00020\b2\u0006\u0010G\u001a\u00020\b2\u0006\u0010L\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010=J6\u0010M\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\n2\u0006\u0010L\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010PJ&\u0010Q\u001a\u00020A2\u0006\u0010G\u001a\u00020\b2\u0006\u0010R\u001a\u00020\b2\u0006\u0010L\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010=\u00a8\u0006S"}, d2={"Lcom/ustadmobile/core/db/dao/ClazzEnrolmentDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolment;", "()V", "findActorEntitiesForGradebook", "", "Lcom/ustadmobile/lib/db/entities/xapi/ActorEntity;", "clazzUid", "", "roleId", "", "sortOrder", "searchText", "", "filter", "accountPersonUid", "currentTime", "studentsLimit", "studentsOffset", "(JIILjava/lang/String;IJJIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllByPersonUid", "Lkotlinx/coroutines/flow/Flow;", "personUid", "findAllClazzesByPersonWithClazz", "Lcom/ustadmobile/lib/db/composites/ClazzEnrolmentAndPersonDetailDetails;", "otherPersonUid", "findAllClazzesByPersonWithClazzAsListAsync", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolmentWithClazz;", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllEnrolmentsByClazzUidAndRole", "(JILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllEnrolmentsByPersonAndClazzUid", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolmentWithLeavingReason;", "findByAccountPersonUidAndClazzUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByClazzUidAndRole", "Landroidx/paging/PagingSource;", "Lcom/ustadmobile/lib/db/composites/PersonAndClazzMemberListDetails;", "permission", "findByClazzUidAndRoleForGradebook", "findByUid", "uid", "findByUidLive", "findClazzEnrolmentEntitiesForPersonViewPermissionCheck", "findClazzEnrolmentEntityForClazzEnrolmentInviteUid", "clazzEnrolmentInviteUid", "findEnrolmentWithLeavingReason", "enrolmentUid", "findEnrolmentsAndPersonByClazzUidWithPermissionCheck", "Lcom/ustadmobile/lib/db/composites/ClazzEnrolmentAndPerson;", "findEnrolmentsByClazzUidAndRole", "(JJIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findEnrolmentsByClazzUidAndRolePaged", "(JIILjava/lang/String;IJJJIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllClazzEnrolledAtTimeAsync", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolmentWithPerson;", "date", "roleFilter", "personUidFilter", "getAllEnrolmentsAtTimeByClazzAndPerson", "time", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getClazzNameAndPersonName", "Lcom/ustadmobile/lib/db/composites/CourseNameAndPersonName;", "insertListAsync", "", "entityList", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/ClazzEnrolment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateClazzEnrolmentActiveForClazzEnrolment", "clazzEnrolmentUid", "enrolled", "", "timeChanged", "updateClazzEnrolmentInviteUid", "updateTime", "updateClazzEnrolmentRole", "newRole", "oldRole", "(JJIIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateDateLeftByUid", "endDate", "lib-database_release"})
@Dao
public abstract class ClazzEnrolmentDao
implements BaseDao<ClazzEnrolment> {
    @Insert(entity=Object.class, onConflict=3)
    public abstract void insertListAsync(@NotNull List<? extends ClazzEnrolment> var1);

    @Query(value="\n        SELECT ClazzEnrolment.*, LeavingReason.*, \n               COALESCE(Clazz.clazzTimeZone, 'UTC') as timeZone\n          FROM ClazzEnrolment \n               LEFT JOIN LeavingReason \n                         ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n               LEFT JOIN Clazz \n                         ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n         WHERE clazzEnrolmentPersonUid = :personUid \n           AND ClazzEnrolment.clazzEnrolmentActive \n           AND clazzEnrolmentClazzUid = :clazzUid \n      ORDER BY clazzEnrolmentDateLeft DESC\n           ")
    @NotNull
    public abstract Flow<List<ClazzEnrolmentWithLeavingReason>> findAllEnrolmentsByPersonAndClazzUid(long var1, long var3);

    @Query(value="\n            SELECT ClazzEnrolment.*, \n                   LeavingReason.*,\n                   COALESCE(Clazz.clazzTimeZone, 'UTC') AS timeZone\n              FROM ClazzEnrolment \n                   LEFT JOIN LeavingReason \n                             ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n                   LEFT JOIN Clazz \n                             ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n             WHERE ClazzEnrolment.clazzEnrolmentUid = :enrolmentUid\n             ")
    @Nullable
    public abstract Object findEnrolmentWithLeavingReason(long var1, @NotNull Continuation<? super ClazzEnrolmentWithLeavingReason> var3);

    @Query(value="\n        UPDATE ClazzEnrolment \n          SET clazzEnrolmentDateLeft = :endDate,\n              clazzEnrolmentLct = :updateTime\n        WHERE clazzEnrolmentUid = :clazzEnrolmentUid")
    @Nullable
    public abstract Object updateDateLeftByUid(long var1, long var3, long var5, @NotNull Continuation<? super Unit> var7);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull ClazzEnrolment var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="\n               /* List of all CoursePermissions that are granted to the person as per accountPersonUid */\n          WITH CoursePermissionsForAccountPerson AS (\n               \n        /* Get CoursePermissions given to the active user based on their enrolment role*/\n        SELECT CoursePermission.*\n          FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n               JOIN CoursePermission \n                    ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n                   AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n         WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = :accountPersonUid \n         UNION\n        /* Get ClazzUids where the active user can view members based a grant directly to them */\n        SELECT CoursePermission.*\n          FROM CoursePermission\n         WHERE CoursePermission.cpToPersonUid  = :accountPersonUid\n    ),\n               /* Check if CoursePermission for accountPersonUid grants view permission */\n               CanViewPersonUidViaCoursePermission(personUid) AS (\n                    SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                      FROM CoursePermissionsForAccountPerson\n                           JOIN ClazzEnrolment \n                                ON (CoursePermissionsForAccountPerson.cpPermissionsFlag & 8192) > 0\n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = CoursePermissionsForAccountPerson.cpClazzUid  \n                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :otherPersonUid         \n               )     \n        SELECT ClazzEnrolment.*,\n               Clazz.*,\n               CourseTerminology.*\n          FROM ClazzEnrolment\n               JOIN Clazz \n                    ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n               LEFT JOIN CourseTerminology\n                    ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n         WHERE (:accountPersonUid != 0 AND :otherPersonUid != 0)\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = :otherPersonUid\n               /* Check that accountPersonUid has permission to see otherPerson */\n           AND (    (SELECT :accountPersonUid = :otherPersonUid)\n                 OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            8192\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                 OR (SELECT :otherPersonUid IN \n                             (SELECT CanViewPersonUidViaCoursePermission.personUid\n                                 FROM CanViewPersonUidViaCoursePermission))           \n               ) \n              /* Check that accountPersonUid has permission to see related Clazz */\n          AND (     (SELECT :accountPersonUid = :otherPersonUid)\n                 OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            1\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                 OR (EXISTS(SELECT 1\n                              FROM CoursePermissionsForAccountPerson\n                             WHERE CoursePermissionsForAccountPerson.cpClazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n                               AND (CoursePermissionsForAccountPerson.cpPermissionsFlag & 1) > 0)) \n               )\n    ")
    @NotNull
    public abstract Flow<List<ClazzEnrolmentAndPersonDetailDetails>> findAllClazzesByPersonWithClazz(long var1, long var3);

    @Query(value="\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :personUid \n    ")
    @NotNull
    public abstract Flow<List<ClazzEnrolment>> findAllByPersonUid(long var1);

    @Query(value="SELECT ClazzEnrolment.*, Clazz.* \n        FROM ClazzEnrolment \n        LEFT JOIN Clazz ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n        WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :personUid \n        AND ClazzEnrolment.clazzEnrolmentActive\n        ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n    ")
    @Nullable
    public abstract Object findAllClazzesByPersonWithClazzAsListAsync(long var1, @NotNull Continuation<? super List<? extends ClazzEnrolmentWithClazz>> var3);

    @Query(value="\n        SELECT ClazzEnrolment.*, Person.*\n          FROM ClazzEnrolment\n                LEFT JOIN Person \n                          ON ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n              AND :date BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n              AND ClazzEnrolment.clazzEnrolmentDateLeft\n              AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n              AND (:roleFilter = 0 OR ClazzEnrolment.clazzEnrolmentRole = :roleFilter)\n              AND (:personUidFilter = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = :personUidFilter)\n    ")
    @Nullable
    public abstract Object getAllClazzEnrolledAtTimeAsync(long var1, long var3, int var5, long var6, @NotNull Continuation<? super List<ClazzEnrolmentWithPerson>> var8);

    public static /* synthetic */ Object getAllClazzEnrolledAtTimeAsync$default(ClazzEnrolmentDao clazzEnrolmentDao, long l, long l2, int n, long l3, Continuation continuation, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAllClazzEnrolledAtTimeAsync");
        }
        if ((n2 & 8) != 0) {
            l3 = 0L;
        }
        return clazzEnrolmentDao.getAllClazzEnrolledAtTimeAsync(l, l2, n, l3, (Continuation<? super List<ClazzEnrolmentWithPerson>>)continuation);
    }

    @Query(value="\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n           AND :time BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                         AND ClazzEnrolment.clazzEnrolmentDateLeft\n           AND ClazzEnrolment.clazzEnrolmentActive              \n    ")
    @Nullable
    public abstract Object getAllEnrolmentsAtTimeByClazzAndPerson(long var1, long var3, long var5, @NotNull Continuation<? super List<? extends ClazzEnrolment>> var7);

    @Query(value="SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = :uid")
    @Nullable
    public abstract Object findByUid(long var1, @NotNull Continuation<? super ClazzEnrolment> var3);

    @Query(value="SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = :uid")
    @NotNull
    public abstract Flow<ClazzEnrolment> findByUidLive(long var1);

    @Query(value="\n        SELECT * \n          FROM (SELECT Person.*, PersonPicture.*,\n                       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n        \n                       (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n        \n                       (SELECT ClazzEnrolment.clazzEnrolmentRole \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                           AND ClazzEnrolment.clazzEnrolmentActive\n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                         LIMIT 1) AS enrolmentRole\n                  FROM Person\n                       LEFT JOIN PersonPicture\n                                 ON PersonPicture.personPictureUid = Person.personUid\n                 WHERE Person.personUid IN \n                       (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                          FROM ClazzEnrolment \n                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                           AND ClazzEnrolment.clazzEnrolmentActive \n                           AND ClazzEnrolment.clazzEnrolmentRole = :roleId \n                           AND (:filter != 1 \n                                 OR (:currentTime \n                                      BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                      AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                   /* Begin permission check */\n                   AND (\n                           (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         :permission\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     :permission\n         \n        ) > 0)\n               )\n    \n    )\n                        OR Person.personUid = :accountPersonUid\n                       )  \n                   /* End permission check */                   \n                   AND Person.firstNames || ' ' || Person.lastName LIKE :searchText\n               GROUP BY Person.personUid, PersonPicture.personPictureUid) AS CourseMember\n      ORDER BY CASE(:sortOrder)\n                WHEN 1 THEN CourseMember.firstNames\n                WHEN 3 THEN CourseMember.lastName\n                ELSE ''\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 2 THEN CourseMember.firstNames\n                WHEN 4 THEN CourseMember.lastName\n                ELSE ''\n            END DESC,\n            CASE(:sortOrder)\n                WHEN 7 THEN CourseMember.earliestJoinDate\n                WHEN 9 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 8 THEN CourseMember.earliestJoinDate\n                WHEN 10 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END DESC\n    ")
    @NotNull
    public abstract PagingSource<Integer, PersonAndClazzMemberListDetails> findByClazzUidAndRole(long var1, int var3, int var4, @Nullable String var5, int var6, long var7, long var9, long var11);

    public static /* synthetic */ PagingSource findByClazzUidAndRole$default(ClazzEnrolmentDao clazzEnrolmentDao, long l, int n, int n2, String string, int n3, long l2, long l3, long l4, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findByClazzUidAndRole");
        }
        if ((n4 & 8) != 0) {
            string = "%";
        }
        return clazzEnrolmentDao.findByClazzUidAndRole(l, n, n2, string, n3, l2, l3, l4);
    }

    @Query(value="\n        SELECT * \n          FROM (SELECT Person.*, PersonPicture.*,\n                       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n        \n                       (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n        \n                       (SELECT ClazzEnrolment.clazzEnrolmentRole \n                          FROM ClazzEnrolment \n                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                           AND ClazzEnrolment.clazzEnrolmentActive\n                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                         LIMIT 1) AS enrolmentRole\n                  FROM Person\n                       LEFT JOIN PersonPicture\n                                 ON PersonPicture.personPictureUid = Person.personUid\n                       --Dummy join so that invalidations of the StatementEntity table will trigger\n                       -- PagingSource invalidation of ClazzGradebookPagingSource\n                       LEFT JOIN StatementEntity\n                                 ON StatementEntity.statementIdHi = 0 \n                                    AND StatementEntity.statementIdLo = 0\n                       LEFT JOIN ActorEntity\n                                 ON ActorEntity.actorUid = 0\n                 WHERE Person.personUid IN \n                       (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                          FROM ClazzEnrolment \n                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                           AND ClazzEnrolment.clazzEnrolmentActive \n                           AND ClazzEnrolment.clazzEnrolmentRole = :roleId \n                           AND (:filter != 1 \n                                 OR (:currentTime \n                                      BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                      AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                   /* Begin permission check */\n                   AND (\n                           ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                            \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                            \n        ) > 0)\n               )\n    )\n                        OR Person.personUid = :accountPersonUid\n                       )  \n                   /* End permission check */                   \n                   AND Person.firstNames || ' ' || Person.lastName LIKE :searchText\n               GROUP BY Person.personUid, PersonPicture.personPictureUid) AS CourseMember\n      ORDER BY CASE(:sortOrder)\n                WHEN 1 THEN CourseMember.firstNames\n                WHEN 3 THEN CourseMember.lastName\n                ELSE ''\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 2 THEN CourseMember.firstNames\n                WHEN 4 THEN CourseMember.lastName\n                ELSE ''\n            END DESC,\n            CASE(:sortOrder)\n                WHEN 7 THEN CourseMember.earliestJoinDate\n                WHEN 9 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 8 THEN CourseMember.earliestJoinDate\n                WHEN 10 THEN CourseMember.latestDateLeft\n                ELSE 0\n            END DESC\n    ")
    @NotNull
    public abstract PagingSource<Integer, PersonAndClazzMemberListDetails> findByClazzUidAndRoleForGradebook(long var1, int var3, int var4, @Nullable String var5, int var6, long var7, long var9);

    public static /* synthetic */ PagingSource findByClazzUidAndRoleForGradebook$default(ClazzEnrolmentDao clazzEnrolmentDao, long l, int n, int n2, String string, int n3, long l2, long l3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findByClazzUidAndRoleForGradebook");
        }
        if ((n4 & 8) != 0) {
            string = "%";
        }
        return clazzEnrolmentDao.findByClazzUidAndRoleForGradebook(l, n, n2, string, n3, l2, l3);
    }

    @Query(value="\n          WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = :roleId \n                               AND (:filter != 1 \n                                     OR (:currentTime \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = :accountPersonUid\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE :searchText\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(:sortOrder)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(:sortOrder)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(:sortOrder)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(:sortOrder)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT :studentsLimit\n            OFFSET :studentsOffset   \n         )\n    \n          \n        \n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorPersonUid IN \n               (SELECT PersonUids.personUid\n                  FROM PersonUids)\n    ")
    @Nullable
    public abstract Object findActorEntitiesForGradebook(long var1, int var3, int var4, @Nullable String var5, int var6, long var7, long var9, int var11, int var12, @NotNull Continuation<? super List<ActorEntity>> var13);

    public static /* synthetic */ Object findActorEntitiesForGradebook$default(ClazzEnrolmentDao clazzEnrolmentDao, long l, int n, int n2, String string, int n3, long l2, long l3, int n4, int n5, Continuation continuation, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findActorEntitiesForGradebook");
        }
        if ((n6 & 8) != 0) {
            string = "%";
        }
        return clazzEnrolmentDao.findActorEntitiesForGradebook(l, n, n2, string, n3, l2, l3, n4, n5, (Continuation<? super List<ActorEntity>>)continuation);
    }

    @Query(value="\n       SELECT ClazzEnrolment.*,\n              Person.*,\n              PersonPicture.*\n         FROM ClazzEnrolment\n              JOIN Person\n                   ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n              LEFT JOIN PersonPicture\n                   ON PersonPicture.personPictureUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                   \n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n              /* Begin permission check*/\n          AND (\n                   ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n        \n                    8192\n                    \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n    \n                    8192\n                    \n        ) > 0)\n               )\n    )\n              )  \n              /* End permission check */\n    ")
    @Nullable
    public abstract Object findEnrolmentsAndPersonByClazzUidWithPermissionCheck(long var1, long var3, @NotNull Continuation<? super List<ClazzEnrolmentAndPerson>> var5);

    @Query(value="\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n           AND ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n    ")
    @Nullable
    public abstract Object findByAccountPersonUidAndClazzUid(long var1, long var3, @NotNull Continuation<? super List<? extends ClazzEnrolment>> var5);

    @Query(value="\n       SELECT ClazzEnrolment.*\n         FROM ClazzEnrolment\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n          AND ClazzEnrolment.clazzEnrolmentRole = :roleId\n              /* Begin permission check*/\n          AND (\n                   (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         :permission\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     :permission\n         \n        ) > 0)\n               )\n    \n    )\n                OR ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n              )  \n              /* End permission check */\n    ")
    @Nullable
    public abstract Object findEnrolmentsByClazzUidAndRole(long var1, long var3, int var5, long var6, @NotNull Continuation<? super List<? extends ClazzEnrolment>> var8);

    @Query(value="\n         WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = :roleId \n                               AND (:filter != 1 \n                                     OR (:currentTime \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = :accountPersonUid\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE :searchText\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(:sortOrder)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(:sortOrder)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(:sortOrder)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(:sortOrder)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT :studentsLimit\n            OFFSET :studentsOffset   \n         )\n    \n        \n       SELECT ClazzEnrolment.*\n         FROM ClazzEnrolment\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n          AND ClazzEnrolment.clazzEnrolmentRole = :roleId\n          AND ClazzEnrolment.clazzEnrolmentPersonUid IN (\n              SELECT PersonUids.personUid\n                FROM PersonUids)\n              /* Begin permission check*/\n          AND (\n                   (\n         (\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         :permission\n         \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     :permission\n         \n        ) > 0)\n               )\n    \n    )\n                OR ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n              )  \n    ")
    @Nullable
    public abstract Object findEnrolmentsByClazzUidAndRolePaged(long var1, int var3, int var4, @Nullable String var5, int var6, long var7, long var9, long var11, int var13, int var14, @NotNull Continuation<? super List<? extends ClazzEnrolment>> var15);

    public static /* synthetic */ Object findEnrolmentsByClazzUidAndRolePaged$default(ClazzEnrolmentDao clazzEnrolmentDao, long l, int n, int n2, String string, int n3, long l2, long l3, long l4, int n4, int n5, Continuation continuation, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findEnrolmentsByClazzUidAndRolePaged");
        }
        if ((n6 & 8) != 0) {
            string = "%";
        }
        return clazzEnrolmentDao.findEnrolmentsByClazzUidAndRolePaged(l, n, n2, string, n3, l2, l3, l4, n4, n5, (Continuation<? super List<? extends ClazzEnrolment>>)continuation);
    }

    @Query(value="\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n           AND ClazzEnrolment.clazzEnrolmentRole = :roleId\n    ")
    @Nullable
    public abstract Object findAllEnrolmentsByClazzUidAndRole(long var1, int var3, @NotNull Continuation<? super List<? extends ClazzEnrolment>> var4);

    @Query(value="\n        UPDATE ClazzEnrolment \n          SET clazzEnrolmentActive = :enrolled,\n              clazzEnrolmentLct = :timeChanged\n        WHERE clazzEnrolmentUid = :clazzEnrolmentUid")
    public abstract int updateClazzEnrolmentActiveForClazzEnrolment(long var1, boolean var3, long var4);

    @Query(value="\n            UPDATE ClazzEnrolment \n               SET clazzEnrolmentRole = :newRole,\n                   clazzEnrolmentLct = :updateTime      \n             -- Avoid potential for duplicate approvals if user was previously refused      \n             WHERE clazzEnrolmentUid = COALESCE( \n                    (SELECT clazzEnrolmentUid\n                       FROM ClazzEnrolment\n                      WHERE clazzEnrolmentPersonUid = :personUid \n                            AND clazzEnrolmentClazzUid = :clazzUid\n                            AND clazzEnrolmentRole = :oldRole\n                            AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n                      LIMIT 1), 0)")
    @Nullable
    public abstract Object updateClazzEnrolmentRole(long var1, long var3, int var5, int var6, long var7, @NotNull Continuation<? super Integer> var9);

    @Query(value="\n        SELECT Person.firstNames, Person.lastName, Clazz.clazzName\n          FROM Person\n               LEFT JOIN Clazz\n                         ON Clazz.clazzUid = :clazzUid\n        WHERE Person.personUid = :personUid                 \n    ")
    @Nullable
    public abstract Object getClazzNameAndPersonName(long var1, long var3, @NotNull Continuation<? super CourseNameAndPersonName> var5);

    @Query(value="\n          WITH CanViewMembersClazzesViaCoursePermission(clazzUid) AS\n               /* Get clazzuids where active user can view members based on their own enrolment role */\n               (SELECT CoursePermission.cpClazzUid\n                  FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n                       JOIN CoursePermission \n                            ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n                           AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n                 WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = :accountPersonUid \n                   AND (CoursePermission.cpPermissionsFlag & 8192) > 0 \n                UNION\n                /* Get ClazzUids where the active user can view members based a grant directly to them */\n                SELECT CoursePermission.cpClazzUid\n                  FROM CoursePermission\n                 WHERE CoursePermission.cpToPersonUid  = :accountPersonUid\n                   AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n               )\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n            OR (    ClazzEnrolment.clazzEnrolmentClazzUid IN \n                        (SELECT CanViewMembersClazzesViaCoursePermission.clazzUid\n                           FROM CanViewMembersClazzesViaCoursePermission)\n                AND (:otherPersonUid = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = :otherPersonUid)   \n                )\n    ")
    @Nullable
    public abstract Object findClazzEnrolmentEntitiesForPersonViewPermissionCheck(long var1, long var3, @NotNull Continuation<? super List<? extends ClazzEnrolment>> var5);

    @Query(value="\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentInviteUid = :clazzEnrolmentInviteUid\n    ")
    @Nullable
    public abstract Object findClazzEnrolmentEntityForClazzEnrolmentInviteUid(long var1, @NotNull Continuation<? super ClazzEnrolment> var3);

    @Query(value="\n       UPDATE ClazzEnrolment \n          SET clazzEnrolmentInviteUid = :clazzEnrolmentInviteUid,\n              clazzEnrolmentLct = :updateTime\n        WHERE clazzEnrolmentUid = :clazzEnrolmentUid\n    ")
    @Nullable
    public abstract Object updateClazzEnrolmentInviteUid(long var1, long var3, long var5, @NotNull Continuation<? super Unit> var7);
}

