/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ClazzLogAttendanceRecordDao;
import com.ustadmobile.lib.db.composites.PersonAndClazzLogAttendanceRecord;
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord;
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecordWithPerson;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ClazzLogAttendanceRecordDao_Impl
extends ClazzLogAttendanceRecordDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ClazzLogAttendanceRecord> __insertionAdapterOfClazzLogAttendanceRecord;
    private final EntityInsertionAdapter<ClazzLogAttendanceRecord> __insertionAdapterOfClazzLogAttendanceRecord_1;
    private final EntityDeletionOrUpdateAdapter<ClazzLogAttendanceRecord> __updateAdapterOfClazzLogAttendanceRecord;
    private final SharedSQLiteStatement __preparedStmtOfUpdateRescheduledClazzLogUids;

    public ClazzLogAttendanceRecordDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfClazzLogAttendanceRecord = new EntityInsertionAdapter<ClazzLogAttendanceRecord>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ClazzLogAttendanceRecord` (`clazzLogAttendanceRecordUid`,`clazzLogAttendanceRecordClazzLogUid`,`clazzLogAttendanceRecordPersonUid`,`attendanceStatus`,`clazzLogAttendanceRecordMasterChangeSeqNum`,`clazzLogAttendanceRecordLocalChangeSeqNum`,`clazzLogAttendanceRecordLastChangedBy`,`clazzLogAttendanceRecordLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzLogAttendanceRecord entity) {
                statement.bindLong(1, entity.getClazzLogAttendanceRecordUid());
                statement.bindLong(2, entity.getClazzLogAttendanceRecordClazzLogUid());
                statement.bindLong(3, entity.getClazzLogAttendanceRecordPersonUid());
                statement.bindLong(4, (long)entity.getAttendanceStatus());
                statement.bindLong(5, entity.getClazzLogAttendanceRecordMasterChangeSeqNum());
                statement.bindLong(6, entity.getClazzLogAttendanceRecordLocalChangeSeqNum());
                statement.bindLong(7, (long)entity.getClazzLogAttendanceRecordLastChangedBy());
                statement.bindLong(8, entity.getClazzLogAttendanceRecordLastChangedTime());
            }
        };
        this.__insertionAdapterOfClazzLogAttendanceRecord_1 = new EntityInsertionAdapter<ClazzLogAttendanceRecord>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ClazzLogAttendanceRecord` (`clazzLogAttendanceRecordUid`,`clazzLogAttendanceRecordClazzLogUid`,`clazzLogAttendanceRecordPersonUid`,`attendanceStatus`,`clazzLogAttendanceRecordMasterChangeSeqNum`,`clazzLogAttendanceRecordLocalChangeSeqNum`,`clazzLogAttendanceRecordLastChangedBy`,`clazzLogAttendanceRecordLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzLogAttendanceRecord entity) {
                statement.bindLong(1, entity.getClazzLogAttendanceRecordUid());
                statement.bindLong(2, entity.getClazzLogAttendanceRecordClazzLogUid());
                statement.bindLong(3, entity.getClazzLogAttendanceRecordPersonUid());
                statement.bindLong(4, (long)entity.getAttendanceStatus());
                statement.bindLong(5, entity.getClazzLogAttendanceRecordMasterChangeSeqNum());
                statement.bindLong(6, entity.getClazzLogAttendanceRecordLocalChangeSeqNum());
                statement.bindLong(7, (long)entity.getClazzLogAttendanceRecordLastChangedBy());
                statement.bindLong(8, entity.getClazzLogAttendanceRecordLastChangedTime());
            }
        };
        this.__updateAdapterOfClazzLogAttendanceRecord = new EntityDeletionOrUpdateAdapter<ClazzLogAttendanceRecord>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ClazzLogAttendanceRecord` SET `clazzLogAttendanceRecordUid` = ?,`clazzLogAttendanceRecordClazzLogUid` = ?,`clazzLogAttendanceRecordPersonUid` = ?,`attendanceStatus` = ?,`clazzLogAttendanceRecordMasterChangeSeqNum` = ?,`clazzLogAttendanceRecordLocalChangeSeqNum` = ?,`clazzLogAttendanceRecordLastChangedBy` = ?,`clazzLogAttendanceRecordLastChangedTime` = ? WHERE `clazzLogAttendanceRecordUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ClazzLogAttendanceRecord entity) {
                statement.bindLong(1, entity.getClazzLogAttendanceRecordUid());
                statement.bindLong(2, entity.getClazzLogAttendanceRecordClazzLogUid());
                statement.bindLong(3, entity.getClazzLogAttendanceRecordPersonUid());
                statement.bindLong(4, (long)entity.getAttendanceStatus());
                statement.bindLong(5, entity.getClazzLogAttendanceRecordMasterChangeSeqNum());
                statement.bindLong(6, entity.getClazzLogAttendanceRecordLocalChangeSeqNum());
                statement.bindLong(7, (long)entity.getClazzLogAttendanceRecordLastChangedBy());
                statement.bindLong(8, entity.getClazzLogAttendanceRecordLastChangedTime());
                statement.bindLong(9, entity.getClazzLogAttendanceRecordUid());
            }
        };
        this.__preparedStmtOfUpdateRescheduledClazzLogUids = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ClazzLogAttendanceRecord\n           SET clazzLogAttendanceRecordClazzLogUid = ?,\n               clazzLogAttendanceRecordLastChangedTime = ?\n        WHERE clazzLogAttendanceRecordClazzLogUid = ?\n    ";
                return "\n        UPDATE ClazzLogAttendanceRecord\n           SET clazzLogAttendanceRecordClazzLogUid = ?,\n               clazzLogAttendanceRecordLastChangedTime = ?\n        WHERE clazzLogAttendanceRecordClazzLogUid = ?\n    ";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ClazzLogAttendanceRecord entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfClazzLogAttendanceRecord.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ClazzLogAttendanceRecord entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ClazzLogAttendanceRecordDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ClazzLogAttendanceRecordDao_Impl.this.__insertionAdapterOfClazzLogAttendanceRecord.insertAndReturnId((Object)entity);
                    ClazzLogAttendanceRecordDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ClazzLogAttendanceRecordDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ClazzLogAttendanceRecord> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfClazzLogAttendanceRecord.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<? extends ClazzLogAttendanceRecord> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzLogAttendanceRecordDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzLogAttendanceRecordDao_Impl.this.__insertionAdapterOfClazzLogAttendanceRecord.insert((Iterable)entities);
                    ClazzLogAttendanceRecordDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzLogAttendanceRecordDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertListAsync(final List<? extends ClazzLogAttendanceRecord> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzLogAttendanceRecordDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzLogAttendanceRecordDao_Impl.this.__insertionAdapterOfClazzLogAttendanceRecord_1.insert((Iterable)entityList);
                    ClazzLogAttendanceRecordDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzLogAttendanceRecordDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(ClazzLogAttendanceRecord entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfClazzLogAttendanceRecord.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateListAsync(final List<? extends ClazzLogAttendanceRecord> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ClazzLogAttendanceRecordDao_Impl.this.__db.beginTransaction();
                try {
                    ClazzLogAttendanceRecordDao_Impl.this.__updateAdapterOfClazzLogAttendanceRecord.handleMultiple((Iterable)entities);
                    ClazzLogAttendanceRecordDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ClazzLogAttendanceRecordDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRescheduledClazzLogUids(long oldClazzLogUid, long newClazzLogUid, long changedTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateRescheduledClazzLogUids.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newClazzLogUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changedTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, oldClazzLogUid);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateRescheduledClazzLogUids.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClazzLogAttendanceRecord findByUid(long uid) {
        String _sql = "SELECT * from ClazzLogAttendanceRecord WHERE clazzLogAttendanceRecordUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from ClazzLogAttendanceRecord WHERE clazzLogAttendanceRecordUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ClazzLogAttendanceRecord _result2;
            int _cursorIndexOfClazzLogAttendanceRecordUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordUid");
            int _cursorIndexOfClazzLogAttendanceRecordClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordClazzLogUid");
            int _cursorIndexOfClazzLogAttendanceRecordPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordPersonUid");
            int _cursorIndexOfAttendanceStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceStatus");
            int _cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordMasterChangeSeqNum");
            int _cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordLocalChangeSeqNum");
            int _cursorIndexOfClazzLogAttendanceRecordLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordLastChangedBy");
            int _cursorIndexOfClazzLogAttendanceRecordLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordLastChangedTime");
            if (_cursor.moveToFirst()) {
                _result2 = new ClazzLogAttendanceRecord();
                long _tmpClazzLogAttendanceRecordUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordUid);
                _result2.setClazzLogAttendanceRecordUid(_tmpClazzLogAttendanceRecordUid);
                long _tmpClazzLogAttendanceRecordClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid);
                _result2.setClazzLogAttendanceRecordClazzLogUid(_tmpClazzLogAttendanceRecordClazzLogUid);
                long _tmpClazzLogAttendanceRecordPersonUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordPersonUid);
                _result2.setClazzLogAttendanceRecordPersonUid(_tmpClazzLogAttendanceRecordPersonUid);
                int _tmpAttendanceStatus = _cursor.getInt(_cursorIndexOfAttendanceStatus);
                _result2.setAttendanceStatus(_tmpAttendanceStatus);
                long _tmpClazzLogAttendanceRecordMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum);
                _result2.setClazzLogAttendanceRecordMasterChangeSeqNum(_tmpClazzLogAttendanceRecordMasterChangeSeqNum);
                long _tmpClazzLogAttendanceRecordLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum);
                _result2.setClazzLogAttendanceRecordLocalChangeSeqNum(_tmpClazzLogAttendanceRecordLocalChangeSeqNum);
                int _tmpClazzLogAttendanceRecordLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy);
                _result2.setClazzLogAttendanceRecordLastChangedBy(_tmpClazzLogAttendanceRecordLastChangedBy);
                long _tmpClazzLogAttendanceRecordLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime);
                _result2.setClazzLogAttendanceRecordLastChangedTime(_tmpClazzLogAttendanceRecordLastChangedTime);
            } else {
                _result2 = null;
            }
            ClazzLogAttendanceRecord clazzLogAttendanceRecord = _result2;
            return clazzLogAttendanceRecord;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByClazzLogUid(long clazzLogUid, Continuation<? super List<ClazzLogAttendanceRecordWithPerson>> $completion) {
        String _sql = "SELECT ClazzLogAttendanceRecord.*, Person.*\n         FROM ClazzLogAttendanceRecord \n         LEFT JOIN Person ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = Person.personUid\n         WHERE clazzLogAttendanceRecordClazzLogUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ClazzLogAttendanceRecord.*, Person.*\n         FROM ClazzLogAttendanceRecord \n         LEFT JOIN Person ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = Person.personUid\n         WHERE clazzLogAttendanceRecordClazzLogUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzLogUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzLogAttendanceRecordWithPerson>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzLogAttendanceRecordWithPerson> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogAttendanceRecordDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzLogAttendanceRecordUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordUid");
                    int _cursorIndexOfClazzLogAttendanceRecordClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordClazzLogUid");
                    int _cursorIndexOfClazzLogAttendanceRecordPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordPersonUid");
                    int _cursorIndexOfAttendanceStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceStatus");
                    int _cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordMasterChangeSeqNum");
                    int _cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordLocalChangeSeqNum");
                    int _cursorIndexOfClazzLogAttendanceRecordLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordLastChangedBy");
                    int _cursorIndexOfClazzLogAttendanceRecordLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordLastChangedTime");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    ArrayList<ClazzLogAttendanceRecordWithPerson> _result2 = new ArrayList<ClazzLogAttendanceRecordWithPerson>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        ClazzLogAttendanceRecordWithPerson _item = new ClazzLogAttendanceRecordWithPerson();
                        long _tmpClazzLogAttendanceRecordUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordUid);
                        _item.setClazzLogAttendanceRecordUid(_tmpClazzLogAttendanceRecordUid);
                        long _tmpClazzLogAttendanceRecordClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid);
                        _item.setClazzLogAttendanceRecordClazzLogUid(_tmpClazzLogAttendanceRecordClazzLogUid);
                        long _tmpClazzLogAttendanceRecordPersonUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordPersonUid);
                        _item.setClazzLogAttendanceRecordPersonUid(_tmpClazzLogAttendanceRecordPersonUid);
                        int _tmpAttendanceStatus = _cursor.getInt(_cursorIndexOfAttendanceStatus);
                        _item.setAttendanceStatus(_tmpAttendanceStatus);
                        long _tmpClazzLogAttendanceRecordMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum);
                        _item.setClazzLogAttendanceRecordMasterChangeSeqNum(_tmpClazzLogAttendanceRecordMasterChangeSeqNum);
                        long _tmpClazzLogAttendanceRecordLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum);
                        _item.setClazzLogAttendanceRecordLocalChangeSeqNum(_tmpClazzLogAttendanceRecordLocalChangeSeqNum);
                        int _tmpClazzLogAttendanceRecordLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy);
                        _item.setClazzLogAttendanceRecordLastChangedBy(_tmpClazzLogAttendanceRecordLastChangedBy);
                        long _tmpClazzLogAttendanceRecordLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime);
                        _item.setClazzLogAttendanceRecordLastChangedTime(_tmpClazzLogAttendanceRecordLastChangedTime);
                        _item.setPerson(_tmpPerson);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzLogAttendanceRecordWithPerson> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByClazzAndTime(long clazzUid, long clazzLogUid, long time, Continuation<? super List<PersonAndClazzLogAttendanceRecord>> $completion) {
        String _sql = "\n        \n        WITH CurrentlyEnrolledPersonUids(enroledPersonUid) AS\n              (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS enroledPersonUid\n                 FROM ClazzEnrolment\n                WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                  AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                  AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft)\n    \n                  \n        SELECT Person.*, ClazzLogAttendanceRecord.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN ClazzLogAttendanceRecord \n                         ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid = \n                            (SELECT ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordUid  \n                               FROM ClazzLogAttendanceRecord ClazzLogAttendanceRecordInner\n                              WHERE ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordClazzLogUid = ?\n                                AND ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordPersonUid = Person.personUid\n                           ORDER BY ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordLastChangedTime DESC     \n                              LIMIT 1  \n                            )\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN \n               (SELECT CurrentlyEnrolledPersonUids.enroledPersonUid\n                  FROM CurrentlyEnrolledPersonUids)                \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        \n        WITH CurrentlyEnrolledPersonUids(enroledPersonUid) AS\n              (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS enroledPersonUid\n                 FROM ClazzEnrolment\n                WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                  AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                  AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft)\n    \n                  \n        SELECT Person.*, ClazzLogAttendanceRecord.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN ClazzLogAttendanceRecord \n                         ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid = \n                            (SELECT ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordUid  \n                               FROM ClazzLogAttendanceRecord ClazzLogAttendanceRecordInner\n                              WHERE ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordClazzLogUid = ?\n                                AND ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordPersonUid = Person.personUid\n                           ORDER BY ClazzLogAttendanceRecordInner.clazzLogAttendanceRecordLastChangedTime DESC     \n                              LIMIT 1  \n                            )\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN \n               (SELECT CurrentlyEnrolledPersonUids.enroledPersonUid\n                  FROM CurrentlyEnrolledPersonUids)                \n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, time);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzLogUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PersonAndClazzLogAttendanceRecord>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PersonAndClazzLogAttendanceRecord> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ClazzLogAttendanceRecordDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPersonalAccount");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfClazzLogAttendanceRecordUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordUid");
                    int _cursorIndexOfClazzLogAttendanceRecordClazzLogUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordClazzLogUid");
                    int _cursorIndexOfClazzLogAttendanceRecordPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordPersonUid");
                    int _cursorIndexOfAttendanceStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"attendanceStatus");
                    int _cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordMasterChangeSeqNum");
                    int _cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordLocalChangeSeqNum");
                    int _cursorIndexOfClazzLogAttendanceRecordLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordLastChangedBy");
                    int _cursorIndexOfClazzLogAttendanceRecordLastChangedTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzLogAttendanceRecordLastChangedTime");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    ArrayList<PersonAndClazzLogAttendanceRecord> _result2 = new ArrayList<PersonAndClazzLogAttendanceRecord>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonPicture _tmpPersonPicture;
                        ClazzLogAttendanceRecord _tmpAttendanceRecord;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
                            boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_2 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordUid) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordPersonUid) && _cursor.isNull(_cursorIndexOfAttendanceStatus) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime))) {
                            _tmpAttendanceRecord = new ClazzLogAttendanceRecord();
                            long _tmpClazzLogAttendanceRecordUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordUid);
                            _tmpAttendanceRecord.setClazzLogAttendanceRecordUid(_tmpClazzLogAttendanceRecordUid);
                            long _tmpClazzLogAttendanceRecordClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid);
                            _tmpAttendanceRecord.setClazzLogAttendanceRecordClazzLogUid(_tmpClazzLogAttendanceRecordClazzLogUid);
                            long _tmpClazzLogAttendanceRecordPersonUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordPersonUid);
                            _tmpAttendanceRecord.setClazzLogAttendanceRecordPersonUid(_tmpClazzLogAttendanceRecordPersonUid);
                            int _tmpAttendanceStatus = _cursor.getInt(_cursorIndexOfAttendanceStatus);
                            _tmpAttendanceRecord.setAttendanceStatus(_tmpAttendanceStatus);
                            long _tmpClazzLogAttendanceRecordMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum);
                            _tmpAttendanceRecord.setClazzLogAttendanceRecordMasterChangeSeqNum(_tmpClazzLogAttendanceRecordMasterChangeSeqNum);
                            long _tmpClazzLogAttendanceRecordLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum);
                            _tmpAttendanceRecord.setClazzLogAttendanceRecordLocalChangeSeqNum(_tmpClazzLogAttendanceRecordLocalChangeSeqNum);
                            int _tmpClazzLogAttendanceRecordLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy);
                            _tmpAttendanceRecord.setClazzLogAttendanceRecordLastChangedBy(_tmpClazzLogAttendanceRecordLastChangedBy);
                            long _tmpClazzLogAttendanceRecordLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime);
                            _tmpAttendanceRecord.setClazzLogAttendanceRecordLastChangedTime(_tmpClazzLogAttendanceRecordLastChangedTime);
                        } else {
                            _tmpAttendanceRecord = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_3 != 0;
                            _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPersonPicture = null;
                        }
                        PersonAndClazzLogAttendanceRecord _item = new PersonAndClazzLogAttendanceRecord(_tmpPerson, _tmpPersonPicture, _tmpAttendanceRecord);
                        _result2.add(_item);
                    }
                    ArrayList<PersonAndClazzLogAttendanceRecord> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

