/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.composites.OfflineItemAndState;
import com.ustadmobile.lib.db.entities.OfflineItem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H'J\u0016\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/ustadmobile/core/db/dao/OfflineItemDao;", "", "()V", "findByContentEntryUid", "Lkotlinx/coroutines/flow/Flow;", "Lcom/ustadmobile/lib/db/composites/OfflineItemAndState;", "contentEntryUid", "", "nodeId", "insertAsync", "item", "Lcom/ustadmobile/lib/db/entities/OfflineItem;", "(Lcom/ustadmobile/lib/db/entities/OfflineItem;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateActiveByOfflineItemUid", "", "oiUid", "active", "", "(JZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_release"})
@Dao
public abstract class OfflineItemDao {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertAsync(@NotNull OfflineItem var1, @NotNull Continuation<? super Long> var2);

    @Query(value="\n        SELECT OfflineItem.*,\n               TransferJob.*,\n               \n        (SELECT SUM(TransferJobItem.tjTotalSize)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS totalSize,\n                (SELECT SUM(TransferJobItem.tjTransferred)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS transferred \n    ,\n               CAST(OfflineItem.oiActive AS INTEGER) = 1 AND (SELECT EXISTS(\n                       SELECT CompletedJob.tjUid\n                         FROM TransferJob CompletedJob\n                        WHERE CompletedJob.tjTableId = 738\n                          AND CompletedJob.tjEntityUid IN  \n                              \n        (SELECT ContentEntryVersion.cevUid\n                         FROM ContentEntryVersion\n                        WHERE ContentEntryVersion.cevContentEntryUid = :contentEntryUid)\n    \n                          AND CompletedJob.tjStatus = 21\n                          AND CompletedJob.tjType = 2\n                          AND CompletedJob.tjTimeCreated >= OfflineItem.oiLct\n                        LIMIT 1      \n               )) AS readyForOffline,\n               NULL AS latestErrorStr\n          FROM OfflineItem\n               LEFT JOIN TransferJob \n                         ON TransferJob.tjUid = \n                         (SELECT TransferJob.tjUid\n                            FROM TransferJob\n                           WHERE TransferJob.tjTableId = 738\n                             AND TransferJob.tjEntityUid IN  \n                                 \n        (SELECT ContentEntryVersion.cevUid\n                         FROM ContentEntryVersion\n                        WHERE ContentEntryVersion.cevContentEntryUid = :contentEntryUid)\n    \n                             AND TransferJob.tjStatus < 21\n                        ORDER BY TransferJob.tjTimeCreated DESC     \n                           LIMIT 1)\n         WHERE OfflineItem.oiNodeId = :nodeId\n           AND OfflineItem.oiContentEntryUid = :contentEntryUid\n      ORDER BY OfflineItem.oiLct DESC\n         LIMIT 1     \n    ")
    @NotNull
    public abstract Flow<OfflineItemAndState> findByContentEntryUid(long var1, long var3);

    @Query(value="\n        UPDATE OfflineItem\n           SET oiActive = :active\n         WHERE oiUid = :oiUid   \n    ")
    @Nullable
    public abstract Object updateActiveByOfflineItemUid(long var1, boolean var3, @NotNull Continuation<? super Unit> var4);
}

