/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.RawQuery;
import androidx.room.Update;
import androidx.sqlite.db.SupportSQLiteQuery;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.entities.Report;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH'J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH'J\u001c\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00110\u00132\u0006\u0010\u000e\u001a\u00020\u000fH'J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nH'J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H'J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0007H'J\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH'J\u0016\u0010\u001f\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H'J,\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010$\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010(\u00a8\u0006)"}, d2={"Lcom/ustadmobile/core/db/dao/ReportDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Report;", "()V", "deleteReportByUid", "", "reportUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllActiveReport", "Landroidx/paging/PagingSource;", "", "searchBit", "", "isTemplate", "", "findAllActiveReportList", "", "findAllActiveReportLive", "Lkotlinx/coroutines/flow/Flow;", "findAllReports", "findByUid", "entityUid", "findByUidList", "uidList", "findByUidLive", "uid", "getResults", "query", "Landroidx/sqlite/db/SupportSQLiteQuery;", "Lcom/ustadmobile/door/DoorQuery;", "replaceList", "entityList", "toggleVisibilityReportItems", "toggleVisibility", "selectedItem", "updateTime", "(ZLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/Report;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_release"})
@Dao
public abstract class ReportDao
implements BaseDao<Report> {
    @RawQuery(observedEntities={})
    @NotNull
    public abstract List<Report> getResults(@NotNull SupportSQLiteQuery var1);

    @Query(value="DELETE FROM Report WHERE reportUid = :reportUid")
    @Nullable
    public abstract Object deleteReportByUid(long var1, @NotNull Continuation<? super Unit> var3);

    @Query(value="SELECT * FROM Report ORDER BY reportTitle ASC")
    @NotNull
    public abstract PagingSource<Integer, Report> findAllReports();

    @Query(value="\n        SELECT * FROM Report \n        WHERE reportIsTemplate = :isTemplate\n        AND reportTitle LIKE :searchBit\n        ORDER BY reportTitle\n    ")
    @NotNull
    public abstract PagingSource<Integer, Report> findAllActiveReport(@NotNull String var1, boolean var2);

    @Query(value="SELECT * FROM Report WHERE reportUid = :entityUid")
    @Nullable
    public abstract Object findByUid(long var1, @NotNull Continuation<? super Report> var3);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull Report var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="SELECT * FROM Report WHERE reportUid = :uid")
    @NotNull
    public abstract Flow<Report> findByUidLive(long var1);

    @Query(value="\n        SELECT * FROM Report \n        WHERE reportIsTemplate = :isTemplate\n        ORDER BY reportTitle ASC\n    ")
    @NotNull
    public abstract Flow<List<Report>> findAllActiveReportLive(boolean var1);

    @Query(value="\n        SELECT * FROM Report \n        WHERE reportIsTemplate = :isTemplate\n        ORDER BY reportTitle ASC\n    ")
    @NotNull
    public abstract List<Report> findAllActiveReportList(boolean var1);

    @Query(value="SELECT reportUid FROM Report WHERE reportUid IN (:uidList)")
    @NotNull
    public abstract List<Long> findByUidList(@NotNull List<Long> var1);

    @Query(value="\n        UPDATE Report \n        SET reportIsTemplate = :toggleVisibility,\n            reportLastModTime = :updateTime\n        WHERE reportUid IN (:selectedItem)\n    ")
    @Nullable
    public abstract Object toggleVisibilityReportItems(boolean var1, @NotNull List<Long> var2, long var3, @NotNull Continuation<? super Unit> var5);

    @Insert(entity=Object.class, onConflict=1)
    public abstract void replaceList(@NotNull List<Report> var1);
}

