/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.composites.StudentResultAndCourseBlockSourcedId;
import com.ustadmobile.lib.db.entities.StudentResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u0007J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u00a7@\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\tH\u00a7@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0016H\u00a7@\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/ustadmobile/core/db/dao/StudentResultDao;", "", "()V", "existsByUid", "", "srUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByClazzAndStudent", "", "Lcom/ustadmobile/lib/db/composites/StudentResultAndCourseBlockSourcedId;", "clazzUid", "studentPersonUid", "accountPersonUid", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findUidBySourcedId", "sourcedId", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertListAsync", "", "list", "Lcom/ustadmobile/lib/db/entities/StudentResult;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "upsertAsync", "studentResult", "(Lcom/ustadmobile/lib/db/entities/StudentResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_release"})
@Dao
public abstract class StudentResultDao {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertListAsync(@NotNull List<StudentResult> var1, @NotNull Continuation<? super Unit> var2);

    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsertAsync(@NotNull StudentResult var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT StudentResult.*,\n               CourseBlock.cbSourcedId AS cbSourcedId\n          FROM StudentResult\n               LEFT JOIN CourseBlock\n                         ON StudentResult.srCourseBlockUid = CourseBlock.cbUid \n         WHERE StudentResult.srClazzUid = :clazzUid\n           AND StudentResult.srStudentPersonUid = :studentPersonUid\n           AND :accountPersonUid = :accountPersonUid\n    ")
    @Nullable
    public abstract Object findByClazzAndStudent(long var1, long var3, long var5, @NotNull Continuation<? super List<StudentResultAndCourseBlockSourcedId>> var7);

    @Query(value="\n        SELECT COALESCE(\n               (SELECT StudentResult.srUid  \n                  FROM StudentResult \n                 WHERE srSourcedId = :sourcedId), 0)\n    ")
    @Nullable
    public abstract Object findUidBySourcedId(@NotNull String var1, @NotNull Continuation<? super Long> var2);

    @Query(value="\n        SELECT EXISTS(\n               SELECT StudentResult.srUid\n                 FROM StudentResult\n                WHERE StudentResult.srUid = :srUid)\n    ")
    @Nullable
    public abstract Object existsByUid(long var1, @NotNull Continuation<? super Boolean> var3);
}

