/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.VerbLangMapEntryDao;
import com.ustadmobile.lib.db.entities.xapi.VerbLangMapEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class VerbLangMapEntryDao_Impl
extends VerbLangMapEntryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<VerbLangMapEntry> __insertionAdapterOfVerbLangMapEntry;

    public VerbLangMapEntryDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfVerbLangMapEntry = new EntityInsertionAdapter<VerbLangMapEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `VerbLangMapEntry` (`vlmeVerbUid`,`vlmeLangHash`,`vlmeLangCode`,`vlmeEntryString`,`vlmeLastModified`) VALUES (?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull VerbLangMapEntry entity) {
                statement.bindLong(1, entity.getVlmeVerbUid());
                statement.bindLong(2, entity.getVlmeLangHash());
                if (entity.getVlmeLangCode() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getVlmeLangCode());
                }
                if (entity.getVlmeEntryString() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getVlmeEntryString());
                }
                statement.bindLong(5, entity.getVlmeLastModified());
            }
        };
    }

    @Override
    public Object upsertList(final List<VerbLangMapEntry> list, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                VerbLangMapEntryDao_Impl.this.__db.beginTransaction();
                try {
                    VerbLangMapEntryDao_Impl.this.__insertionAdapterOfVerbLangMapEntry.insert((Iterable)list);
                    VerbLangMapEntryDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    VerbLangMapEntryDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByVerbUidAsync(long verbUid, Continuation<? super List<VerbLangMapEntry>> $completion) {
        String _sql = "\n        SELECT VerbLangMapEntry.*\n          FROM VerbLangMapEntry\n         WHERE VerbLangMapEntry.vlmeVerbUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT VerbLangMapEntry.*\n          FROM VerbLangMapEntry\n         WHERE VerbLangMapEntry.vlmeVerbUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, verbUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<VerbLangMapEntry>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<VerbLangMapEntry> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)VerbLangMapEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfVlmeVerbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeVerbUid");
                    int _cursorIndexOfVlmeLangHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeLangHash");
                    int _cursorIndexOfVlmeLangCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeLangCode");
                    int _cursorIndexOfVlmeEntryString = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeEntryString");
                    int _cursorIndexOfVlmeLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vlmeLastModified");
                    ArrayList<VerbLangMapEntry> _result2 = new ArrayList<VerbLangMapEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpVlmeVerbUid = _cursor.getLong(_cursorIndexOfVlmeVerbUid);
                        long _tmpVlmeLangHash = _cursor.getLong(_cursorIndexOfVlmeLangHash);
                        String _tmpVlmeLangCode = _cursor.isNull(_cursorIndexOfVlmeLangCode) ? null : _cursor.getString(_cursorIndexOfVlmeLangCode);
                        String _tmpVlmeEntryString = _cursor.isNull(_cursorIndexOfVlmeEntryString) ? null : _cursor.getString(_cursorIndexOfVlmeEntryString);
                        long _tmpVlmeLastModified = _cursor.getLong(_cursorIndexOfVlmeLastModified);
                        VerbLangMapEntry _item = new VerbLangMapEntry(_tmpVlmeVerbUid, _tmpVlmeLangHash, _tmpVlmeLangCode, _tmpVlmeEntryString, _tmpVlmeLastModified);
                        _result2.add(_item);
                    }
                    ArrayList<VerbLangMapEntry> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

