/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.composites.ClazzInviteAndClazz;
import com.ustadmobile.lib.db.composites.ClazzInviteWithTimeZone;
import com.ustadmobile.lib.db.entities.ClazzInvite;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0018\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u00a7@\u00a2\u0006\u0002\u0010\u0010J,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H'J\u001c\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u00a7@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u00a7@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001f\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ&\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u00a7@\u00a2\u0006\u0002\u0010$\u00a8\u0006%"}, d2={"Lcom/ustadmobile/core/db/dao/ClazzInviteDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ClazzInvite;", "()V", "findClazzInviteEntityForInviteToken", "Lcom/ustadmobile/lib/db/composites/ClazzInviteWithTimeZone;", "inviteTokenUid", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findClazzInviteEntityForInviteTokenAsFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/ustadmobile/lib/db/composites/ClazzInviteAndClazz;", "findClazzInviteFromContact", "inviteContact", "findInviteAsync", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findPendingInviteByPersonUid", "Landroidx/paging/PagingSource;", "", "ciPersonUid", "", "clazzUid", "currentTime", "insertAll", "", "entity", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replace", "(Lcom/ustadmobile/lib/db/entities/ClazzInvite;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAll", "updateClazzInviteToRevokeInvite", "updateInviteStatus", "status", "ciUid", "updateTime", "(IJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_debug"})
@Dao
public abstract class ClazzInviteDao
implements BaseDao<ClazzInvite> {
    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object replace(@NotNull ClazzInvite var1, @NotNull Continuation<? super Long> var2);

    @Insert(entity=Object.class, onConflict=5)
    @Nullable
    public abstract Object insertAll(@NotNull List<ClazzInvite> var1, @NotNull Continuation<? super Unit> var2);

    @Update(entity=Object.class, onConflict=5)
    @Nullable
    public abstract Object updateAll(@NotNull List<ClazzInvite> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="SELECT * FROM ClazzInvite")
    @Nullable
    public abstract Object findInviteAsync(@NotNull Continuation<? super List<ClazzInvite>> var1);

    @Query(value="\n    SELECT ClazzInvite.*, \n           COALESCE(Clazz.clazzTimeZone, 'UTC') AS timeZone\n      FROM ClazzInvite\n           LEFT JOIN Clazz \n                     ON Clazz.clazzUid = ClazzInvite.ciClazzUid\n     WHERE ClazzInvite.inviteToken = :inviteTokenUid\n")
    @Nullable
    public abstract Object findClazzInviteEntityForInviteToken(@NotNull String var1, @NotNull Continuation<? super ClazzInviteWithTimeZone> var2);

    @Query(value="\n    SELECT ClazzInvite.*, Clazz.*\n      FROM ClazzInvite\n           JOIN Clazz \n                ON Clazz.clazzUid = ClazzInvite.ciClazzUid\n     WHERE ClazzInvite.inviteToken = :inviteTokenUid\n    ")
    @NotNull
    public abstract Flow<ClazzInviteAndClazz> findClazzInviteEntityForInviteTokenAsFlow(@NotNull String var1);

    @Query(value="\n        UPDATE ClazzInvite \n           SET inviteStatus = :status,\n               inviteLct = :updateTime\n         WHERE ClazzInvite.ciUid =:ciUid\n    ")
    @Nullable
    public abstract Object updateInviteStatus(int var1, long var2, long var4, @NotNull Continuation<? super Unit> var6);

    @Query(value="SELECT * FROM ClazzInvite \n                 WHERE ciPersonUid = :ciPersonUid AND ciClazzUid = :clazzUid \n              AND inviteExpire > :currentTime AND inviteStatus = 0")
    @NotNull
    public abstract PagingSource<Integer, ClazzInvite> findPendingInviteByPersonUid(long var1, long var3, long var5);

    @Query(value="\n        UPDATE ClazzInvite \n          SET inviteStatus = 3\n        WHERE inviteContact = :inviteContact")
    @Nullable
    public abstract Object updateClazzInviteToRevokeInvite(@NotNull String var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="SELECT * FROM ClazzInvite WHERE inviteContact = :inviteContact")
    @Nullable
    public abstract Object findClazzInviteFromContact(@NotNull String var1, @NotNull Continuation<? super ClazzInvite> var2);
}

