/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.ActivityInteractionDao;
import com.ustadmobile.lib.db.entities.xapi.ActivityInteractionEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ActivityInteractionDao_Impl
extends ActivityInteractionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ActivityInteractionEntity> __insertionAdapterOfActivityInteractionEntity;

    public ActivityInteractionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfActivityInteractionEntity = new EntityInsertionAdapter<ActivityInteractionEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `ActivityInteractionEntity` (`aieActivityUid`,`aieHash`,`aieProp`,`aieId`,`aieLastMod`,`aieIsDeleted`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ActivityInteractionEntity entity) {
                statement.bindLong(1, entity.getAieActivityUid());
                statement.bindLong(2, entity.getAieHash());
                statement.bindLong(3, (long)entity.getAieProp());
                if (entity.getAieId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getAieId());
                }
                statement.bindLong(5, entity.getAieLastMod());
                int _tmp = entity.getAieIsDeleted() ? 1 : 0;
                statement.bindLong(6, (long)_tmp);
            }
        };
    }

    @Override
    public Object insertOrIgnoreAsync(final List<ActivityInteractionEntity> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ActivityInteractionDao_Impl.this.__db.beginTransaction();
                try {
                    ActivityInteractionDao_Impl.this.__insertionAdapterOfActivityInteractionEntity.insert((Iterable)entities);
                    ActivityInteractionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ActivityInteractionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findActivityUidsWithInteractionEntitiesAsync(List<Long> activityUids, Continuation<? super List<Long>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT DISTINCT ActivityInteractionEntity.aieActivityUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM ActivityInteractionEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE ActivityInteractionEntity.aieActivityUid IN (");
        int _inputSize = activityUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : activityUids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<Long>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Long> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActivityInteractionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<Long> _result2 = new ArrayList<Long>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Long _item_1 = _cursor.getLong(0);
                        _result2.add(_item_1);
                    }
                    ArrayList<Long> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllByActivityUidAsync(long activityUid, Continuation<? super List<ActivityInteractionEntity>> $completion) {
        String _sql = "\n        SELECT ActivityInteractionEntity.*\n          FROM ActivityInteractionEntity\n         WHERE ActivityInteractionEntity.aieActivityUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ActivityInteractionEntity.*\n          FROM ActivityInteractionEntity\n         WHERE ActivityInteractionEntity.aieActivityUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, activityUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ActivityInteractionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ActivityInteractionEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActivityInteractionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfAieActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aieActivityUid");
                    int _cursorIndexOfAieHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aieHash");
                    int _cursorIndexOfAieProp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aieProp");
                    int _cursorIndexOfAieId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aieId");
                    int _cursorIndexOfAieLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aieLastMod");
                    int _cursorIndexOfAieIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aieIsDeleted");
                    ArrayList<ActivityInteractionEntity> _result2 = new ArrayList<ActivityInteractionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpAieActivityUid = _cursor.getLong(_cursorIndexOfAieActivityUid);
                        long _tmpAieHash = _cursor.getLong(_cursorIndexOfAieHash);
                        int _tmpAieProp = _cursor.getInt(_cursorIndexOfAieProp);
                        String _tmpAieId = _cursor.isNull(_cursorIndexOfAieId) ? null : _cursor.getString(_cursorIndexOfAieId);
                        long _tmpAieLastMod = _cursor.getLong(_cursorIndexOfAieLastMod);
                        int _tmp = _cursor.getInt(_cursorIndexOfAieIsDeleted);
                        boolean _tmpAieIsDeleted = _tmp != 0;
                        ActivityInteractionEntity _item = new ActivityInteractionEntity(_tmpAieActivityUid, _tmpAieHash, _tmpAieProp, _tmpAieId, _tmpAieLastMod, _tmpAieIsDeleted);
                        _result2.add(_item);
                    }
                    ArrayList<ActivityInteractionEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

