/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Objects;

public enum UserVerificationMethod {
    PRESENCE_INTERNAL(1L, "presence_internal"),
    FINGERPRINT_INTERNAL(2L, "fingerprint_internal"),
    PASSCODE_INTERNAL(4L, "passcode_internal"),
    VOICEPRINT_INTERNAL(8L, "voiceprint_internal"),
    FACEPRINT_INTERNAL(16L, "faceprint_internal"),
    LOCATION_INTERNAL(32L, "location_internal"),
    EYEPRINT_INTERNAL(64L, "eyeprint_internal"),
    PATTERN_INTERNAL(128L, "pattern_internal"),
    HANDPRINT_INTERNAL(256L, "handprint_internal"),
    PASSCODE_EXTERNAL(2048L, "passcode_external"),
    PATTERN_EXTERNAL(4096L, "pattern_external"),
    NONE(512L, "none"),
    ALL(1024L, "all");

    private static final String VALUE_OUT_OF_RANGE_TEMPLATE = "value %s is out of range";
    private final long value;
    private final String string;

    private UserVerificationMethod(long value, String string3) {
        this.value = value;
        this.string = string3;
    }

    public static UserVerificationMethod create(String value) {
        return Arrays.stream(UserVerificationMethod.values()).filter(item2 -> Objects.equals(item2.string, value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public static UserVerificationMethod create(long value) {
        if (value > 0xFFFFFFFFL || value < 0L) {
            throw new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value));
        }
        return Arrays.stream(UserVerificationMethod.values()).filter(item2 -> item2.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    public String toString() {
        return this.string;
    }
}

