/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.cors;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.response.ApplicationResponse;
import io.ktor.server.response.ApplicationResponsePropertiesKt;
import io.ktor.util.reflect.TypeInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a+\u0010\u0007\u001a\u00020\u0006*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0013\u0010\t\u001a\u00020\u0006*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001b\u0010\u000b\u001a\u00020\u0006*\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u001d\u0010\u000e\u001a\u00020\u0006*\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001f\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001aa\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00160\u00142\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u00190\u0018H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001aE\u0010 \u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u00190\u0018H\u0000\u00a2\u0006\u0004\b \u0010!\u001a1\u0010#\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00012\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u00190\u0018H\u0000\u00a2\u0006\u0004\b#\u0010$\u001a!\u0010'\u001a\u00020\u0003*\u00020\u00002\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u0014H\u0000\u00a2\u0006\u0004\b'\u0010(\u001a!\u0010)\u001a\u00020\u0003*\u00020\u00002\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u0014H\u0000\u00a2\u0006\u0004\b)\u0010(\u001a\u0014\u0010*\u001a\u00020\u0006*\u00020\u0000H\u0080@\u00a2\u0006\u0004\b*\u0010+\u001a\u0017\u0010,\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b,\u0010-\u001a\u0017\u0010.\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b.\u0010/\"\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102\u00a8\u00063"}, d2={"Lio/ktor/server/application/ApplicationCall;", "", "origin", "", "allowsAnyHost", "allowCredentials", "", "accessControlAllowOrigin", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;ZZ)V", "corsVary", "(Lio/ktor/server/application/ApplicationCall;)V", "accessControlAllowCredentials", "(Lio/ktor/server/application/ApplicationCall;Z)V", "maxAgeHeaderValue", "accessControlMaxAge", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;)V", "Lio/ktor/http/RequestConnectionPoint;", "point", "isSameOrigin", "(Ljava/lang/String;Lio/ktor/http/RequestConnectionPoint;)Z", "", "hostsNormalized", "Lkotlin/Pair;", "hostsWithWildcard", "", "Lkotlin/Function1;", "originPredicates", "corsCheckOrigins", "(Ljava/lang/String;ZLjava/util/Set;Ljava/util/Set;Ljava/util/List;)Z", "requestHeaders", "allHeadersSet", "headerPredicates", "corsCheckRequestHeaders", "(Ljava/util/List;Ljava/util/Set;Ljava/util/List;)Z", "header", "headerMatchesAPredicate", "(Ljava/lang/String;Ljava/util/List;)Z", "Lio/ktor/http/HttpMethod;", "methods", "corsCheckCurrentMethod", "(Lio/ktor/server/application/ApplicationCall;Ljava/util/Set;)Z", "corsCheckRequestMethod", "respondCorsFailed", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isValidOrigin", "(Ljava/lang/String;)Z", "normalizeOrigin", "(Ljava/lang/String;)Ljava/lang/String;", "Lkotlin/text/Regex;", "NUMBER_REGEX", "Lkotlin/text/Regex;", "ktor-server-cors"})
@SourceDebugExtension(value={"SMAP\nCORSUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CORSUtils.kt\nio/ktor/server/plugins/cors/CORSUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ApplicationResponseFunctions.kt\nio/ktor/server/response/ApplicationResponseFunctionsKt\n+ 5 Type.kt\nio/ktor/util/reflect/TypeKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,138:1\n1761#2,3:139\n1761#2,3:142\n1740#2,3:145\n1761#2,3:148\n1#3:151\n28#4:152\n29#4:162\n69#5:153\n84#5,8:154\n1069#6,2:163\n*S KotlinDebug\n*F\n+ 1 CORSUtils.kt\nio/ktor/server/plugins/cors/CORSUtilsKt\n*L\n57#1:139,3\n58#1:142,3\n65#1:145,3\n70#1:148,3\n80#1:152\n80#1:162\n80#1:153\n80#1:154,8\n93#1:163,2\n*E\n"})
public final class CORSUtilsKt {
    @NotNull
    private static final Regex NUMBER_REGEX = new Regex("[0-9]+");

    public static final void accessControlAllowOrigin(@NotNull ApplicationCall $this$accessControlAllowOrigin, @NotNull String origin, boolean allowsAnyHost, boolean allowCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$accessControlAllowOrigin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        String headerOrigin = allowsAnyHost && !allowCredentials ? "*" : origin;
        ApplicationResponsePropertiesKt.header((ApplicationResponse)$this$accessControlAllowOrigin.getResponse(), (String)HttpHeaders.INSTANCE.getAccessControlAllowOrigin(), (String)headerOrigin);
    }

    public static final void corsVary(@NotNull ApplicationCall $this$corsVary) {
        Intrinsics.checkNotNullParameter((Object)$this$corsVary, (String)"<this>");
        String vary = $this$corsVary.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getVary());
        String varyValue = vary == null ? HttpHeaders.INSTANCE.getOrigin() : vary + ", " + HttpHeaders.INSTANCE.getOrigin();
        ApplicationResponsePropertiesKt.header((ApplicationResponse)$this$corsVary.getResponse(), (String)HttpHeaders.INSTANCE.getVary(), (String)varyValue);
    }

    public static final void accessControlAllowCredentials(@NotNull ApplicationCall $this$accessControlAllowCredentials, boolean allowCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$accessControlAllowCredentials, (String)"<this>");
        if (allowCredentials) {
            ApplicationResponsePropertiesKt.header((ApplicationResponse)$this$accessControlAllowCredentials.getResponse(), (String)HttpHeaders.INSTANCE.getAccessControlAllowCredentials(), (String)"true");
        }
    }

    public static final void accessControlMaxAge(@NotNull ApplicationCall $this$accessControlMaxAge, @Nullable String maxAgeHeaderValue) {
        Intrinsics.checkNotNullParameter((Object)$this$accessControlMaxAge, (String)"<this>");
        if (maxAgeHeaderValue != null) {
            ApplicationResponsePropertiesKt.header((ApplicationResponse)$this$accessControlMaxAge.getResponse(), (String)HttpHeaders.INSTANCE.getAccessControlMaxAge(), (String)maxAgeHeaderValue);
        }
    }

    public static final boolean isSameOrigin(@NotNull String origin, @NotNull RequestConnectionPoint point) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        String requestOrigin = point.getScheme() + "://" + point.getServerHost() + ':' + point.getServerPort();
        return Intrinsics.areEqual((Object)CORSUtilsKt.normalizeOrigin(requestOrigin), (Object)CORSUtilsKt.normalizeOrigin(origin));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean corsCheckOrigins(@NotNull String origin, boolean allowsAnyHost, @NotNull Set<String> hostsNormalized, @NotNull Set<Pair<String, String>> hostsWithWildcard, @NotNull List<? extends Function1<? super String, Boolean>> originPredicates) {
        Function1 it;
        boolean bl;
        Iterable $this$any$iv;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(hostsNormalized, (String)"hostsNormalized");
        Intrinsics.checkNotNullParameter(hostsWithWildcard, (String)"hostsWithWildcard");
        Intrinsics.checkNotNullParameter(originPredicates, (String)"originPredicates");
        String normalizedOrigin = CORSUtilsKt.normalizeOrigin(origin);
        if (allowsAnyHost) return true;
        if (hostsNormalized.contains(normalizedOrigin)) return true;
        Iterable iterable = hostsWithWildcard;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                String prefix = (String)pair.component1();
                String suffix = (String)pair.component2();
                if (StringsKt.startsWith$default((String)normalizedOrigin, (String)prefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)normalizedOrigin, (String)suffix, (boolean)false, (int)2, null)) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = originPredicates;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (Function1)element$iv;
            boolean bl4 = false;
        } while (!((Boolean)it.invoke((Object)origin)).booleanValue());
        return true;
    }

    public static final boolean corsCheckRequestHeaders(@NotNull List<String> requestHeaders, @NotNull Set<String> allHeadersSet, @NotNull List<? extends Function1<? super String, Boolean>> headerPredicates) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            Intrinsics.checkNotNullParameter(allHeadersSet, (String)"allHeadersSet");
            Intrinsics.checkNotNullParameter(headerPredicates, (String)"headerPredicates");
            Iterable $this$all$iv = requestHeaders;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String header = (String)element$iv;
                    boolean bl2 = false;
                    if (allHeadersSet.contains(header) || CORSUtilsKt.headerMatchesAPredicate(header, headerPredicates)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean headerMatchesAPredicate(@NotNull String header, @NotNull List<? extends Function1<? super String, Boolean>> headerPredicates) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter(headerPredicates, (String)"headerPredicates");
            Iterable $this$any$iv = headerPredicates;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)it.invoke((Object)header)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean corsCheckCurrentMethod(@NotNull ApplicationCall $this$corsCheckCurrentMethod, @NotNull Set<HttpMethod> methods) {
        Intrinsics.checkNotNullParameter((Object)$this$corsCheckCurrentMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        return methods.contains(ApplicationRequestPropertiesKt.getHttpMethod((ApplicationRequest)$this$corsCheckCurrentMethod.getRequest()));
    }

    public static final boolean corsCheckRequestMethod(@NotNull ApplicationCall $this$corsCheckRequestMethod, @NotNull Set<HttpMethod> methods) {
        HttpMethod httpMethod;
        Intrinsics.checkNotNullParameter((Object)$this$corsCheckRequestMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        String string = ApplicationRequestPropertiesKt.header((ApplicationRequest)$this$corsCheckRequestMethod.getRequest(), (String)HttpHeaders.INSTANCE.getAccessControlRequestMethod());
        if (string != null) {
            String it = string;
            boolean bl = false;
            httpMethod = new HttpMethod(it);
        } else {
            httpMethod = null;
        }
        HttpMethod requestMethod = httpMethod;
        return requestMethod != null && methods.contains(requestMethod);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object respondCorsFailed(@NotNull ApplicationCall $this$respondCorsFailed, @NotNull Continuation<? super Unit> $completion) {
        KType kType;
        void $this$respond$iv;
        ApplicationCall applicationCall = $this$respondCorsFailed;
        HttpStatusCode message$iv = HttpStatusCode.Companion.getForbidden();
        boolean $i$f$respond = false;
        HttpStatusCode httpStatusCode = message$iv;
        void var6_6 = $this$respond$iv;
        boolean $i$f$typeInfo = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(HttpStatusCode.class);
        boolean $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(HttpStatusCode.class);
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KType kType2 = kType;
        KClass kClass2 = kClass;
        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
        Object object = var6_6.respond((Object)httpStatusCode, typeInfo, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidOrigin(@NotNull String origin) {
        int index;
        int n;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (((CharSequence)origin).length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (Intrinsics.areEqual((Object)origin, (Object)"null")) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)origin, (CharSequence)"%", (boolean)false, (int)2, null)) {
            return false;
        }
        int protoDelimiter = StringsKt.indexOf$default((CharSequence)origin, (String)"://", (int)0, (boolean)false, (int)6, null);
        if (protoDelimiter <= 0) {
            return false;
        }
        if (!Character.isLetter(origin.charAt(0))) return false;
        CharSequence $this$all$iv = origin.subSequence(0, protoDelimiter);
        boolean $i$f$all = false;
        for (n = 0; n < $this$all$iv.length(); ++n) {
            char element$iv;
            char ch = element$iv = $this$all$iv.charAt(n);
            boolean bl2 = false;
            if (!Character.isLetter(ch) && !Character.isDigit(ch) && ch != '-' && ch != '+') {
                if (ch != '.') return false;
            }
            boolean bl3 = true;
            if (bl3) continue;
            return false;
        }
        boolean bl4 = true;
        if (!bl4) return false;
        boolean bl5 = true;
        boolean protoValid = bl5;
        if (!protoValid) {
            return false;
        }
        int portIndex = origin.length();
        n = origin.length();
        block4: for (index = protoDelimiter + 3; index < n; ++index) {
            char ch = origin.charAt(index);
            switch (ch) {
                case '/': 
                case ':': {
                    portIndex = index + 1;
                    break block4;
                }
                default: {
                    if (ch != '?') continue block4;
                    return false;
                }
            }
        }
        index = portIndex;
        n = origin.length();
        while (index < n) {
            boolean isTrailingSlash;
            boolean bl6 = isTrailingSlash = index == origin.length() - 1 && origin.charAt(index) == '/';
            if (!Character.isDigit(origin.charAt(index)) && !isTrailingSlash) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @NotNull
    public static final String normalizeOrigin(@NotNull String origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (Intrinsics.areEqual((Object)origin, (Object)"null") || Intrinsics.areEqual((Object)origin, (Object)"*")) {
            return origin;
        }
        StringBuilder builder = new StringBuilder(origin.length());
        StringBuilder stringBuilder = StringsKt.endsWith$default((String)origin, (String)"/", (boolean)false, (int)2, null) ? builder.append(origin, 0, origin.length() - 1) : builder.append(origin);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CharSequence charSequence = StringsKt.substringAfterLast((String)string, (String)":", (String)"");
        if (!NUMBER_REGEX.matches(charSequence)) {
            String port;
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = StringsKt.substringBefore$default((String)string2, (char)':', null, (int)2, null);
            String string4 = Intrinsics.areEqual((Object)string3, (Object)"http") ? "80" : (port = Intrinsics.areEqual((Object)string3, (Object)"https") ? "443" : null);
            if (port != null) {
                builder.append(':' + port);
            }
        }
        String string5 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        return string5;
    }
}

