/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.account.validateqrbadge;

import androidx.compose.runtime.internal.StabilityInferred;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.shared.domain.account.validateqrbadge.QrValidationResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u0086\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lworld/respect/shared/domain/account/validateqrbadge/ValidateQrCodeUseCase;", "", "schoolUrl", "Lio/ktor/http/Url;", "<init>", "(Lio/ktor/http/Url;)V", "invoke", "Lworld/respect/shared/domain/account/validateqrbadge/QrValidationResult;", "qrCodeUrl", "", "personGuid", "isValidUrlFormat", "", "isValidSchoolUrl", "hasValidBadgeSection", "respect-lib-shared"})
@StabilityInferred(parameters=0)
public final class ValidateQrCodeUseCase {
    @Nullable
    private final Url schoolUrl;
    public static final int $stable = 8;

    public ValidateQrCodeUseCase(@Nullable Url schoolUrl) {
        this.schoolUrl = schoolUrl;
    }

    @NotNull
    public final QrValidationResult invoke(@NotNull String qrCodeUrl, @Nullable String personGuid) {
        Intrinsics.checkNotNullParameter((Object)qrCodeUrl, (String)"qrCodeUrl");
        if (!this.isValidUrlFormat(qrCodeUrl)) {
            return QrValidationResult.Companion.getInvalidUrl();
        }
        if (!this.isValidSchoolUrl(qrCodeUrl)) {
            return QrValidationResult.Companion.getInvalidUrl();
        }
        if (!this.hasValidBadgeSection(qrCodeUrl)) {
            return QrValidationResult.Companion.getInvalidUrl();
        }
        return QrValidationResult.Companion.getValid();
    }

    public static /* synthetic */ QrValidationResult invoke$default(ValidateQrCodeUseCase validateQrCodeUseCase, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        return validateQrCodeUseCase.invoke(string2, string3);
    }

    private final boolean isValidUrlFormat(String qrCodeUrl) {
        boolean bl;
        try {
            URLUtilsKt.Url((String)qrCodeUrl);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final boolean isValidSchoolUrl(String qrCodeUrl) {
        return this.schoolUrl != null ? StringsKt.startsWith$default((String)qrCodeUrl, (String)this.schoolUrl.toString(), (boolean)false, (int)2, null) : true;
    }

    private final boolean hasValidBadgeSection(String qrCodeUrl) {
        return StringsKt.contains((CharSequence)qrCodeUrl, (CharSequence)"/personqrbadge", (boolean)true);
    }
}

