/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.HintHandlerKt;
import androidx.paging.LoadType;
import androidx.paging.ViewportHint;
import androidx.paging.internal.SynchronizedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fR\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Landroidx/paging/HintHandler;", "", "<init>", "()V", "state", "Landroidx/paging/HintHandler$State;", "lastAccessHint", "Landroidx/paging/ViewportHint$Access;", "getLastAccessHint", "()Landroidx/paging/ViewportHint$Access;", "hintFor", "Lkotlinx/coroutines/flow/Flow;", "Landroidx/paging/ViewportHint;", "loadType", "Landroidx/paging/LoadType;", "forceSetHint", "", "viewportHint", "processHint", "State", "HintFlow", "paging-common"})
public final class HintHandler {
    @NotNull
    private final State state = new State();

    @Nullable
    public final ViewportHint.Access getLastAccessHint() {
        return this.state.getLastAccessHint();
    }

    @NotNull
    public final Flow<ViewportHint> hintFor(@NotNull LoadType loadType) {
        Flow<ViewportHint> flow2;
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        switch (WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()]) {
            case 1: {
                flow2 = this.state.getPrependFlow();
                break;
            }
            case 2: {
                flow2 = this.state.getAppendFlow();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid load type for hints");
            }
        }
        return flow2;
    }

    public final void forceSetHint(@NotNull LoadType loadType, @NotNull ViewportHint viewportHint) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        Intrinsics.checkNotNullParameter((Object)viewportHint, (String)"viewportHint");
        if (!(loadType == LoadType.PREPEND || loadType == LoadType.APPEND)) {
            boolean bl = false;
            String string = "invalid load type for reset: " + loadType;
            throw new IllegalArgumentException(string.toString());
        }
        this.state.modify(null, (Function2<? super HintFlow, ? super HintFlow, Unit>)((Function2)(arg_0, arg_1) -> HintHandler.forceSetHint$lambda$1(loadType, viewportHint, arg_0, arg_1)));
    }

    public final void processHint(@NotNull ViewportHint viewportHint) {
        Intrinsics.checkNotNullParameter((Object)viewportHint, (String)"viewportHint");
        this.state.modify(viewportHint instanceof ViewportHint.Access ? (ViewportHint.Access)viewportHint : null, (Function2<? super HintFlow, ? super HintFlow, Unit>)((Function2)(arg_0, arg_1) -> HintHandler.processHint$lambda$2(viewportHint, arg_0, arg_1)));
    }

    private static final Unit forceSetHint$lambda$1(LoadType $loadType, ViewportHint $viewportHint, HintFlow prependHint, HintFlow appendHint) {
        Intrinsics.checkNotNullParameter((Object)prependHint, (String)"prependHint");
        Intrinsics.checkNotNullParameter((Object)appendHint, (String)"appendHint");
        if ($loadType == LoadType.PREPEND) {
            prependHint.setValue($viewportHint);
        } else {
            appendHint.setValue($viewportHint);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processHint$lambda$2(ViewportHint $viewportHint, HintFlow prependHint, HintFlow appendHint) {
        Intrinsics.checkNotNullParameter((Object)prependHint, (String)"prependHint");
        Intrinsics.checkNotNullParameter((Object)appendHint, (String)"appendHint");
        if (HintHandlerKt.shouldPrioritizeOver($viewportHint, prependHint.getValue(), LoadType.PREPEND)) {
            prependHint.setValue($viewportHint);
        }
        if (HintHandlerKt.shouldPrioritizeOver($viewportHint, appendHint.getValue(), LoadType.APPEND)) {
            appendHint.setValue($viewportHint);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Landroidx/paging/HintHandler$HintFlow;", "", "<init>", "(Landroidx/paging/HintHandler;)V", "value", "Landroidx/paging/ViewportHint;", "getValue", "()Landroidx/paging/ViewportHint;", "setValue", "(Landroidx/paging/ViewportHint;)V", "_flow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "flow", "Lkotlinx/coroutines/flow/Flow;", "getFlow", "()Lkotlinx/coroutines/flow/Flow;", "paging-common"})
    private final class HintFlow {
        @Nullable
        private ViewportHint value;
        @NotNull
        private final MutableSharedFlow<ViewportHint> _flow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);

        @Nullable
        public final ViewportHint getValue() {
            return this.value;
        }

        public final void setValue(@Nullable ViewportHint value) {
            this.value = value;
            if (value != null) {
                this._flow.tryEmit((Object)value);
            }
        }

        @NotNull
        public final Flow<ViewportHint> getFlow() {
            return (Flow)this._flow;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JP\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\t2>\u0010\u0019\u001a:\u0012\u0017\u0012\u00150\u0005R\u00020\u0006\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0004\u0012\u0017\u0012\u00150\u0005R\u00020\u0006\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00170\u001aR\u0012\u0010\u0004\u001a\u00060\u0005R\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0005R\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/paging/HintHandler$State;", "", "<init>", "(Landroidx/paging/HintHandler;)V", "prepend", "Landroidx/paging/HintHandler$HintFlow;", "Landroidx/paging/HintHandler;", "append", "value", "Landroidx/paging/ViewportHint$Access;", "lastAccessHint", "getLastAccessHint", "()Landroidx/paging/ViewportHint$Access;", "prependFlow", "Lkotlinx/coroutines/flow/Flow;", "Landroidx/paging/ViewportHint;", "getPrependFlow", "()Lkotlinx/coroutines/flow/Flow;", "appendFlow", "getAppendFlow", "lock", "Landroidx/paging/internal/SynchronizedLock;", "modify", "", "accessHint", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "paging-common"})
    @SourceDebugExtension(value={"SMAP\nHintHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HintHandler.kt\nandroidx/paging/HintHandler$State\n+ 2 SynchronizedLock.kt\nandroidx/paging/internal/SynchronizedLockKt\n+ 3 SynchronizedLock.jvm.kt\nandroidx/paging/internal/SynchronizedLock\n*L\n1#1,154:1\n40#2:155\n22#3:156\n*S KotlinDebug\n*F\n+ 1 HintHandler.kt\nandroidx/paging/HintHandler$State\n*L\n102#1:155\n102#1:156\n*E\n"})
    private final class State {
        @NotNull
        private final HintFlow prepend;
        @NotNull
        private final HintFlow append;
        @Nullable
        private ViewportHint.Access lastAccessHint;
        @NotNull
        private final SynchronizedLock lock;

        public State() {
            this.prepend = new HintFlow();
            this.append = new HintFlow();
            this.lock = new SynchronizedLock();
        }

        @Nullable
        public final ViewportHint.Access getLastAccessHint() {
            return this.lastAccessHint;
        }

        @NotNull
        public final Flow<ViewportHint> getPrependFlow() {
            return this.prepend.getFlow();
        }

        @NotNull
        public final Flow<ViewportHint> getAppendFlow() {
            return this.append.getFlow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void modify(@Nullable ViewportHint.Access accessHint, @NotNull Function2<? super HintFlow, ? super HintFlow, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            SynchronizedLock $this$withLock$iv = this.lock;
            boolean $i$f$withLock = false;
            SynchronizedLock this_$iv$iv = $this$withLock$iv;
            boolean $i$f$withLockImpl = false;
            SynchronizedLock synchronizedLock = this_$iv$iv;
            synchronized (synchronizedLock) {
                boolean bl = false;
                if (accessHint != null) {
                    this.lastAccessHint = accessHint;
                }
                block.invoke((Object)this.prepend, (Object)this.append);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.PREPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.APPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

