package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.WriteQueueItemEntity
import world.respect.datalayer.school.writequeue.WriteQueueItem

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class WriteQueueItemEntityDao_Impl(
  __db: RoomDatabase,
) : WriteQueueItemEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfWriteQueueItemEntity: EntityInsertAdapter<WriteQueueItemEntity>

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfWriteQueueItemEntity = object : EntityInsertAdapter<WriteQueueItemEntity>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `WriteQueueItemEntity` (`wqiQueueItemId`,`wqiModel`,`wqiUid`,`wqiTimeQueued`,`wqiAttemptCount`,`wqiTimeWritten`,`wqiAccountGuid`) VALUES (nullif(?, 0),?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: WriteQueueItemEntity) {
        statement.bindLong(1, entity.wqiQueueItemId.toLong())
        val _tmp: Int = __schoolTypeConverters.fromWriteQueueItemModel(entity.wqiModel)
        statement.bindLong(2, _tmp.toLong())
        statement.bindText(3, entity.wqiUid)
        statement.bindLong(4, entity.wqiTimeQueued)
        statement.bindLong(5, entity.wqiAttemptCount.toLong())
        statement.bindLong(6, entity.wqiTimeWritten)
        statement.bindText(7, entity.wqiAccountGuid)
      }
    }
  }

  public override suspend fun upsert(list: List<WriteQueueItemEntity>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfWriteQueueItemEntity.insert(_connection, list)
  }

  public override suspend fun getPending(accountGuid: String, limit: Int): List<WriteQueueItemEntity> {
    val _sql: String = """
        |
        |        SELECT WriteQueueItemEntity.* 
        |          FROM WriteQueueItemEntity
        |         WHERE WriteQueueItemEntity.wqiAccountGuid = ?
        |           AND WriteQueueItemEntity.wqiTimeWritten = 0
        |      ORDER BY WriteQueueItemEntity.wqiTimeQueued ASC
        |        LIMIT ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, accountGuid)
        _argIndex = 2
        _stmt.bindLong(_argIndex, limit.toLong())
        val _columnIndexOfWqiQueueItemId: Int = getColumnIndexOrThrow(_stmt, "wqiQueueItemId")
        val _columnIndexOfWqiModel: Int = getColumnIndexOrThrow(_stmt, "wqiModel")
        val _columnIndexOfWqiUid: Int = getColumnIndexOrThrow(_stmt, "wqiUid")
        val _columnIndexOfWqiTimeQueued: Int = getColumnIndexOrThrow(_stmt, "wqiTimeQueued")
        val _columnIndexOfWqiAttemptCount: Int = getColumnIndexOrThrow(_stmt, "wqiAttemptCount")
        val _columnIndexOfWqiTimeWritten: Int = getColumnIndexOrThrow(_stmt, "wqiTimeWritten")
        val _columnIndexOfWqiAccountGuid: Int = getColumnIndexOrThrow(_stmt, "wqiAccountGuid")
        val _result: MutableList<WriteQueueItemEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: WriteQueueItemEntity
          val _tmpWqiQueueItemId: Int
          _tmpWqiQueueItemId = _stmt.getLong(_columnIndexOfWqiQueueItemId).toInt()
          val _tmpWqiModel: WriteQueueItem.Model
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfWqiModel).toInt()
          _tmpWqiModel = __schoolTypeConverters.toWriteQueueItemModel(_tmp)
          val _tmpWqiUid: String
          _tmpWqiUid = _stmt.getText(_columnIndexOfWqiUid)
          val _tmpWqiTimeQueued: Long
          _tmpWqiTimeQueued = _stmt.getLong(_columnIndexOfWqiTimeQueued)
          val _tmpWqiAttemptCount: Int
          _tmpWqiAttemptCount = _stmt.getLong(_columnIndexOfWqiAttemptCount).toInt()
          val _tmpWqiTimeWritten: Long
          _tmpWqiTimeWritten = _stmt.getLong(_columnIndexOfWqiTimeWritten)
          val _tmpWqiAccountGuid: String
          _tmpWqiAccountGuid = _stmt.getText(_columnIndexOfWqiAccountGuid)
          _item = WriteQueueItemEntity(_tmpWqiQueueItemId,_tmpWqiModel,_tmpWqiUid,_tmpWqiTimeQueued,_tmpWqiAttemptCount,_tmpWqiTimeWritten,_tmpWqiAccountGuid)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun updateTimeWritten(ids: List<Int>, timeWritten: Long) {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("        UPDATE WriteQueueItemEntity")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("           SET wqiTimeWritten = ")
    _stringBuilder.append("?")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("         WHERE wqiQueueItemId IN (")
    val _inputSize: Int = ids.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    _stringBuilder.append("""
        |
        |""".trimMargin())
    _stringBuilder.append("    ")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, timeWritten)
        _argIndex = 2
        for (_item: Int in ids) {
          _stmt.bindLong(_argIndex, _item.toLong())
          _argIndex++
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
