/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a+\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0017\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\t\u0010\n\"\u0018\u0010\r\u001a\u00060\u000bj\u0002`\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"", "resource", "Lkotlin/Pair;", "", "Lkotlin/Function0;", "Ljava/io/InputStream;", "keyAndStreamSupplier", "(Ljava/lang/Object;)Lkotlin/Pair;", "input", "sha256Hex", "(Ljava/io/InputStream;)Ljava/lang/String;", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nETagProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ETagProvider.kt\nio/ktor/server/http/content/ETagProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class ETagProviderKt {
    @NotNull
    private static final Logger LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger((String)"io.ktor.server.http.content.ETagProvider");

    private static final Pair<String, Function0<InputStream>> keyAndStreamSupplier(Object resource2) {
        Pair pair;
        Object object = resource2;
        if (object instanceof File) {
            pair = TuplesKt.to((Object)(((File)resource2).getAbsolutePath() + ':' + ((File)resource2).lastModified() + ':' + ((File)resource2).length()), () -> ETagProviderKt.keyAndStreamSupplier$lambda$0(resource2));
        } else if (object instanceof Path) {
            Path path = ((Path)resource2).toAbsolutePath();
            BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            pair = TuplesKt.to((Object)("" + path + ':' + attrs.lastModifiedTime().toMillis() + ':' + attrs.size()), () -> ETagProviderKt.keyAndStreamSupplier$lambda$1(path));
        } else if (object instanceof URL) {
            Object object2;
            try {
                long it;
                boolean bl = false;
                URLConnection conn = ((URL)resource2).openConnection();
                Long l = conn.getLastModified();
                long l2 = ((Number)l).longValue();
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                Object object3 = Boolean.valueOf(it > 0L) != false ? l : null;
                if (object3 == null || (object3 = ((Long)object3).toString()) == null) {
                    object3 = "";
                }
                l = conn.getContentLengthLong();
                it = ((Number)l).longValue();
                stringBuilder = stringBuilder.append((String)object3).append(':');
                boolean bl3 = false;
                Object object4 = Boolean.valueOf(it >= 0L) != false ? l : null;
                if (object4 == null || (object4 = ((Long)object4).toString()) == null) {
                    object4 = "";
                }
                object2 = Result.constructor-impl((Object)stringBuilder.append((String)object4).toString());
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String string = "";
            String meta = (String)(Result.isFailure-impl((Object)object2) ? string : object2);
            pair = TuplesKt.to((Object)(((URL)resource2).toExternalForm() + ':' + meta), () -> ETagProviderKt.keyAndStreamSupplier$lambda$5(resource2));
        } else {
            pair = null;
        }
        return pair;
    }

    private static final String sha256Hex(InputStream input) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] buf = new byte[8192];
        int n = 0;
        while ((n = input.read(buf)) != -1) {
            md.update(buf, 0, n);
        }
        byte[] byArray = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, ETagProviderKt::sha256Hex$lambda$6, (int)30, null);
    }

    private static final FileInputStream keyAndStreamSupplier$lambda$0(Object $resource) {
        return new FileInputStream((File)$resource);
    }

    private static final InputStream keyAndStreamSupplier$lambda$1(Path $path) {
        return Files.newInputStream($path, new OpenOption[0]);
    }

    private static final InputStream keyAndStreamSupplier$lambda$5(Object $resource) {
        return ((URL)$resource).openStream();
    }

    private static final CharSequence sha256Hex$lambda$6(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p() {
        return LOGGER;
    }

    public static final /* synthetic */ String access$sha256Hex(InputStream input) {
        return ETagProviderKt.sha256Hex(input);
    }

    public static final /* synthetic */ Pair access$keyAndStreamSupplier(Object resource2) {
        return ETagProviderKt.keyAndStreamSupplier(resource2);
    }
}

