/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection.internal;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0000\u001a\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0000\u001a\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0000\"\u0010\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00058\u0000X\u0081\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0016"}, d2={"EMPTY_INTS", "", "EMPTY_LONGS", "", "EMPTY_OBJECTS", "", "", "[Ljava/lang/Object;", "binarySearch", "", "array", "size", "value", "", "equal", "", "a", "b", "idealByteArraySize", "need", "idealIntArraySize", "idealLongArraySize", "collection"})
public final class ContainerHelpersKt {
    @JvmField
    @NotNull
    public static final int[] EMPTY_INTS = new int[0];
    @JvmField
    @NotNull
    public static final long[] EMPTY_LONGS = new long[0];
    @JvmField
    @NotNull
    public static final Object[] EMPTY_OBJECTS = new Object[0];

    public static final int idealIntArraySize(int need) {
        return ContainerHelpersKt.idealByteArraySize(need * 4) / 4;
    }

    public static final int idealLongArraySize(int need) {
        return ContainerHelpersKt.idealByteArraySize(need * 8) / 8;
    }

    public static final int idealByteArraySize(int need) {
        for (int i2 = 4; i2 < 32; ++i2) {
            if (need > (1 << i2) - 12) continue;
            return (1 << i2) - 12;
        }
        return need;
    }

    public static final boolean equal(@Nullable Object a2, @Nullable Object b2) {
        return Intrinsics.areEqual(a2, b2);
    }

    public static final int binarySearch(@NotNull int[] array2, int size2, int value) {
        Intrinsics.checkNotNullParameter(array2, "array");
        int lo = 0;
        int hi = size2 - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = array2[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public static final int binarySearch(@NotNull long[] array2, int size2, long value) {
        Intrinsics.checkNotNullParameter(array2, "array");
        int lo = 0;
        int hi = size2 - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            long midVal = array2[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }
}

