/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.school.daos;

import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.coroutines.FlowUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import io.ktor.http.Url;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.time.Instant;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.school.SchoolTypeConverters;
import world.respect.datalayer.db.school.daos.PersonQrBadgeEntityDao;
import world.respect.datalayer.db.school.entities.PersonQrBadgeEntity;
import world.respect.datalayer.db.shared.SharedConverters;
import world.respect.datalayer.school.model.StatusEnum;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J6\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010!J\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J6\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100%2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0%2\u0006\u0010'\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lworld/respect/datalayer/db/school/daos/PersonQrBadgeEntityDao_Impl;", "Lworld/respect/datalayer/db/school/daos/PersonQrBadgeEntityDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfPersonQrBadgeEntity", "Landroidx/room/EntityInsertAdapter;", "Lworld/respect/datalayer/db/school/entities/PersonQrBadgeEntity;", "__sharedConverters", "Lworld/respect/datalayer/db/shared/SharedConverters;", "__schoolTypeConverters", "Lworld/respect/datalayer/db/school/SchoolTypeConverters;", "upsertAsyncList", "", "list", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAll", "authenticatedPersonUidNum", "", "personGuidNum", "includeDeleted", "", "qrCodeUrl", "", "(JJZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByGuid", "guid", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByQrCodeUrl", "getLastModifiedByUidNum", "uidNum", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidList", "uids", "findAllAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findByGuidHashAsFlow", "guidnum", "Companion", "respect-datalayer-db_debug"})
public final class PersonQrBadgeEntityDao_Impl
implements PersonQrBadgeEntityDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<PersonQrBadgeEntity> __insertAdapterOfPersonQrBadgeEntity;
    @NotNull
    private final SharedConverters __sharedConverters;
    @NotNull
    private final SchoolTypeConverters __schoolTypeConverters;

    public PersonQrBadgeEntityDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__sharedConverters = new SharedConverters();
        this.__schoolTypeConverters = new SchoolTypeConverters();
        this.__db = __db;
        this.__insertAdapterOfPersonQrBadgeEntity = (EntityInsertAdapter)new EntityInsertAdapter<PersonQrBadgeEntity>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `PersonQrBadgeEntity` (`pqrGuidNum`,`pqrGuid`,`pqrLastModified`,`pqrStored`,`pqrQrCodeUrl`,`pqrStatus`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, PersonQrBadgeEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, entity.getPqrGuidNum());
                statement.bindText(2, entity.getPqrGuid());
                Long _tmp = __sharedConverters.fromInstant(entity.getPqrLastModified());
                if (_tmp == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindLong(3, _tmp.longValue());
                }
                Long _tmp_1 = __sharedConverters.fromInstant(entity.getPqrStored());
                if (_tmp_1 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindLong(4, _tmp_1.longValue());
                }
                Url _tmpPqrQrCodeUrl = entity.getPqrQrCodeUrl();
                String _tmp_2 = __sharedConverters.fromUrl(_tmpPqrQrCodeUrl);
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                int _tmp_3 = __schoolTypeConverters.fromStatusEnum(entity.getPqrStatus());
                statement.bindLong(6, (long)_tmp_3);
            }
        };
    }

    @Override
    @Nullable
    public Object upsertAsyncList(@NotNull List<PersonQrBadgeEntity> list2, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> PersonQrBadgeEntityDao_Impl.upsertAsyncList$lambda$0(this, list2, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object findAll(long authenticatedPersonUidNum, long personGuidNum, boolean includeDeleted, @Nullable String qrCodeUrl, @NotNull Continuation<? super List<PersonQrBadgeEntity>> $completion) {
        String _sql = "\n            WITH \n            AuthenticatedPermissionPersonUids(uidNum) AS (\n                SELECT ? AS uidNum\n                UNION\n                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum\n                  FROM PersonRelatedPersonEntity\n                 WHERE 5 IN \n                       (SELECT PersonRoleEntity.prRoleEnum\n                          FROM PersonRoleEntity\n                         WHERE PersonRoleEntity.prPersonGuidHash = ?)\n                   AND PersonRelatedPersonEntity.prpPersonUidNum = ?)     \n        ,  \n                 \n            AuthenticatedPersonClassPermissions AS (\n                SELECT ClassPermissionEntity.*\n                  FROM ClassPermissionEntity\n                 WHERE (ClassPermissionEntity.cpeToEnrollmentRole, ClassPermissionEntity.cpeClassUidNum) IN \n                       (SELECT EnrollmentEntity.eRole, EnrollmentEntity.eClassUidNum\n                          FROM EnrollmentEntity\n                         WHERE EnrollmentEntity.ePersonUidNum IN \n                               (\n            SELECT AuthenticatedPermissionPersonUids.uidNum\n              FROM AuthenticatedPermissionPersonUids\n        )\n                           AND EnrollmentEntity.eStatus = 1)\n            )\n        \n                 \n          SELECT PersonQrBadgeEntity.*\n            FROM PersonQrBadgeEntity\n                 JOIN PersonEntity \n                      ON PersonEntity.pGuidHash = PersonQrBadgeEntity.pqrGuidNum\n\n           WHERE (? = 0 OR PersonQrBadgeEntity.pqrGuidNum = ?)\n             AND (? OR PersonQrBadgeEntity.pqrStatus = 1)        \n             AND (? IS NULL OR PersonQrBadgeEntity.pqrQrCodeUrl = ?)\n             AND (\n                PersonEntity.pGuidHash = ?\n             OR PersonEntity.pGuidHash IN \n                (SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum\n                   FROM PersonRelatedPersonEntity\n                  WHERE PersonRelatedPersonEntity.prpPersonUidNum = ?)\n             OR EXISTS(\n                    SELECT 1\n                      FROM SchoolPermissionGrantEntity\n                     WHERE SchoolPermissionGrantEntity.spgToRole IN \n                           (SELECT PersonRoleEntity.prRoleEnum\n                              FROM PersonRoleEntity\n                             WHERE PersonRoleEntity.prPersonGuidHash IN \n                                   (\n            SELECT AuthenticatedPermissionPersonUids.uidNum\n              FROM AuthenticatedPermissionPersonUids\n        ))\n                               AND (SchoolPermissionGrantEntity.spgPermissions & (\n            CASE(SELECT PersonRoleEntity.prRoleEnum\n                   FROM PersonRoleEntity\n                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash\n                  LIMIT 1)                    \n                 \n             WHEN 1 THEN 256\n             WHEN 3 THEN 256\n             WHEN 4 THEN 64\n             WHEN 2 THEN 4\n             WHEN 5 THEN 16\n             ELSE 9223372036854775807\n        \n            END     \n        )) > 0)\n             OR EXISTS(\n                    SELECT 1\n                      FROM AuthenticatedPersonClassPermissions\n                     WHERE AuthenticatedPersonClassPermissions.cpeClassUidNum IN \n                           (SELECT EnrollmentEntity.eClassUidNum\n                              FROM EnrollmentEntity\n                             WHERE EnrollmentEntity.ePersonUidNum = PersonEntity.pGuidHash)\n                       AND (AuthenticatedPersonClassPermissions.cpePermissions & (\n            CASE(SELECT PersonRoleEntity.prRoleEnum\n                   FROM PersonRoleEntity\n                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash\n                  LIMIT 1)                    \n                 \n             WHEN 1 THEN 256\n             WHEN 3 THEN 256\n             WHEN 4 THEN 64\n             WHEN 2 THEN 4\n             WHEN 5 THEN 16\n             ELSE 9223372036854775807\n        \n            END     \n        )) > 0)\n        )    \n        ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> PersonQrBadgeEntityDao_Impl.findAll$lambda$0(_sql, authenticatedPersonUidNum, personGuidNum, includeDeleted, qrCodeUrl, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByGuid(@NotNull String guid, @NotNull Continuation<? super PersonQrBadgeEntity> $completion) {
        String _sql = "\n           SELECT PersonQrBadgeEntity.* \n             FROM PersonQrBadgeEntity\n            WHERE pqrGuid = ?\n        ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> PersonQrBadgeEntityDao_Impl.findByGuid$lambda$0(_sql, guid, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByQrCodeUrl(@NotNull String qrCodeUrl, @NotNull Continuation<? super PersonQrBadgeEntity> $completion) {
        String _sql = "\n        SELECT PersonQrBadgeEntity.*\n          FROM PersonQrBadgeEntity\n         WHERE PersonQrBadgeEntity.pqrQrCodeUrl = ?\n           AND PersonQrBadgeEntity.pqrStatus = 1\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> PersonQrBadgeEntityDao_Impl.findByQrCodeUrl$lambda$0(_sql, qrCodeUrl, this, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object getLastModifiedByUidNum(long uidNum, @NotNull Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT PersonQrBadgeEntity.pqrLastModified\n          FROM PersonQrBadgeEntity\n         WHERE PersonQrBadgeEntity.pqrGuidNum = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> PersonQrBadgeEntityDao_Impl.getLastModifiedByUidNum$lambda$0(_sql, uidNum, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByUidList(@NotNull List<Long> uids, @NotNull Continuation<? super List<PersonQrBadgeEntity>> $completion) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT PersonQrBadgeEntity.*");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM PersonQrBadgeEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE PersonQrBadgeEntity.pqrGuidNum IN (");
        int _inputSize = uids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String string = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String _sql = string;
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> PersonQrBadgeEntityDao_Impl.findByUidList$lambda$0(_sql, uids, this, arg_0), $completion);
    }

    @Override
    @NotNull
    public Flow<List<PersonQrBadgeEntity>> findAllAsFlow(long authenticatedPersonUidNum, long personGuidNum, boolean includeDeleted, @Nullable String qrCodeUrl) {
        String _sql = "\n            WITH \n            AuthenticatedPermissionPersonUids(uidNum) AS (\n                SELECT ? AS uidNum\n                UNION\n                SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum AS uidNum\n                  FROM PersonRelatedPersonEntity\n                 WHERE 5 IN \n                       (SELECT PersonRoleEntity.prRoleEnum\n                          FROM PersonRoleEntity\n                         WHERE PersonRoleEntity.prPersonGuidHash = ?)\n                   AND PersonRelatedPersonEntity.prpPersonUidNum = ?)     \n        ,  \n                 \n            AuthenticatedPersonClassPermissions AS (\n                SELECT ClassPermissionEntity.*\n                  FROM ClassPermissionEntity\n                 WHERE (ClassPermissionEntity.cpeToEnrollmentRole, ClassPermissionEntity.cpeClassUidNum) IN \n                       (SELECT EnrollmentEntity.eRole, EnrollmentEntity.eClassUidNum\n                          FROM EnrollmentEntity\n                         WHERE EnrollmentEntity.ePersonUidNum IN \n                               (\n            SELECT AuthenticatedPermissionPersonUids.uidNum\n              FROM AuthenticatedPermissionPersonUids\n        )\n                           AND EnrollmentEntity.eStatus = 1)\n            )\n        \n                 \n          SELECT PersonQrBadgeEntity.*\n            FROM PersonQrBadgeEntity\n                 JOIN PersonEntity \n                      ON PersonEntity.pGuidHash = PersonQrBadgeEntity.pqrGuidNum\n\n           WHERE (? = 0 OR PersonQrBadgeEntity.pqrGuidNum = ?)\n             AND (? OR PersonQrBadgeEntity.pqrStatus = 1)        \n             AND (? IS NULL OR PersonQrBadgeEntity.pqrQrCodeUrl = ?)\n             AND (\n                PersonEntity.pGuidHash = ?\n             OR PersonEntity.pGuidHash IN \n                (SELECT PersonRelatedPersonEntity.prpOtherPersonUidNum\n                   FROM PersonRelatedPersonEntity\n                  WHERE PersonRelatedPersonEntity.prpPersonUidNum = ?)\n             OR EXISTS(\n                    SELECT 1\n                      FROM SchoolPermissionGrantEntity\n                     WHERE SchoolPermissionGrantEntity.spgToRole IN \n                           (SELECT PersonRoleEntity.prRoleEnum\n                              FROM PersonRoleEntity\n                             WHERE PersonRoleEntity.prPersonGuidHash IN \n                                   (\n            SELECT AuthenticatedPermissionPersonUids.uidNum\n              FROM AuthenticatedPermissionPersonUids\n        ))\n                               AND (SchoolPermissionGrantEntity.spgPermissions & (\n            CASE(SELECT PersonRoleEntity.prRoleEnum\n                   FROM PersonRoleEntity\n                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash\n                  LIMIT 1)                    \n                 \n             WHEN 1 THEN 256\n             WHEN 3 THEN 256\n             WHEN 4 THEN 64\n             WHEN 2 THEN 4\n             WHEN 5 THEN 16\n             ELSE 9223372036854775807\n        \n            END     \n        )) > 0)\n             OR EXISTS(\n                    SELECT 1\n                      FROM AuthenticatedPersonClassPermissions\n                     WHERE AuthenticatedPersonClassPermissions.cpeClassUidNum IN \n                           (SELECT EnrollmentEntity.eClassUidNum\n                              FROM EnrollmentEntity\n                             WHERE EnrollmentEntity.ePersonUidNum = PersonEntity.pGuidHash)\n                       AND (AuthenticatedPersonClassPermissions.cpePermissions & (\n            CASE(SELECT PersonRoleEntity.prRoleEnum\n                   FROM PersonRoleEntity\n                  WHERE PersonRoleEntity.prPersonGuidHash = PersonEntity.pGuidHash\n                  LIMIT 1)                    \n                 \n             WHEN 1 THEN 256\n             WHEN 3 THEN 256\n             WHEN 4 THEN 64\n             WHEN 2 THEN 4\n             WHEN 5 THEN 16\n             ELSE 9223372036854775807\n        \n            END     \n        )) > 0)\n        )    \n        ";
        String[] stringArray = new String[]{"PersonRelatedPersonEntity", "PersonRoleEntity", "ClassPermissionEntity", "EnrollmentEntity", "PersonQrBadgeEntity", "PersonEntity", "SchoolPermissionGrantEntity"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, arg_0 -> PersonQrBadgeEntityDao_Impl.findAllAsFlow$lambda$0(_sql, authenticatedPersonUidNum, personGuidNum, includeDeleted, qrCodeUrl, this, arg_0));
    }

    @Override
    @NotNull
    public Flow<PersonQrBadgeEntity> findByGuidHashAsFlow(long guidnum) {
        String _sql = "\n        SELECT * \n         FROM PersonQrBadgeEntity\n        WHERE pqrGuidNum = ?\n          AND pqrStatus = 1\n    ";
        String[] stringArray = new String[]{"PersonQrBadgeEntity"};
        return FlowUtil.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, arg_0 -> PersonQrBadgeEntityDao_Impl.findByGuidHashAsFlow$lambda$0(_sql, guidnum, this, arg_0));
    }

    private static final Unit upsertAsyncList$lambda$0(PersonQrBadgeEntityDao_Impl this$0, List $list, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfPersonQrBadgeEntity.insert(_connection, (Iterable)$list);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAll$lambda$0(String $_sql, long $authenticatedPersonUidNum, long $personGuidNum, boolean $includeDeleted, String $qrCodeUrl, PersonQrBadgeEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            _argIndex = 3;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            _argIndex = 4;
            _stmt.bindLong(_argIndex, $personGuidNum);
            _argIndex = 5;
            _stmt.bindLong(_argIndex, $personGuidNum);
            _argIndex = 6;
            int _tmp = $includeDeleted ? 1 : 0;
            _stmt.bindLong(_argIndex, (long)_tmp);
            _argIndex = 7;
            if ($qrCodeUrl == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindText(_argIndex, $qrCodeUrl);
            }
            _argIndex = 8;
            if ($qrCodeUrl == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindText(_argIndex, $qrCodeUrl);
            }
            _argIndex = 9;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            _argIndex = 10;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            int _columnIndexOfPqrGuidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuidNum");
            int _columnIndexOfPqrGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuid");
            int _columnIndexOfPqrLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrLastModified");
            int _columnIndexOfPqrStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStored");
            int _columnIndexOfPqrQrCodeUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrQrCodeUrl");
            int _columnIndexOfPqrStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStatus");
            List _result = new ArrayList();
            while (_stmt.step()) {
                PersonQrBadgeEntity _item = null;
                long _tmpPqrGuidNum = 0L;
                _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum);
                String _tmpPqrGuid = null;
                _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid);
                Instant _tmpPqrLastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfPqrLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrLastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrLastModified = _tmp_2;
                Instant _tmpPqrStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfPqrStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrStored = _tmp_4;
                Url _tmpPqrQrCodeUrl = null;
                String _tmp_5 = null;
                _tmp_5 = _stmt.isNull(_columnIndexOfPqrQrCodeUrl) ? null : _stmt.getText(_columnIndexOfPqrQrCodeUrl);
                _tmpPqrQrCodeUrl = this$0.__sharedConverters.toUrl(_tmp_5);
                StatusEnum _tmpPqrStatus = null;
                int _tmp_6 = 0;
                _tmp_6 = (int)_stmt.getLong(_columnIndexOfPqrStatus);
                _tmpPqrStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp_6);
                _item = new PersonQrBadgeEntity(_tmpPqrGuidNum, _tmpPqrGuid, _tmpPqrLastModified, _tmpPqrStored, _tmpPqrQrCodeUrl, _tmpPqrStatus);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PersonQrBadgeEntity findByGuid$lambda$0(String $_sql, String $guid, PersonQrBadgeEntityDao_Impl this$0, SQLiteConnection _connection) {
        PersonQrBadgeEntity personQrBadgeEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $guid);
            int _columnIndexOfPqrGuidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuidNum");
            int _columnIndexOfPqrGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuid");
            int _columnIndexOfPqrLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrLastModified");
            int _columnIndexOfPqrStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStored");
            int _columnIndexOfPqrQrCodeUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrQrCodeUrl");
            int _columnIndexOfPqrStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStatus");
            PersonQrBadgeEntity _result = null;
            if (_stmt.step()) {
                long _tmpPqrGuidNum = 0L;
                _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum);
                String _tmpPqrGuid = null;
                _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid);
                Instant _tmpPqrLastModified = null;
                Long _tmp = null;
                _tmp = _stmt.isNull(_columnIndexOfPqrLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrLastModified));
                Instant _tmp_1 = this$0.__sharedConverters.toInstant(_tmp);
                if (_tmp_1 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrLastModified = _tmp_1;
                Instant _tmpPqrStored = null;
                Long _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPqrStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrStored));
                Instant _tmp_3 = this$0.__sharedConverters.toInstant(_tmp_2);
                if (_tmp_3 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrStored = _tmp_3;
                Url _tmpPqrQrCodeUrl = null;
                String _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPqrQrCodeUrl) ? null : _stmt.getText(_columnIndexOfPqrQrCodeUrl);
                _tmpPqrQrCodeUrl = this$0.__sharedConverters.toUrl(_tmp_4);
                StatusEnum _tmpPqrStatus = null;
                int _tmp_5 = 0;
                _tmp_5 = (int)_stmt.getLong(_columnIndexOfPqrStatus);
                _tmpPqrStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp_5);
                _result = new PersonQrBadgeEntity(_tmpPqrGuidNum, _tmpPqrGuid, _tmpPqrLastModified, _tmpPqrStored, _tmpPqrQrCodeUrl, _tmpPqrStatus);
            } else {
                _result = null;
            }
            personQrBadgeEntity = _result;
        }
        return personQrBadgeEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PersonQrBadgeEntity findByQrCodeUrl$lambda$0(String $_sql, String $qrCodeUrl, PersonQrBadgeEntityDao_Impl this$0, SQLiteConnection _connection) {
        PersonQrBadgeEntity personQrBadgeEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $qrCodeUrl);
            int _columnIndexOfPqrGuidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuidNum");
            int _columnIndexOfPqrGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuid");
            int _columnIndexOfPqrLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrLastModified");
            int _columnIndexOfPqrStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStored");
            int _columnIndexOfPqrQrCodeUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrQrCodeUrl");
            int _columnIndexOfPqrStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStatus");
            PersonQrBadgeEntity _result = null;
            if (_stmt.step()) {
                long _tmpPqrGuidNum = 0L;
                _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum);
                String _tmpPqrGuid = null;
                _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid);
                Instant _tmpPqrLastModified = null;
                Long _tmp = null;
                _tmp = _stmt.isNull(_columnIndexOfPqrLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrLastModified));
                Instant _tmp_1 = this$0.__sharedConverters.toInstant(_tmp);
                if (_tmp_1 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrLastModified = _tmp_1;
                Instant _tmpPqrStored = null;
                Long _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPqrStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrStored));
                Instant _tmp_3 = this$0.__sharedConverters.toInstant(_tmp_2);
                if (_tmp_3 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrStored = _tmp_3;
                Url _tmpPqrQrCodeUrl = null;
                String _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPqrQrCodeUrl) ? null : _stmt.getText(_columnIndexOfPqrQrCodeUrl);
                _tmpPqrQrCodeUrl = this$0.__sharedConverters.toUrl(_tmp_4);
                StatusEnum _tmpPqrStatus = null;
                int _tmp_5 = 0;
                _tmp_5 = (int)_stmt.getLong(_columnIndexOfPqrStatus);
                _tmpPqrStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp_5);
                _result = new PersonQrBadgeEntity(_tmpPqrGuidNum, _tmpPqrGuid, _tmpPqrLastModified, _tmpPqrStored, _tmpPqrQrCodeUrl, _tmpPqrStatus);
            } else {
                _result = null;
            }
            personQrBadgeEntity = _result;
        }
        return personQrBadgeEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Long getLastModifiedByUidNum$lambda$0(String $_sql, long $uidNum, SQLiteConnection _connection) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $uidNum);
            Long _result = null;
            _result = _stmt.step() ? (_stmt.isNull(0) ? null : Long.valueOf(_stmt.getLong(0))) : null;
            l = _result;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findByUidList$lambda$0(String $_sql, List $uids, PersonQrBadgeEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            Iterator iterator = $uids.iterator();
            while (iterator.hasNext()) {
                long _item = ((Number)iterator.next()).longValue();
                _stmt.bindLong(_argIndex, _item);
                ++_argIndex;
            }
            int _columnIndexOfPqrGuidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuidNum");
            int _columnIndexOfPqrGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuid");
            int _columnIndexOfPqrLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrLastModified");
            int _columnIndexOfPqrStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStored");
            int _columnIndexOfPqrQrCodeUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrQrCodeUrl");
            int _columnIndexOfPqrStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStatus");
            List _result = new ArrayList();
            while (_stmt.step()) {
                PersonQrBadgeEntity _item_1 = null;
                long _tmpPqrGuidNum = 0L;
                _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum);
                String _tmpPqrGuid = null;
                _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid);
                Instant _tmpPqrLastModified = null;
                Long _tmp = null;
                _tmp = _stmt.isNull(_columnIndexOfPqrLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrLastModified));
                Instant _tmp_1 = this$0.__sharedConverters.toInstant(_tmp);
                if (_tmp_1 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrLastModified = _tmp_1;
                Instant _tmpPqrStored = null;
                Long _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPqrStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrStored));
                Instant _tmp_3 = this$0.__sharedConverters.toInstant(_tmp_2);
                if (_tmp_3 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrStored = _tmp_3;
                Url _tmpPqrQrCodeUrl = null;
                String _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPqrQrCodeUrl) ? null : _stmt.getText(_columnIndexOfPqrQrCodeUrl);
                _tmpPqrQrCodeUrl = this$0.__sharedConverters.toUrl(_tmp_4);
                StatusEnum _tmpPqrStatus = null;
                int _tmp_5 = 0;
                _tmp_5 = (int)_stmt.getLong(_columnIndexOfPqrStatus);
                _tmpPqrStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp_5);
                _item_1 = new PersonQrBadgeEntity(_tmpPqrGuidNum, _tmpPqrGuid, _tmpPqrLastModified, _tmpPqrStored, _tmpPqrQrCodeUrl, _tmpPqrStatus);
                _result.add(_item_1);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAllAsFlow$lambda$0(String $_sql, long $authenticatedPersonUidNum, long $personGuidNum, boolean $includeDeleted, String $qrCodeUrl, PersonQrBadgeEntityDao_Impl this$0, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            _argIndex = 3;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            _argIndex = 4;
            _stmt.bindLong(_argIndex, $personGuidNum);
            _argIndex = 5;
            _stmt.bindLong(_argIndex, $personGuidNum);
            _argIndex = 6;
            int _tmp = $includeDeleted ? 1 : 0;
            _stmt.bindLong(_argIndex, (long)_tmp);
            _argIndex = 7;
            if ($qrCodeUrl == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindText(_argIndex, $qrCodeUrl);
            }
            _argIndex = 8;
            if ($qrCodeUrl == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindText(_argIndex, $qrCodeUrl);
            }
            _argIndex = 9;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            _argIndex = 10;
            _stmt.bindLong(_argIndex, $authenticatedPersonUidNum);
            int _columnIndexOfPqrGuidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuidNum");
            int _columnIndexOfPqrGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuid");
            int _columnIndexOfPqrLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrLastModified");
            int _columnIndexOfPqrStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStored");
            int _columnIndexOfPqrQrCodeUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrQrCodeUrl");
            int _columnIndexOfPqrStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStatus");
            List _result = new ArrayList();
            while (_stmt.step()) {
                PersonQrBadgeEntity _item = null;
                long _tmpPqrGuidNum = 0L;
                _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum);
                String _tmpPqrGuid = null;
                _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid);
                Instant _tmpPqrLastModified = null;
                Long _tmp_1 = null;
                _tmp_1 = _stmt.isNull(_columnIndexOfPqrLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrLastModified));
                Instant _tmp_2 = this$0.__sharedConverters.toInstant(_tmp_1);
                if (_tmp_2 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrLastModified = _tmp_2;
                Instant _tmpPqrStored = null;
                Long _tmp_3 = null;
                _tmp_3 = _stmt.isNull(_columnIndexOfPqrStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrStored));
                Instant _tmp_4 = this$0.__sharedConverters.toInstant(_tmp_3);
                if (_tmp_4 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrStored = _tmp_4;
                Url _tmpPqrQrCodeUrl = null;
                String _tmp_5 = null;
                _tmp_5 = _stmt.isNull(_columnIndexOfPqrQrCodeUrl) ? null : _stmt.getText(_columnIndexOfPqrQrCodeUrl);
                _tmpPqrQrCodeUrl = this$0.__sharedConverters.toUrl(_tmp_5);
                StatusEnum _tmpPqrStatus = null;
                int _tmp_6 = 0;
                _tmp_6 = (int)_stmt.getLong(_columnIndexOfPqrStatus);
                _tmpPqrStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp_6);
                _item = new PersonQrBadgeEntity(_tmpPqrGuidNum, _tmpPqrGuid, _tmpPqrLastModified, _tmpPqrStored, _tmpPqrQrCodeUrl, _tmpPqrStatus);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PersonQrBadgeEntity findByGuidHashAsFlow$lambda$0(String $_sql, long $guidnum, PersonQrBadgeEntityDao_Impl this$0, SQLiteConnection _connection) {
        PersonQrBadgeEntity personQrBadgeEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $guidnum);
            int _columnIndexOfPqrGuidNum = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuidNum");
            int _columnIndexOfPqrGuid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrGuid");
            int _columnIndexOfPqrLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrLastModified");
            int _columnIndexOfPqrStored = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStored");
            int _columnIndexOfPqrQrCodeUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrQrCodeUrl");
            int _columnIndexOfPqrStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pqrStatus");
            PersonQrBadgeEntity _result = null;
            if (_stmt.step()) {
                long _tmpPqrGuidNum = 0L;
                _tmpPqrGuidNum = _stmt.getLong(_columnIndexOfPqrGuidNum);
                String _tmpPqrGuid = null;
                _tmpPqrGuid = _stmt.getText(_columnIndexOfPqrGuid);
                Instant _tmpPqrLastModified = null;
                Long _tmp = null;
                _tmp = _stmt.isNull(_columnIndexOfPqrLastModified) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrLastModified));
                Instant _tmp_1 = this$0.__sharedConverters.toInstant(_tmp);
                if (_tmp_1 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrLastModified = _tmp_1;
                Instant _tmpPqrStored = null;
                Long _tmp_2 = null;
                _tmp_2 = _stmt.isNull(_columnIndexOfPqrStored) ? null : Long.valueOf(_stmt.getLong(_columnIndexOfPqrStored));
                Instant _tmp_3 = this$0.__sharedConverters.toInstant(_tmp_2);
                if (_tmp_3 == null) {
                    throw new IllegalStateException("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.".toString());
                }
                _tmpPqrStored = _tmp_3;
                Url _tmpPqrQrCodeUrl = null;
                String _tmp_4 = null;
                _tmp_4 = _stmt.isNull(_columnIndexOfPqrQrCodeUrl) ? null : _stmt.getText(_columnIndexOfPqrQrCodeUrl);
                _tmpPqrQrCodeUrl = this$0.__sharedConverters.toUrl(_tmp_4);
                StatusEnum _tmpPqrStatus = null;
                int _tmp_5 = 0;
                _tmp_5 = (int)_stmt.getLong(_columnIndexOfPqrStatus);
                _tmpPqrStatus = this$0.__schoolTypeConverters.toStatusEnum(_tmp_5);
                _result = new PersonQrBadgeEntity(_tmpPqrGuidNum, _tmpPqrGuid, _tmpPqrLastModified, _tmpPqrStored, _tmpPqrQrCodeUrl, _tmpPqrStatus);
            } else {
                _result = null;
            }
            personQrBadgeEntity = _result;
        }
        return personQrBadgeEntity;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/datalayer/db/school/daos/PersonQrBadgeEntityDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-datalayer-db_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

