/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.data.attestation.statement.Response;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="android-safetynet")
@JsonPropertyOrder(value={"ver", "response"})
public class AndroidSafetyNetAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "android-safetynet";
    private final String ver;
    private final JWS<Response> response;

    @JsonCreator
    public AndroidSafetyNetAttestationStatement(@JsonProperty(value="ver") @NotNull String ver, @JsonProperty(value="response") @NotNull JWS<Response> response2) {
        AssertUtil.notNull(ver, "ver must not be null");
        AssertUtil.notNull(response2, "response must not be null");
        this.ver = ver;
        this.response = response2;
    }

    @Override
    @JsonIgnore
    @NotNull
    public String getFormat() {
        return FORMAT;
    }

    @Override
    @JsonIgnore
    @Nullable
    public AttestationCertificatePath getX5c() {
        JWS<Response> res = this.getResponse();
        CertPath x5c = res.getHeader().getX5c();
        if (x5c == null) {
            return null;
        }
        return new AttestationCertificatePath(x5c.getCertificates().stream().map(X509Certificate.class::cast).collect(Collectors.toList()));
    }

    @Override
    public void validate() {
        CertPath x5c = this.getResponse().getHeader().getX5c();
        if (x5c == null || x5c.getCertificates().isEmpty()) {
            throw new ConstraintViolationException("No attestation certificate is found in android safetynet attestation statement.");
        }
    }

    @JsonGetter(value="ver")
    @NotNull
    public String getVer() {
        return this.ver;
    }

    @JsonGetter(value="response")
    @NotNull
    public JWS<Response> getResponse() {
        return this.response;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidSafetyNetAttestationStatement that = (AndroidSafetyNetAttestationStatement)o;
        return Objects.equals(this.ver, that.ver) && Objects.equals(this.response, that.response);
    }

    public int hashCode() {
        return Objects.hash(this.ver, this.response);
    }

    public String toString() {
        return "AndroidSafetyNetAttestationStatement(ver=" + this.ver + ", response=" + this.response + ")";
    }
}

