/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.qrose.options.QrCodeMatrix;
import io.github.alexzhirkevich.qrose.qrcode.ErrorCorrectionLevel;
import io.github.alexzhirkevich.qrose.qrcode.MaskPattern;
import io.github.alexzhirkevich.qrose.qrcode.QRCodeDataType;
import io.github.alexzhirkevich.qrose.qrcode.internals.BitBuffer;
import io.github.alexzhirkevich.qrose.qrcode.internals.Polynomial;
import io.github.alexzhirkevich.qrose.qrcode.internals.QR8BitByte;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRAlphaNum;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSetup;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRCodeSquare;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRData;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRNumber;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRUtil;
import io.github.alexzhirkevich.qrose.qrcode.internals.RSBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/QRCode;", "", "data", "", "errorCorrectionLevel", "Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;", "dataType", "Lio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;", "(Ljava/lang/String;Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;Lio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;)V", "qrCodeData", "Lio/github/alexzhirkevich/qrose/qrcode/internals/QRData;", "createBytes", "", "buffer", "Lio/github/alexzhirkevich/qrose/qrcode/internals/BitBuffer;", "rsBlocks", "", "Lio/github/alexzhirkevich/qrose/qrcode/internals/RSBlock;", "(Lio/github/alexzhirkevich/qrose/qrcode/internals/BitBuffer;[Lio/github/alexzhirkevich/qrose/qrcode/internals/RSBlock;)[I", "createData", "type", "", "encode", "Lio/github/alexzhirkevich/qrose/options/QrCodeMatrix;", "maskPattern", "Lio/github/alexzhirkevich/qrose/qrcode/MaskPattern;", "toString", "Companion", "qrose"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nQRCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QRCode.kt\nio/github/alexzhirkevich/qrose/qrcode/QRCode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n11065#2:210\n11400#2,2:211\n11065#2:213\n11400#2,3:214\n11402#2:217\n13374#2,3:219\n1#3:218\n*S KotlinDebug\n*F\n+ 1 QRCode.kt\nio/github/alexzhirkevich/qrose/qrcode/QRCode\n*L\n98#1:210\n98#1:211,2\n99#1:213\n99#1:214,3\n98#1:217\n155#1:219,3\n*E\n"})
public final class QRCode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String data;
    @NotNull
    private final ErrorCorrectionLevel errorCorrectionLevel;
    @NotNull
    private final QRCodeDataType dataType;
    @NotNull
    private final QRData qrCodeData;
    public static final int $stable;
    public static final int DEFAULT_CELL_SIZE = 1;
    private static final int PAD0 = 236;
    private static final int PAD1 = 17;

    @JvmOverloads
    public QRCode(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel, @NotNull QRCodeDataType dataType) {
        QRData qRData;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        this.data = data;
        this.errorCorrectionLevel = errorCorrectionLevel;
        this.dataType = dataType;
        switch (WhenMappings.$EnumSwitchMapping$0[this.dataType.ordinal()]) {
            case 1: {
                qRData = new QRNumber(this.data);
                break;
            }
            case 2: {
                qRData = new QRAlphaNum(this.data);
                break;
            }
            case 3: {
                qRData = new QR8BitByte(this.data);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.qrCodeData = qRData;
    }

    public /* synthetic */ QRCode(String string, ErrorCorrectionLevel errorCorrectionLevel, QRCodeDataType qRCodeDataType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            errorCorrectionLevel = ErrorCorrectionLevel.M;
        }
        if ((n & 4) != 0) {
            qRCodeDataType = QRUtil.INSTANCE.getDataType(string);
        }
        this(string, errorCorrectionLevel, qRCodeDataType);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final QrCodeMatrix encode(int type, @NotNull MaskPattern maskPattern) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)maskPattern), (String)"maskPattern");
        int moduleCount = type * 4 + 17;
        QRCodeSquare[][] qRCodeSquareArray = new QRCodeSquare[moduleCount][];
        for (int i = 0; i < moduleCount; ++i) {
            int n = i;
            int n2 = 0;
            QRCodeSquare[] qRCodeSquareArray2 = new QRCodeSquare[moduleCount];
            int n3 = n;
            QRCodeSquare[][] qRCodeSquareArray3 = qRCodeSquareArray;
            while (n2 < moduleCount) {
                int n4 = n2++;
                qRCodeSquareArray2[n4] = null;
            }
            qRCodeSquareArray3[n3] = qRCodeSquareArray2;
        }
        QRCodeSquare[][] modules = qRCodeSquareArray;
        QRCodeSetup.setupTopLeftPositionProbePattern$default(QRCodeSetup.INSTANCE, modules, 0, 2, null);
        QRCodeSetup.setupTopRightPositionProbePattern$default(QRCodeSetup.INSTANCE, modules, 0, 2, null);
        QRCodeSetup.setupBottomLeftPositionProbePattern$default(QRCodeSetup.INSTANCE, modules, 0, 2, null);
        QRCodeSetup.INSTANCE.setupPositionAdjustPattern(type, modules);
        QRCodeSetup.INSTANCE.setupTimingPattern(moduleCount, modules);
        QRCodeSetup.INSTANCE.setupTypeInfo(this.errorCorrectionLevel, maskPattern, moduleCount, modules);
        if (type >= 7) {
            QRCodeSetup.INSTANCE.setupTypeNumber(type, moduleCount, modules);
        }
        int[] data = this.createData(type);
        QRCodeSetup.INSTANCE.applyMaskPattern(data, maskPattern, moduleCount, modules);
        Object[] $this$map$iv = (Object[])modules;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it;
            QRCodeSquare[] qRCodeSquareArray4 = (QRCodeSquare[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$map$iv2 = it;
            boolean $i$f$map2 = false;
            void var18_22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv2).length);
            boolean $i$f$mapTo2 = false;
            int n = ((void)$this$mapTo$iv$iv2).length;
            for (int i = 0; i < n; ++i) {
                void pixel;
                void item$iv$iv2;
                void var24_28 = item$iv$iv2 = $this$mapTo$iv$iv2[i];
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                void v0 = pixel;
                collection2.add((v0 != null ? v0.getDark() : false) ? QrCodeMatrix.PixelType.DarkPixel : QrCodeMatrix.PixelType.LightPixel);
            }
            collection.add((List)destination$iv$iv2);
        }
        List list = (List)destination$iv$iv;
        return new QrCodeMatrix(list);
    }

    public static /* synthetic */ QrCodeMatrix encode$default(QRCode qRCode, int n, MaskPattern maskPattern, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = io.github.alexzhirkevich.qrose.qrcode.QRCode$Companion.typeForDataAndECL$default(Companion, qRCode.data, qRCode.errorCorrectionLevel, null, 4, null);
        }
        if ((n2 & 2) != 0) {
            maskPattern = MaskPattern.PATTERN000;
        }
        return qRCode.encode(n, maskPattern);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] createData(int type) {
        RSBlock[] rsBlocks = RSBlock.Companion.getRSBlocks(type, this.errorCorrectionLevel);
        BitBuffer buffer = new BitBuffer();
        buffer.put(this.qrCodeData.getDataType().getValue(), 4);
        buffer.put(this.qrCodeData.length(), this.qrCodeData.getLengthInBits(type));
        this.qrCodeData.write(buffer);
        RSBlock[] rSBlockArray = rsBlocks;
        int n = 0;
        int n2 = rSBlockArray.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            RSBlock rSBlock;
            RSBlock rSBlock2 = rSBlock = rSBlockArray[i];
            int n3 = n;
            boolean bl = false;
            int n4 = it.getDataCount();
            n = n3 + n4;
        }
        int totalDataCount = n * 8;
        if (buffer.getLengthInBits() > totalDataCount) {
            throw new IllegalArgumentException("Code length overflow (" + buffer.getLengthInBits() + " > " + totalDataCount + ")");
        }
        if (buffer.getLengthInBits() + 4 <= totalDataCount) {
            buffer.put(0, 4);
        }
        while (buffer.getLengthInBits() % 8 != 0) {
            buffer.put(false);
        }
        while (buffer.getLengthInBits() < totalDataCount) {
            buffer.put(236, 8);
            if (buffer.getLengthInBits() >= totalDataCount) break;
            buffer.put(17, 8);
        }
        return this.createBytes(buffer, rsBlocks);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] createBytes(BitBuffer buffer, RSBlock[] rsBlocks) {
        int r;
        int i;
        int n;
        int offset = 0;
        int maxDcCount = 0;
        int maxEcCount = 0;
        int totalCodeCount = 0;
        int n2 = 0;
        int n3 = rsBlocks.length;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            nArrayArray[n4] = new int[0];
        }
        int[][] dcData = nArrayArray;
        n3 = 0;
        int n5 = rsBlocks.length;
        int[][] nArrayArray2 = new int[n5][];
        while (n3 < n5) {
            n = n3++;
            nArrayArray2[n] = new int[0];
        }
        int[][] ecData = nArrayArray2;
        RSBlock[] $this$forEachIndexed$iv = rsBlocks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (RSBlock item$iv : $this$forEachIndexed$iv) {
            void it;
            int n6 = index$iv++;
            RSBlock rSBlock = item$iv;
            int i2 = n6;
            boolean bl = false;
            int dcCount = it.getDataCount();
            int ecCount = it.getTotalCount() - dcCount;
            totalCodeCount += it.getTotalCount();
            maxDcCount = RangesKt.coerceAtLeast((int)maxDcCount, (int)dcCount);
            maxEcCount = RangesKt.coerceAtLeast((int)maxEcCount, (int)ecCount);
            int n7 = 0;
            int[] nArray = new int[dcCount];
            int n8 = i2;
            int[][] nArrayArray3 = dcData;
            while (n7 < dcCount) {
                int n9 = n7++;
                nArray[n9] = 0xFF & buffer.getBuffer()[n9 + offset];
            }
            nArrayArray3[n8] = nArray;
            offset += dcCount;
            Polynomial rsPoly = QRUtil.INSTANCE.getErrorCorrectPolynomial(ecCount);
            Polynomial rawPoly = new Polynomial(dcData[i2], rsPoly.len() - 1);
            Polynomial modPoly = rawPoly.mod(rsPoly);
            int ecDataSize = rsPoly.len() - 1;
            int[] nArray2 = new int[ecDataSize];
            n8 = i2;
            nArrayArray3 = ecData;
            for (int j = 0; j < ecDataSize; ++j) {
                int n10 = j;
                int modIndex = n10 + modPoly.len() - ecDataSize;
                nArray2[n10] = modIndex >= 0 ? modPoly.get(modIndex) : 0;
            }
            nArrayArray3[n8] = nArray2;
        }
        int index = 0;
        int[] data = new int[totalCodeCount];
        n = maxDcCount;
        for (i = 0; i < n; ++i) {
            int n11 = rsBlocks.length;
            for (r = 0; r < n11; ++r) {
                if (i >= dcData[r].length) continue;
                data[index++] = dcData[r][i];
            }
        }
        n = maxEcCount;
        for (i = 0; i < n; ++i) {
            int n12 = rsBlocks.length;
            for (r = 0; r < n12; ++r) {
                if (i >= ecData[r].length) continue;
                data[index++] = ecData[r][i];
            }
        }
        return data;
    }

    @NotNull
    public String toString() {
        return "QRCode(data=" + this.data + ", errorCorrectionLevel=" + this.errorCorrectionLevel + ", dataType=" + this.dataType + ", qrCodeData=" + Reflection.getOrCreateKotlinClass(this.qrCodeData.getClass()).getSimpleName() + ")";
    }

    @JvmOverloads
    public QRCode(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        this(data, errorCorrectionLevel, null, 4, null);
    }

    @JvmOverloads
    public QRCode(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(data, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final QrCodeMatrix encode(int type) {
        return QRCode.encode$default(this, type, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final QrCodeMatrix encode() {
        return QRCode.encode$default(this, 0, null, 3, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final int typeForDataAndECL(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel, @NotNull QRCodeDataType dataType) {
        return Companion.typeForDataAndECL(data, errorCorrectionLevel, dataType);
    }

    @JvmStatic
    @JvmOverloads
    public static final int typeForDataAndECL(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
        return Companion.typeForDataAndECL(data, errorCorrectionLevel);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/QRCode$Companion;", "", "()V", "DEFAULT_CELL_SIZE", "", "PAD0", "PAD1", "typeForDataAndECL", "data", "", "errorCorrectionLevel", "Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;", "dataType", "Lio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;", "qrose"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final int typeForDataAndECL(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel, @NotNull QRCodeDataType dataType) {
            QRData qRData;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
            Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
            switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                case 1: {
                    qRData = new QRNumber(data);
                    break;
                }
                case 2: {
                    qRData = new QRAlphaNum(data);
                    break;
                }
                case 3: {
                    qRData = new QR8BitByte(data);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            QRData qrCodeData = qRData;
            int dataLength = qrCodeData.length();
            int n = errorCorrectionLevel.getMaxTypeNum();
            for (int typeNum = 1; typeNum < n; ++typeNum) {
                if (dataLength > QRUtil.INSTANCE.getMaxLength(typeNum, dataType, errorCorrectionLevel)) continue;
                return typeNum;
            }
            return 40;
        }

        public static /* synthetic */ int typeForDataAndECL$default(Companion companion, String string, ErrorCorrectionLevel errorCorrectionLevel, QRCodeDataType qRCodeDataType, int n, Object object) {
            if ((n & 4) != 0) {
                qRCodeDataType = QRUtil.INSTANCE.getDataType(string);
            }
            return companion.typeForDataAndECL(string, errorCorrectionLevel, qRCodeDataType);
        }

        @JvmStatic
        @JvmOverloads
        public final int typeForDataAndECL(@NotNull String data, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
            return io.github.alexzhirkevich.qrose.qrcode.QRCode$Companion.typeForDataAndECL$default(this, data, errorCorrectionLevel, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[QRCodeDataType.values().length];
                try {
                    nArray[QRCodeDataType.NUMBERS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QRCodeDataType.UPPER_ALPHA_NUM.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[QRCodeDataType.DEFAULT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QRCodeDataType.values().length];
            try {
                nArray[QRCodeDataType.NUMBERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeDataType.UPPER_ALPHA_NUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeDataType.DEFAULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

