/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.util.AssertUtil;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AuthenticatorTransportConverter {
    @NotNull
    public AuthenticatorTransport convert(@NotNull String value) {
        try {
            AssertUtil.notNull(value, "value must not be null");
            return AuthenticatorTransport.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public Set<AuthenticatorTransport> convertSet(@NotNull Set<String> values2) {
        try {
            AssertUtil.notNull(values2, "values must not be null");
            return values2.stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public String convertToString(@NotNull AuthenticatorTransport value) {
        try {
            AssertUtil.notNull(value, "value must not be null");
            return value.getValue();
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public Set<String> convertSetToStringSet(@NotNull Set<AuthenticatorTransport> values2) {
        try {
            AssertUtil.notNull(values2, "values must not be null");
            return values2.stream().map(this::convertToString).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }
}

