/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver.bundled;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0018"}, d2={"Landroidx/sqlite/driver/bundled/NativeLibraryLoader;", "", "<init>", "()V", "LIB_PATH_PROPERTY_NAME", "", "LIB_NAME_PROPERTY_NAME", "osName", "getOsName", "()Ljava/lang/String;", "osArch", "getOsArch", "osPrefix", "getOsPrefix", "archSuffix", "getArchSuffix", "loadLibrary", "", "name", "getLibraryName", "getResourceName", "libName", "tryLoad", "path", "sqlite-bundled"})
@SourceDebugExtension(value={"SMAP\nNativeLibraryLoader.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeLibraryLoader.jvm.kt\nandroidx/sqlite/driver/bundled/NativeLibraryLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public final class NativeLibraryLoader {
    @NotNull
    public static final NativeLibraryLoader INSTANCE = new NativeLibraryLoader();
    @NotNull
    private static final String LIB_PATH_PROPERTY_NAME = "androidx.sqlite.driver.bundled.path";
    @NotNull
    private static final String LIB_NAME_PROPERTY_NAME = "androidx.sqlite.driver.bundled.name";

    private NativeLibraryLoader() {
    }

    private final String getOsName() {
        String string2;
        block3: {
            block2: {
                string2 = System.getProperty("os.name");
                if (string2 == null) break block2;
                String string3 = string2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                String string4 = string3.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                string2 = string4;
                if (string4 != null) break block3;
            }
            throw new IllegalStateException("Cannot read osName".toString());
        }
        return string2;
    }

    private final String getOsArch() {
        String string2;
        block3: {
            block2: {
                string2 = System.getProperty("os.arch");
                if (string2 == null) break block2;
                String string3 = string2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                String string4 = string3.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                string2 = string4;
                if (string4 != null) break block3;
            }
            throw new IllegalStateException("Cannot read osArch".toString());
        }
        return string2;
    }

    private final String getOsPrefix() {
        String string2;
        if (StringsKt.contains$default((CharSequence)this.getOsName(), "linux", false, 2, null)) {
            string2 = "linux";
        } else if (StringsKt.contains$default((CharSequence)this.getOsName(), "mac", false, 2, null) || StringsKt.contains$default((CharSequence)this.getOsName(), "osx", false, 2, null)) {
            string2 = "osx";
        } else if (StringsKt.contains$default((CharSequence)this.getOsName(), "windows", false, 2, null)) {
            string2 = "windows";
        } else {
            throw new IllegalStateException(("Unsupported operating system: " + this.getOsName()).toString());
        }
        return string2;
    }

    private final String getArchSuffix() {
        String string2;
        if (Intrinsics.areEqual(this.getOsArch(), "aarch64")) {
            string2 = "arm64";
        } else if (StringsKt.contains$default((CharSequence)this.getOsArch(), "arm", false, 2, null)) {
            string2 = StringsKt.contains$default((CharSequence)this.getOsArch(), "64", false, 2, null) ? "arm64" : "arm32";
        } else if (StringsKt.contains$default((CharSequence)this.getOsArch(), "64", false, 2, null)) {
            string2 = "x64";
        } else if (StringsKt.contains$default((CharSequence)this.getOsArch(), "86", false, 2, null)) {
            string2 = "x86";
        } else {
            throw new IllegalStateException(("Unsupported architecture: " + this.getOsArch()).toString());
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadLibrary(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        NativeLibraryLoader nativeLibraryLoader = this;
        synchronized (nativeLibraryLoader) {
            boolean bl = false;
            try {
                System.loadLibrary(name);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String libraryPath = System.getProperty(LIB_PATH_PROPERTY_NAME);
                if (libraryPath != null) {
                    String libName;
                    File libFile;
                    String string2 = System.getProperty(LIB_NAME_PROPERTY_NAME);
                    if (string2 == null) {
                        string2 = INSTANCE.getLibraryName(name);
                    }
                    if (!(libFile = new File(libraryPath, libName = string2)).exists()) {
                        boolean $i$a$-check-NativeLibraryLoader$loadLibrary$1$32 = false;
                        String $i$a$-check-NativeLibraryLoader$loadLibrary$1$32 = "Cannot find a suitable SQLite binary for " + INSTANCE.getOsName() + " | " + INSTANCE.getOsArch() + " at the configured path (androidx.sqlite.driver.bundled.path = " + libraryPath + "). File " + libFile + " does not exist.";
                        throw new IllegalStateException($i$a$-check-NativeLibraryLoader$loadLibrary$1$32.toString());
                    }
                    String string3 = libFile.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue(string3, "getCanonicalPath(...)");
                    INSTANCE.tryLoad(string3);
                    return;
                }
                String libName = INSTANCE.getLibraryName(name);
                File javaHomeLibs = new File(System.getProperty("java.home"), Intrinsics.areEqual(INSTANCE.getOsPrefix(), "windows") ? "bin" : "lib");
                File libFile = FilesKt.resolve(javaHomeLibs, libName);
                if (libFile.exists()) {
                    String string4 = libFile.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue(string4, "getCanonicalPath(...)");
                    INSTANCE.tryLoad(string4);
                    return;
                }
                String libResourceName = INSTANCE.getResourceName(libName);
                Object object = Files.createTempFile("androidx_" + name, null, new FileAttribute[0]);
                Path $this$loadLibrary_u24lambda_u244_u24lambda_u241 = object;
                boolean bl2 = false;
                $this$loadLibrary_u24lambda_u244_u24lambda_u241.toFile().deleteOnExit();
                Path libTempCopy = object;
                ClassLoader classLoader = NativeLibraryLoader.class.getClassLoader();
                Intrinsics.checkNotNull(classLoader);
                object = classLoader.getResourceAsStream(libResourceName);
                Throwable throwable = null;
                try {
                    InputStream resourceStream = (InputStream)object;
                    boolean bl3 = false;
                    if (resourceStream == null) {
                        boolean bl4 = false;
                        String string5 = "Cannot find a suitable SQLite binary for " + INSTANCE.getOsName() + " | " + INSTANCE.getOsArch() + ". Please file a bug at https://issuetracker.google.com/issues/new?component=460784";
                        throw new IllegalStateException(string5.toString());
                    }
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    long l = Files.copy(resourceStream, libTempCopy, copyOptionArray);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                }
                String string6 = libTempCopy.toFile().getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue(string6, "getCanonicalPath(...)");
                INSTANCE.tryLoad(string6);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final String getLibraryName(String name) {
        String string2;
        String string3;
        switch (this.getOsPrefix()) {
            case "osx": 
            case "linux": {
                string3 = "lib";
                break;
            }
            case "windows": {
                string3 = "";
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported operating system: " + this.getOsName()).toString());
            }
        }
        String prefix = string3;
        switch (this.getOsPrefix()) {
            case "linux": {
                string2 = "so";
                break;
            }
            case "osx": {
                string2 = "dylib";
                break;
            }
            case "windows": {
                string2 = "dll";
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported operating system: " + this.getOsName()).toString());
            }
        }
        String extension = string2;
        return prefix + name + '.' + extension;
    }

    private final String getResourceName(String libName) {
        String resourceFolder = this.getOsPrefix() + '_' + this.getArchSuffix();
        return "natives/" + resourceFolder + '/' + libName;
    }

    private final void tryLoad(String path) {
        System.load(path);
    }
}

