/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.coroutines.FlowUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache;
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao;
import com.ustadmobile.libcache.db.entities.NeighborCache;
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0096@\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0096@\u00a2\u0006\u0004\b\u0011\u0010\u000bJ\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010\u0012\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao_Impl;", "Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao;", "Landroidx/room/RoomDatabase;", "__db", "<init>", "(Landroidx/room/RoomDatabase;)V", "", "Lcom/ustadmobile/libcache/db/entities/NeighborCacheEntry;", "neighborCacheEntryList", "", "upsertList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlinx/coroutines/flow/Flow;", "allEntriesAsFlow", "()Lkotlinx/coroutines/flow/Flow;", "", "urlHashes", "findAvailableEntries", "urlHash", "Lcom/ustadmobile/libcache/db/composites/NeighborCacheEntryAndNeighborCache;", "findAvailableNeighborsByUrlHash", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Landroidx/room/RoomDatabase;", "Landroidx/room/EntityInsertAdapter;", "__insertAdapterOfNeighborCacheEntry", "Landroidx/room/EntityInsertAdapter;", "Companion", "respect-lib-cache"})
public final class NeighborCacheEntryDao_Impl
extends NeighborCacheEntryDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<NeighborCacheEntry> __insertAdapterOfNeighborCacheEntry;

    public NeighborCacheEntryDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter(__db, "__db");
        this.__db = __db;
        this.__insertAdapterOfNeighborCacheEntry = new EntityInsertAdapter<NeighborCacheEntry>(){

            @Override
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `NeighborCacheEntry` (`nceNeighborUid`,`nceUrlHash`) VALUES (?,?)";
            }

            @Override
            protected void bind(SQLiteStatement statement, NeighborCacheEntry entity) {
                Intrinsics.checkNotNullParameter(statement, "statement");
                Intrinsics.checkNotNullParameter(entity, "entity");
                statement.bindLong(1, entity.getNceNeighborUid());
                statement.bindLong(2, entity.getNceUrlHash());
            }
        };
    }

    @Override
    @Nullable
    public Object upsertList(@NotNull List<NeighborCacheEntry> neighborCacheEntryList, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending(this.__db, false, true, arg_0 -> NeighborCacheEntryDao_Impl.upsertList$lambda$0(this, neighborCacheEntryList, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public Flow<List<NeighborCacheEntry>> allEntriesAsFlow() {
        String _sql = "\n        SELECT NeighborCacheEntry.* \n          FROM NeighborCacheEntry\n    ";
        String[] stringArray = new String[]{"NeighborCacheEntry"};
        return FlowUtil.createFlow(this.__db, false, stringArray, arg_0 -> NeighborCacheEntryDao_Impl.allEntriesAsFlow$lambda$0(_sql, arg_0));
    }

    @Override
    @Nullable
    public Object findAvailableEntries(@NotNull List<Long> urlHashes, @NotNull Continuation<? super List<Long>> $completion) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT NeighborCacheEntry.nceUrlHash");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM NeighborCacheEntry");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE NeighborCacheEntry.nceUrlHash IN (");
        int _inputSize = urlHashes.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(") ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String string2 = _stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String _sql = string2;
        return DBUtil.performSuspending(this.__db, true, false, arg_0 -> NeighborCacheEntryDao_Impl.findAvailableEntries$lambda$0(_sql, urlHashes, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findAvailableNeighborsByUrlHash(long urlHash, @NotNull Continuation<? super List<NeighborCacheEntryAndNeighborCache>> $completion) {
        String _sql = "\n        SELECT NeighborCacheEntry.*,\n               NeighborCache.*\n          FROM NeighborCacheEntry\n               JOIN NeighborCache\n                    ON NeighborCache.neighborUid = NeighborCacheEntry.nceNeighborUid\n         WHERE NeighborCacheEntry.nceUrlHash = ?\n           AND NeighborCache.neighborStatus = 1\n    ";
        return DBUtil.performSuspending(this.__db, true, false, arg_0 -> NeighborCacheEntryDao_Impl.findAvailableNeighborsByUrlHash$lambda$0(_sql, urlHash, arg_0), $completion);
    }

    private static final Unit upsertList$lambda$0(NeighborCacheEntryDao_Impl this$0, List $neighborCacheEntryList, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        this$0.__insertAdapterOfNeighborCacheEntry.insert(_connection, $neighborCacheEntryList);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List allEntriesAsFlow$lambda$0(String $_sql, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _columnIndexOfNceNeighborUid = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "nceNeighborUid");
            int _columnIndexOfNceUrlHash = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "nceUrlHash");
            List _result = new ArrayList();
            while (_stmt.step()) {
                NeighborCacheEntry _item = null;
                long _tmpNceNeighborUid = 0L;
                _tmpNceNeighborUid = _stmt.getLong(_columnIndexOfNceNeighborUid);
                long _tmpNceUrlHash = 0L;
                _tmpNceUrlHash = _stmt.getLong(_columnIndexOfNceUrlHash);
                _item = new NeighborCacheEntry(_tmpNceNeighborUid, _tmpNceUrlHash);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAvailableEntries$lambda$0(String $_sql, List $urlHashes, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            Iterator iterator2 = $urlHashes.iterator();
            while (iterator2.hasNext()) {
                long _item = ((Number)iterator2.next()).longValue();
                _stmt.bindLong(_argIndex, _item);
                ++_argIndex;
            }
            List _result = new ArrayList();
            while (_stmt.step()) {
                long _item_1 = 0L;
                _item_1 = _stmt.getLong(0);
                _result.add(_item_1);
            }
            list2 = _result;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findAvailableNeighborsByUrlHash$lambda$0(String $_sql, long $urlHash, SQLiteConnection _connection) {
        List list2;
        Intrinsics.checkNotNullParameter(_connection, "_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $urlHash);
            int _columnIndexOfNceNeighborUid = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "nceNeighborUid");
            int _columnIndexOfNceUrlHash = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "nceUrlHash");
            int _columnIndexOfNeighborUid = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "neighborUid");
            int _columnIndexOfNeighborDeviceName = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "neighborDeviceName");
            int _columnIndexOfNeighborIp = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "neighborIp");
            int _columnIndexOfNeighborUdpPort = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "neighborUdpPort");
            int _columnIndexOfNeighborHttpPort = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "neighborHttpPort");
            int _columnIndexOfNeighborDiscovered = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "neighborDiscovered");
            int _columnIndexOfNeighborPingTime = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "neighborPingTime");
            int _columnIndexOfNeighborLastSeen = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "neighborLastSeen");
            int _columnIndexOfNeighborStatus = SQLiteStatementUtil.getColumnIndexOrThrow(_stmt, "neighborStatus");
            List _result = new ArrayList();
            while (_stmt.step()) {
                NeighborCacheEntryAndNeighborCache _item = null;
                NeighborCacheEntry _tmpNeighborCacheEntry = null;
                long _tmpNceNeighborUid = 0L;
                _tmpNceNeighborUid = _stmt.getLong(_columnIndexOfNceNeighborUid);
                long _tmpNceUrlHash = 0L;
                _tmpNceUrlHash = _stmt.getLong(_columnIndexOfNceUrlHash);
                _tmpNeighborCacheEntry = new NeighborCacheEntry(_tmpNceNeighborUid, _tmpNceUrlHash);
                NeighborCache _tmpNeighborCache = null;
                long _tmpNeighborUid = 0L;
                _tmpNeighborUid = _stmt.getLong(_columnIndexOfNeighborUid);
                String _tmpNeighborDeviceName = null;
                _tmpNeighborDeviceName = _stmt.getText(_columnIndexOfNeighborDeviceName);
                String _tmpNeighborIp = null;
                _tmpNeighborIp = _stmt.getText(_columnIndexOfNeighborIp);
                int _tmpNeighborUdpPort = 0;
                _tmpNeighborUdpPort = (int)_stmt.getLong(_columnIndexOfNeighborUdpPort);
                int _tmpNeighborHttpPort = 0;
                _tmpNeighborHttpPort = (int)_stmt.getLong(_columnIndexOfNeighborHttpPort);
                long _tmpNeighborDiscovered = 0L;
                _tmpNeighborDiscovered = _stmt.getLong(_columnIndexOfNeighborDiscovered);
                int _tmpNeighborPingTime = 0;
                _tmpNeighborPingTime = (int)_stmt.getLong(_columnIndexOfNeighborPingTime);
                long _tmpNeighborLastSeen = 0L;
                _tmpNeighborLastSeen = _stmt.getLong(_columnIndexOfNeighborLastSeen);
                int _tmpNeighborStatus = 0;
                _tmpNeighborStatus = (int)_stmt.getLong(_columnIndexOfNeighborStatus);
                _tmpNeighborCache = new NeighborCache(_tmpNeighborUid, _tmpNeighborDeviceName, _tmpNeighborIp, _tmpNeighborUdpPort, _tmpNeighborHttpPort, _tmpNeighborDiscovered, _tmpNeighborPingTime, _tmpNeighborLastSeen, _tmpNeighborStatus);
                _item = new NeighborCacheEntryAndNeighborCache(_tmpNeighborCache, _tmpNeighborCacheEntry);
                _result.add(_item);
            }
            list2 = _result;
        }
        return list2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao_Impl$Companion;", "", "<init>", "()V", "", "Lkotlin/reflect/KClass;", "getRequiredConverters", "()Ljava/util/List;", "respect-lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

