/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="android-key")
public class AndroidKeyAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "android-key";
    @JsonProperty
    private final COSEAlgorithmIdentifier alg;
    @JsonProperty
    private final byte[] sig;
    @JsonProperty
    private final AttestationCertificatePath x5c;

    @JsonCreator
    public AndroidKeyAttestationStatement(@JsonProperty(value="alg") @NotNull COSEAlgorithmIdentifier alg, @JsonProperty(value="sig") @NotNull byte[] sig, @JsonProperty(value="x5c") @NotNull AttestationCertificatePath x5c) {
        AssertUtil.notNull(alg, "alg must not be null");
        AssertUtil.notNull(sig, "sig must not be null");
        AssertUtil.notNull(x5c, "x5c must not be null");
        this.alg = alg;
        this.sig = sig;
        this.x5c = x5c;
    }

    @NotNull
    public COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    @NotNull
    public byte[] getSig() {
        return ArrayUtil.clone(this.sig);
    }

    @Override
    @NotNull
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    @Override
    @NotNull
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidKeyAttestationStatement that = (AndroidKeyAttestationStatement)o;
        return Objects.equals(this.alg, that.alg) && Arrays.equals(this.sig, that.sig) && Objects.equals(this.x5c, that.x5c);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.alg, this.x5c);
        result2 = 31 * result2 + Arrays.hashCode(this.sig);
        return result2;
    }

    public String toString() {
        return "AndroidKeyAttestationStatement(alg=" + this.alg + ", sig=" + ArrayUtil.toHexString(this.sig) + ", x5c=" + this.x5c + ")";
    }
}

