/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.io.File;
import java.io.IOException;
import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.impl.type.FileVerificationStep;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;

public class FileVerification {
    public boolean verifyExists = false;
    public boolean verifyNotExists = false;
    public boolean verifyIsFile = false;
    public boolean verifyIsDirectory = false;
    public boolean verifyCanRead = false;
    public boolean verifyCanWrite = false;
    public boolean verifyCanWriteParent = false;
    public boolean verifyCanCreate = false;
    public boolean verifyCanExecute = false;
    public boolean verifyIsAbsolute = false;
    private FileVerification nextFileVerification;

    public FileVerification or() {
        this.nextFileVerification = new FileVerification();
        return this.nextFileVerification;
    }

    public void verify(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        FileVerificationStep verifyPresenceAndType;
        if (this.verifyIsAbsolute) {
            this.verifyIsAbsolute(parser, arg, file2);
        }
        if (!this.verifyStep(verifyPresenceAndType = () -> this.verifyPresenceAndType(parser, arg, file2))) {
            this.nextFileVerification.verify(parser, arg, file2);
        } else {
            FileVerificationStep verifyPermissions = () -> this.verifyPermissions(parser, arg, file2);
            if (!this.verifyStep(verifyPermissions)) {
                this.nextFileVerification.verify(parser, arg, file2);
            }
        }
    }

    private boolean verifyStep(FileVerificationStep step) throws ArgumentParserException {
        boolean result2 = true;
        try {
            step.verify();
        }
        catch (ArgumentParserException e) {
            if (this.nextFileVerification == null) {
                throw e;
            }
            result2 = false;
        }
        return result2;
    }

    private void verifyPresenceAndType(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (this.verifyExists) {
            this.verifyExists(parser, arg, file2);
        }
        if (this.verifyNotExists) {
            this.verifyNotExists(parser, arg, file2);
        }
        if (this.verifyIsFile) {
            this.verifyIsFile(parser, arg, file2);
        }
        if (this.verifyIsDirectory) {
            this.verifyIsDirectory(parser, arg, file2);
        }
    }

    private void verifyPermissions(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (this.verifyCanRead) {
            this.verifyCanRead(parser, arg, file2);
        }
        if (this.verifyCanWrite) {
            this.verifyCanWrite(parser, arg, file2);
        }
        if (this.verifyCanWriteParent) {
            this.verifyCanWriteParent(parser, arg, file2);
        }
        if (this.verifyCanCreate) {
            this.verifyCanCreate(parser, arg, file2);
        }
        if (this.verifyCanExecute) {
            this.verifyCanExecute(parser, arg, file2);
        }
    }

    private void verifyExists(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (!this.exists(file2)) {
            this.throwException(parser, arg, file2, "fileNotFoundError");
        }
    }

    private void verifyNotExists(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (this.exists(file2)) {
            this.throwException(parser, arg, file2, "fileFoundError");
        }
    }

    private void verifyIsFile(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (!this.isFile(file2)) {
            this.throwException(parser, arg, file2, "notAFileError");
        }
    }

    private void verifyIsDirectory(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (!this.isDirectory(file2)) {
            this.throwException(parser, arg, file2, "notADirectoryError");
        }
    }

    private void verifyCanRead(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (!this.canRead(file2)) {
            this.throwException(parser, arg, file2, "insufficientPermissionsToReadFileError");
        }
    }

    private void verifyCanWrite(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (!this.canWrite(file2)) {
            this.throwException(parser, arg, file2, "insufficientPermissionsToWriteFileError");
        }
    }

    private void verifyCanWriteParent(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        File parent = file2.getParentFile();
        if (parent == null || !this.canWrite(parent)) {
            this.throwException(parser, arg, file2, "cannotWriteParentOfFileError");
        }
    }

    private void verifyCanCreate(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        try {
            File parent = file2.getCanonicalFile().getParentFile();
            if (parent != null && this.canWrite(parent)) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.throwException(parser, arg, file2, "cannotCreateFileError");
    }

    private void verifyCanExecute(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (!this.canExecute(file2)) {
            this.throwException(parser, arg, file2, "insufficientPermissionsToExecuteFileError");
        }
    }

    private void verifyIsAbsolute(ArgumentParser parser, Argument arg, File file2) throws ArgumentParserException {
        if (!file2.isAbsolute()) {
            this.throwException(parser, arg, file2, "notAnAbsoluteFileError");
        }
    }

    private void throwException(ArgumentParser parser, Argument arg, File file2, String messageKey) throws ArgumentParserException {
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, MessageLocalization.localize(parser.getConfig().getResourceBundle(), messageKey), file2), parser, arg);
    }

    protected boolean exists(File file2) {
        return file2.exists();
    }

    protected boolean isDirectory(File file2) {
        return file2.isDirectory();
    }

    protected boolean isFile(File file2) {
        return file2.isFile();
    }

    protected boolean canRead(File file2) {
        return file2.canRead();
    }

    protected boolean canWrite(File file2) {
        return file2.canWrite();
    }

    protected boolean canExecute(File file2) {
        return file2.canExecute();
    }
}

