/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.xapi;

import com.benasher44.uuid.UuidKt;
import com.ustadmobile.core.domain.xapi.XapiException;
import com.ustadmobile.door.DoorUri;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u001a-\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\b\u0010\u0007\u001a\u0004\u0018\u0001H\u00062\u0006\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0003\u001a\u001a\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u001a\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u001a\"\u0010\u0012\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u001a\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u00a8\u0006\u0017"}, d2={"xapiRequireDurationOrNullAsLong", "", "duration", "", "(Ljava/lang/String;)Ljava/lang/Long;", "xapiRequireNotNullOrThrow", "T", "required", "message", "responseCode", "", "(Ljava/lang/Object;Ljava/lang/String;I)Ljava/lang/Object;", "xapiRequireTimestampAsLong", "timestampStr", "xapiRequireValidIRI", "iri", "errorMessage", "xapiRequireValidIRIOrNull", "xapiRequireValidUuidOrNull", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "uuid", "xapiRequireValidUuidOrNullAsString", "core_release"})
@SourceDebugExtension(value={"SMAP\nXapiRequire.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XapiRequire.kt\ncom/ustadmobile/core/domain/xapi/XapiRequireKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class XapiRequireKt {
    public static final <T> T xapiRequireNotNullOrThrow(@Nullable T required, @NotNull String message, int responseCode) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        T t = required;
        if (t == null) {
            throw new XapiException(responseCode, message, null, 4, null);
        }
        return t;
    }

    public static /* synthetic */ Object xapiRequireNotNullOrThrow$default(Object object, String string2, int n, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            n = 400;
        }
        return XapiRequireKt.xapiRequireNotNullOrThrow(object, string2, n);
    }

    @Nullable
    public static final Long xapiRequireDurationOrNullAsLong(@Nullable String duration) {
        Long l;
        String string2 = duration;
        if (string2 != null) {
            long l2;
            String it = string2;
            boolean bl = false;
            try {
                l2 = Duration.getInWholeMilliseconds-impl((long)Duration.Companion.parseIsoString-UwyO8pc(it));
            }
            catch (Throwable e) {
                throw new XapiException(400, "Invalid duration: " + e.getMessage(), e);
            }
            l = l2;
        } else {
            l = null;
        }
        return l;
    }

    public static final long xapiRequireTimestampAsLong(@NotNull String timestampStr) {
        Intrinsics.checkNotNullParameter((Object)timestampStr, (String)"timestampStr");
        try {
            return Instant.Companion.parse(timestampStr).toEpochMilliseconds();
        }
        catch (Throwable e) {
            throw new XapiException(400, "Invalid timestamp: " + e.getMessage(), e);
        }
    }

    @Nullable
    public static final UUID xapiRequireValidUuidOrNull(@Nullable String uuid, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        try {
            UUID uUID;
            String string2 = uuid;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                uUID = UuidKt.uuidFrom((String)it);
            } else {
                uUID = null;
            }
            return uUID;
        }
        catch (Throwable e) {
            throw new XapiException(400, errorMessage + ": " + e.getMessage(), e);
        }
    }

    public static /* synthetic */ UUID xapiRequireValidUuidOrNull$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "Invalid uuid";
        }
        return XapiRequireKt.xapiRequireValidUuidOrNull(string2, string3);
    }

    @Nullable
    public static final String xapiRequireValidUuidOrNullAsString(@Nullable String uuid, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        try {
            if (uuid != null) {
                UuidKt.uuidFrom((String)uuid);
            }
            return uuid;
        }
        catch (Throwable e) {
            throw new XapiException(400, errorMessage + ": " + e.getMessage(), e);
        }
    }

    public static /* synthetic */ String xapiRequireValidUuidOrNullAsString$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "Invalid uuid";
        }
        return XapiRequireKt.xapiRequireValidUuidOrNullAsString(string2, string3);
    }

    @Nullable
    public static final String xapiRequireValidIRIOrNull(@Nullable String iri, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (iri != null) {
            try {
                DoorUri.Companion.parse(iri);
            }
            catch (Throwable e) {
                throw new XapiException(400, errorMessage + ": " + e.getMessage(), e);
            }
        }
        return iri;
    }

    public static /* synthetic */ String xapiRequireValidIRIOrNull$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "Invalid IRI:";
        }
        return XapiRequireKt.xapiRequireValidIRIOrNull(string2, string3);
    }

    @NotNull
    public static final String xapiRequireValidIRI(@Nullable String iri, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (iri == null) {
            throw new XapiException(400, errorMessage + ": iri is null", null, 4, null);
        }
        XapiRequireKt.xapiRequireValidIRIOrNull$default(iri, null, 2, null);
        return iri;
    }

    public static /* synthetic */ String xapiRequireValidIRI$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "Invalid iri";
        }
        return XapiRequireKt.xapiRequireValidIRI(string2, string3);
    }
}

