/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.impl.nav;

import com.ustadmobile.core.impl.nav.NavCommand;
import com.ustadmobile.door.util.SystemTimeKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/core/impl/nav/NavCommandExecutionTracker;", "", "timeout", "", "(J)V", "executedTimestamps", "", "runIfNotExecutedOrTimedOut", "", "navCommand", "Lcom/ustadmobile/core/impl/nav/NavCommand;", "block", "Lkotlin/Function1;", "Companion", "core_release"})
public final class NavCommandExecutionTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long timeout;
    @NotNull
    private final Set<Long> executedTimestamps;
    public static final long DEFAULT_TIMEOUT = 5000L;

    public NavCommandExecutionTracker(long timeout) {
        this.timeout = timeout;
        this.executedTimestamps = new LinkedHashSet();
    }

    public /* synthetic */ NavCommandExecutionTracker(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 5000L;
        }
        this(l);
    }

    public final void runIfNotExecutedOrTimedOut(@NotNull NavCommand navCommand, @NotNull Function1<? super NavCommand, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)navCommand, (String)"navCommand");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long timeNow = SystemTimeKt.systemTimeInMillis();
        if (!this.executedTimestamps.contains(navCommand.getTimestamp()) && timeNow - navCommand.getTimestamp() < this.timeout) {
            block.invoke((Object)navCommand);
            ((Collection)this.executedTimestamps).add(navCommand.getTimestamp());
        }
        CollectionsKt.removeAll((Iterable)this.executedTimestamps, (Function1)((Function1)new Function1<Long, Boolean>(timeNow, this){
            final /* synthetic */ long $timeNow;
            final /* synthetic */ NavCommandExecutionTracker this$0;
            {
                this.$timeNow = $timeNow;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(long it) {
                return this.$timeNow - it > NavCommandExecutionTracker.access$getTimeout$p(this.this$0);
            }
        }));
    }

    public NavCommandExecutionTracker() {
        this(0L, 1, null);
    }

    public static final /* synthetic */ long access$getTimeout$p(NavCommandExecutionTracker $this) {
        return $this.timeout;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/core/impl/nav/NavCommandExecutionTracker$Companion;", "", "()V", "DEFAULT_TIMEOUT", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

