/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.viewmodel.clazz.gradebook;

import com.ustadmobile.core.util.ext.CommonFloatExtKt;
import com.ustadmobile.lib.db.composites.BlockStatus;
import com.ustadmobile.lib.db.entities.CourseBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a(\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001\u001a\u001b\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\r\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\bH\u0002\u001a\u001b\u0010\u0010\u001a\u0004\u0018\u00010\f*\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0011\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"COMPLETABLE_BLOCK_TYPES", "", "", "aggregateIfModule", "Lcom/ustadmobile/lib/db/composites/BlockStatus;", "blockUid", "", "blocks", "Lcom/ustadmobile/lib/db/entities/CourseBlock;", "displayMarkFor", "", "maxPoints", "", "(Lcom/ustadmobile/lib/db/composites/BlockStatus;Ljava/lang/Float;)Ljava/lang/String;", "isCompleteable", "", "markFor", "(Lcom/ustadmobile/lib/db/composites/BlockStatus;Ljava/lang/Float;)Ljava/lang/Float;", "core_release"})
@SourceDebugExtension(value={"SMAP\nBlockStatusExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockStatusExt.kt\ncom/ustadmobile/core/viewmodel/clazz/gradebook/BlockStatusExtKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n288#2,2:113\n1774#2,4:115\n766#2:119\n857#2,2:120\n1194#2,2:122\n1222#2,4:124\n1855#2,2:128\n288#2,2:130\n*S KotlinDebug\n*F\n+ 1 BlockStatusExt.kt\ncom/ustadmobile/core/viewmodel/clazz/gradebook/BlockStatusExtKt\n*L\n20#1:113,2\n22#1:115,4\n28#1:119\n28#1:120,2\n29#1:122,2\n29#1:124,4\n41#1:128,2\n91#1:130,2\n*E\n"})
public final class BlockStatusExtKt {
    @NotNull
    private static final List<Integer> COMPLETABLE_BLOCK_TYPES;

    private static final boolean isCompleteable(CourseBlock $this$isCompleteable) {
        return COMPLETABLE_BLOCK_TYPES.contains($this$isCompleteable.getCbType());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final BlockStatus aggregateIfModule(@NotNull List<BlockStatus> $this$aggregateIfModule, long blockUid, @NotNull List<CourseBlock> blocks) {
        BlockStatus blockStatus;
        Object v0;
        block17: {
            Intrinsics.checkNotNullParameter($this$aggregateIfModule, (String)"<this>");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Iterable $this$firstOrNull$iv = blocks;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CourseBlock it = (CourseBlock)element$iv;
                boolean bl = false;
                if (!(it.getCbUid() == blockUid)) continue;
                v0 = element$iv;
                break block17;
            }
            v0 = null;
        }
        CourseBlock courseBlock = v0;
        if (courseBlock == null) {
            return null;
        }
        CourseBlock block = courseBlock;
        if (block.getCbType() == 100) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            void $this$filterTo$iv$iv;
            int moduleBlockCount;
            Object element$iv;
            Iterable $this$count$iv = blocks;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv) {
                    CourseBlock it = (CourseBlock)element$iv2;
                    boolean bl = false;
                    if (!(it.getCbModuleParentBlockUid() == blockUid) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v2 = moduleBlockCount = count$iv;
            }
            if (moduleBlockCount == 0) {
                return null;
            }
            Iterable $this$filter$iv = blocks;
            boolean $i$f$filter = false;
            element$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CourseBlock it = (CourseBlock)element$iv$iv;
                boolean bl = false;
                if (!(it.getCbModuleParentBlockUid() == blockUid)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                CourseBlock bl = (CourseBlock)element$iv$iv;
                Map map2 = destination$iv$iv2;
                boolean bl2 = false;
                map2.put(it.getCbUid(), element$iv$iv);
            }
            Map moduleBlockUids = destination$iv$iv2;
            int numBlocksWithScoreResult = 0;
            int numBlocksWithScore = 0;
            int numModsComplete = 0;
            int numBlocksSuccessSet = 0;
            int numBlocksSuccess = 0;
            int numBlocksFailed = 0;
            float totalPointsScored = 0.0f;
            float maxPointsInModule = 0.0f;
            int numCompleteableBlocksInModule = 0;
            Iterable $this$forEach$iv = $this$aggregateIfModule;
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                float it;
                CourseBlock courseBlock2;
                Object object;
                CourseBlock blockForStatus;
                BlockStatus blockStatus2 = (BlockStatus)element$iv3;
                boolean bl = false;
                if (!moduleBlockUids.keySet().contains(blockStatus2.getSCbUid())) continue;
                CourseBlock courseBlock3 = blockForStatus = (CourseBlock)moduleBlockUids.get(blockStatus2.getSCbUid());
                boolean bl3 = courseBlock3 != null ? BlockStatusExtKt.isCompleteable(courseBlock3) : false;
                if (bl3) {
                    ++numCompleteableBlocksInModule;
                }
                if ((object = blockForStatus) != null && (object = object.getCbMaxPoints()) != null) {
                    courseBlock2 = object;
                    it = ((Number)courseBlock2).floatValue();
                    boolean bl4 = false;
                    maxPointsInModule += it;
                    ++numBlocksWithScore;
                }
                if (blockStatus2.getSScoreScaled() != null) {
                    it = ((Number)courseBlock2).floatValue();
                    boolean bl5 = false;
                    Object object2 = blockForStatus;
                    totalPointsScored += it * (object2 != null && (object2 = object2.getCbMaxPoints()) != null ? ((Float)object2).floatValue() : 0.0f);
                    ++numBlocksWithScoreResult;
                }
                if (blockStatus2.getSIsCompleted()) {
                    ++numModsComplete;
                }
                if (blockStatus2.getSIsSuccess() == null) continue;
                boolean isSuccess = courseBlock2.booleanValue();
                boolean bl6 = false;
                ++numBlocksSuccessSet;
                if (isSuccess) {
                    ++numBlocksSuccess;
                    continue;
                }
                ++numBlocksFailed;
            }
            boolean isModuleComplete = numCompleteableBlocksInModule > 0 && numCompleteableBlocksInModule == numModsComplete;
            BlockStatus blockStatus3 = (BlockStatus)CollectionsKt.firstOrNull($this$aggregateIfModule);
            long l = blockStatus3 != null ? blockStatus3.getSPersonUid() : 0L;
            Float f = !(maxPointsInModule == 0.0f) ? Float.valueOf(totalPointsScored / maxPointsInModule) : null;
            Boolean bl = isModuleComplete && numBlocksSuccess == numBlocksSuccessSet ? Boolean.valueOf(true) : (isModuleComplete && numBlocksFailed > 0 ? Boolean.valueOf(false) : null);
            blockStatus = new BlockStatus(l, blockUid, null, isModuleComplete, bl, f, 4, null);
        } else {
            Object v9;
            block18: {
                Iterable $this$firstOrNull$iv = $this$aggregateIfModule;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BlockStatus it = (BlockStatus)element$iv;
                    boolean bl = false;
                    if (!(it.getSCbUid() == blockUid)) continue;
                    v9 = element$iv;
                    break block18;
                }
                v9 = null;
            }
            blockStatus = v9;
        }
        return blockStatus;
    }

    @Nullable
    public static final Float markFor(@NotNull BlockStatus $this$markFor, @Nullable Float maxPoints) {
        Intrinsics.checkNotNullParameter((Object)$this$markFor, (String)"<this>");
        Float scaledMarkVal = $this$markFor.getSScoreScaled();
        return scaledMarkVal != null && maxPoints != null ? Float.valueOf(scaledMarkVal.floatValue() * maxPoints.floatValue()) : null;
    }

    @Nullable
    public static final String displayMarkFor(@NotNull BlockStatus $this$displayMarkFor, @Nullable Float maxPoints) {
        Intrinsics.checkNotNullParameter((Object)$this$displayMarkFor, (String)"<this>");
        Float f = BlockStatusExtKt.markFor($this$displayMarkFor, maxPoints);
        return f != null ? CommonFloatExtKt.toDisplayString$default(f.floatValue(), 0, 1, null) : null;
    }

    static {
        Object[] objectArray = new Integer[]{104, 103};
        COMPLETABLE_BLOCK_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }
}

