/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.backup;

import android.content.Context;
import android.net.Uri;
import com.ustadmobile.core.domain.backup.CommonJvmZipFileUseCase;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/core/domain/backup/AndroidZipFileUseCase;", "Lcom/ustadmobile/core/domain/backup/CommonJvmZipFileUseCase;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "createOutputFile", "Ljava/io/File;", "path", "", "openInputStream", "Ljava/io/InputStream;", "uri", "core_release"})
public final class AndroidZipFileUseCase
extends CommonJvmZipFileUseCase {
    @NotNull
    private final Context context;

    public AndroidZipFileUseCase(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @NotNull
    protected InputStream openInputStream(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        InputStream inputStream = this.context.getContentResolver().openInputStream(Uri.parse((String)uri));
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to open input stream for URI: " + uri);
        }
        return inputStream;
    }

    @Override
    @NotNull
    protected File createOutputFile(@NotNull String path) {
        File file;
        block0: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            file = new File(this.context.getExternalFilesDir(null), path);
            File file2 = file.getParentFile();
            if (file2 == null) break block0;
            file2.mkdirs();
        }
        return file;
    }
}

