/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.blob.savepicture;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import com.ustadmobile.core.account.LearningSpace;
import com.ustadmobile.core.domain.blob.savepicture.EnqueueSavePictureUseCase;
import com.ustadmobile.core.domain.blob.savepicture.SavePictureWorker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096B\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/ustadmobile/core/domain/blob/savepicture/EnqueueSavePictureUseCaseAndroid;", "Lcom/ustadmobile/core/domain/blob/savepicture/EnqueueSavePictureUseCase;", "appContext", "Landroid/content/Context;", "learningSpace", "Lcom/ustadmobile/core/account/LearningSpace;", "(Landroid/content/Context;Lcom/ustadmobile/core/account/LearningSpace;)V", "invoke", "", "entityUid", "", "tableId", "", "pictureUri", "", "(JILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core_release"})
@SourceDebugExtension(value={"SMAP\nEnqueueSavePictureUseCaseAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnqueueSavePictureUseCaseAndroid.kt\ncom/ustadmobile/core/domain/blob/savepicture/EnqueueSavePictureUseCaseAndroid\n+ 2 OneTimeWorkRequest.kt\nandroidx/work/OneTimeWorkRequestKt\n*L\n1#1,40:1\n100#2:41\n*S KotlinDebug\n*F\n+ 1 EnqueueSavePictureUseCaseAndroid.kt\ncom/ustadmobile/core/domain/blob/savepicture/EnqueueSavePictureUseCaseAndroid\n*L\n32#1:41\n*E\n"})
public final class EnqueueSavePictureUseCaseAndroid
implements EnqueueSavePictureUseCase {
    @NotNull
    private final Context appContext;
    @NotNull
    private final LearningSpace learningSpace;

    public EnqueueSavePictureUseCaseAndroid(@NotNull Context appContext, @NotNull LearningSpace learningSpace) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)learningSpace, (String)"learningSpace");
        this.appContext = appContext;
        this.learningSpace = learningSpace;
    }

    @Override
    @Nullable
    public Object invoke(long entityUid, int tableId, @Nullable String pictureUri, @NotNull Continuation<? super Unit> $completion) {
        String workName = this.learningSpace.getUrl() + "-" + tableId + "-" + entityUid;
        Data data = new Data.Builder().putString("endpoint", this.learningSpace.getUrl()).putLong("entityUid", entityUid).putInt("tableId", tableId).putString("localUri", pictureUri).build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"build(...)");
        Data inputData = data;
        boolean $i$f$OneTimeWorkRequestBuilder = false;
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(SavePictureWorker.class).setInputData(inputData)).build();
        WorkManager.getInstance((Context)this.appContext).enqueueUniqueWork(workName, ExistingWorkPolicy.REPLACE, workRequest);
        return Unit.INSTANCE;
    }
}

