/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.passkey;

import com.ustadmobile.core.account.LearningSpace;
import com.ustadmobile.core.domain.credentials.passkey.EncodeUserHandleUseCase;
import io.ktor.util.Base64Kt;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/core/domain/passkey/EncodeUserHandleUseCaseImpl;", "Lcom/ustadmobile/core/domain/credentials/passkey/EncodeUserHandleUseCase;", "learningSpace", "Lcom/ustadmobile/core/account/LearningSpace;", "(Lcom/ustadmobile/core/account/LearningSpace;)V", "getLearningSpace", "()Lcom/ustadmobile/core/account/LearningSpace;", "invoke", "", "personPasskeyUid", "", "core_release"})
@SourceDebugExtension(value={"SMAP\nEncodeUserHandleUseCaseImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncodeUserHandleUseCaseImpl.kt\ncom/ustadmobile/core/domain/passkey/EncodeUserHandleUseCaseImpl\n+ 2 Strings.kt\nio/ktor/utils/io/core/StringsKt\n*L\n1#1,30:1\n7#2,4:31\n*S KotlinDebug\n*F\n+ 1 EncodeUserHandleUseCaseImpl.kt\ncom/ustadmobile/core/domain/passkey/EncodeUserHandleUseCaseImpl\n*L\n18#1:31,4\n*E\n"})
public final class EncodeUserHandleUseCaseImpl
implements EncodeUserHandleUseCase {
    @NotNull
    private final LearningSpace learningSpace;

    public EncodeUserHandleUseCaseImpl(@NotNull LearningSpace learningSpace) {
        Intrinsics.checkNotNullParameter((Object)learningSpace, (String)"learningSpace");
        this.learningSpace = learningSpace;
    }

    @NotNull
    public final LearningSpace getLearningSpace() {
        return this.learningSpace;
    }

    @Override
    @NotNull
    public String invoke(long personPasskeyUid) {
        byte[] stringBytes;
        String stringToEncode;
        String $this$toByteArray_u24default$iv = stringToEncode = this.learningSpace.getUrl();
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
            v0 = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
        } else {
            CharsetEncoder charsetEncoder = charset$iv.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            v0 = stringBytes = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv, (int)0, (int)$this$toByteArray_u24default$iv.length());
        }
        if (stringBytes.length > 55) {
            throw new IllegalArgumentException("Learning space URL is too long");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 + stringBytes.length);
        byteBuffer.putLong(personPasskeyUid);
        byteBuffer.put(stringBytes);
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return Base64Kt.encodeBase64((byte[])byArray);
    }
}

