/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ContentCategoryDao;
import com.ustadmobile.lib.db.entities.ContentCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

public final class ContentCategoryDao_Impl
extends ContentCategoryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContentCategory> __insertionAdapterOfContentCategory;
    private final EntityDeletionOrUpdateAdapter<ContentCategory> __updateAdapterOfContentCategory;

    public ContentCategoryDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContentCategory = new EntityInsertionAdapter<ContentCategory>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ContentCategory` (`contentCategoryUid`,`ctnCatContentCategorySchemaUid`,`name`,`contentCategoryLocalChangeSeqNum`,`contentCategoryMasterChangeSeqNum`,`contentCategoryLastChangedBy`,`contentCategoryLct`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentCategory entity) {
                statement.bindLong(1, entity.getContentCategoryUid());
                statement.bindLong(2, entity.getCtnCatContentCategorySchemaUid());
                if (entity.getName() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getName());
                }
                statement.bindLong(4, entity.getContentCategoryLocalChangeSeqNum());
                statement.bindLong(5, entity.getContentCategoryMasterChangeSeqNum());
                statement.bindLong(6, (long)entity.getContentCategoryLastChangedBy());
                statement.bindLong(7, entity.getContentCategoryLct());
            }
        };
        this.__updateAdapterOfContentCategory = new EntityDeletionOrUpdateAdapter<ContentCategory>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ContentCategory` SET `contentCategoryUid` = ?,`ctnCatContentCategorySchemaUid` = ?,`name` = ?,`contentCategoryLocalChangeSeqNum` = ?,`contentCategoryMasterChangeSeqNum` = ?,`contentCategoryLastChangedBy` = ?,`contentCategoryLct` = ? WHERE `contentCategoryUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentCategory entity) {
                statement.bindLong(1, entity.getContentCategoryUid());
                statement.bindLong(2, entity.getCtnCatContentCategorySchemaUid());
                if (entity.getName() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getName());
                }
                statement.bindLong(4, entity.getContentCategoryLocalChangeSeqNum());
                statement.bindLong(5, entity.getContentCategoryMasterChangeSeqNum());
                statement.bindLong(6, (long)entity.getContentCategoryLastChangedBy());
                statement.bindLong(7, entity.getContentCategoryLct());
                statement.bindLong(8, entity.getContentCategoryUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ContentCategory entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfContentCategory.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ContentCategory entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ContentCategoryDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ContentCategoryDao_Impl.this.__insertionAdapterOfContentCategory.insertAndReturnId((Object)entity);
                    ContentCategoryDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ContentCategoryDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ContentCategory> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContentCategory.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ContentCategory entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfContentCategory.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContentCategory> publicContentCategories() {
        String _sql = "SELECT ContentCategory.* FROM ContentCategory";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ContentCategory.* FROM ContentCategory", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfContentCategoryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryUid");
            int _cursorIndexOfCtnCatContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctnCatContentCategorySchemaUid");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfContentCategoryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryLocalChangeSeqNum");
            int _cursorIndexOfContentCategoryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryMasterChangeSeqNum");
            int _cursorIndexOfContentCategoryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryLastChangedBy");
            int _cursorIndexOfContentCategoryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryLct");
            ArrayList<ContentCategory> _result2 = new ArrayList<ContentCategory>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ContentCategory _item = new ContentCategory();
                long _tmpContentCategoryUid = _cursor.getLong(_cursorIndexOfContentCategoryUid);
                _item.setContentCategoryUid(_tmpContentCategoryUid);
                long _tmpCtnCatContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfCtnCatContentCategorySchemaUid);
                _item.setCtnCatContentCategorySchemaUid(_tmpCtnCatContentCategorySchemaUid);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _item.setName(_tmpName);
                long _tmpContentCategoryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryLocalChangeSeqNum);
                _item.setContentCategoryLocalChangeSeqNum(_tmpContentCategoryLocalChangeSeqNum);
                long _tmpContentCategoryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryMasterChangeSeqNum);
                _item.setContentCategoryMasterChangeSeqNum(_tmpContentCategoryMasterChangeSeqNum);
                int _tmpContentCategoryLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategoryLastChangedBy);
                _item.setContentCategoryLastChangedBy(_tmpContentCategoryLastChangedBy);
                long _tmpContentCategoryLct = _cursor.getLong(_cursorIndexOfContentCategoryLct);
                _item.setContentCategoryLct(_tmpContentCategoryLct);
                _result2.add(_item);
            }
            ArrayList<ContentCategory> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentCategory findCategoryBySchemaIdAndName(long schemaId, String name) {
        String _sql = "SELECT * FROM ContentCategory WHERE ctnCatContentCategorySchemaUid = ? AND name = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentCategory WHERE ctnCatContentCategorySchemaUid = ? AND name = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, schemaId);
        _argIndex = 2;
        _statement.bindString(_argIndex, name);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ContentCategory _result2;
            int _cursorIndexOfContentCategoryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryUid");
            int _cursorIndexOfCtnCatContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ctnCatContentCategorySchemaUid");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfContentCategoryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryLocalChangeSeqNum");
            int _cursorIndexOfContentCategoryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryMasterChangeSeqNum");
            int _cursorIndexOfContentCategoryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryLastChangedBy");
            int _cursorIndexOfContentCategoryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentCategoryLct");
            if (_cursor.moveToFirst()) {
                _result2 = new ContentCategory();
                long _tmpContentCategoryUid = _cursor.getLong(_cursorIndexOfContentCategoryUid);
                _result2.setContentCategoryUid(_tmpContentCategoryUid);
                long _tmpCtnCatContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfCtnCatContentCategorySchemaUid);
                _result2.setCtnCatContentCategorySchemaUid(_tmpCtnCatContentCategorySchemaUid);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _result2.setName(_tmpName);
                long _tmpContentCategoryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryLocalChangeSeqNum);
                _result2.setContentCategoryLocalChangeSeqNum(_tmpContentCategoryLocalChangeSeqNum);
                long _tmpContentCategoryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryMasterChangeSeqNum);
                _result2.setContentCategoryMasterChangeSeqNum(_tmpContentCategoryMasterChangeSeqNum);
                int _tmpContentCategoryLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategoryLastChangedBy);
                _result2.setContentCategoryLastChangedBy(_tmpContentCategoryLastChangedBy);
                long _tmpContentCategoryLct = _cursor.getLong(_cursorIndexOfContentCategoryLct);
                _result2.setContentCategoryLct(_tmpContentCategoryLct);
            } else {
                _result2 = null;
            }
            ContentCategory contentCategory = _result2;
            return contentCategory;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

