/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.lib.db.composites.BlockStatus;
import com.ustadmobile.lib.db.composites.ContentEntryAndDetail;
import com.ustadmobile.lib.db.composites.ContentEntryAndLanguage;
import com.ustadmobile.lib.db.composites.ContentEntryAndListDetail;
import com.ustadmobile.lib.db.composites.ContentEntryAndPicture;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin;
import com.ustadmobile.lib.db.entities.ContentEntryPicture2;
import com.ustadmobile.lib.db.entities.ContentEntryVersion;
import com.ustadmobile.lib.db.entities.ContentEntryWithLanguage;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ContentEntryDao_Impl
extends ContentEntryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContentEntry> __insertionAdapterOfContentEntry;
    private final EntityInsertionAdapter<ContentEntry> __insertionAdapterOfContentEntry_1;
    private final EntityDeletionOrUpdateAdapter<ContentEntry> __updateAdapterOfContentEntry;
    private final SharedSQLiteStatement __preparedStmtOfUpdateContentEntryInActive;
    private final SharedSQLiteStatement __preparedStmtOfUpdateContentEntryContentFlag;

    public ContentEntryDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContentEntry = new EntityInsertionAdapter<ContentEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ContentEntry` (`contentEntryUid`,`title`,`description`,`entryId`,`author`,`publisher`,`licenseType`,`licenseName`,`licenseUrl`,`sourceUrl`,`thumbnailUrl`,`lastModified`,`primaryLanguageUid`,`languageVariantUid`,`contentFlags`,`leaf`,`publik`,`ceInactive`,`completionCriteria`,`minScore`,`contentTypeFlag`,`contentOwner`,`contentOwnerType`,`contentEntryLocalChangeSeqNum`,`contentEntryMasterChangeSeqNum`,`contentEntryLastChangedBy`,`contentEntryLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntry entity) {
                statement.bindLong(1, entity.getContentEntryUid());
                if (entity.getTitle() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getTitle());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getDescription());
                }
                if (entity.getEntryId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getEntryId());
                }
                if (entity.getAuthor() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getAuthor());
                }
                if (entity.getPublisher() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getPublisher());
                }
                statement.bindLong(7, (long)entity.getLicenseType());
                if (entity.getLicenseName() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getLicenseName());
                }
                if (entity.getLicenseUrl() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getLicenseUrl());
                }
                if (entity.getSourceUrl() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getSourceUrl());
                }
                if (entity.getThumbnailUrl() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getThumbnailUrl());
                }
                statement.bindLong(12, entity.getLastModified());
                statement.bindLong(13, entity.getPrimaryLanguageUid());
                statement.bindLong(14, entity.getLanguageVariantUid());
                statement.bindLong(15, (long)entity.getContentFlags());
                int _tmp = entity.getLeaf() ? 1 : 0;
                statement.bindLong(16, (long)_tmp);
                int _tmp_1 = entity.getPublik() ? 1 : 0;
                statement.bindLong(17, (long)_tmp_1);
                int _tmp_2 = entity.getCeInactive() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_2);
                statement.bindLong(19, (long)entity.getCompletionCriteria());
                statement.bindLong(20, (long)entity.getMinScore());
                statement.bindLong(21, (long)entity.getContentTypeFlag());
                statement.bindLong(22, entity.getContentOwner());
                statement.bindLong(23, (long)entity.getContentOwnerType());
                statement.bindLong(24, entity.getContentEntryLocalChangeSeqNum());
                statement.bindLong(25, entity.getContentEntryMasterChangeSeqNum());
                statement.bindLong(26, (long)entity.getContentEntryLastChangedBy());
                statement.bindLong(27, entity.getContentEntryLct());
            }
        };
        this.__insertionAdapterOfContentEntry_1 = new EntityInsertionAdapter<ContentEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ContentEntry` (`contentEntryUid`,`title`,`description`,`entryId`,`author`,`publisher`,`licenseType`,`licenseName`,`licenseUrl`,`sourceUrl`,`thumbnailUrl`,`lastModified`,`primaryLanguageUid`,`languageVariantUid`,`contentFlags`,`leaf`,`publik`,`ceInactive`,`completionCriteria`,`minScore`,`contentTypeFlag`,`contentOwner`,`contentOwnerType`,`contentEntryLocalChangeSeqNum`,`contentEntryMasterChangeSeqNum`,`contentEntryLastChangedBy`,`contentEntryLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntry entity) {
                statement.bindLong(1, entity.getContentEntryUid());
                if (entity.getTitle() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getTitle());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getDescription());
                }
                if (entity.getEntryId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getEntryId());
                }
                if (entity.getAuthor() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getAuthor());
                }
                if (entity.getPublisher() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getPublisher());
                }
                statement.bindLong(7, (long)entity.getLicenseType());
                if (entity.getLicenseName() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getLicenseName());
                }
                if (entity.getLicenseUrl() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getLicenseUrl());
                }
                if (entity.getSourceUrl() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getSourceUrl());
                }
                if (entity.getThumbnailUrl() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getThumbnailUrl());
                }
                statement.bindLong(12, entity.getLastModified());
                statement.bindLong(13, entity.getPrimaryLanguageUid());
                statement.bindLong(14, entity.getLanguageVariantUid());
                statement.bindLong(15, (long)entity.getContentFlags());
                int _tmp = entity.getLeaf() ? 1 : 0;
                statement.bindLong(16, (long)_tmp);
                int _tmp_1 = entity.getPublik() ? 1 : 0;
                statement.bindLong(17, (long)_tmp_1);
                int _tmp_2 = entity.getCeInactive() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_2);
                statement.bindLong(19, (long)entity.getCompletionCriteria());
                statement.bindLong(20, (long)entity.getMinScore());
                statement.bindLong(21, (long)entity.getContentTypeFlag());
                statement.bindLong(22, entity.getContentOwner());
                statement.bindLong(23, (long)entity.getContentOwnerType());
                statement.bindLong(24, entity.getContentEntryLocalChangeSeqNum());
                statement.bindLong(25, entity.getContentEntryMasterChangeSeqNum());
                statement.bindLong(26, (long)entity.getContentEntryLastChangedBy());
                statement.bindLong(27, entity.getContentEntryLct());
            }
        };
        this.__updateAdapterOfContentEntry = new EntityDeletionOrUpdateAdapter<ContentEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ContentEntry` SET `contentEntryUid` = ?,`title` = ?,`description` = ?,`entryId` = ?,`author` = ?,`publisher` = ?,`licenseType` = ?,`licenseName` = ?,`licenseUrl` = ?,`sourceUrl` = ?,`thumbnailUrl` = ?,`lastModified` = ?,`primaryLanguageUid` = ?,`languageVariantUid` = ?,`contentFlags` = ?,`leaf` = ?,`publik` = ?,`ceInactive` = ?,`completionCriteria` = ?,`minScore` = ?,`contentTypeFlag` = ?,`contentOwner` = ?,`contentOwnerType` = ?,`contentEntryLocalChangeSeqNum` = ?,`contentEntryMasterChangeSeqNum` = ?,`contentEntryLastChangedBy` = ?,`contentEntryLct` = ? WHERE `contentEntryUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntry entity) {
                statement.bindLong(1, entity.getContentEntryUid());
                if (entity.getTitle() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getTitle());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getDescription());
                }
                if (entity.getEntryId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getEntryId());
                }
                if (entity.getAuthor() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getAuthor());
                }
                if (entity.getPublisher() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getPublisher());
                }
                statement.bindLong(7, (long)entity.getLicenseType());
                if (entity.getLicenseName() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindString(8, entity.getLicenseName());
                }
                if (entity.getLicenseUrl() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getLicenseUrl());
                }
                if (entity.getSourceUrl() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getSourceUrl());
                }
                if (entity.getThumbnailUrl() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindString(11, entity.getThumbnailUrl());
                }
                statement.bindLong(12, entity.getLastModified());
                statement.bindLong(13, entity.getPrimaryLanguageUid());
                statement.bindLong(14, entity.getLanguageVariantUid());
                statement.bindLong(15, (long)entity.getContentFlags());
                int _tmp = entity.getLeaf() ? 1 : 0;
                statement.bindLong(16, (long)_tmp);
                int _tmp_1 = entity.getPublik() ? 1 : 0;
                statement.bindLong(17, (long)_tmp_1);
                int _tmp_2 = entity.getCeInactive() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_2);
                statement.bindLong(19, (long)entity.getCompletionCriteria());
                statement.bindLong(20, (long)entity.getMinScore());
                statement.bindLong(21, (long)entity.getContentTypeFlag());
                statement.bindLong(22, entity.getContentOwner());
                statement.bindLong(23, (long)entity.getContentOwnerType());
                statement.bindLong(24, entity.getContentEntryLocalChangeSeqNum());
                statement.bindLong(25, entity.getContentEntryMasterChangeSeqNum());
                statement.bindLong(26, (long)entity.getContentEntryLastChangedBy());
                statement.bindLong(27, entity.getContentEntryLct());
                statement.bindLong(28, entity.getContentEntryUid());
            }
        };
        this.__preparedStmtOfUpdateContentEntryInActive = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n            UPDATE ContentEntry \n               SET ceInactive = ?,\n                   contentEntryLct = ?        \n            WHERE ContentEntry.contentEntryUid = ?";
                return "\n            UPDATE ContentEntry \n               SET ceInactive = ?,\n                   contentEntryLct = ?        \n            WHERE ContentEntry.contentEntryUid = ?";
            }
        };
        this.__preparedStmtOfUpdateContentEntryContentFlag = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ContentEntry \n           SET contentTypeFlag = ?,\n               contentEntryLct = ? \n         WHERE ContentEntry.contentEntryUid = ?";
                return "\n        UPDATE ContentEntry \n           SET contentTypeFlag = ?,\n               contentEntryLct = ? \n         WHERE ContentEntry.contentEntryUid = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ContentEntry entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfContentEntry.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final ContentEntry entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ContentEntryDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ContentEntryDao_Impl.this.__insertionAdapterOfContentEntry.insertAndReturnId((Object)entity);
                    ContentEntryDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ContentEntryDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends ContentEntry> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContentEntry.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<? extends ContentEntry> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ContentEntryDao_Impl.this.__db.beginTransaction();
                try {
                    ContentEntryDao_Impl.this.__insertionAdapterOfContentEntry.insert((Iterable)entityList);
                    ContentEntryDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContentEntryDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertAsync(final ContentEntry entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ContentEntryDao_Impl.this.__db.beginTransaction();
                try {
                    ContentEntryDao_Impl.this.__insertionAdapterOfContentEntry_1.insert((Object)entity);
                    ContentEntryDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContentEntryDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(ContentEntry entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfContentEntry.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final ContentEntry entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                ContentEntryDao_Impl.this.__db.beginTransaction();
                try {
                    ContentEntryDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += ContentEntryDao_Impl.this.__updateAdapterOfContentEntry.handle((Object)entity);
                    return n;
                }
                finally {
                    ContentEntryDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateContentEntryInActive(long contentEntryUid, boolean ceInactive, long changedTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateContentEntryInActive.acquire();
        int _argIndex = 1;
        int _tmp = ceInactive ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changedTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, contentEntryUid);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateContentEntryInActive.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateContentEntryContentFlag(int contentFlag, long contentEntryUid, long changedTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateContentEntryContentFlag.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)contentFlag);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changedTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, contentEntryUid);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateContentEntryContentFlag.release(_stmt);
        }
    }

    @Override
    public Object findByUidAsync(long entryUid, Continuation<? super ContentEntry> $completion) {
        String _sql = "SELECT * FROM ContentEntry WHERE contentEntryUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntry WHERE contentEntryUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, entryUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntry call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntry _result2;
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ContentEntry();
                        long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                        _result2.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result2.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result2.setDescription(_tmpDescription);
                        String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                        _result2.setEntryId(_tmpEntryId);
                        String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                        _result2.setAuthor(_tmpAuthor);
                        String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                        _result2.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                        _result2.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                        _result2.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                        _result2.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                        _result2.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                        _result2.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                        _result2.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _result2.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _result2.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                        _result2.setContentFlags(_tmpContentFlags);
                        int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _result2.setLeaf(_tmpLeaf);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _result2.setPublik(_tmpPublik);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _result2.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _result2.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                        _result2.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _result2.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                        _result2.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                        _result2.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _result2.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _result2.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _result2.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                        _result2.setContentEntryLct(_tmpContentEntryLct);
                    } else {
                        _result2 = null;
                    }
                    ContentEntry contentEntry = _result2;
                    return contentEntry;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findEntryWithLanguageByEntryIdAsync(long entryUuid, Continuation<? super ContentEntryAndLanguage> $completion) {
        String _sql = "\n        SELECT ContentEntry.*, Language.* \n          FROM ContentEntry \n               LEFT JOIN Language \n                         ON Language.langUid = ContentEntry.primaryLanguageUid\n         WHERE ContentEntry.contentEntryUid=?\n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntry.*, Language.* \n          FROM ContentEntry \n               LEFT JOIN Language \n                         ON Language.langUid = ContentEntry.primaryLanguageUid\n         WHERE ContentEntry.contentEntryUid=?\n        ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, entryUuid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntryAndLanguage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryAndLanguage call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntryAndLanguage _result2;
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
                    int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
                    int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
                    int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
                    int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
                    int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
                    int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
                    int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
                    int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
                    if (_cursor.moveToFirst()) {
                        Language _tmpLanguage;
                        ContentEntry _tmpContentEntry;
                        if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
                            _tmpContentEntry = new ContentEntry();
                            long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                            _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
                            String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                            _tmpContentEntry.setTitle(_tmpTitle);
                            String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                            _tmpContentEntry.setDescription(_tmpDescription);
                            String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                            _tmpContentEntry.setEntryId(_tmpEntryId);
                            String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                            _tmpContentEntry.setAuthor(_tmpAuthor);
                            String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                            _tmpContentEntry.setPublisher(_tmpPublisher);
                            int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                            _tmpContentEntry.setLicenseType(_tmpLicenseType);
                            String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                            _tmpContentEntry.setLicenseName(_tmpLicenseName);
                            String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                            _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
                            String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                            _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
                            String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                            _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
                            long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                            _tmpContentEntry.setLastModified(_tmpLastModified);
                            long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                            _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                            long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                            _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                            int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                            _tmpContentEntry.setContentFlags(_tmpContentFlags);
                            int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                            boolean _tmpLeaf = _tmp != 0;
                            _tmpContentEntry.setLeaf(_tmpLeaf);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                            boolean _tmpPublik = _tmp_1 != 0;
                            _tmpContentEntry.setPublik(_tmpPublik);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                            boolean _tmpCeInactive = _tmp_2 != 0;
                            _tmpContentEntry.setCeInactive(_tmpCeInactive);
                            int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                            _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
                            int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                            _tmpContentEntry.setMinScore(_tmpMinScore);
                            int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                            _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
                            long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                            _tmpContentEntry.setContentOwner(_tmpContentOwner);
                            int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                            _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
                            long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                            _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                            long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                            _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                            int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                            _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                            long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                            _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
                        } else {
                            _tmpContentEntry = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
                            _tmpLanguage = new Language();
                            long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                            _tmpLanguage.setLangUid(_tmpLangUid);
                            String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                            _tmpLanguage.setName(_tmpName);
                            String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                            _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
                            String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                            _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
                            String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                            _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
                            String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                            _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfLanguageActive);
                            boolean _tmpLanguageActive = _tmp_3 != 0;
                            _tmpLanguage.setLanguageActive(_tmpLanguageActive);
                            long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                            _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                            long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                            _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                            int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                            _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
                            long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                            _tmpLanguage.setLangLct(_tmpLangLct);
                        } else {
                            _tmpLanguage = null;
                        }
                        _result2 = new ContentEntryAndLanguage(_tmpContentEntry, _tmpLanguage);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryAndLanguage contentEntryAndLanguage = _result2;
                    return contentEntryAndLanguage;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidWithEditDetails(long uid, Continuation<? super ContentEntryAndPicture> $completion) {
        String _sql = "\n        SELECT ContentEntry.*, ContentEntryPicture2.*\n          FROM ContentEntry\n               LEFT JOIN ContentEntryPicture2 \n                         ON ContentEntryPicture2.cepUid = ?\n         WHERE ContentEntry.contentEntryUid = ?                \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntry.*, ContentEntryPicture2.*\n          FROM ContentEntry\n               LEFT JOIN ContentEntryPicture2 \n                         ON ContentEntryPicture2.cepUid = ?\n         WHERE ContentEntry.contentEntryUid = ?                \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntryAndPicture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryAndPicture call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntryAndPicture _result2;
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepUid");
                    int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepLct");
                    int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepPictureUri");
                    int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepThumbnailUri");
                    if (_cursor.moveToFirst()) {
                        ContentEntryPicture2 _tmpPicture;
                        ContentEntry _tmpEntry;
                        if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
                            _tmpEntry = new ContentEntry();
                            long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                            _tmpEntry.setContentEntryUid(_tmpContentEntryUid);
                            String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                            _tmpEntry.setTitle(_tmpTitle);
                            String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                            _tmpEntry.setDescription(_tmpDescription);
                            String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                            _tmpEntry.setEntryId(_tmpEntryId);
                            String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                            _tmpEntry.setAuthor(_tmpAuthor);
                            String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                            _tmpEntry.setPublisher(_tmpPublisher);
                            int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                            _tmpEntry.setLicenseType(_tmpLicenseType);
                            String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                            _tmpEntry.setLicenseName(_tmpLicenseName);
                            String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                            _tmpEntry.setLicenseUrl(_tmpLicenseUrl);
                            String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                            _tmpEntry.setSourceUrl(_tmpSourceUrl);
                            String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                            _tmpEntry.setThumbnailUrl(_tmpThumbnailUrl);
                            long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                            _tmpEntry.setLastModified(_tmpLastModified);
                            long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                            _tmpEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                            long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                            _tmpEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                            int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                            _tmpEntry.setContentFlags(_tmpContentFlags);
                            int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                            boolean _tmpLeaf = _tmp != 0;
                            _tmpEntry.setLeaf(_tmpLeaf);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                            boolean _tmpPublik = _tmp_1 != 0;
                            _tmpEntry.setPublik(_tmpPublik);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                            boolean _tmpCeInactive = _tmp_2 != 0;
                            _tmpEntry.setCeInactive(_tmpCeInactive);
                            int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                            _tmpEntry.setCompletionCriteria(_tmpCompletionCriteria);
                            int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                            _tmpEntry.setMinScore(_tmpMinScore);
                            int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                            _tmpEntry.setContentTypeFlag(_tmpContentTypeFlag);
                            long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                            _tmpEntry.setContentOwner(_tmpContentOwner);
                            int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                            _tmpEntry.setContentOwnerType(_tmpContentOwnerType);
                            long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                            _tmpEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                            long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                            _tmpEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                            int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                            _tmpEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                            long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                            _tmpEntry.setContentEntryLct(_tmpContentEntryLct);
                        } else {
                            _tmpEntry = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCepUid) && _cursor.isNull(_cursorIndexOfCepLct) && _cursor.isNull(_cursorIndexOfCepPictureUri) && _cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
                            long _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
                            long _tmpCepLct = _cursor.getLong(_cursorIndexOfCepLct);
                            String _tmpCepPictureUri = _cursor.isNull(_cursorIndexOfCepPictureUri) ? null : _cursor.getString(_cursorIndexOfCepPictureUri);
                            String _tmpCepThumbnailUri = _cursor.isNull(_cursorIndexOfCepThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCepThumbnailUri);
                            _tmpPicture = new ContentEntryPicture2(_tmpCepUid, _tmpCepLct, _tmpCepPictureUri, _tmpCepThumbnailUri);
                        } else {
                            _tmpPicture = null;
                        }
                        _result2 = new ContentEntryAndPicture(_tmpEntry, _tmpPicture);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryAndPicture contentEntryAndPicture = _result2;
                    return contentEntryAndPicture;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<ContentEntryAndDetail> findByContentEntryUidWithDetailsAsFlow(long contentEntryUid, long clazzUid, long courseBlockUid, long accountPersonUid) {
        String _sql = "\n              -- When the user is viewing ContentEntryDetail where the class is specified eg \n              -- for a ContentEntry that is part of a Clazz then results information will only be\n              -- included if the user is a student in the class\n              -- If the user is viewing the ContentEntryDetail via the library then the results\n              -- information will always be included\n              WITH IncludeResults(includeResults) AS (\n                   SELECT CAST(\n                      (SELECT (? = 0)\n                           OR (\n        (SELECT EXISTS(\n                SELECT 1\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                   AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                   AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n    )\n                      ) AS INTEGER)\n                  )\n\n              SELECT ContentEntry.*, ContentEntryVersion.*, ContentEntryPicture2.*,\n                   ? AS sPersonUid,\n                   ? AS sCbUid,\n                   \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = ?\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = ?\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n              FROM ContentEntry\n                   LEFT JOIN ContentEntryVersion\n                             ON ContentEntryVersion.cevUid = \n                             (SELECT ContentEntryVersion.cevUid\n                                FROM ContentEntryVersion\n                               WHERE ContentEntryVersion.cevContentEntryUid = ?\n                                 AND CAST(cevInActive AS INTEGER) = 0\n                            ORDER BY ContentEntryVersion.cevLct DESC\n                              LIMIT 1)\n                   LEFT JOIN ContentEntryPicture2\n                             ON ContentEntryPicture2.cepUid = ?   \n             WHERE ContentEntry.contentEntryUid = ?\n            ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n              -- When the user is viewing ContentEntryDetail where the class is specified eg \n              -- for a ContentEntry that is part of a Clazz then results information will only be\n              -- included if the user is a student in the class\n              -- If the user is viewing the ContentEntryDetail via the library then the results\n              -- information will always be included\n              WITH IncludeResults(includeResults) AS (\n                   SELECT CAST(\n                      (SELECT (? = 0)\n                           OR (\n        (SELECT EXISTS(\n                SELECT 1\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n                   AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n                   AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n    )\n                      ) AS INTEGER)\n                  )\n\n              SELECT ContentEntry.*, ContentEntryVersion.*, ContentEntryPicture2.*,\n                   ? AS sPersonUid,\n                   ? AS sCbUid,\n                   \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = ?\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = ?\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n              FROM ContentEntry\n                   LEFT JOIN ContentEntryVersion\n                             ON ContentEntryVersion.cevUid = \n                             (SELECT ContentEntryVersion.cevUid\n                                FROM ContentEntryVersion\n                               WHERE ContentEntryVersion.cevContentEntryUid = ?\n                                 AND CAST(cevInActive AS INTEGER) = 0\n                            ORDER BY ContentEntryVersion.cevLct DESC\n                              LIMIT 1)\n                   LEFT JOIN ContentEntryPicture2\n                             ON ContentEntryPicture2.cepUid = ?   \n             WHERE ContentEntry.contentEntryUid = ?\n            ", (int)13);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, courseBlockUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, contentEntryUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzEnrolment", "StatementEntity", "ContentEntry", "ContentEntryVersion", "ContentEntryPicture2"}, (Callable)new Callable<ContentEntryAndDetail>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryAndDetail call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ContentEntryAndDetail _result2;
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    int _cursorIndexOfCevUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevUid");
                    int _cursorIndexOfCevContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentEntryUid");
                    int _cursorIndexOfCevOpenUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOpenUri");
                    int _cursorIndexOfCevContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevContentType");
                    int _cursorIndexOfCevManifestUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevManifestUrl");
                    int _cursorIndexOfCevSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevSize");
                    int _cursorIndexOfCevInActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevInActive");
                    int _cursorIndexOfCevLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLastModified");
                    int _cursorIndexOfCevLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevLct");
                    int _cursorIndexOfCevStorageSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevStorageSize");
                    int _cursorIndexOfCevOriginalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cevOriginalSize");
                    int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepUid");
                    int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepLct");
                    int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepPictureUri");
                    int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepThumbnailUri");
                    int _cursorIndexOfSPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sPersonUid");
                    int _cursorIndexOfSCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sCbUid");
                    int _cursorIndexOfSProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sProgress");
                    int _cursorIndexOfSIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sIsSuccess");
                    int _cursorIndexOfSIsCompleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sIsCompleted");
                    int _cursorIndexOfSScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sScoreScaled");
                    if (_cursor.moveToFirst()) {
                        BlockStatus _tmpStatus;
                        ContentEntryPicture2 _tmpPicture;
                        ContentEntryVersion _tmpLatestVersion;
                        ContentEntry _tmpEntry;
                        if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
                            _tmpEntry = new ContentEntry();
                            long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                            _tmpEntry.setContentEntryUid(_tmpContentEntryUid);
                            String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                            _tmpEntry.setTitle(_tmpTitle);
                            String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                            _tmpEntry.setDescription(_tmpDescription);
                            String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                            _tmpEntry.setEntryId(_tmpEntryId);
                            String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                            _tmpEntry.setAuthor(_tmpAuthor);
                            String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                            _tmpEntry.setPublisher(_tmpPublisher);
                            int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                            _tmpEntry.setLicenseType(_tmpLicenseType);
                            String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                            _tmpEntry.setLicenseName(_tmpLicenseName);
                            String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                            _tmpEntry.setLicenseUrl(_tmpLicenseUrl);
                            String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                            _tmpEntry.setSourceUrl(_tmpSourceUrl);
                            String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                            _tmpEntry.setThumbnailUrl(_tmpThumbnailUrl);
                            long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                            _tmpEntry.setLastModified(_tmpLastModified);
                            long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                            _tmpEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                            long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                            _tmpEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                            int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                            _tmpEntry.setContentFlags(_tmpContentFlags);
                            int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                            boolean _tmpLeaf = _tmp != 0;
                            _tmpEntry.setLeaf(_tmpLeaf);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                            boolean _tmpPublik = _tmp_1 != 0;
                            _tmpEntry.setPublik(_tmpPublik);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                            boolean _tmpCeInactive = _tmp_2 != 0;
                            _tmpEntry.setCeInactive(_tmpCeInactive);
                            int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                            _tmpEntry.setCompletionCriteria(_tmpCompletionCriteria);
                            int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                            _tmpEntry.setMinScore(_tmpMinScore);
                            int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                            _tmpEntry.setContentTypeFlag(_tmpContentTypeFlag);
                            long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                            _tmpEntry.setContentOwner(_tmpContentOwner);
                            int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                            _tmpEntry.setContentOwnerType(_tmpContentOwnerType);
                            long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                            _tmpEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                            long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                            _tmpEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                            int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                            _tmpEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                            long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                            _tmpEntry.setContentEntryLct(_tmpContentEntryLct);
                        } else {
                            _tmpEntry = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCevUid) && _cursor.isNull(_cursorIndexOfCevContentEntryUid) && _cursor.isNull(_cursorIndexOfCevOpenUri) && _cursor.isNull(_cursorIndexOfCevContentType) && _cursor.isNull(_cursorIndexOfCevManifestUrl) && _cursor.isNull(_cursorIndexOfCevSize) && _cursor.isNull(_cursorIndexOfCevInActive) && _cursor.isNull(_cursorIndexOfCevLastModified) && _cursor.isNull(_cursorIndexOfCevLct) && _cursor.isNull(_cursorIndexOfCevStorageSize) && _cursor.isNull(_cursorIndexOfCevOriginalSize))) {
                            long _tmpCevUid = _cursor.getLong(_cursorIndexOfCevUid);
                            long _tmpCevContentEntryUid = _cursor.getLong(_cursorIndexOfCevContentEntryUid);
                            String _tmpCevOpenUri = _cursor.isNull(_cursorIndexOfCevOpenUri) ? null : _cursor.getString(_cursorIndexOfCevOpenUri);
                            String _tmpCevContentType = _cursor.isNull(_cursorIndexOfCevContentType) ? null : _cursor.getString(_cursorIndexOfCevContentType);
                            String _tmpCevManifestUrl = _cursor.isNull(_cursorIndexOfCevManifestUrl) ? null : _cursor.getString(_cursorIndexOfCevManifestUrl);
                            long _tmpCevSize = _cursor.getLong(_cursorIndexOfCevSize);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfCevInActive);
                            boolean _tmpCevInActive = _tmp_3 != 0;
                            long _tmpCevLastModified = _cursor.getLong(_cursorIndexOfCevLastModified);
                            long _tmpCevLct = _cursor.getLong(_cursorIndexOfCevLct);
                            long _tmpCevStorageSize = _cursor.getLong(_cursorIndexOfCevStorageSize);
                            long _tmpCevOriginalSize = _cursor.getLong(_cursorIndexOfCevOriginalSize);
                            _tmpLatestVersion = new ContentEntryVersion(_tmpCevUid, _tmpCevContentEntryUid, _tmpCevOpenUri, _tmpCevContentType, _tmpCevManifestUrl, _tmpCevSize, _tmpCevInActive, _tmpCevLastModified, _tmpCevLct, _tmpCevStorageSize, _tmpCevOriginalSize);
                        } else {
                            _tmpLatestVersion = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCepUid) && _cursor.isNull(_cursorIndexOfCepLct) && _cursor.isNull(_cursorIndexOfCepPictureUri) && _cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
                            long _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
                            long _tmpCepLct = _cursor.getLong(_cursorIndexOfCepLct);
                            String _tmpCepPictureUri = _cursor.isNull(_cursorIndexOfCepPictureUri) ? null : _cursor.getString(_cursorIndexOfCepPictureUri);
                            String _tmpCepThumbnailUri = _cursor.isNull(_cursorIndexOfCepThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCepThumbnailUri);
                            _tmpPicture = new ContentEntryPicture2(_tmpCepUid, _tmpCepLct, _tmpCepPictureUri, _tmpCepThumbnailUri);
                        } else {
                            _tmpPicture = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfSPersonUid) && _cursor.isNull(_cursorIndexOfSCbUid) && _cursor.isNull(_cursorIndexOfSProgress) && _cursor.isNull(_cursorIndexOfSIsSuccess) && _cursor.isNull(_cursorIndexOfSIsCompleted) && _cursor.isNull(_cursorIndexOfSScoreScaled))) {
                            long _tmpSPersonUid = _cursor.getLong(_cursorIndexOfSPersonUid);
                            long _tmpSCbUid = _cursor.getLong(_cursorIndexOfSCbUid);
                            Integer _tmpSProgress = _cursor.isNull(_cursorIndexOfSProgress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSProgress));
                            Integer _tmp_4 = _cursor.isNull(_cursorIndexOfSIsSuccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSIsSuccess));
                            Boolean _tmpSIsSuccess = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                            int _tmp_5 = _cursor.getInt(_cursorIndexOfSIsCompleted);
                            boolean _tmpSIsCompleted = _tmp_5 != 0;
                            Float _tmpSScoreScaled = _cursor.isNull(_cursorIndexOfSScoreScaled) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfSScoreScaled));
                            _tmpStatus = new BlockStatus(_tmpSPersonUid, _tmpSCbUid, _tmpSProgress, _tmpSIsCompleted, _tmpSIsSuccess, _tmpSScoreScaled);
                        } else {
                            _tmpStatus = null;
                        }
                        _result2 = new ContentEntryAndDetail(_tmpEntry, _tmpLatestVersion, _tmpPicture, _tmpStatus);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryAndDetail contentEntryAndDetail = _result2;
                    return contentEntryAndDetail;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentEntry findBySourceUrl(String sourceUrl) {
        String _sql = "SELECT * FROM ContentEntry WHERE sourceUrl = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntry WHERE sourceUrl = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, sourceUrl);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ContentEntry _result2;
            int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
            int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
            int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
            int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
            int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
            int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
            int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
            int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
            int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
            int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
            int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
            int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
            int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
            int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
            int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
            int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
            int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
            int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
            int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
            int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
            int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
            int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
            int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
            int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
            if (_cursor.moveToFirst()) {
                _result2 = new ContentEntry();
                long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                _result2.setContentEntryUid(_tmpContentEntryUid);
                String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                _result2.setTitle(_tmpTitle);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                _result2.setDescription(_tmpDescription);
                String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                _result2.setEntryId(_tmpEntryId);
                String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                _result2.setAuthor(_tmpAuthor);
                String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                _result2.setPublisher(_tmpPublisher);
                int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                _result2.setLicenseType(_tmpLicenseType);
                String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                _result2.setLicenseName(_tmpLicenseName);
                String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                _result2.setLicenseUrl(_tmpLicenseUrl);
                String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                _result2.setSourceUrl(_tmpSourceUrl);
                String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                _result2.setThumbnailUrl(_tmpThumbnailUrl);
                long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                _result2.setLastModified(_tmpLastModified);
                long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                _result2.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                _result2.setLanguageVariantUid(_tmpLanguageVariantUid);
                int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                _result2.setContentFlags(_tmpContentFlags);
                int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                boolean _tmpLeaf = _tmp != 0;
                _result2.setLeaf(_tmpLeaf);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                boolean _tmpPublik = _tmp_1 != 0;
                _result2.setPublik(_tmpPublik);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                boolean _tmpCeInactive = _tmp_2 != 0;
                _result2.setCeInactive(_tmpCeInactive);
                int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                _result2.setCompletionCriteria(_tmpCompletionCriteria);
                int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                _result2.setMinScore(_tmpMinScore);
                int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                _result2.setContentTypeFlag(_tmpContentTypeFlag);
                long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                _result2.setContentOwner(_tmpContentOwner);
                int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                _result2.setContentOwnerType(_tmpContentOwnerType);
                long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                _result2.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                _result2.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                _result2.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                _result2.setContentEntryLct(_tmpContentEntryLct);
            } else {
                _result2 = null;
            }
            ContentEntry contentEntry = _result2;
            return contentEntry;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findTitleByUidAsync(long entryUid, Continuation<? super String> $completion) {
        String _sql = "SELECT title FROM ContentEntry WHERE contentEntryUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT title FROM ContentEntry WHERE contentEntryUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, entryUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    String _result2 = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result2;
                    return string;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, ContentEntry> getChildrenByParentUid(long parentUid) {
        String _sql = "SELECT ContentEntry.* FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ContentEntry.* FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, parentUid);
        return new LimitOffsetPagingSource<ContentEntry>(_statement, this.__db, new String[]{"ContentEntry", "ContentEntryParentChildJoin"}){

            @NonNull
            protected List<ContentEntry> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryUid");
                int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"title");
                int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"description");
                int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"entryId");
                int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"author");
                int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publisher");
                int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseType");
                int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseName");
                int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseUrl");
                int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sourceUrl");
                int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"thumbnailUrl");
                int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastModified");
                int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"primaryLanguageUid");
                int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"languageVariantUid");
                int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentFlags");
                int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"leaf");
                int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publik");
                int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ceInactive");
                int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"completionCriteria");
                int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"minScore");
                int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentTypeFlag");
                int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwner");
                int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwnerType");
                int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLocalChangeSeqNum");
                int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryMasterChangeSeqNum");
                int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLastChangedBy");
                int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLct");
                ArrayList<ContentEntry> _result2 = new ArrayList<ContentEntry>(cursor.getCount());
                while (cursor.moveToNext()) {
                    ContentEntry _item = new ContentEntry();
                    long _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
                    _item.setContentEntryUid(_tmpContentEntryUid);
                    String _tmpTitle = cursor.isNull(_cursorIndexOfTitle) ? null : cursor.getString(_cursorIndexOfTitle);
                    _item.setTitle(_tmpTitle);
                    String _tmpDescription = cursor.isNull(_cursorIndexOfDescription) ? null : cursor.getString(_cursorIndexOfDescription);
                    _item.setDescription(_tmpDescription);
                    String _tmpEntryId = cursor.isNull(_cursorIndexOfEntryId) ? null : cursor.getString(_cursorIndexOfEntryId);
                    _item.setEntryId(_tmpEntryId);
                    String _tmpAuthor = cursor.isNull(_cursorIndexOfAuthor) ? null : cursor.getString(_cursorIndexOfAuthor);
                    _item.setAuthor(_tmpAuthor);
                    String _tmpPublisher = cursor.isNull(_cursorIndexOfPublisher) ? null : cursor.getString(_cursorIndexOfPublisher);
                    _item.setPublisher(_tmpPublisher);
                    int _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
                    _item.setLicenseType(_tmpLicenseType);
                    String _tmpLicenseName = cursor.isNull(_cursorIndexOfLicenseName) ? null : cursor.getString(_cursorIndexOfLicenseName);
                    _item.setLicenseName(_tmpLicenseName);
                    String _tmpLicenseUrl = cursor.isNull(_cursorIndexOfLicenseUrl) ? null : cursor.getString(_cursorIndexOfLicenseUrl);
                    _item.setLicenseUrl(_tmpLicenseUrl);
                    String _tmpSourceUrl = cursor.isNull(_cursorIndexOfSourceUrl) ? null : cursor.getString(_cursorIndexOfSourceUrl);
                    _item.setSourceUrl(_tmpSourceUrl);
                    String _tmpThumbnailUrl = cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : cursor.getString(_cursorIndexOfThumbnailUrl);
                    _item.setThumbnailUrl(_tmpThumbnailUrl);
                    long _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
                    _item.setLastModified(_tmpLastModified);
                    long _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                    _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                    long _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
                    _item.setLanguageVariantUid(_tmpLanguageVariantUid);
                    int _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
                    _item.setContentFlags(_tmpContentFlags);
                    int _tmp = cursor.getInt(_cursorIndexOfLeaf);
                    boolean _tmpLeaf = _tmp != 0;
                    _item.setLeaf(_tmpLeaf);
                    int _tmp_1 = cursor.getInt(_cursorIndexOfPublik);
                    boolean _tmpPublik = _tmp_1 != 0;
                    _item.setPublik(_tmpPublik);
                    int _tmp_2 = cursor.getInt(_cursorIndexOfCeInactive);
                    boolean _tmpCeInactive = _tmp_2 != 0;
                    _item.setCeInactive(_tmpCeInactive);
                    int _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
                    _item.setCompletionCriteria(_tmpCompletionCriteria);
                    int _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
                    _item.setMinScore(_tmpMinScore);
                    int _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
                    _item.setContentTypeFlag(_tmpContentTypeFlag);
                    long _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
                    _item.setContentOwner(_tmpContentOwner);
                    int _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
                    _item.setContentOwnerType(_tmpContentOwnerType);
                    long _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                    _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                    long _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                    _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                    int _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                    _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                    long _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
                    _item.setContentEntryLct(_tmpContentEntryLct);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object getChildrenByParentAsync(long parentUid, Continuation<? super List<? extends ContentEntry>> $completion) {
        String _sql = "\n        SELECT ContentEntry.*\n          FROM ContentEntryParentChildJoin\n               JOIN ContentEntry \n                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid\n         WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntry.*\n          FROM ContentEntryParentChildJoin\n               JOIN ContentEntry \n                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid\n         WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, parentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ContentEntry>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ContentEntry> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    ArrayList<ContentEntry> _result2 = new ArrayList<ContentEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ContentEntry _item = new ContentEntry();
                        long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                        _item.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _item.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _item.setDescription(_tmpDescription);
                        String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                        _item.setEntryId(_tmpEntryId);
                        String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                        _item.setAuthor(_tmpAuthor);
                        String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                        _item.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                        _item.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                        _item.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                        _item.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                        _item.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                        _item.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                        _item.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _item.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                        _item.setContentFlags(_tmpContentFlags);
                        int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _item.setLeaf(_tmpLeaf);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _item.setPublik(_tmpPublik);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _item.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _item.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                        _item.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _item.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                        _item.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                        _item.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                        _item.setContentEntryLct(_tmpContentEntryLct);
                        _result2.add(_item);
                    }
                    ArrayList<ContentEntry> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getCountNumberOfChildrenByParentUUidAsync(long parentUid, Continuation<? super Integer> $completion) {
        String _sql = "SELECT COUNT(*) FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, parentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getContentByUuidAsync(long parentUid, Continuation<? super ContentEntry> $completion) {
        String _sql = "SELECT * FROM ContentEntry where contentEntryUid = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntry where contentEntryUid = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, parentUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntry call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntry _result2;
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ContentEntry();
                        long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                        _result2.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result2.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result2.setDescription(_tmpDescription);
                        String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                        _result2.setEntryId(_tmpEntryId);
                        String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                        _result2.setAuthor(_tmpAuthor);
                        String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                        _result2.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                        _result2.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                        _result2.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                        _result2.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                        _result2.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                        _result2.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                        _result2.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _result2.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _result2.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                        _result2.setContentFlags(_tmpContentFlags);
                        int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _result2.setLeaf(_tmpLeaf);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _result2.setPublik(_tmpPublik);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _result2.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _result2.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                        _result2.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _result2.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                        _result2.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                        _result2.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _result2.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _result2.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _result2.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                        _result2.setContentEntryLct(_tmpContentEntryLct);
                    } else {
                        _result2 = null;
                    }
                    ContentEntry contentEntry = _result2;
                    return contentEntry;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllLanguageRelatedEntriesAsync(long entryUuid, Continuation<? super List<? extends ContentEntry>> $completion) {
        String _sql = "SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryRelatedEntryJoin ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryRelatedEntryJoin.relType = 1 AND ContentEntryRelatedEntryJoin.cerejRelatedEntryUid != ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryRelatedEntryJoin ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryRelatedEntryJoin.relType = 1 AND ContentEntryRelatedEntryJoin.cerejRelatedEntryUid != ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, entryUuid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ContentEntry>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ContentEntry> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    ArrayList<ContentEntry> _result2 = new ArrayList<ContentEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ContentEntry _item = new ContentEntry();
                        long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                        _item.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _item.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _item.setDescription(_tmpDescription);
                        String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                        _item.setEntryId(_tmpEntryId);
                        String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                        _item.setAuthor(_tmpAuthor);
                        String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                        _item.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                        _item.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                        _item.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                        _item.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                        _item.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                        _item.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                        _item.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _item.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                        _item.setContentFlags(_tmpContentFlags);
                        int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _item.setLeaf(_tmpLeaf);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _item.setPublik(_tmpPublik);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _item.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _item.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                        _item.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _item.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                        _item.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                        _item.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                        _item.setContentEntryLct(_tmpContentEntryLct);
                        _result2.add(_item);
                    }
                    ArrayList<ContentEntry> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidWithLanguageAsync(long uid, Continuation<? super ContentEntryWithLanguage> $completion) {
        String _sql = "\n        SELECT ContentEntry.*, Language.*\n          FROM ContentEntry\n               LEFT JOIN Language \n                      ON Language.langUid = ContentEntry.primaryLanguageUid \n         WHERE ContentEntry.contentEntryUid = ?              \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntry.*, Language.*\n          FROM ContentEntry\n               LEFT JOIN Language \n                      ON Language.langUid = ContentEntry.primaryLanguageUid \n         WHERE ContentEntry.contentEntryUid = ?              \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntryWithLanguage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryWithLanguage call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntryWithLanguage _result2;
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
                    int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
                    int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
                    int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
                    int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
                    int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
                    int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
                    int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
                    int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
                    if (_cursor.moveToFirst()) {
                        Language _tmpLanguage;
                        if (!(_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
                            _tmpLanguage = new Language();
                            long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                            _tmpLanguage.setLangUid(_tmpLangUid);
                            String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                            _tmpLanguage.setName(_tmpName);
                            String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                            _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
                            String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                            _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
                            String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                            _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
                            String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                            _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
                            int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                            boolean _tmpLanguageActive = _tmp != 0;
                            _tmpLanguage.setLanguageActive(_tmpLanguageActive);
                            long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                            _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                            long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                            _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                            int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                            _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
                            long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                            _tmpLanguage.setLangLct(_tmpLangLct);
                        } else {
                            _tmpLanguage = null;
                        }
                        _result2 = new ContentEntryWithLanguage();
                        long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                        _result2.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result2.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result2.setDescription(_tmpDescription);
                        String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                        _result2.setEntryId(_tmpEntryId);
                        String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                        _result2.setAuthor(_tmpAuthor);
                        String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                        _result2.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                        _result2.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                        _result2.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                        _result2.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                        _result2.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                        _result2.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                        _result2.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _result2.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _result2.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                        _result2.setContentFlags(_tmpContentFlags);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp_1 != 0;
                        _result2.setLeaf(_tmpLeaf);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_2 != 0;
                        _result2.setPublik(_tmpPublik);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_3 != 0;
                        _result2.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _result2.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                        _result2.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _result2.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                        _result2.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                        _result2.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _result2.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _result2.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _result2.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                        _result2.setContentEntryLct(_tmpContentEntryLct);
                        _result2.setLanguage(_tmpLanguage);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryWithLanguage contentEntryWithLanguage = _result2;
                    return contentEntryWithLanguage;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentEntry findByUid(long entryUid) {
        String _sql = "SELECT * FROM ContentEntry WHERE contentEntryUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntry WHERE contentEntryUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, entryUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ContentEntry _result2;
            int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
            int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
            int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
            int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
            int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
            int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
            int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
            int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
            int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
            int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
            int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
            int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
            int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
            int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
            int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
            int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
            int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
            int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
            int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
            int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
            int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
            int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
            int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
            int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
            if (_cursor.moveToFirst()) {
                _result2 = new ContentEntry();
                long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                _result2.setContentEntryUid(_tmpContentEntryUid);
                String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                _result2.setTitle(_tmpTitle);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                _result2.setDescription(_tmpDescription);
                String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                _result2.setEntryId(_tmpEntryId);
                String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                _result2.setAuthor(_tmpAuthor);
                String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                _result2.setPublisher(_tmpPublisher);
                int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                _result2.setLicenseType(_tmpLicenseType);
                String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                _result2.setLicenseName(_tmpLicenseName);
                String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                _result2.setLicenseUrl(_tmpLicenseUrl);
                String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                _result2.setSourceUrl(_tmpSourceUrl);
                String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                _result2.setThumbnailUrl(_tmpThumbnailUrl);
                long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                _result2.setLastModified(_tmpLastModified);
                long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                _result2.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                _result2.setLanguageVariantUid(_tmpLanguageVariantUid);
                int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                _result2.setContentFlags(_tmpContentFlags);
                int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                boolean _tmpLeaf = _tmp != 0;
                _result2.setLeaf(_tmpLeaf);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                boolean _tmpPublik = _tmp_1 != 0;
                _result2.setPublik(_tmpPublik);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                boolean _tmpCeInactive = _tmp_2 != 0;
                _result2.setCeInactive(_tmpCeInactive);
                int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                _result2.setCompletionCriteria(_tmpCompletionCriteria);
                int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                _result2.setMinScore(_tmpMinScore);
                int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                _result2.setContentTypeFlag(_tmpContentTypeFlag);
                long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                _result2.setContentOwner(_tmpContentOwner);
                int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                _result2.setContentOwnerType(_tmpContentOwnerType);
                long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                _result2.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                _result2.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                _result2.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                _result2.setContentEntryLct(_tmpContentEntryLct);
            } else {
                _result2 = null;
            }
            ContentEntry contentEntry = _result2;
            return contentEntry;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<ContentEntry> findByTitle(String title) {
        String _sql = "SELECT * FROM ContentEntry WHERE title = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntry WHERE title = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, title);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ContentEntry"}, (Callable)new Callable<ContentEntry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntry call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ContentEntry _result2;
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ContentEntry();
                        long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                        _result2.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result2.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result2.setDescription(_tmpDescription);
                        String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                        _result2.setEntryId(_tmpEntryId);
                        String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                        _result2.setAuthor(_tmpAuthor);
                        String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                        _result2.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                        _result2.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                        _result2.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                        _result2.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                        _result2.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                        _result2.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                        _result2.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _result2.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _result2.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                        _result2.setContentFlags(_tmpContentFlags);
                        int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _result2.setLeaf(_tmpLeaf);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _result2.setPublik(_tmpPublik);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _result2.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _result2.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                        _result2.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _result2.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                        _result2.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                        _result2.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _result2.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _result2.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _result2.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                        _result2.setContentEntryLct(_tmpContentEntryLct);
                    } else {
                        _result2 = null;
                    }
                    ContentEntry contentEntry = _result2;
                    return contentEntry;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findBySourceUrlWithContentEntryStatusAsync(String sourceUrl, Continuation<? super ContentEntry> $completion) {
        String _sql = "SELECT ContentEntry.* FROM ContentEntry WHERE ContentEntry.sourceUrl = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ContentEntry.* FROM ContentEntry WHERE ContentEntry.sourceUrl = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, sourceUrl);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntry call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntry _result2;
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ContentEntry();
                        long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                        _result2.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result2.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result2.setDescription(_tmpDescription);
                        String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                        _result2.setEntryId(_tmpEntryId);
                        String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                        _result2.setAuthor(_tmpAuthor);
                        String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                        _result2.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                        _result2.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                        _result2.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                        _result2.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                        _result2.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                        _result2.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                        _result2.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _result2.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _result2.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                        _result2.setContentFlags(_tmpContentFlags);
                        int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _result2.setLeaf(_tmpLeaf);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _result2.setPublik(_tmpPublik);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _result2.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _result2.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                        _result2.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _result2.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                        _result2.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                        _result2.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _result2.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _result2.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _result2.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                        _result2.setContentEntryLct(_tmpContentEntryLct);
                    } else {
                        _result2 = null;
                    }
                    ContentEntry contentEntry = _result2;
                    return contentEntry;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, ContentEntryAndListDetail> getChildrenByParentUidWithCategoryFilterOrderByName(long accountPersonUid, long parentUid, long langParam, long categoryParam0, int sortOrder, boolean includeDeleted) {
        String _sql = "\n            WITH IncludeResults(includeResults) AS (SELECT 1)\n            \n            SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*,\n                   \n               ? AS sPersonUid,\n               0 AS sCbUid,\n               \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = ?\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = ?\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n    \n              FROM ContentEntry \n                    LEFT JOIN ContentEntryParentChildJoin \n                         ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n                    LEFT JOIN ContentEntryPicture2\n                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid\n             WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ? \n               AND (? = 0 OR ContentEntry.primaryLanguageUid = ?)\n               AND (? = 0 OR ? \n                    IN (SELECT ceccjContentCategoryUid \n                          FROM ContentEntryContentCategoryJoin \n                         WHERE ceccjContentEntryUid = ContentEntry.contentEntryUid)) \n               AND (CAST(? AS INTEGER) = 1 OR CAST(ContentEntryParentChildJoin.cepcjDeleted AS INTEGER) = 0)          \n            ORDER BY ContentEntryParentChildJoin.childIndex,\n                     CASE(?)\n                     WHEN 1 THEN ContentEntry.title\n                     ELSE ''\n                     END ASC,\n                     CASE(?)\n                     WHEN 2 THEN ContentEntry.title\n                     ELSE ''\n                     END DESC,             \n                     ContentEntry.contentEntryUid";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n            WITH IncludeResults(includeResults) AS (SELECT 1)\n            \n            SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*,\n                   \n               ? AS sPersonUid,\n               0 AS sCbUid,\n               \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = ?\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = ?\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n    \n              FROM ContentEntry \n                    LEFT JOIN ContentEntryParentChildJoin \n                         ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n                    LEFT JOIN ContentEntryPicture2\n                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid\n             WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ? \n               AND (? = 0 OR ContentEntry.primaryLanguageUid = ?)\n               AND (? = 0 OR ? \n                    IN (SELECT ceccjContentCategoryUid \n                          FROM ContentEntryContentCategoryJoin \n                         WHERE ceccjContentEntryUid = ContentEntry.contentEntryUid)) \n               AND (CAST(? AS INTEGER) = 1 OR CAST(ContentEntryParentChildJoin.cepcjDeleted AS INTEGER) = 0)          \n            ORDER BY ContentEntryParentChildJoin.childIndex,\n                     CASE(?)\n                     WHEN 1 THEN ContentEntry.title\n                     ELSE ''\n                     END ASC,\n                     CASE(?)\n                     WHEN 2 THEN ContentEntry.title\n                     ELSE ''\n                     END DESC,             \n                     ContentEntry.contentEntryUid", (int)14);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, parentUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, langParam);
        _argIndex = 9;
        _statement.bindLong(_argIndex, langParam);
        _argIndex = 10;
        _statement.bindLong(_argIndex, categoryParam0);
        _argIndex = 11;
        _statement.bindLong(_argIndex, categoryParam0);
        _argIndex = 12;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 13;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 14;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<ContentEntryAndListDetail>(_statement, this.__db, new String[]{"StatementEntity", "ContentEntry", "ContentEntryParentChildJoin", "ContentEntryPicture2", "ContentEntryContentCategoryJoin"}){

            @NonNull
            protected List<ContentEntryAndListDetail> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryUid");
                int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"title");
                int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"description");
                int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"entryId");
                int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"author");
                int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publisher");
                int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseType");
                int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseName");
                int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseUrl");
                int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sourceUrl");
                int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"thumbnailUrl");
                int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastModified");
                int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"primaryLanguageUid");
                int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"languageVariantUid");
                int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentFlags");
                int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"leaf");
                int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publik");
                int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ceInactive");
                int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"completionCriteria");
                int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"minScore");
                int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentTypeFlag");
                int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwner");
                int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwnerType");
                int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLocalChangeSeqNum");
                int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryMasterChangeSeqNum");
                int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLastChangedBy");
                int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLct");
                int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjParentContentEntryUid");
                int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjChildContentEntryUid");
                int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childIndex");
                int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjUid");
                int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjLocalChangeSeqNum");
                int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjMasterChangeSeqNum");
                int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjLastChangedBy");
                int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjLct");
                int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjDeleted");
                int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepUid");
                int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepLct");
                int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepPictureUri");
                int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepThumbnailUri");
                int _cursorIndexOfSPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sPersonUid");
                int _cursorIndexOfSCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sCbUid");
                int _cursorIndexOfSProgress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sProgress");
                int _cursorIndexOfSIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sIsSuccess");
                int _cursorIndexOfSIsCompleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sIsCompleted");
                int _cursorIndexOfSScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sScoreScaled");
                ArrayList<ContentEntryAndListDetail> _result2 = new ArrayList<ContentEntryAndListDetail>(cursor.getCount());
                while (cursor.moveToNext()) {
                    BlockStatus _tmpStatus;
                    ContentEntryPicture2 _tmpPicture;
                    ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
                    ContentEntry _tmpContentEntry;
                    if (!(cursor.isNull(_cursorIndexOfContentEntryUid) && cursor.isNull(_cursorIndexOfTitle) && cursor.isNull(_cursorIndexOfDescription) && cursor.isNull(_cursorIndexOfEntryId) && cursor.isNull(_cursorIndexOfAuthor) && cursor.isNull(_cursorIndexOfPublisher) && cursor.isNull(_cursorIndexOfLicenseType) && cursor.isNull(_cursorIndexOfLicenseName) && cursor.isNull(_cursorIndexOfLicenseUrl) && cursor.isNull(_cursorIndexOfSourceUrl) && cursor.isNull(_cursorIndexOfThumbnailUrl) && cursor.isNull(_cursorIndexOfLastModified) && cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && cursor.isNull(_cursorIndexOfLanguageVariantUid) && cursor.isNull(_cursorIndexOfContentFlags) && cursor.isNull(_cursorIndexOfLeaf) && cursor.isNull(_cursorIndexOfPublik) && cursor.isNull(_cursorIndexOfCeInactive) && cursor.isNull(_cursorIndexOfCompletionCriteria) && cursor.isNull(_cursorIndexOfMinScore) && cursor.isNull(_cursorIndexOfContentTypeFlag) && cursor.isNull(_cursorIndexOfContentOwner) && cursor.isNull(_cursorIndexOfContentOwnerType) && cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && cursor.isNull(_cursorIndexOfContentEntryLct))) {
                        _tmpContentEntry = new ContentEntry();
                        long _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
                        _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = cursor.isNull(_cursorIndexOfTitle) ? null : cursor.getString(_cursorIndexOfTitle);
                        _tmpContentEntry.setTitle(_tmpTitle);
                        String _tmpDescription = cursor.isNull(_cursorIndexOfDescription) ? null : cursor.getString(_cursorIndexOfDescription);
                        _tmpContentEntry.setDescription(_tmpDescription);
                        String _tmpEntryId = cursor.isNull(_cursorIndexOfEntryId) ? null : cursor.getString(_cursorIndexOfEntryId);
                        _tmpContentEntry.setEntryId(_tmpEntryId);
                        String _tmpAuthor = cursor.isNull(_cursorIndexOfAuthor) ? null : cursor.getString(_cursorIndexOfAuthor);
                        _tmpContentEntry.setAuthor(_tmpAuthor);
                        String _tmpPublisher = cursor.isNull(_cursorIndexOfPublisher) ? null : cursor.getString(_cursorIndexOfPublisher);
                        _tmpContentEntry.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
                        _tmpContentEntry.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = cursor.isNull(_cursorIndexOfLicenseName) ? null : cursor.getString(_cursorIndexOfLicenseName);
                        _tmpContentEntry.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = cursor.isNull(_cursorIndexOfLicenseUrl) ? null : cursor.getString(_cursorIndexOfLicenseUrl);
                        _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = cursor.isNull(_cursorIndexOfSourceUrl) ? null : cursor.getString(_cursorIndexOfSourceUrl);
                        _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : cursor.getString(_cursorIndexOfThumbnailUrl);
                        _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
                        _tmpContentEntry.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
                        _tmpContentEntry.setContentFlags(_tmpContentFlags);
                        int _tmp_1 = cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp_1 != 0;
                        _tmpContentEntry.setLeaf(_tmpLeaf);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_2 != 0;
                        _tmpContentEntry.setPublik(_tmpPublik);
                        int _tmp_3 = cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_3 != 0;
                        _tmpContentEntry.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
                        _tmpContentEntry.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
                        _tmpContentEntry.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
                        _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
                        _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
                    } else {
                        _tmpContentEntry = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct) && cursor.isNull(_cursorIndexOfCepcjDeleted))) {
                        long _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                        long _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                        int _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
                        _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                        long _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
                        _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
                        long _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                        _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                        long _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                        _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                        int _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                        _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                        long _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
                        _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
                        int _tmp_4 = cursor.getInt(_cursorIndexOfCepcjDeleted);
                        boolean _tmpCepcjDeleted = _tmp_4 != 0;
                        _tmpContentEntryParentChildJoin.setCepcjDeleted(_tmpCepcjDeleted);
                    } else {
                        _tmpContentEntryParentChildJoin = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCepUid) && cursor.isNull(_cursorIndexOfCepLct) && cursor.isNull(_cursorIndexOfCepPictureUri) && cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
                        long _tmpCepUid = cursor.getLong(_cursorIndexOfCepUid);
                        long _tmpCepLct = cursor.getLong(_cursorIndexOfCepLct);
                        String _tmpCepPictureUri = cursor.isNull(_cursorIndexOfCepPictureUri) ? null : cursor.getString(_cursorIndexOfCepPictureUri);
                        String _tmpCepThumbnailUri = cursor.isNull(_cursorIndexOfCepThumbnailUri) ? null : cursor.getString(_cursorIndexOfCepThumbnailUri);
                        _tmpPicture = new ContentEntryPicture2(_tmpCepUid, _tmpCepLct, _tmpCepPictureUri, _tmpCepThumbnailUri);
                    } else {
                        _tmpPicture = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfSPersonUid) && cursor.isNull(_cursorIndexOfSCbUid) && cursor.isNull(_cursorIndexOfSProgress) && cursor.isNull(_cursorIndexOfSIsSuccess) && cursor.isNull(_cursorIndexOfSIsCompleted) && cursor.isNull(_cursorIndexOfSScoreScaled))) {
                        long _tmpSPersonUid = cursor.getLong(_cursorIndexOfSPersonUid);
                        long _tmpSCbUid = cursor.getLong(_cursorIndexOfSCbUid);
                        Integer _tmpSProgress = cursor.isNull(_cursorIndexOfSProgress) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfSProgress));
                        Integer _tmp_5 = cursor.isNull(_cursorIndexOfSIsSuccess) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfSIsSuccess));
                        Boolean _tmpSIsSuccess = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                        int _tmp_6 = cursor.getInt(_cursorIndexOfSIsCompleted);
                        boolean _tmpSIsCompleted = _tmp_6 != 0;
                        Float _tmpSScoreScaled = cursor.isNull(_cursorIndexOfSScoreScaled) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfSScoreScaled));
                        _tmpStatus = new BlockStatus(_tmpSPersonUid, _tmpSCbUid, _tmpSProgress, _tmpSIsCompleted, _tmpSIsSuccess, _tmpSScoreScaled);
                    } else {
                        _tmpStatus = null;
                    }
                    ContentEntryAndListDetail _item = new ContentEntryAndListDetail(_tmpContentEntry, _tmpPicture, _tmpContentEntryParentChildJoin, _tmpStatus);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public PagingSource<Integer, ContentEntryAndListDetail> getContentFromMyCourses(long accountPersonUid) {
        String _sql = "\n        WITH IncludeResults(includeResults) AS (SELECT 1)\n        \n        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*,\n               \n               ? AS sPersonUid,\n               0 AS sCbUid,\n               \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = ?\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = ?\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n    \n          FROM CourseBlock\n               JOIN ContentEntry \n                    ON CourseBlock.cbType = 104\n                       AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n                       AND CAST(CourseBlock.cbActive AS INTEGER) = 1\n               LEFT JOIN ContentEntryParentChildJoin\n                         ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = 0\n               LEFT JOIN ContentEntryPicture2\n                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid          \n         WHERE CourseBlock.cbClazzUid IN\n               (SELECT ClazzEnrolment.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?)\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH IncludeResults(includeResults) AS (SELECT 1)\n        \n        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*,\n               \n               ? AS sPersonUid,\n               0 AS sCbUid,\n               \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = ?\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = ?\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n    \n          FROM CourseBlock\n               JOIN ContentEntry \n                    ON CourseBlock.cbType = 104\n                       AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n                       AND CAST(CourseBlock.cbActive AS INTEGER) = 1\n               LEFT JOIN ContentEntryParentChildJoin\n                         ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = 0\n               LEFT JOIN ContentEntryPicture2\n                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid          \n         WHERE CourseBlock.cbClazzUid IN\n               (SELECT ClazzEnrolment.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?)\n    ", (int)7);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        return new LimitOffsetPagingSource<ContentEntryAndListDetail>(_statement, this.__db, new String[]{"StatementEntity", "CourseBlock", "ContentEntry", "ContentEntryParentChildJoin", "ContentEntryPicture2", "ClazzEnrolment"}){

            @NonNull
            protected List<ContentEntryAndListDetail> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryUid");
                int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"title");
                int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"description");
                int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"entryId");
                int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"author");
                int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publisher");
                int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseType");
                int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseName");
                int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseUrl");
                int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sourceUrl");
                int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"thumbnailUrl");
                int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastModified");
                int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"primaryLanguageUid");
                int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"languageVariantUid");
                int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentFlags");
                int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"leaf");
                int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publik");
                int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ceInactive");
                int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"completionCriteria");
                int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"minScore");
                int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentTypeFlag");
                int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwner");
                int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwnerType");
                int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLocalChangeSeqNum");
                int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryMasterChangeSeqNum");
                int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLastChangedBy");
                int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLct");
                int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjParentContentEntryUid");
                int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjChildContentEntryUid");
                int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childIndex");
                int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjUid");
                int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjLocalChangeSeqNum");
                int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjMasterChangeSeqNum");
                int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjLastChangedBy");
                int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjLct");
                int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjDeleted");
                int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepUid");
                int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepLct");
                int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepPictureUri");
                int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepThumbnailUri");
                int _cursorIndexOfSPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sPersonUid");
                int _cursorIndexOfSCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sCbUid");
                int _cursorIndexOfSProgress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sProgress");
                int _cursorIndexOfSIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sIsSuccess");
                int _cursorIndexOfSIsCompleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sIsCompleted");
                int _cursorIndexOfSScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sScoreScaled");
                ArrayList<ContentEntryAndListDetail> _result2 = new ArrayList<ContentEntryAndListDetail>(cursor.getCount());
                while (cursor.moveToNext()) {
                    BlockStatus _tmpStatus;
                    ContentEntryPicture2 _tmpPicture;
                    ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
                    ContentEntry _tmpContentEntry;
                    if (!(cursor.isNull(_cursorIndexOfContentEntryUid) && cursor.isNull(_cursorIndexOfTitle) && cursor.isNull(_cursorIndexOfDescription) && cursor.isNull(_cursorIndexOfEntryId) && cursor.isNull(_cursorIndexOfAuthor) && cursor.isNull(_cursorIndexOfPublisher) && cursor.isNull(_cursorIndexOfLicenseType) && cursor.isNull(_cursorIndexOfLicenseName) && cursor.isNull(_cursorIndexOfLicenseUrl) && cursor.isNull(_cursorIndexOfSourceUrl) && cursor.isNull(_cursorIndexOfThumbnailUrl) && cursor.isNull(_cursorIndexOfLastModified) && cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && cursor.isNull(_cursorIndexOfLanguageVariantUid) && cursor.isNull(_cursorIndexOfContentFlags) && cursor.isNull(_cursorIndexOfLeaf) && cursor.isNull(_cursorIndexOfPublik) && cursor.isNull(_cursorIndexOfCeInactive) && cursor.isNull(_cursorIndexOfCompletionCriteria) && cursor.isNull(_cursorIndexOfMinScore) && cursor.isNull(_cursorIndexOfContentTypeFlag) && cursor.isNull(_cursorIndexOfContentOwner) && cursor.isNull(_cursorIndexOfContentOwnerType) && cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && cursor.isNull(_cursorIndexOfContentEntryLct))) {
                        _tmpContentEntry = new ContentEntry();
                        long _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
                        _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = cursor.isNull(_cursorIndexOfTitle) ? null : cursor.getString(_cursorIndexOfTitle);
                        _tmpContentEntry.setTitle(_tmpTitle);
                        String _tmpDescription = cursor.isNull(_cursorIndexOfDescription) ? null : cursor.getString(_cursorIndexOfDescription);
                        _tmpContentEntry.setDescription(_tmpDescription);
                        String _tmpEntryId = cursor.isNull(_cursorIndexOfEntryId) ? null : cursor.getString(_cursorIndexOfEntryId);
                        _tmpContentEntry.setEntryId(_tmpEntryId);
                        String _tmpAuthor = cursor.isNull(_cursorIndexOfAuthor) ? null : cursor.getString(_cursorIndexOfAuthor);
                        _tmpContentEntry.setAuthor(_tmpAuthor);
                        String _tmpPublisher = cursor.isNull(_cursorIndexOfPublisher) ? null : cursor.getString(_cursorIndexOfPublisher);
                        _tmpContentEntry.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
                        _tmpContentEntry.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = cursor.isNull(_cursorIndexOfLicenseName) ? null : cursor.getString(_cursorIndexOfLicenseName);
                        _tmpContentEntry.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = cursor.isNull(_cursorIndexOfLicenseUrl) ? null : cursor.getString(_cursorIndexOfLicenseUrl);
                        _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = cursor.isNull(_cursorIndexOfSourceUrl) ? null : cursor.getString(_cursorIndexOfSourceUrl);
                        _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : cursor.getString(_cursorIndexOfThumbnailUrl);
                        _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
                        _tmpContentEntry.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
                        _tmpContentEntry.setContentFlags(_tmpContentFlags);
                        int _tmp = cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _tmpContentEntry.setLeaf(_tmpLeaf);
                        int _tmp_1 = cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _tmpContentEntry.setPublik(_tmpPublik);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _tmpContentEntry.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
                        _tmpContentEntry.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
                        _tmpContentEntry.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
                        _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
                        _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
                    } else {
                        _tmpContentEntry = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct) && cursor.isNull(_cursorIndexOfCepcjDeleted))) {
                        long _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                        long _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                        int _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
                        _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                        long _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
                        _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
                        long _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                        _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                        long _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                        _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                        int _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                        _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                        long _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
                        _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
                        int _tmp_3 = cursor.getInt(_cursorIndexOfCepcjDeleted);
                        boolean _tmpCepcjDeleted = _tmp_3 != 0;
                        _tmpContentEntryParentChildJoin.setCepcjDeleted(_tmpCepcjDeleted);
                    } else {
                        _tmpContentEntryParentChildJoin = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCepUid) && cursor.isNull(_cursorIndexOfCepLct) && cursor.isNull(_cursorIndexOfCepPictureUri) && cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
                        long _tmpCepUid = cursor.getLong(_cursorIndexOfCepUid);
                        long _tmpCepLct = cursor.getLong(_cursorIndexOfCepLct);
                        String _tmpCepPictureUri = cursor.isNull(_cursorIndexOfCepPictureUri) ? null : cursor.getString(_cursorIndexOfCepPictureUri);
                        String _tmpCepThumbnailUri = cursor.isNull(_cursorIndexOfCepThumbnailUri) ? null : cursor.getString(_cursorIndexOfCepThumbnailUri);
                        _tmpPicture = new ContentEntryPicture2(_tmpCepUid, _tmpCepLct, _tmpCepPictureUri, _tmpCepThumbnailUri);
                    } else {
                        _tmpPicture = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfSPersonUid) && cursor.isNull(_cursorIndexOfSCbUid) && cursor.isNull(_cursorIndexOfSProgress) && cursor.isNull(_cursorIndexOfSIsSuccess) && cursor.isNull(_cursorIndexOfSIsCompleted) && cursor.isNull(_cursorIndexOfSScoreScaled))) {
                        long _tmpSPersonUid = cursor.getLong(_cursorIndexOfSPersonUid);
                        long _tmpSCbUid = cursor.getLong(_cursorIndexOfSCbUid);
                        Integer _tmpSProgress = cursor.isNull(_cursorIndexOfSProgress) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfSProgress));
                        Integer _tmp_4 = cursor.isNull(_cursorIndexOfSIsSuccess) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfSIsSuccess));
                        Boolean _tmpSIsSuccess = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                        int _tmp_5 = cursor.getInt(_cursorIndexOfSIsCompleted);
                        boolean _tmpSIsCompleted = _tmp_5 != 0;
                        Float _tmpSScoreScaled = cursor.isNull(_cursorIndexOfSScoreScaled) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfSScoreScaled));
                        _tmpStatus = new BlockStatus(_tmpSPersonUid, _tmpSCbUid, _tmpSProgress, _tmpSIsCompleted, _tmpSIsSuccess, _tmpSScoreScaled);
                    } else {
                        _tmpStatus = null;
                    }
                    ContentEntryAndListDetail _item = new ContentEntryAndListDetail(_tmpContentEntry, _tmpPicture, _tmpContentEntryParentChildJoin, _tmpStatus);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public PagingSource<Integer, ContentEntryAndListDetail> getContentByOwner(long accountPersonUid) {
        String _sql = "\n        WITH IncludeResults(includeResults) AS (SELECT 1)\n        \n        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*, \n               \n               ? AS sPersonUid,\n               0 AS sCbUid,\n               \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = ?\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = ?\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n    \n          FROM ContentEntry\n               LEFT JOIN ContentEntryParentChildJoin\n                         ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = 0\n               LEFT JOIN ContentEntryPicture2\n                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid\n         WHERE ContentEntry.contentOwner = ?\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        WITH IncludeResults(includeResults) AS (SELECT 1)\n        \n        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*, \n               \n               ? AS sPersonUid,\n               0 AS sCbUid,\n               \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = ?\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = ?\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = ?\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = ?\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n    \n          FROM ContentEntry\n               LEFT JOIN ContentEntryParentChildJoin\n                         ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = 0\n               LEFT JOIN ContentEntryPicture2\n                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid\n         WHERE ContentEntry.contentOwner = ?\n    ", (int)7);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        return new LimitOffsetPagingSource<ContentEntryAndListDetail>(_statement, this.__db, new String[]{"StatementEntity", "ContentEntry", "ContentEntryParentChildJoin", "ContentEntryPicture2"}){

            @NonNull
            protected List<ContentEntryAndListDetail> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryUid");
                int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"title");
                int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"description");
                int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"entryId");
                int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"author");
                int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publisher");
                int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseType");
                int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseName");
                int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseUrl");
                int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sourceUrl");
                int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"thumbnailUrl");
                int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastModified");
                int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"primaryLanguageUid");
                int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"languageVariantUid");
                int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentFlags");
                int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"leaf");
                int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publik");
                int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ceInactive");
                int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"completionCriteria");
                int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"minScore");
                int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentTypeFlag");
                int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwner");
                int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwnerType");
                int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLocalChangeSeqNum");
                int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryMasterChangeSeqNum");
                int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLastChangedBy");
                int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLct");
                int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjParentContentEntryUid");
                int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjChildContentEntryUid");
                int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"childIndex");
                int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjUid");
                int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjLocalChangeSeqNum");
                int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjMasterChangeSeqNum");
                int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjLastChangedBy");
                int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjLct");
                int _cursorIndexOfCepcjDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepcjDeleted");
                int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepUid");
                int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepLct");
                int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepPictureUri");
                int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepThumbnailUri");
                int _cursorIndexOfSPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sPersonUid");
                int _cursorIndexOfSCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sCbUid");
                int _cursorIndexOfSProgress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sProgress");
                int _cursorIndexOfSIsSuccess = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sIsSuccess");
                int _cursorIndexOfSIsCompleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sIsCompleted");
                int _cursorIndexOfSScoreScaled = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sScoreScaled");
                ArrayList<ContentEntryAndListDetail> _result2 = new ArrayList<ContentEntryAndListDetail>(cursor.getCount());
                while (cursor.moveToNext()) {
                    BlockStatus _tmpStatus;
                    ContentEntryPicture2 _tmpPicture;
                    ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
                    ContentEntry _tmpContentEntry;
                    if (!(cursor.isNull(_cursorIndexOfContentEntryUid) && cursor.isNull(_cursorIndexOfTitle) && cursor.isNull(_cursorIndexOfDescription) && cursor.isNull(_cursorIndexOfEntryId) && cursor.isNull(_cursorIndexOfAuthor) && cursor.isNull(_cursorIndexOfPublisher) && cursor.isNull(_cursorIndexOfLicenseType) && cursor.isNull(_cursorIndexOfLicenseName) && cursor.isNull(_cursorIndexOfLicenseUrl) && cursor.isNull(_cursorIndexOfSourceUrl) && cursor.isNull(_cursorIndexOfThumbnailUrl) && cursor.isNull(_cursorIndexOfLastModified) && cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && cursor.isNull(_cursorIndexOfLanguageVariantUid) && cursor.isNull(_cursorIndexOfContentFlags) && cursor.isNull(_cursorIndexOfLeaf) && cursor.isNull(_cursorIndexOfPublik) && cursor.isNull(_cursorIndexOfCeInactive) && cursor.isNull(_cursorIndexOfCompletionCriteria) && cursor.isNull(_cursorIndexOfMinScore) && cursor.isNull(_cursorIndexOfContentTypeFlag) && cursor.isNull(_cursorIndexOfContentOwner) && cursor.isNull(_cursorIndexOfContentOwnerType) && cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && cursor.isNull(_cursorIndexOfContentEntryLct))) {
                        _tmpContentEntry = new ContentEntry();
                        long _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
                        _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = cursor.isNull(_cursorIndexOfTitle) ? null : cursor.getString(_cursorIndexOfTitle);
                        _tmpContentEntry.setTitle(_tmpTitle);
                        String _tmpDescription = cursor.isNull(_cursorIndexOfDescription) ? null : cursor.getString(_cursorIndexOfDescription);
                        _tmpContentEntry.setDescription(_tmpDescription);
                        String _tmpEntryId = cursor.isNull(_cursorIndexOfEntryId) ? null : cursor.getString(_cursorIndexOfEntryId);
                        _tmpContentEntry.setEntryId(_tmpEntryId);
                        String _tmpAuthor = cursor.isNull(_cursorIndexOfAuthor) ? null : cursor.getString(_cursorIndexOfAuthor);
                        _tmpContentEntry.setAuthor(_tmpAuthor);
                        String _tmpPublisher = cursor.isNull(_cursorIndexOfPublisher) ? null : cursor.getString(_cursorIndexOfPublisher);
                        _tmpContentEntry.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
                        _tmpContentEntry.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = cursor.isNull(_cursorIndexOfLicenseName) ? null : cursor.getString(_cursorIndexOfLicenseName);
                        _tmpContentEntry.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = cursor.isNull(_cursorIndexOfLicenseUrl) ? null : cursor.getString(_cursorIndexOfLicenseUrl);
                        _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = cursor.isNull(_cursorIndexOfSourceUrl) ? null : cursor.getString(_cursorIndexOfSourceUrl);
                        _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : cursor.getString(_cursorIndexOfThumbnailUrl);
                        _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
                        _tmpContentEntry.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
                        _tmpContentEntry.setContentFlags(_tmpContentFlags);
                        int _tmp = cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _tmpContentEntry.setLeaf(_tmpLeaf);
                        int _tmp_1 = cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _tmpContentEntry.setPublik(_tmpPublik);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _tmpContentEntry.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
                        _tmpContentEntry.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
                        _tmpContentEntry.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
                        _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
                        _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
                    } else {
                        _tmpContentEntry = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct) && cursor.isNull(_cursorIndexOfCepcjDeleted))) {
                        long _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                        long _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                        int _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
                        _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid, _tmpCepcjChildContentEntryUid, _tmpChildIndex);
                        long _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
                        _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
                        long _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                        _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                        long _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                        _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                        int _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                        _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                        long _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
                        _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
                        int _tmp_3 = cursor.getInt(_cursorIndexOfCepcjDeleted);
                        boolean _tmpCepcjDeleted = _tmp_3 != 0;
                        _tmpContentEntryParentChildJoin.setCepcjDeleted(_tmpCepcjDeleted);
                    } else {
                        _tmpContentEntryParentChildJoin = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCepUid) && cursor.isNull(_cursorIndexOfCepLct) && cursor.isNull(_cursorIndexOfCepPictureUri) && cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
                        long _tmpCepUid = cursor.getLong(_cursorIndexOfCepUid);
                        long _tmpCepLct = cursor.getLong(_cursorIndexOfCepLct);
                        String _tmpCepPictureUri = cursor.isNull(_cursorIndexOfCepPictureUri) ? null : cursor.getString(_cursorIndexOfCepPictureUri);
                        String _tmpCepThumbnailUri = cursor.isNull(_cursorIndexOfCepThumbnailUri) ? null : cursor.getString(_cursorIndexOfCepThumbnailUri);
                        _tmpPicture = new ContentEntryPicture2(_tmpCepUid, _tmpCepLct, _tmpCepPictureUri, _tmpCepThumbnailUri);
                    } else {
                        _tmpPicture = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfSPersonUid) && cursor.isNull(_cursorIndexOfSCbUid) && cursor.isNull(_cursorIndexOfSProgress) && cursor.isNull(_cursorIndexOfSIsSuccess) && cursor.isNull(_cursorIndexOfSIsCompleted) && cursor.isNull(_cursorIndexOfSScoreScaled))) {
                        long _tmpSPersonUid = cursor.getLong(_cursorIndexOfSPersonUid);
                        long _tmpSCbUid = cursor.getLong(_cursorIndexOfSCbUid);
                        Integer _tmpSProgress = cursor.isNull(_cursorIndexOfSProgress) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfSProgress));
                        Integer _tmp_4 = cursor.isNull(_cursorIndexOfSIsSuccess) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfSIsSuccess));
                        Boolean _tmpSIsSuccess = _tmp_4 == null ? null : Boolean.valueOf(_tmp_4 != 0);
                        int _tmp_5 = cursor.getInt(_cursorIndexOfSIsCompleted);
                        boolean _tmpSIsCompleted = _tmp_5 != 0;
                        Float _tmpSScoreScaled = cursor.isNull(_cursorIndexOfSScoreScaled) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfSScoreScaled));
                        _tmpStatus = new BlockStatus(_tmpSPersonUid, _tmpSCbUid, _tmpSProgress, _tmpSIsCompleted, _tmpSIsSuccess, _tmpSScoreScaled);
                    } else {
                        _tmpStatus = null;
                    }
                    ContentEntryAndListDetail _item = new ContentEntryAndListDetail(_tmpContentEntry, _tmpPicture, _tmpContentEntryParentChildJoin, _tmpStatus);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContentEntry> getChildrenByAll(long parentUid) {
        String _sql = "SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, parentUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
            int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
            int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
            int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
            int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
            int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
            int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
            int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
            int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
            int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
            int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
            int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
            int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
            int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
            int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
            int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
            int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
            int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
            int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
            int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
            int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
            int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
            int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
            int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
            ArrayList<ContentEntry> _result2 = new ArrayList<ContentEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ContentEntry _item = new ContentEntry();
                long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                _item.setContentEntryUid(_tmpContentEntryUid);
                String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                _item.setDescription(_tmpDescription);
                String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                _item.setEntryId(_tmpEntryId);
                String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                _item.setAuthor(_tmpAuthor);
                String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                _item.setPublisher(_tmpPublisher);
                int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                _item.setLicenseType(_tmpLicenseType);
                String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                _item.setLicenseName(_tmpLicenseName);
                String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                _item.setLicenseUrl(_tmpLicenseUrl);
                String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                _item.setSourceUrl(_tmpSourceUrl);
                String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                _item.setThumbnailUrl(_tmpThumbnailUrl);
                long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                _item.setLastModified(_tmpLastModified);
                long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                _item.setLanguageVariantUid(_tmpLanguageVariantUid);
                int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                _item.setContentFlags(_tmpContentFlags);
                int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                boolean _tmpLeaf = _tmp != 0;
                _item.setLeaf(_tmpLeaf);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                boolean _tmpPublik = _tmp_1 != 0;
                _item.setPublik(_tmpPublik);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                boolean _tmpCeInactive = _tmp_2 != 0;
                _item.setCeInactive(_tmpCeInactive);
                int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                _item.setCompletionCriteria(_tmpCompletionCriteria);
                int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                _item.setMinScore(_tmpMinScore);
                int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                _item.setContentTypeFlag(_tmpContentTypeFlag);
                long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                _item.setContentOwner(_tmpContentOwner);
                int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                _item.setContentOwnerType(_tmpContentOwnerType);
                long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                _item.setContentEntryLct(_tmpContentEntryLct);
                _result2.add(_item);
            }
            ArrayList<ContentEntry> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flow<ContentEntry> findLiveContentEntry(long parentUid) {
        String _sql = "SELECT * FROM ContentEntry where contentEntryUid = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntry where contentEntryUid = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, parentUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ContentEntry"}, (Callable)new Callable<ContentEntry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntry call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ContentEntry _result2;
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new ContentEntry();
                        long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                        _result2.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result2.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result2.setDescription(_tmpDescription);
                        String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                        _result2.setEntryId(_tmpEntryId);
                        String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                        _result2.setAuthor(_tmpAuthor);
                        String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                        _result2.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                        _result2.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                        _result2.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                        _result2.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                        _result2.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                        _result2.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                        _result2.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _result2.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _result2.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                        _result2.setContentFlags(_tmpContentFlags);
                        int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp != 0;
                        _result2.setLeaf(_tmpLeaf);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_1 != 0;
                        _result2.setPublik(_tmpPublik);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_2 != 0;
                        _result2.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _result2.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                        _result2.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _result2.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                        _result2.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                        _result2.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _result2.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _result2.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _result2.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                        _result2.setContentEntryLct(_tmpContentEntryLct);
                    } else {
                        _result2 = null;
                    }
                    ContentEntry contentEntry = _result2;
                    return contentEntry;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getContentEntryUidFromXapiObjectId(String objectId) {
        String _sql = "SELECT COALESCE((SELECT contentEntryUid \n                                      FROM ContentEntry \n                                     WHERE entryId = ? \n                                     LIMIT 1),0) AS ID";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COALESCE((SELECT contentEntryUid \n                                      FROM ContentEntry \n                                     WHERE entryId = ? \n                                     LIMIT 1),0) AS ID", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, objectId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            long _result2 = _cursor.moveToFirst() ? _cursor.getLong(0) : 0L;
            long l = _result2;
            return l;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContentEntry> findSimilarIdEntryForKhan(String sourceUrl) {
        String _sql = "SELECT * FROM ContentEntry WHERE sourceUrl LIKE ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ContentEntry WHERE sourceUrl LIKE ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, sourceUrl);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
            int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
            int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
            int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
            int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
            int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
            int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
            int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
            int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
            int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
            int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
            int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
            int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
            int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
            int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
            int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
            int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
            int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
            int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
            int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
            int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
            int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
            int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
            int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
            ArrayList<ContentEntry> _result2 = new ArrayList<ContentEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ContentEntry _item = new ContentEntry();
                long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                _item.setContentEntryUid(_tmpContentEntryUid);
                String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                _item.setDescription(_tmpDescription);
                String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                _item.setEntryId(_tmpEntryId);
                String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                _item.setAuthor(_tmpAuthor);
                String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                _item.setPublisher(_tmpPublisher);
                int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                _item.setLicenseType(_tmpLicenseType);
                String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                _item.setLicenseName(_tmpLicenseName);
                String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                _item.setLicenseUrl(_tmpLicenseUrl);
                String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                _item.setSourceUrl(_tmpSourceUrl);
                String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                _item.setThumbnailUrl(_tmpThumbnailUrl);
                long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                _item.setLastModified(_tmpLastModified);
                long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                _item.setLanguageVariantUid(_tmpLanguageVariantUid);
                int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                _item.setContentFlags(_tmpContentFlags);
                int _tmp = _cursor.getInt(_cursorIndexOfLeaf);
                boolean _tmpLeaf = _tmp != 0;
                _item.setLeaf(_tmpLeaf);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
                boolean _tmpPublik = _tmp_1 != 0;
                _item.setPublik(_tmpPublik);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
                boolean _tmpCeInactive = _tmp_2 != 0;
                _item.setCeInactive(_tmpCeInactive);
                int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                _item.setCompletionCriteria(_tmpCompletionCriteria);
                int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                _item.setMinScore(_tmpMinScore);
                int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                _item.setContentTypeFlag(_tmpContentTypeFlag);
                long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                _item.setContentOwner(_tmpContentOwner);
                int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                _item.setContentOwnerType(_tmpContentOwnerType);
                long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                _item.setContentEntryLct(_tmpContentEntryLct);
                _result2.add(_item);
            }
            ArrayList<ContentEntry> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object getContentEntryFromUids(List<Long> contentEntryUids, Continuation<? super List<UidAndLabel>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("Select ContentEntry.contentEntryUid AS uid, ContentEntry.title As labelName ");
        _stringBuilder.append("\n");
        _stringBuilder.append("                    from ContentEntry WHERE contentEntryUid IN (");
        int _inputSize = contentEntryUids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : contentEntryUids) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<UidAndLabel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<UidAndLabel> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfUid = false;
                    boolean _cursorIndexOfLabelName = true;
                    ArrayList<UidAndLabel> _result2 = new ArrayList<UidAndLabel>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        UidAndLabel _item_1 = new UidAndLabel();
                        long _tmpUid = _cursor.getLong(0);
                        _item_1.setUid(_tmpUid);
                        String _tmpLabelName = _cursor.isNull(1) ? null : _cursor.getString(1);
                        _item_1.setLabelName(_tmpLabelName);
                        _result2.add(_item_1);
                    }
                    ArrayList<UidAndLabel> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

