/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CourseBlockDao;
import com.ustadmobile.lib.db.composites.CourseBlockAndAssignment;
import com.ustadmobile.lib.db.composites.CourseBlockAndDbEntities;
import com.ustadmobile.lib.db.composites.CourseBlockAndDisplayDetails;
import com.ustadmobile.lib.db.composites.CourseBlockAndGradebookDisplayDetails;
import com.ustadmobile.lib.db.composites.CourseBlockAndPicture;
import com.ustadmobile.lib.db.composites.CourseBlockUidAndClazzUid;
import com.ustadmobile.lib.db.entities.ClazzAssignment;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryPicture2;
import com.ustadmobile.lib.db.entities.CourseBlock;
import com.ustadmobile.lib.db.entities.CourseBlockPicture;
import com.ustadmobile.lib.db.entities.Language;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class CourseBlockDao_Impl
extends CourseBlockDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CourseBlock> __insertionAdapterOfCourseBlock;
    private final EntityInsertionAdapter<CourseBlock> __insertionAdapterOfCourseBlock_1;
    private final EntityDeletionOrUpdateAdapter<CourseBlock> __updateAdapterOfCourseBlock;
    private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;
    private final SharedSQLiteStatement __preparedStmtOfUpdateFromLineItem;

    public CourseBlockDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCourseBlock = new EntityInsertionAdapter<CourseBlock>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `CourseBlock` (`cbUid`,`cbType`,`cbIndentLevel`,`cbModuleParentBlockUid`,`cbTitle`,`cbDescription`,`cbCompletionCriteria`,`cbHideUntilDate`,`cbDeadlineDate`,`cbLateSubmissionPenalty`,`cbGracePeriodDate`,`cbMaxPoints`,`cbMinPoints`,`cbIndex`,`cbClazzUid`,`cbClazzSourcedId`,`cbActive`,`cbHidden`,`cbEntityUid`,`cbLct`,`cbSourcedId`,`cbMetadata`,`cbCreatedByAppId`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseBlock entity) {
                statement.bindLong(1, entity.getCbUid());
                statement.bindLong(2, (long)entity.getCbType());
                statement.bindLong(3, (long)entity.getCbIndentLevel());
                statement.bindLong(4, entity.getCbModuleParentBlockUid());
                if (entity.getCbTitle() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getCbTitle());
                }
                if (entity.getCbDescription() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCbDescription());
                }
                statement.bindLong(7, (long)entity.getCbCompletionCriteria());
                statement.bindLong(8, entity.getCbHideUntilDate());
                statement.bindLong(9, entity.getCbDeadlineDate());
                statement.bindLong(10, (long)entity.getCbLateSubmissionPenalty());
                statement.bindLong(11, entity.getCbGracePeriodDate());
                if (entity.getCbMaxPoints() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindDouble(12, (double)entity.getCbMaxPoints().floatValue());
                }
                if (entity.getCbMinPoints() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindDouble(13, (double)entity.getCbMinPoints().floatValue());
                }
                statement.bindLong(14, (long)entity.getCbIndex());
                statement.bindLong(15, entity.getCbClazzUid());
                if (entity.getCbClazzSourcedId() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindString(16, entity.getCbClazzSourcedId());
                }
                int _tmp = entity.getCbActive() ? 1 : 0;
                statement.bindLong(17, (long)_tmp);
                int _tmp_1 = entity.getCbHidden() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_1);
                statement.bindLong(19, entity.getCbEntityUid());
                statement.bindLong(20, entity.getCbLct());
                if (entity.getCbSourcedId() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindString(21, entity.getCbSourcedId());
                }
                if (entity.getCbMetadata() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindString(22, entity.getCbMetadata());
                }
                if (entity.getCbCreatedByAppId() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getCbCreatedByAppId());
                }
            }
        };
        this.__insertionAdapterOfCourseBlock_1 = new EntityInsertionAdapter<CourseBlock>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `CourseBlock` (`cbUid`,`cbType`,`cbIndentLevel`,`cbModuleParentBlockUid`,`cbTitle`,`cbDescription`,`cbCompletionCriteria`,`cbHideUntilDate`,`cbDeadlineDate`,`cbLateSubmissionPenalty`,`cbGracePeriodDate`,`cbMaxPoints`,`cbMinPoints`,`cbIndex`,`cbClazzUid`,`cbClazzSourcedId`,`cbActive`,`cbHidden`,`cbEntityUid`,`cbLct`,`cbSourcedId`,`cbMetadata`,`cbCreatedByAppId`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseBlock entity) {
                statement.bindLong(1, entity.getCbUid());
                statement.bindLong(2, (long)entity.getCbType());
                statement.bindLong(3, (long)entity.getCbIndentLevel());
                statement.bindLong(4, entity.getCbModuleParentBlockUid());
                if (entity.getCbTitle() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getCbTitle());
                }
                if (entity.getCbDescription() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCbDescription());
                }
                statement.bindLong(7, (long)entity.getCbCompletionCriteria());
                statement.bindLong(8, entity.getCbHideUntilDate());
                statement.bindLong(9, entity.getCbDeadlineDate());
                statement.bindLong(10, (long)entity.getCbLateSubmissionPenalty());
                statement.bindLong(11, entity.getCbGracePeriodDate());
                if (entity.getCbMaxPoints() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindDouble(12, (double)entity.getCbMaxPoints().floatValue());
                }
                if (entity.getCbMinPoints() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindDouble(13, (double)entity.getCbMinPoints().floatValue());
                }
                statement.bindLong(14, (long)entity.getCbIndex());
                statement.bindLong(15, entity.getCbClazzUid());
                if (entity.getCbClazzSourcedId() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindString(16, entity.getCbClazzSourcedId());
                }
                int _tmp = entity.getCbActive() ? 1 : 0;
                statement.bindLong(17, (long)_tmp);
                int _tmp_1 = entity.getCbHidden() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_1);
                statement.bindLong(19, entity.getCbEntityUid());
                statement.bindLong(20, entity.getCbLct());
                if (entity.getCbSourcedId() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindString(21, entity.getCbSourcedId());
                }
                if (entity.getCbMetadata() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindString(22, entity.getCbMetadata());
                }
                if (entity.getCbCreatedByAppId() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getCbCreatedByAppId());
                }
            }
        };
        this.__updateAdapterOfCourseBlock = new EntityDeletionOrUpdateAdapter<CourseBlock>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `CourseBlock` SET `cbUid` = ?,`cbType` = ?,`cbIndentLevel` = ?,`cbModuleParentBlockUid` = ?,`cbTitle` = ?,`cbDescription` = ?,`cbCompletionCriteria` = ?,`cbHideUntilDate` = ?,`cbDeadlineDate` = ?,`cbLateSubmissionPenalty` = ?,`cbGracePeriodDate` = ?,`cbMaxPoints` = ?,`cbMinPoints` = ?,`cbIndex` = ?,`cbClazzUid` = ?,`cbClazzSourcedId` = ?,`cbActive` = ?,`cbHidden` = ?,`cbEntityUid` = ?,`cbLct` = ?,`cbSourcedId` = ?,`cbMetadata` = ?,`cbCreatedByAppId` = ? WHERE `cbUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseBlock entity) {
                statement.bindLong(1, entity.getCbUid());
                statement.bindLong(2, (long)entity.getCbType());
                statement.bindLong(3, (long)entity.getCbIndentLevel());
                statement.bindLong(4, entity.getCbModuleParentBlockUid());
                if (entity.getCbTitle() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getCbTitle());
                }
                if (entity.getCbDescription() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getCbDescription());
                }
                statement.bindLong(7, (long)entity.getCbCompletionCriteria());
                statement.bindLong(8, entity.getCbHideUntilDate());
                statement.bindLong(9, entity.getCbDeadlineDate());
                statement.bindLong(10, (long)entity.getCbLateSubmissionPenalty());
                statement.bindLong(11, entity.getCbGracePeriodDate());
                if (entity.getCbMaxPoints() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindDouble(12, (double)entity.getCbMaxPoints().floatValue());
                }
                if (entity.getCbMinPoints() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindDouble(13, (double)entity.getCbMinPoints().floatValue());
                }
                statement.bindLong(14, (long)entity.getCbIndex());
                statement.bindLong(15, entity.getCbClazzUid());
                if (entity.getCbClazzSourcedId() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindString(16, entity.getCbClazzSourcedId());
                }
                int _tmp = entity.getCbActive() ? 1 : 0;
                statement.bindLong(17, (long)_tmp);
                int _tmp_1 = entity.getCbHidden() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_1);
                statement.bindLong(19, entity.getCbEntityUid());
                statement.bindLong(20, entity.getCbLct());
                if (entity.getCbSourcedId() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindString(21, entity.getCbSourcedId());
                }
                if (entity.getCbMetadata() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindString(22, entity.getCbMetadata());
                }
                if (entity.getCbCreatedByAppId() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getCbCreatedByAppId());
                }
                statement.bindLong(24, entity.getCbUid());
            }
        };
        this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE CourseBlock \n           SET cbActive = ?, \n               cbLct = ?\n         WHERE cbUid = ?";
                return "\n        UPDATE CourseBlock \n           SET cbActive = ?, \n               cbLct = ?\n         WHERE cbUid = ?";
            }
        };
        this.__preparedStmtOfUpdateFromLineItem = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE CourseBlock\n           SET cbActive = ?,\n               cbLct = ?,\n               cbTitle = ?,\n               cbDescription = ?,\n               cbHideUntilDate = ?,\n               cbDeadlineDate = ?,\n               cbMinPoints = ?,\n               cbMaxPoints = ?\n         WHERE cbUid = ?      \n    ";
                return "\n        UPDATE CourseBlock\n           SET cbActive = ?,\n               cbLct = ?,\n               cbTitle = ?,\n               cbDescription = ?,\n               cbHideUntilDate = ?,\n               cbDeadlineDate = ?,\n               cbMinPoints = ?,\n               cbMaxPoints = ?\n         WHERE cbUid = ?      \n    ";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(CourseBlock entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfCourseBlock.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final CourseBlock entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                CourseBlockDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = CourseBlockDao_Impl.this.__insertionAdapterOfCourseBlock.insertAndReturnId((Object)entity);
                    CourseBlockDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    CourseBlockDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends CourseBlock> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCourseBlock.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<? extends CourseBlock> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseBlockDao_Impl.this.__db.beginTransaction();
                try {
                    CourseBlockDao_Impl.this.__insertionAdapterOfCourseBlock.insert((Iterable)entityList);
                    CourseBlockDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseBlockDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object replaceListAsync(final List<CourseBlock> list, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseBlockDao_Impl.this.__db.beginTransaction();
                try {
                    CourseBlockDao_Impl.this.__insertionAdapterOfCourseBlock_1.insert((Iterable)list);
                    CourseBlockDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseBlockDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertListAsync(final List<CourseBlock> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseBlockDao_Impl.this.__db.beginTransaction();
                try {
                    CourseBlockDao_Impl.this.__insertionAdapterOfCourseBlock_1.insert((Iterable)entities);
                    CourseBlockDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseBlockDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(CourseBlock entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCourseBlock.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateListAsync(final List<? extends CourseBlock> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseBlockDao_Impl.this.__db.beginTransaction();
                try {
                    CourseBlockDao_Impl.this.__updateAdapterOfCourseBlock.handleMultiple((Iterable)entityList);
                    CourseBlockDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseBlockDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateAsync(final CourseBlock entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                CourseBlockDao_Impl.this.__db.beginTransaction();
                try {
                    CourseBlockDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += CourseBlockDao_Impl.this.__updateAdapterOfCourseBlock.handle((Object)entity);
                    return n;
                }
                finally {
                    CourseBlockDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateActiveByUid(final long cbUid, final boolean active, final long changeTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CourseBlockDao_Impl.this.__preparedStmtOfUpdateActiveByUid.acquire();
                int _argIndex = 1;
                int _tmp = active ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, changeTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, cbUid);
                try {
                    Unit unit;
                    CourseBlockDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        CourseBlockDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        CourseBlockDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    CourseBlockDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    CourseBlockDao_Impl.this.__preparedStmtOfUpdateActiveByUid.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateFromLineItem(final long cbUid, final boolean active, final long dateLastModified, final String title, final String description, final long assignDate, final long dueDate, final float resultValueMin, final float resultValueMax, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CourseBlockDao_Impl.this.__preparedStmtOfUpdateFromLineItem.acquire();
                int _argIndex = 1;
                int _tmp = active ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, dateLastModified);
                _argIndex = 3;
                _stmt.bindString(_argIndex, title);
                _argIndex = 4;
                _stmt.bindString(_argIndex, description);
                _argIndex = 5;
                _stmt.bindLong(_argIndex, assignDate);
                _argIndex = 6;
                _stmt.bindLong(_argIndex, dueDate);
                _argIndex = 7;
                _stmt.bindDouble(_argIndex, (double)resultValueMin);
                _argIndex = 8;
                _stmt.bindDouble(_argIndex, (double)resultValueMax);
                _argIndex = 9;
                _stmt.bindLong(_argIndex, cbUid);
                try {
                    Unit unit;
                    CourseBlockDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        CourseBlockDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        CourseBlockDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    CourseBlockDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    CourseBlockDao_Impl.this.__preparedStmtOfUpdateFromLineItem.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super CourseBlock> $completion) {
        String _sql = "SELECT * FROM CourseBlock WHERE cbUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM CourseBlock WHERE cbUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseBlock>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseBlock call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseBlock _result2;
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    if (_cursor.moveToFirst()) {
                        long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                        int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                        int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                        long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                        String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                        String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                        int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                        long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                        long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                        int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                        long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                        Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                        Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                        int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                        long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                        String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                        int _tmp = _cursor.getInt(_cursorIndexOfCbActive);
                        boolean _tmpCbActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
                        boolean _tmpCbHidden = _tmp_1 != 0;
                        long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                        long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                        String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                        String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                        String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                        _result2 = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                    } else {
                        _result2 = null;
                    }
                    CourseBlock courseBlock = _result2;
                    return courseBlock;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object existsByUid(long cbUid, Continuation<? super Boolean> $completion) {
        String _sql = "\n        SELECT EXISTS(\n               SELECT CourseBlock.cbUid\n                 FROM CourseBlock\n                WHERE CourseBlock.cbUid = ?)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT EXISTS(\n               SELECT CourseBlock.cbUid\n                 FROM CourseBlock\n                WHERE CourseBlock.cbUid = ?)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, cbUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _tmp;
                    Boolean _result2 = _cursor.moveToFirst() ? Boolean.valueOf((_tmp = _cursor.getInt(0)) != 0) : Boolean.valueOf(false);
                    Boolean bl = _result2;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<CourseBlock> findByUidAsyncAsFlow(long uid) {
        String _sql = "SELECT * FROM CourseBlock WHERE cbUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM CourseBlock WHERE cbUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseBlock"}, (Callable)new Callable<CourseBlock>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseBlock call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CourseBlock _result2;
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    if (_cursor.moveToFirst()) {
                        long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                        int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                        int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                        long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                        String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                        String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                        int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                        long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                        long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                        int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                        long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                        Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                        Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                        int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                        long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                        String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                        int _tmp = _cursor.getInt(_cursorIndexOfCbActive);
                        boolean _tmpCbActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
                        boolean _tmpCbHidden = _tmp_1 != 0;
                        long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                        long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                        String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                        String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                        String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                        _result2 = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                    } else {
                        _result2 = null;
                    }
                    CourseBlock courseBlock = _result2;
                    return courseBlock;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<CourseBlockAndPicture> findByUidWithPictureAsFlow(long uid) {
        String _sql = "\n        SELECT CourseBlock.*, CourseBlockPicture.*\n          FROM CourseBlock\n               LEFT JOIN CourseBlockPicture \n                         ON CourseBlockPicture.cbpUid = ?\n         WHERE CourseBlock.cbUid = ?                \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseBlock.*, CourseBlockPicture.*\n          FROM CourseBlock\n               LEFT JOIN CourseBlockPicture \n                         ON CourseBlockPicture.cbpUid = ?\n         WHERE CourseBlock.cbUid = ?                \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseBlock", "CourseBlockPicture"}, (Callable)new Callable<CourseBlockAndPicture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseBlockAndPicture call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CourseBlockAndPicture _result2;
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpUid");
                    int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpLct");
                    int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpPictureUri");
                    int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpThumbnailUri");
                    if (_cursor.moveToFirst()) {
                        CourseBlockPicture _tmpPicture;
                        CourseBlock _tmpBlock;
                        if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
                            long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                            int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                            int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                            long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                            String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                            String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                            int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                            long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                            long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                            int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                            long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                            Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                            Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                            int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                            long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                            String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                            int _tmp = _cursor.getInt(_cursorIndexOfCbActive);
                            boolean _tmpCbActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
                            boolean _tmpCbHidden = _tmp_1 != 0;
                            long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                            long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                            String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                            String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                            String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                            _tmpBlock = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                        } else {
                            _tmpBlock = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
                            long _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
                            long _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
                            String _tmpCbpPictureUri = _cursor.isNull(_cursorIndexOfCbpPictureUri) ? null : _cursor.getString(_cursorIndexOfCbpPictureUri);
                            String _tmpCbpThumbnailUri = _cursor.isNull(_cursorIndexOfCbpThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCbpThumbnailUri);
                            _tmpPicture = new CourseBlockPicture(_tmpCbpUid, _tmpCbpLct, _tmpCbpPictureUri, _tmpCbpThumbnailUri);
                        } else {
                            _tmpPicture = null;
                        }
                        _result2 = new CourseBlockAndPicture(_tmpBlock, _tmpPicture);
                    } else {
                        _result2 = null;
                    }
                    CourseBlockAndPicture courseBlockAndPicture = _result2;
                    return courseBlockAndPicture;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findAllCourseBlockByClazzUidAsync(long clazzUid, boolean includeInactive, Continuation<? super List<CourseBlockAndDbEntities>> $completion) {
        String _sql = "\n        SELECT CourseBlock.*, Assignment.*, Entry.*, Language.*, CourseBlockPicture.*,\n               (SELECT CourseGroupSet.cgsName\n                  FROM CourseGroupSet\n                 WHERE CourseBlock.cbType = 103\n                   AND assignment.caGroupUid != 0\n                   AND CourseGroupSet.cgsUid = assignment.caGroupUid) AS assignmentCourseGroupSetName\n          FROM CourseBlock \n               LEFT JOIN ClazzAssignment AS Assignment\n                         ON assignment.caUid = CourseBlock.cbEntityUid\n                            AND CourseBlock.cbType = 103\n               LEFT JOIN ContentEntry AS Entry\n                         ON entry.contentEntryUid = CourseBlock.cbEntityUid\n                            AND CourseBlock.cbType = 104\n               LEFT JOIN Language\n                         ON Language.langUid = Entry.primaryLanguageUid\n                            AND CourseBlock.cbType = 104\n               LEFT JOIN CourseBlockPicture\n                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    \n         WHERE CourseBlock.cbClazzUid = ?\n           AND (CAST(? AS INTEGER) = 1 OR CourseBlock.cbActive)\n           AND (CourseBlock.cbType != 300)\n      ORDER BY CourseBlock.cbIndex\n          ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseBlock.*, Assignment.*, Entry.*, Language.*, CourseBlockPicture.*,\n               (SELECT CourseGroupSet.cgsName\n                  FROM CourseGroupSet\n                 WHERE CourseBlock.cbType = 103\n                   AND assignment.caGroupUid != 0\n                   AND CourseGroupSet.cgsUid = assignment.caGroupUid) AS assignmentCourseGroupSetName\n          FROM CourseBlock \n               LEFT JOIN ClazzAssignment AS Assignment\n                         ON assignment.caUid = CourseBlock.cbEntityUid\n                            AND CourseBlock.cbType = 103\n               LEFT JOIN ContentEntry AS Entry\n                         ON entry.contentEntryUid = CourseBlock.cbEntityUid\n                            AND CourseBlock.cbType = 104\n               LEFT JOIN Language\n                         ON Language.langUid = Entry.primaryLanguageUid\n                            AND CourseBlock.cbType = 104\n               LEFT JOIN CourseBlockPicture\n                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    \n         WHERE CourseBlock.cbClazzUid = ?\n           AND (CAST(? AS INTEGER) = 1 OR CourseBlock.cbActive)\n           AND (CourseBlock.cbType != 300)\n      ORDER BY CourseBlock.cbIndex\n          ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        int _tmp = includeInactive ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseBlockAndDbEntities>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseBlockAndDbEntities> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
                    int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
                    int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
                    int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
                    int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
                    int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
                    int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
                    int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
                    int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
                    int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
                    int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
                    int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
                    int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
                    int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
                    int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
                    int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
                    int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
                    int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
                    int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
                    int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
                    int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
                    int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
                    int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
                    int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
                    int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
                    int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
                    int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
                    int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
                    int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
                    int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
                    int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
                    int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
                    int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpUid");
                    int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpLct");
                    int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpPictureUri");
                    int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpThumbnailUri");
                    int _cursorIndexOfAssignmentCourseGroupSetName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"assignmentCourseGroupSetName");
                    ArrayList<CourseBlockAndDbEntities> _result2 = new ArrayList<CourseBlockAndDbEntities>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CourseBlockPicture _tmpCourseBlockPicture;
                        Language _tmpContentEntryLang;
                        ContentEntry _tmpContentEntry;
                        ClazzAssignment _tmpAssignment;
                        CourseBlock _tmpCourseBlock;
                        String _tmpAssignmentCourseGroupSetName = _cursor.isNull(_cursorIndexOfAssignmentCourseGroupSetName) ? null : _cursor.getString(_cursorIndexOfAssignmentCourseGroupSetName);
                        if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
                            long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                            int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                            int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                            long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                            String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                            String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                            int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                            long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                            long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                            int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                            long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                            Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                            Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                            int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                            long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                            String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfCbActive);
                            boolean _tmpCbActive = _tmp_1 != 0;
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfCbHidden);
                            boolean _tmpCbHidden = _tmp_2 != 0;
                            long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                            long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                            String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                            String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                            String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                            _tmpCourseBlock = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                        } else {
                            _tmpCourseBlock = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCaUid) && _cursor.isNull(_cursorIndexOfCaTitle) && _cursor.isNull(_cursorIndexOfCaDescription) && _cursor.isNull(_cursorIndexOfCaGroupUid) && _cursor.isNull(_cursorIndexOfCaActive) && _cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && _cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && _cursor.isNull(_cursorIndexOfCaCompletionCriteria) && _cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && _cursor.isNull(_cursorIndexOfCaFileType) && _cursor.isNull(_cursorIndexOfCaSizeLimit) && _cursor.isNull(_cursorIndexOfCaNumberOfFiles) && _cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && _cursor.isNull(_cursorIndexOfCaMarkingType) && _cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && _cursor.isNull(_cursorIndexOfCaTextLimitType) && _cursor.isNull(_cursorIndexOfCaTextLimit) && _cursor.isNull(_cursorIndexOfCaXObjectUid) && _cursor.isNull(_cursorIndexOfCaClazzUid) && _cursor.isNull(_cursorIndexOfCaPeerReviewerCount) && _cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaLastChangedBy) && _cursor.isNull(_cursorIndexOfCaLct))) {
                            long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                            String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                            String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                            long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfCaActive);
                            boolean _tmpCaActive = _tmp_3 != 0;
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                            boolean _tmpCaClassCommentEnabled = _tmp_4 != 0;
                            int _tmp_5 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                            boolean _tmpCaPrivateCommentsEnabled = _tmp_5 != 0;
                            int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                            int _tmp_6 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                            boolean _tmpCaRequireFileSubmission = _tmp_6 != 0;
                            int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                            int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                            int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                            int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                            int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                            int _tmp_7 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                            boolean _tmpCaRequireTextSubmission = _tmp_7 != 0;
                            int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                            int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                            long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                            long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                            int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                            long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                            long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                            int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                            long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                            _tmpAssignment = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
                        } else {
                            _tmpAssignment = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
                            _tmpContentEntry = new ContentEntry();
                            long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                            _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
                            String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                            _tmpContentEntry.setTitle(_tmpTitle);
                            String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                            _tmpContentEntry.setDescription(_tmpDescription);
                            String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                            _tmpContentEntry.setEntryId(_tmpEntryId);
                            String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                            _tmpContentEntry.setAuthor(_tmpAuthor);
                            String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                            _tmpContentEntry.setPublisher(_tmpPublisher);
                            int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                            _tmpContentEntry.setLicenseType(_tmpLicenseType);
                            String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                            _tmpContentEntry.setLicenseName(_tmpLicenseName);
                            String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                            _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
                            String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                            _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
                            String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                            _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
                            long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                            _tmpContentEntry.setLastModified(_tmpLastModified);
                            long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                            _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                            long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                            _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                            int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                            _tmpContentEntry.setContentFlags(_tmpContentFlags);
                            int _tmp_8 = _cursor.getInt(_cursorIndexOfLeaf);
                            boolean _tmpLeaf = _tmp_8 != 0;
                            _tmpContentEntry.setLeaf(_tmpLeaf);
                            int _tmp_9 = _cursor.getInt(_cursorIndexOfPublik);
                            boolean _tmpPublik = _tmp_9 != 0;
                            _tmpContentEntry.setPublik(_tmpPublik);
                            int _tmp_10 = _cursor.getInt(_cursorIndexOfCeInactive);
                            boolean _tmpCeInactive = _tmp_10 != 0;
                            _tmpContentEntry.setCeInactive(_tmpCeInactive);
                            int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                            _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
                            int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                            _tmpContentEntry.setMinScore(_tmpMinScore);
                            int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                            _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
                            long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                            _tmpContentEntry.setContentOwner(_tmpContentOwner);
                            int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                            _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
                            long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                            _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                            long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                            _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                            int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                            _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                            long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                            _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
                        } else {
                            _tmpContentEntry = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
                            _tmpContentEntryLang = new Language();
                            long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                            _tmpContentEntryLang.setLangUid(_tmpLangUid);
                            String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                            _tmpContentEntryLang.setName(_tmpName);
                            String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                            _tmpContentEntryLang.setIso_639_1_standard(_tmpIso_639_1_standard);
                            String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                            _tmpContentEntryLang.setIso_639_2_standard(_tmpIso_639_2_standard);
                            String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                            _tmpContentEntryLang.setIso_639_3_standard(_tmpIso_639_3_standard);
                            String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                            _tmpContentEntryLang.setLanguage_Type(_tmpLanguage_Type);
                            int _tmp_11 = _cursor.getInt(_cursorIndexOfLanguageActive);
                            boolean _tmpLanguageActive = _tmp_11 != 0;
                            _tmpContentEntryLang.setLanguageActive(_tmpLanguageActive);
                            long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                            _tmpContentEntryLang.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                            long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                            _tmpContentEntryLang.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                            int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                            _tmpContentEntryLang.setLangLastChangedBy(_tmpLangLastChangedBy);
                            long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                            _tmpContentEntryLang.setLangLct(_tmpLangLct);
                        } else {
                            _tmpContentEntryLang = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
                            long _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
                            long _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
                            String _tmpCbpPictureUri = _cursor.isNull(_cursorIndexOfCbpPictureUri) ? null : _cursor.getString(_cursorIndexOfCbpPictureUri);
                            String _tmpCbpThumbnailUri = _cursor.isNull(_cursorIndexOfCbpThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCbpThumbnailUri);
                            _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid, _tmpCbpLct, _tmpCbpPictureUri, _tmpCbpThumbnailUri);
                        } else {
                            _tmpCourseBlockPicture = null;
                        }
                        CourseBlockAndDbEntities _item = new CourseBlockAndDbEntities(_tmpCourseBlock, _tmpCourseBlockPicture, _tmpContentEntry, _tmpContentEntryLang, _tmpAssignment, _tmpAssignmentCourseGroupSetName);
                        _result2.add(_item);
                    }
                    ArrayList<CourseBlockAndDbEntities> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<CourseBlockAndDisplayDetails>> findAllCourseBlockByClazzUidAsFlow(long clazzUid, boolean includeInactive, boolean includeHidden, long hideUntilFilterTime, long accountPersonUid) {
        String _sql = "\n        SELECT CourseBlock.*, ContentEntry.*, CourseBlockPicture.*, ContentEntryPicture2.*\n          FROM CourseBlock\n               LEFT JOIN ContentEntry\n                         ON CourseBlock.cbType = 104\n                            AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n               LEFT JOIN CourseBlockPicture\n                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    \n               LEFT JOIN ContentEntryPicture2\n                         ON CourseBlock.cbType = 104\n                            AND ContentEntryPicture2.cepUid = CourseBlock.cbEntityUid\n         WHERE CourseBlock.cbClazzUid = ?\n           AND (CAST(? AS INTEGER) = 1 OR CourseBlock.cbActive)\n           AND (CAST(? AS INTEGER) = 1 OR NOT CourseBlock.cbHidden)\n           AND (? >= CourseBlock.cbHideUntilDate)\n           AND (? >= COALESCE(\n                (SELECT CourseBlockParent.cbHideUntilDate\n                   FROM CourseBlock CourseBlockParent\n                  WHERE CourseBlockParent.cbUid = CourseBlock.cbModuleParentBlockUid), 0))\n           AND (CourseBlock.cbType != 300)\n           AND ? = ?        \n      ORDER BY CourseBlock.cbIndex       \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseBlock.*, ContentEntry.*, CourseBlockPicture.*, ContentEntryPicture2.*\n          FROM CourseBlock\n               LEFT JOIN ContentEntry\n                         ON CourseBlock.cbType = 104\n                            AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n               LEFT JOIN CourseBlockPicture\n                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    \n               LEFT JOIN ContentEntryPicture2\n                         ON CourseBlock.cbType = 104\n                            AND ContentEntryPicture2.cepUid = CourseBlock.cbEntityUid\n         WHERE CourseBlock.cbClazzUid = ?\n           AND (CAST(? AS INTEGER) = 1 OR CourseBlock.cbActive)\n           AND (CAST(? AS INTEGER) = 1 OR NOT CourseBlock.cbHidden)\n           AND (? >= CourseBlock.cbHideUntilDate)\n           AND (? >= COALESCE(\n                (SELECT CourseBlockParent.cbHideUntilDate\n                   FROM CourseBlock CourseBlockParent\n                  WHERE CourseBlockParent.cbUid = CourseBlock.cbModuleParentBlockUid), 0))\n           AND (CourseBlock.cbType != 300)\n           AND ? = ?        \n      ORDER BY CourseBlock.cbIndex       \n    ", (int)7);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        int _tmp = includeInactive ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 3;
        int _tmp_1 = includeHidden ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 4;
        _statement.bindLong(_argIndex, hideUntilFilterTime);
        _argIndex = 5;
        _statement.bindLong(_argIndex, hideUntilFilterTime);
        _argIndex = 6;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseBlock", "ContentEntry", "CourseBlockPicture", "ContentEntryPicture2"}, (Callable)new Callable<List<CourseBlockAndDisplayDetails>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseBlockAndDisplayDetails> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpUid");
                    int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpLct");
                    int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpPictureUri");
                    int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpThumbnailUri");
                    int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepUid");
                    int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepLct");
                    int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepPictureUri");
                    int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepThumbnailUri");
                    ArrayList<CourseBlockAndDisplayDetails> _result2 = new ArrayList<CourseBlockAndDisplayDetails>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ContentEntryPicture2 _tmpContentEntryPicture2;
                        CourseBlockPicture _tmpCourseBlockPicture;
                        ContentEntry _tmpContentEntry;
                        CourseBlock _tmpCourseBlock;
                        if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
                            long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                            int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                            int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                            long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                            String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                            String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                            int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                            long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                            long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                            int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                            long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                            Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                            Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                            int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                            long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                            String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfCbActive);
                            boolean _tmpCbActive = _tmp_2 != 0;
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfCbHidden);
                            boolean _tmpCbHidden = _tmp_3 != 0;
                            long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                            long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                            String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                            String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                            String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                            _tmpCourseBlock = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                        } else {
                            _tmpCourseBlock = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
                            _tmpContentEntry = new ContentEntry();
                            long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                            _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
                            String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                            _tmpContentEntry.setTitle(_tmpTitle);
                            String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                            _tmpContentEntry.setDescription(_tmpDescription);
                            String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                            _tmpContentEntry.setEntryId(_tmpEntryId);
                            String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                            _tmpContentEntry.setAuthor(_tmpAuthor);
                            String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                            _tmpContentEntry.setPublisher(_tmpPublisher);
                            int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                            _tmpContentEntry.setLicenseType(_tmpLicenseType);
                            String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                            _tmpContentEntry.setLicenseName(_tmpLicenseName);
                            String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                            _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
                            String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                            _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
                            String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                            _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
                            long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                            _tmpContentEntry.setLastModified(_tmpLastModified);
                            long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                            _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                            long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                            _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                            int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                            _tmpContentEntry.setContentFlags(_tmpContentFlags);
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfLeaf);
                            boolean _tmpLeaf = _tmp_4 != 0;
                            _tmpContentEntry.setLeaf(_tmpLeaf);
                            int _tmp_5 = _cursor.getInt(_cursorIndexOfPublik);
                            boolean _tmpPublik = _tmp_5 != 0;
                            _tmpContentEntry.setPublik(_tmpPublik);
                            int _tmp_6 = _cursor.getInt(_cursorIndexOfCeInactive);
                            boolean _tmpCeInactive = _tmp_6 != 0;
                            _tmpContentEntry.setCeInactive(_tmpCeInactive);
                            int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                            _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
                            int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                            _tmpContentEntry.setMinScore(_tmpMinScore);
                            int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                            _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
                            long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                            _tmpContentEntry.setContentOwner(_tmpContentOwner);
                            int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                            _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
                            long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                            _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                            long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                            _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                            int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                            _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                            long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                            _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
                        } else {
                            _tmpContentEntry = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
                            long _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
                            long _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
                            String _tmpCbpPictureUri = _cursor.isNull(_cursorIndexOfCbpPictureUri) ? null : _cursor.getString(_cursorIndexOfCbpPictureUri);
                            String _tmpCbpThumbnailUri = _cursor.isNull(_cursorIndexOfCbpThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCbpThumbnailUri);
                            _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid, _tmpCbpLct, _tmpCbpPictureUri, _tmpCbpThumbnailUri);
                        } else {
                            _tmpCourseBlockPicture = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCepUid) && _cursor.isNull(_cursorIndexOfCepLct) && _cursor.isNull(_cursorIndexOfCepPictureUri) && _cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
                            long _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
                            long _tmpCepLct = _cursor.getLong(_cursorIndexOfCepLct);
                            String _tmpCepPictureUri = _cursor.isNull(_cursorIndexOfCepPictureUri) ? null : _cursor.getString(_cursorIndexOfCepPictureUri);
                            String _tmpCepThumbnailUri = _cursor.isNull(_cursorIndexOfCepThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCepThumbnailUri);
                            _tmpContentEntryPicture2 = new ContentEntryPicture2(_tmpCepUid, _tmpCepLct, _tmpCepPictureUri, _tmpCepThumbnailUri);
                        } else {
                            _tmpContentEntryPicture2 = null;
                        }
                        CourseBlockAndDisplayDetails _item = new CourseBlockAndDisplayDetails(_tmpCourseBlock, _tmpCourseBlockPicture, _tmpContentEntry, _tmpContentEntryPicture2);
                        _result2.add(_item);
                    }
                    ArrayList<CourseBlockAndDisplayDetails> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public PagingSource<Integer, CourseBlockAndDisplayDetails> findAllCourseBlockByClazzUidAsPagingSource(long clazzUid, List<Long> collapseList, boolean includeInactive, boolean includeHidden, long hideUntilFilterTime, long accountPersonUid) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT CourseBlock.*, ContentEntry.*, CourseBlockPicture.*, ContentEntryPicture2.*,");
        _stringBuilder.append("\n");
        _stringBuilder.append("               CourseBlock.cbUid NOT IN(");
        int _inputSize = collapseList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") AS expanded");
        _stringBuilder.append("\n");
        _stringBuilder.append("          FROM CourseBlock");
        _stringBuilder.append("\n");
        _stringBuilder.append("               LEFT JOIN ContentEntry");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON CourseBlock.cbType = 104");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("               LEFT JOIN CourseBlockPicture");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               LEFT JOIN ContentEntryPicture2");
        _stringBuilder.append("\n");
        _stringBuilder.append("                         ON CourseBlock.cbType = 104");
        _stringBuilder.append("\n");
        _stringBuilder.append("                            AND ContentEntryPicture2.cepUid = CourseBlock.cbEntityUid");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE CourseBlock.cbClazzUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND CourseBlock.cbModuleParentBlockUid NOT IN(");
        int _inputSize_1 = collapseList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (CAST(");
        _stringBuilder.append("?");
        _stringBuilder.append(" AS INTEGER) = 1 OR CourseBlock.cbActive)");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (CAST(");
        _stringBuilder.append("?");
        _stringBuilder.append(" AS INTEGER) = 1 OR NOT CourseBlock.cbHidden)");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (");
        _stringBuilder.append("?");
        _stringBuilder.append(" >= CourseBlock.cbHideUntilDate)");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (");
        _stringBuilder.append("?");
        _stringBuilder.append(" >= COALESCE(");
        _stringBuilder.append("\n");
        _stringBuilder.append("                (SELECT CourseBlockParent.cbHideUntilDate");
        _stringBuilder.append("\n");
        _stringBuilder.append("                   FROM CourseBlock CourseBlockParent");
        _stringBuilder.append("\n");
        _stringBuilder.append("                  WHERE CourseBlockParent.cbUid = CourseBlock.cbModuleParentBlockUid), 0))");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND (CourseBlock.cbType != 300) ");
        _stringBuilder.append("\n");
        _stringBuilder.append("           AND ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = ");
        _stringBuilder.append("?");
        _stringBuilder.append("       ");
        _stringBuilder.append("\n");
        _stringBuilder.append("      ORDER BY CourseBlock.cbIndex       ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 7 + _inputSize + _inputSize_1;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : collapseList) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2 + _inputSize;
        for (long _item_1 : collapseList) {
            _statement.bindLong(_argIndex, _item_1);
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize + _inputSize;
        int _tmp = includeInactive ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 3 + _inputSize + _inputSize;
        int _tmp_1 = includeHidden ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 4 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, hideUntilFilterTime);
        _argIndex = 5 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, hideUntilFilterTime);
        _argIndex = 6 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 7 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, accountPersonUid);
        return new LimitOffsetPagingSource<CourseBlockAndDisplayDetails>(_statement, this.__db, new String[]{"CourseBlock", "ContentEntry", "CourseBlockPicture", "ContentEntryPicture2"}){

            @NonNull
            protected List<CourseBlockAndDisplayDetails> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbUid");
                int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbType");
                int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbIndentLevel");
                int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbModuleParentBlockUid");
                int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbTitle");
                int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbDescription");
                int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbCompletionCriteria");
                int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbHideUntilDate");
                int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbDeadlineDate");
                int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbLateSubmissionPenalty");
                int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbGracePeriodDate");
                int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbMaxPoints");
                int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbMinPoints");
                int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbIndex");
                int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbClazzUid");
                int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbClazzSourcedId");
                int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbActive");
                int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbHidden");
                int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbEntityUid");
                int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbLct");
                int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbSourcedId");
                int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbMetadata");
                int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbCreatedByAppId");
                int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryUid");
                int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"title");
                int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"description");
                int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"entryId");
                int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"author");
                int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publisher");
                int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseType");
                int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseName");
                int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"licenseUrl");
                int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"sourceUrl");
                int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"thumbnailUrl");
                int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastModified");
                int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"primaryLanguageUid");
                int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"languageVariantUid");
                int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentFlags");
                int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"leaf");
                int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"publik");
                int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"ceInactive");
                int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"completionCriteria");
                int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"minScore");
                int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentTypeFlag");
                int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwner");
                int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentOwnerType");
                int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLocalChangeSeqNum");
                int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryMasterChangeSeqNum");
                int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLastChangedBy");
                int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contentEntryLct");
                int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbpUid");
                int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbpLct");
                int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbpPictureUri");
                int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cbpThumbnailUri");
                int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepUid");
                int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepLct");
                int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepPictureUri");
                int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"cepThumbnailUri");
                ArrayList<CourseBlockAndDisplayDetails> _result2 = new ArrayList<CourseBlockAndDisplayDetails>(cursor.getCount());
                while (cursor.moveToNext()) {
                    ContentEntryPicture2 _tmpContentEntryPicture2;
                    CourseBlockPicture _tmpCourseBlockPicture;
                    ContentEntry _tmpContentEntry;
                    CourseBlock _tmpCourseBlock;
                    if (!(cursor.isNull(_cursorIndexOfCbUid) && cursor.isNull(_cursorIndexOfCbType) && cursor.isNull(_cursorIndexOfCbIndentLevel) && cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && cursor.isNull(_cursorIndexOfCbTitle) && cursor.isNull(_cursorIndexOfCbDescription) && cursor.isNull(_cursorIndexOfCbCompletionCriteria) && cursor.isNull(_cursorIndexOfCbHideUntilDate) && cursor.isNull(_cursorIndexOfCbDeadlineDate) && cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && cursor.isNull(_cursorIndexOfCbGracePeriodDate) && cursor.isNull(_cursorIndexOfCbMaxPoints) && cursor.isNull(_cursorIndexOfCbMinPoints) && cursor.isNull(_cursorIndexOfCbIndex) && cursor.isNull(_cursorIndexOfCbClazzUid) && cursor.isNull(_cursorIndexOfCbClazzSourcedId) && cursor.isNull(_cursorIndexOfCbActive) && cursor.isNull(_cursorIndexOfCbHidden) && cursor.isNull(_cursorIndexOfCbEntityUid) && cursor.isNull(_cursorIndexOfCbLct) && cursor.isNull(_cursorIndexOfCbSourcedId) && cursor.isNull(_cursorIndexOfCbMetadata) && cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
                        long _tmpCbUid = cursor.getLong(_cursorIndexOfCbUid);
                        int _tmpCbType = cursor.getInt(_cursorIndexOfCbType);
                        int _tmpCbIndentLevel = cursor.getInt(_cursorIndexOfCbIndentLevel);
                        long _tmpCbModuleParentBlockUid = cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                        String _tmpCbTitle = cursor.isNull(_cursorIndexOfCbTitle) ? null : cursor.getString(_cursorIndexOfCbTitle);
                        String _tmpCbDescription = cursor.isNull(_cursorIndexOfCbDescription) ? null : cursor.getString(_cursorIndexOfCbDescription);
                        int _tmpCbCompletionCriteria = cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                        long _tmpCbHideUntilDate = cursor.getLong(_cursorIndexOfCbHideUntilDate);
                        long _tmpCbDeadlineDate = cursor.getLong(_cursorIndexOfCbDeadlineDate);
                        int _tmpCbLateSubmissionPenalty = cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                        long _tmpCbGracePeriodDate = cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                        Float _tmpCbMaxPoints = cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfCbMaxPoints));
                        Float _tmpCbMinPoints = cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(cursor.getFloat(_cursorIndexOfCbMinPoints));
                        int _tmpCbIndex = cursor.getInt(_cursorIndexOfCbIndex);
                        long _tmpCbClazzUid = cursor.getLong(_cursorIndexOfCbClazzUid);
                        String _tmpCbClazzSourcedId = cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : cursor.getString(_cursorIndexOfCbClazzSourcedId);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfCbActive);
                        boolean _tmpCbActive = _tmp_2 != 0;
                        int _tmp_3 = cursor.getInt(_cursorIndexOfCbHidden);
                        boolean _tmpCbHidden = _tmp_3 != 0;
                        long _tmpCbEntityUid = cursor.getLong(_cursorIndexOfCbEntityUid);
                        long _tmpCbLct = cursor.getLong(_cursorIndexOfCbLct);
                        String _tmpCbSourcedId = cursor.isNull(_cursorIndexOfCbSourcedId) ? null : cursor.getString(_cursorIndexOfCbSourcedId);
                        String _tmpCbMetadata = cursor.isNull(_cursorIndexOfCbMetadata) ? null : cursor.getString(_cursorIndexOfCbMetadata);
                        String _tmpCbCreatedByAppId = cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : cursor.getString(_cursorIndexOfCbCreatedByAppId);
                        _tmpCourseBlock = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                    } else {
                        _tmpCourseBlock = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfContentEntryUid) && cursor.isNull(_cursorIndexOfTitle) && cursor.isNull(_cursorIndexOfDescription) && cursor.isNull(_cursorIndexOfEntryId) && cursor.isNull(_cursorIndexOfAuthor) && cursor.isNull(_cursorIndexOfPublisher) && cursor.isNull(_cursorIndexOfLicenseType) && cursor.isNull(_cursorIndexOfLicenseName) && cursor.isNull(_cursorIndexOfLicenseUrl) && cursor.isNull(_cursorIndexOfSourceUrl) && cursor.isNull(_cursorIndexOfThumbnailUrl) && cursor.isNull(_cursorIndexOfLastModified) && cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && cursor.isNull(_cursorIndexOfLanguageVariantUid) && cursor.isNull(_cursorIndexOfContentFlags) && cursor.isNull(_cursorIndexOfLeaf) && cursor.isNull(_cursorIndexOfPublik) && cursor.isNull(_cursorIndexOfCeInactive) && cursor.isNull(_cursorIndexOfCompletionCriteria) && cursor.isNull(_cursorIndexOfMinScore) && cursor.isNull(_cursorIndexOfContentTypeFlag) && cursor.isNull(_cursorIndexOfContentOwner) && cursor.isNull(_cursorIndexOfContentOwnerType) && cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && cursor.isNull(_cursorIndexOfContentEntryLct))) {
                        _tmpContentEntry = new ContentEntry();
                        long _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
                        _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
                        String _tmpTitle = cursor.isNull(_cursorIndexOfTitle) ? null : cursor.getString(_cursorIndexOfTitle);
                        _tmpContentEntry.setTitle(_tmpTitle);
                        String _tmpDescription = cursor.isNull(_cursorIndexOfDescription) ? null : cursor.getString(_cursorIndexOfDescription);
                        _tmpContentEntry.setDescription(_tmpDescription);
                        String _tmpEntryId = cursor.isNull(_cursorIndexOfEntryId) ? null : cursor.getString(_cursorIndexOfEntryId);
                        _tmpContentEntry.setEntryId(_tmpEntryId);
                        String _tmpAuthor = cursor.isNull(_cursorIndexOfAuthor) ? null : cursor.getString(_cursorIndexOfAuthor);
                        _tmpContentEntry.setAuthor(_tmpAuthor);
                        String _tmpPublisher = cursor.isNull(_cursorIndexOfPublisher) ? null : cursor.getString(_cursorIndexOfPublisher);
                        _tmpContentEntry.setPublisher(_tmpPublisher);
                        int _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
                        _tmpContentEntry.setLicenseType(_tmpLicenseType);
                        String _tmpLicenseName = cursor.isNull(_cursorIndexOfLicenseName) ? null : cursor.getString(_cursorIndexOfLicenseName);
                        _tmpContentEntry.setLicenseName(_tmpLicenseName);
                        String _tmpLicenseUrl = cursor.isNull(_cursorIndexOfLicenseUrl) ? null : cursor.getString(_cursorIndexOfLicenseUrl);
                        _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
                        String _tmpSourceUrl = cursor.isNull(_cursorIndexOfSourceUrl) ? null : cursor.getString(_cursorIndexOfSourceUrl);
                        _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
                        String _tmpThumbnailUrl = cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : cursor.getString(_cursorIndexOfThumbnailUrl);
                        _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
                        long _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
                        _tmpContentEntry.setLastModified(_tmpLastModified);
                        long _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                        _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                        long _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
                        _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                        int _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
                        _tmpContentEntry.setContentFlags(_tmpContentFlags);
                        int _tmp_4 = cursor.getInt(_cursorIndexOfLeaf);
                        boolean _tmpLeaf = _tmp_4 != 0;
                        _tmpContentEntry.setLeaf(_tmpLeaf);
                        int _tmp_5 = cursor.getInt(_cursorIndexOfPublik);
                        boolean _tmpPublik = _tmp_5 != 0;
                        _tmpContentEntry.setPublik(_tmpPublik);
                        int _tmp_6 = cursor.getInt(_cursorIndexOfCeInactive);
                        boolean _tmpCeInactive = _tmp_6 != 0;
                        _tmpContentEntry.setCeInactive(_tmpCeInactive);
                        int _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
                        _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
                        int _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
                        _tmpContentEntry.setMinScore(_tmpMinScore);
                        int _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
                        _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
                        long _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
                        _tmpContentEntry.setContentOwner(_tmpContentOwner);
                        int _tmpContentOwnerType = cursor.getInt(_cursorIndexOfContentOwnerType);
                        _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
                        long _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                        _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                        long _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                        _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                        int _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                        _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                        long _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
                        _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
                    } else {
                        _tmpContentEntry = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCbpUid) && cursor.isNull(_cursorIndexOfCbpLct) && cursor.isNull(_cursorIndexOfCbpPictureUri) && cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
                        long _tmpCbpUid = cursor.getLong(_cursorIndexOfCbpUid);
                        long _tmpCbpLct = cursor.getLong(_cursorIndexOfCbpLct);
                        String _tmpCbpPictureUri = cursor.isNull(_cursorIndexOfCbpPictureUri) ? null : cursor.getString(_cursorIndexOfCbpPictureUri);
                        String _tmpCbpThumbnailUri = cursor.isNull(_cursorIndexOfCbpThumbnailUri) ? null : cursor.getString(_cursorIndexOfCbpThumbnailUri);
                        _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid, _tmpCbpLct, _tmpCbpPictureUri, _tmpCbpThumbnailUri);
                    } else {
                        _tmpCourseBlockPicture = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfCepUid) && cursor.isNull(_cursorIndexOfCepLct) && cursor.isNull(_cursorIndexOfCepPictureUri) && cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
                        long _tmpCepUid = cursor.getLong(_cursorIndexOfCepUid);
                        long _tmpCepLct = cursor.getLong(_cursorIndexOfCepLct);
                        String _tmpCepPictureUri = cursor.isNull(_cursorIndexOfCepPictureUri) ? null : cursor.getString(_cursorIndexOfCepPictureUri);
                        String _tmpCepThumbnailUri = cursor.isNull(_cursorIndexOfCepThumbnailUri) ? null : cursor.getString(_cursorIndexOfCepThumbnailUri);
                        _tmpContentEntryPicture2 = new ContentEntryPicture2(_tmpCepUid, _tmpCepLct, _tmpCepPictureUri, _tmpCepThumbnailUri);
                    } else {
                        _tmpContentEntryPicture2 = null;
                    }
                    CourseBlockAndDisplayDetails _item_2 = new CourseBlockAndDisplayDetails(_tmpCourseBlock, _tmpCourseBlockPicture, _tmpContentEntry, _tmpContentEntryPicture2);
                    _result2.add(_item_2);
                }
                return _result2;
            }
        };
    }

    @Override
    public Flow<String> getTitleByAssignmentUid(long assignmentUid) {
        String _sql = "\n        SELECT CourseBlock.cbTitle\n          FROM CourseBlock \n         WHERE CourseBlock.cbEntityUid = ?\n           AND CourseBlock.cbType = 103\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseBlock.cbTitle\n          FROM CourseBlock \n         WHERE CourseBlock.cbEntityUid = ?\n           AND CourseBlock.cbType = 103\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseBlock"}, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    String _result2 = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result2;
                    return string;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<CourseBlock> findByUidAsFlow(long courseBlockUid) {
        String _sql = "\n        SELECT CourseBlock.*\n          FROM CourseBlock\n         WHERE CourseBlock.cbUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseBlock.*\n          FROM CourseBlock\n         WHERE CourseBlock.cbUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, courseBlockUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseBlock"}, (Callable)new Callable<CourseBlock>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseBlock call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CourseBlock _result2;
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    if (_cursor.moveToFirst()) {
                        long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                        int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                        int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                        long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                        String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                        String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                        int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                        long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                        long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                        int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                        long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                        Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                        Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                        int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                        long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                        String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                        int _tmp = _cursor.getInt(_cursorIndexOfCbActive);
                        boolean _tmpCbActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
                        boolean _tmpCbHidden = _tmp_1 != 0;
                        long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                        long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                        String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                        String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                        String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                        _result2 = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                    } else {
                        _result2 = null;
                    }
                    CourseBlock courseBlock = _result2;
                    return courseBlock;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findCourseBlockAndClazzUidByDiscussionPostUid(long postUid, Continuation<? super CourseBlockUidAndClazzUid> $completion) {
        String _sql = "\n        SELECT COALESCE(CourseBlock.cbUid, 0) AS courseBlockUid,\n               COALESCE(CourseBlock.cbClazzUid, 0) AS clazzUid\n          FROM CourseBlock\n         WHERE CourseBlock.cbUid = \n               (SELECT DiscussionPost.discussionPostCourseBlockUid \n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostUid = ?)\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COALESCE(CourseBlock.cbUid, 0) AS courseBlockUid,\n               COALESCE(CourseBlock.cbClazzUid, 0) AS clazzUid\n          FROM CourseBlock\n         WHERE CourseBlock.cbUid = \n               (SELECT DiscussionPost.discussionPostCourseBlockUid \n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostUid = ?)\n         LIMIT 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, postUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseBlockUidAndClazzUid>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseBlockUidAndClazzUid call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseBlockUidAndClazzUid _result2;
                    boolean _cursorIndexOfCourseBlockUid = false;
                    boolean _cursorIndexOfClazzUid = true;
                    if (_cursor.moveToFirst()) {
                        long _tmpCourseBlockUid = _cursor.getLong(0);
                        long _tmpClazzUid = _cursor.getLong(1);
                        _result2 = new CourseBlockUidAndClazzUid(_tmpClazzUid, _tmpCourseBlockUid);
                    } else {
                        _result2 = null;
                    }
                    CourseBlockUidAndClazzUid courseBlockUidAndClazzUid = _result2;
                    return courseBlockUidAndClazzUid;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findCourseBlockByDiscussionPostUid(long postUid, Continuation<? super CourseBlock> $completion) {
        String _sql = "\n        SELECT CourseBlock.*\n          FROM CourseBlock\n         WHERE CourseBlock.cbUid = \n               (SELECT DiscussionPost.discussionPostCourseBlockUid \n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostUid = ?) \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseBlock.*\n          FROM CourseBlock\n         WHERE CourseBlock.cbUid = \n               (SELECT DiscussionPost.discussionPostCourseBlockUid \n                  FROM DiscussionPost\n                 WHERE DiscussionPost.discussionPostUid = ?) \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, postUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseBlock>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseBlock call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseBlock _result2;
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    if (_cursor.moveToFirst()) {
                        long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                        int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                        int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                        long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                        String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                        String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                        int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                        long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                        long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                        int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                        long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                        Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                        Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                        int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                        long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                        String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                        int _tmp = _cursor.getInt(_cursorIndexOfCbActive);
                        boolean _tmpCbActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
                        boolean _tmpCbHidden = _tmp_1 != 0;
                        long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                        long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                        String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                        String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                        String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                        _result2 = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                    } else {
                        _result2 = null;
                    }
                    CourseBlock courseBlock = _result2;
                    return courseBlock;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findClazzUidByCourseBlockUid(long courseBlockUid, Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT COALESCE(CourseBlock.cbClazzUid, 0) AS clazzUid\n          FROM CourseBlock\n         WHERE CourseBlock.cbUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COALESCE(CourseBlock.cbClazzUid, 0) AS clazzUid\n          FROM CourseBlock\n         WHERE CourseBlock.cbUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, courseBlockUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<CourseBlockAndAssignment> findCourseBlockByAssignmentUid(long assignmentUid) {
        String _sql = "\n        SELECT ClazzAssignment.*, CourseBlock.* \n          FROM ClazzAssignment\n               JOIN CourseBlock \n                    ON CourseBlock.cbEntityUid = ?\n         WHERE ClazzAssignment.caUid = ?\n         LIMIT 1 \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzAssignment.*, CourseBlock.* \n          FROM ClazzAssignment\n               JOIN CourseBlock \n                    ON CourseBlock.cbEntityUid = ?\n         WHERE ClazzAssignment.caUid = ?\n         LIMIT 1 \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, assignmentUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzAssignment", "CourseBlock"}, (Callable)new Callable<CourseBlockAndAssignment>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseBlockAndAssignment call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CourseBlockAndAssignment _result2;
                    int _cursorIndexOfCaUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caUid");
                    int _cursorIndexOfCaTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTitle");
                    int _cursorIndexOfCaDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caDescription");
                    int _cursorIndexOfCaGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caGroupUid");
                    int _cursorIndexOfCaActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caActive");
                    int _cursorIndexOfCaClassCommentEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClassCommentEnabled");
                    int _cursorIndexOfCaPrivateCommentsEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPrivateCommentsEnabled");
                    int _cursorIndexOfCaCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caCompletionCriteria");
                    int _cursorIndexOfCaRequireFileSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireFileSubmission");
                    int _cursorIndexOfCaFileType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caFileType");
                    int _cursorIndexOfCaSizeLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSizeLimit");
                    int _cursorIndexOfCaNumberOfFiles = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caNumberOfFiles");
                    int _cursorIndexOfCaSubmissionPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caSubmissionPolicy");
                    int _cursorIndexOfCaMarkingType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMarkingType");
                    int _cursorIndexOfCaRequireTextSubmission = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caRequireTextSubmission");
                    int _cursorIndexOfCaTextLimitType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimitType");
                    int _cursorIndexOfCaTextLimit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caTextLimit");
                    int _cursorIndexOfCaXObjectUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caXObjectUid");
                    int _cursorIndexOfCaClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caClazzUid");
                    int _cursorIndexOfCaPeerReviewerCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caPeerReviewerCount");
                    int _cursorIndexOfCaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLocalChangeSeqNum");
                    int _cursorIndexOfCaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caMasterChangeSeqNum");
                    int _cursorIndexOfCaLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLastChangedBy");
                    int _cursorIndexOfCaLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"caLct");
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    if (_cursor.moveToFirst()) {
                        CourseBlock _tmpCourseBlock;
                        ClazzAssignment _tmpAssignment;
                        if (!(_cursor.isNull(_cursorIndexOfCaUid) && _cursor.isNull(_cursorIndexOfCaTitle) && _cursor.isNull(_cursorIndexOfCaDescription) && _cursor.isNull(_cursorIndexOfCaGroupUid) && _cursor.isNull(_cursorIndexOfCaActive) && _cursor.isNull(_cursorIndexOfCaClassCommentEnabled) && _cursor.isNull(_cursorIndexOfCaPrivateCommentsEnabled) && _cursor.isNull(_cursorIndexOfCaCompletionCriteria) && _cursor.isNull(_cursorIndexOfCaRequireFileSubmission) && _cursor.isNull(_cursorIndexOfCaFileType) && _cursor.isNull(_cursorIndexOfCaSizeLimit) && _cursor.isNull(_cursorIndexOfCaNumberOfFiles) && _cursor.isNull(_cursorIndexOfCaSubmissionPolicy) && _cursor.isNull(_cursorIndexOfCaMarkingType) && _cursor.isNull(_cursorIndexOfCaRequireTextSubmission) && _cursor.isNull(_cursorIndexOfCaTextLimitType) && _cursor.isNull(_cursorIndexOfCaTextLimit) && _cursor.isNull(_cursorIndexOfCaXObjectUid) && _cursor.isNull(_cursorIndexOfCaClazzUid) && _cursor.isNull(_cursorIndexOfCaPeerReviewerCount) && _cursor.isNull(_cursorIndexOfCaLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCaLastChangedBy) && _cursor.isNull(_cursorIndexOfCaLct))) {
                            long _tmpCaUid = _cursor.getLong(_cursorIndexOfCaUid);
                            String _tmpCaTitle = _cursor.isNull(_cursorIndexOfCaTitle) ? null : _cursor.getString(_cursorIndexOfCaTitle);
                            String _tmpCaDescription = _cursor.isNull(_cursorIndexOfCaDescription) ? null : _cursor.getString(_cursorIndexOfCaDescription);
                            long _tmpCaGroupUid = _cursor.getLong(_cursorIndexOfCaGroupUid);
                            int _tmp = _cursor.getInt(_cursorIndexOfCaActive);
                            boolean _tmpCaActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfCaClassCommentEnabled);
                            boolean _tmpCaClassCommentEnabled = _tmp_1 != 0;
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfCaPrivateCommentsEnabled);
                            boolean _tmpCaPrivateCommentsEnabled = _tmp_2 != 0;
                            int _tmpCaCompletionCriteria = _cursor.getInt(_cursorIndexOfCaCompletionCriteria);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfCaRequireFileSubmission);
                            boolean _tmpCaRequireFileSubmission = _tmp_3 != 0;
                            int _tmpCaFileType = _cursor.getInt(_cursorIndexOfCaFileType);
                            int _tmpCaSizeLimit = _cursor.getInt(_cursorIndexOfCaSizeLimit);
                            int _tmpCaNumberOfFiles = _cursor.getInt(_cursorIndexOfCaNumberOfFiles);
                            int _tmpCaSubmissionPolicy = _cursor.getInt(_cursorIndexOfCaSubmissionPolicy);
                            int _tmpCaMarkingType = _cursor.getInt(_cursorIndexOfCaMarkingType);
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfCaRequireTextSubmission);
                            boolean _tmpCaRequireTextSubmission = _tmp_4 != 0;
                            int _tmpCaTextLimitType = _cursor.getInt(_cursorIndexOfCaTextLimitType);
                            int _tmpCaTextLimit = _cursor.getInt(_cursorIndexOfCaTextLimit);
                            long _tmpCaXObjectUid = _cursor.getLong(_cursorIndexOfCaXObjectUid);
                            long _tmpCaClazzUid = _cursor.getLong(_cursorIndexOfCaClazzUid);
                            int _tmpCaPeerReviewerCount = _cursor.getInt(_cursorIndexOfCaPeerReviewerCount);
                            long _tmpCaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCaLocalChangeSeqNum);
                            long _tmpCaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCaMasterChangeSeqNum);
                            int _tmpCaLastChangedBy = _cursor.getInt(_cursorIndexOfCaLastChangedBy);
                            long _tmpCaLct = _cursor.getLong(_cursorIndexOfCaLct);
                            _tmpAssignment = new ClazzAssignment(_tmpCaUid, _tmpCaTitle, _tmpCaDescription, _tmpCaGroupUid, _tmpCaActive, _tmpCaClassCommentEnabled, _tmpCaPrivateCommentsEnabled, _tmpCaCompletionCriteria, _tmpCaRequireFileSubmission, _tmpCaFileType, _tmpCaSizeLimit, _tmpCaNumberOfFiles, _tmpCaSubmissionPolicy, _tmpCaMarkingType, _tmpCaRequireTextSubmission, _tmpCaTextLimitType, _tmpCaTextLimit, _tmpCaXObjectUid, _tmpCaClazzUid, _tmpCaPeerReviewerCount, _tmpCaLocalChangeSeqNum, _tmpCaMasterChangeSeqNum, _tmpCaLastChangedBy, _tmpCaLct);
                        } else {
                            _tmpAssignment = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
                            long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                            int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                            int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                            long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                            String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                            String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                            int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                            long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                            long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                            int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                            long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                            Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                            Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                            int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                            long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                            String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                            int _tmp_5 = _cursor.getInt(_cursorIndexOfCbActive);
                            boolean _tmpCbActive = _tmp_5 != 0;
                            int _tmp_6 = _cursor.getInt(_cursorIndexOfCbHidden);
                            boolean _tmpCbHidden = _tmp_6 != 0;
                            long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                            long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                            String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                            String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                            String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                            _tmpCourseBlock = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                        } else {
                            _tmpCourseBlock = null;
                        }
                        _result2 = new CourseBlockAndAssignment(_tmpCourseBlock, _tmpAssignment);
                    } else {
                        _result2 = null;
                    }
                    CourseBlockAndAssignment courseBlockAndAssignment = _result2;
                    return courseBlockAndAssignment;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findBySourcedId(String sourcedId, long accountPersonUid, Continuation<? super CourseBlock> $completion) {
        String _sql = "\n            SELECT CourseBlock.*\n              FROM CourseBlock\n             WHERE CAST(cbUid AS TEXT) = ?\n                OR cbSourcedId = ?\n               AND ? != 0 \n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n            SELECT CourseBlock.*\n              FROM CourseBlock\n             WHERE CAST(cbUid AS TEXT) = ?\n                OR cbSourcedId = ?\n               AND ? != 0 \n        ", (int)3);
        int _argIndex = 1;
        _statement.bindString(_argIndex, sourcedId);
        _argIndex = 2;
        _statement.bindString(_argIndex, sourcedId);
        _argIndex = 3;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseBlock>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseBlock call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseBlock _result2;
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    if (_cursor.moveToFirst()) {
                        long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                        int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                        int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                        long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                        String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                        String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                        int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                        long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                        long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                        int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                        long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                        Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                        Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                        int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                        long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                        String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                        int _tmp = _cursor.getInt(_cursorIndexOfCbActive);
                        boolean _tmpCbActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
                        boolean _tmpCbHidden = _tmp_1 != 0;
                        long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                        long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                        String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                        String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                        String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                        _result2 = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                    } else {
                        _result2 = null;
                    }
                    CourseBlock courseBlock = _result2;
                    return courseBlock;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByClazzUid(long clazzUid, Continuation<? super List<CourseBlock>> $completion) {
        String _sql = "\n        SELECT CourseBlock.*\n          FROM CourseBlock\n         WHERE CourseBlock.cbClazzUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseBlock.*\n          FROM CourseBlock\n         WHERE CourseBlock.cbClazzUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseBlock>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseBlock> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    ArrayList<CourseBlock> _result2 = new ArrayList<CourseBlock>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                        int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                        int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                        long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                        String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                        String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                        int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                        long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                        long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                        int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                        long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                        Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                        Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                        int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                        long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                        String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                        int _tmp = _cursor.getInt(_cursorIndexOfCbActive);
                        boolean _tmpCbActive = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
                        boolean _tmpCbHidden = _tmp_1 != 0;
                        long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                        long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                        String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                        String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                        String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                        CourseBlock _item = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                        _result2.add(_item);
                    }
                    ArrayList<CourseBlock> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<CourseBlockAndGradebookDisplayDetails>> findByClazzUidAsFlow(long clazzUid) {
        String _sql = "\n        SELECT CourseBlock.*, ContentEntry.*, CourseBlockPicture.*, ContentEntryPicture2.*\n          FROM CourseBlock\n               LEFT JOIN ContentEntry\n                         ON CourseBlock.cbType = 104\n                            AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n               LEFT JOIN CourseBlockPicture\n                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    \n               LEFT JOIN ContentEntryPicture2\n                         ON CourseBlock.cbType = 104\n                            AND ContentEntryPicture2.cepUid = CourseBlock.cbEntityUid\n         WHERE CourseBlock.cbClazzUid = ?\n           AND CAST(CourseBlock.cbActive AS INTEGER) = 1\n      ORDER BY CourseBlock.cbIndex\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseBlock.*, ContentEntry.*, CourseBlockPicture.*, ContentEntryPicture2.*\n          FROM CourseBlock\n               LEFT JOIN ContentEntry\n                         ON CourseBlock.cbType = 104\n                            AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n               LEFT JOIN CourseBlockPicture\n                         ON CourseBlockPicture.cbpUid = CourseBlock.cbUid    \n               LEFT JOIN ContentEntryPicture2\n                         ON CourseBlock.cbType = 104\n                            AND ContentEntryPicture2.cepUid = CourseBlock.cbEntityUid\n         WHERE CourseBlock.cbClazzUid = ?\n           AND CAST(CourseBlock.cbActive AS INTEGER) = 1\n      ORDER BY CourseBlock.cbIndex\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"CourseBlock", "ContentEntry", "CourseBlockPicture", "ContentEntryPicture2"}, (Callable)new Callable<List<CourseBlockAndGradebookDisplayDetails>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseBlockAndGradebookDisplayDetails> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbUid");
                    int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbType");
                    int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndentLevel");
                    int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbModuleParentBlockUid");
                    int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbTitle");
                    int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDescription");
                    int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCompletionCriteria");
                    int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHideUntilDate");
                    int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbDeadlineDate");
                    int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLateSubmissionPenalty");
                    int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbGracePeriodDate");
                    int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMaxPoints");
                    int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMinPoints");
                    int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbIndex");
                    int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzUid");
                    int _cursorIndexOfCbClazzSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbClazzSourcedId");
                    int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbActive");
                    int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbHidden");
                    int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbEntityUid");
                    int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbLct");
                    int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbSourcedId");
                    int _cursorIndexOfCbMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbMetadata");
                    int _cursorIndexOfCbCreatedByAppId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbCreatedByAppId");
                    int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryUid");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"entryId");
                    int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"author");
                    int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publisher");
                    int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseType");
                    int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseName");
                    int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"licenseUrl");
                    int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUrl");
                    int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailUrl");
                    int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastModified");
                    int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryLanguageUid");
                    int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageVariantUid");
                    int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentFlags");
                    int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaf");
                    int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publik");
                    int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ceInactive");
                    int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"completionCriteria");
                    int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minScore");
                    int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentTypeFlag");
                    int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwner");
                    int _cursorIndexOfContentOwnerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentOwnerType");
                    int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLocalChangeSeqNum");
                    int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryMasterChangeSeqNum");
                    int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLastChangedBy");
                    int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contentEntryLct");
                    int _cursorIndexOfCbpUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpUid");
                    int _cursorIndexOfCbpLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpLct");
                    int _cursorIndexOfCbpPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpPictureUri");
                    int _cursorIndexOfCbpThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cbpThumbnailUri");
                    int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepUid");
                    int _cursorIndexOfCepLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepLct");
                    int _cursorIndexOfCepPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepPictureUri");
                    int _cursorIndexOfCepThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cepThumbnailUri");
                    ArrayList<CourseBlockAndGradebookDisplayDetails> _result2 = new ArrayList<CourseBlockAndGradebookDisplayDetails>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ContentEntryPicture2 _tmpContentEntryPicture2;
                        CourseBlockPicture _tmpCourseBlockPicture;
                        ContentEntry _tmpContentEntry;
                        CourseBlock _tmpBlock;
                        if (!(_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbClazzSourcedId) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct) && _cursor.isNull(_cursorIndexOfCbSourcedId) && _cursor.isNull(_cursorIndexOfCbMetadata) && _cursor.isNull(_cursorIndexOfCbCreatedByAppId))) {
                            long _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
                            int _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
                            int _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
                            long _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
                            String _tmpCbTitle = _cursor.isNull(_cursorIndexOfCbTitle) ? null : _cursor.getString(_cursorIndexOfCbTitle);
                            String _tmpCbDescription = _cursor.isNull(_cursorIndexOfCbDescription) ? null : _cursor.getString(_cursorIndexOfCbDescription);
                            int _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
                            long _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
                            long _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
                            int _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
                            long _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
                            Float _tmpCbMaxPoints = _cursor.isNull(_cursorIndexOfCbMaxPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMaxPoints));
                            Float _tmpCbMinPoints = _cursor.isNull(_cursorIndexOfCbMinPoints) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfCbMinPoints));
                            int _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
                            long _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
                            String _tmpCbClazzSourcedId = _cursor.isNull(_cursorIndexOfCbClazzSourcedId) ? null : _cursor.getString(_cursorIndexOfCbClazzSourcedId);
                            int _tmp = _cursor.getInt(_cursorIndexOfCbActive);
                            boolean _tmpCbActive = _tmp != 0;
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfCbHidden);
                            boolean _tmpCbHidden = _tmp_1 != 0;
                            long _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
                            long _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
                            String _tmpCbSourcedId = _cursor.isNull(_cursorIndexOfCbSourcedId) ? null : _cursor.getString(_cursorIndexOfCbSourcedId);
                            String _tmpCbMetadata = _cursor.isNull(_cursorIndexOfCbMetadata) ? null : _cursor.getString(_cursorIndexOfCbMetadata);
                            String _tmpCbCreatedByAppId = _cursor.isNull(_cursorIndexOfCbCreatedByAppId) ? null : _cursor.getString(_cursorIndexOfCbCreatedByAppId);
                            _tmpBlock = new CourseBlock(_tmpCbUid, _tmpCbType, _tmpCbIndentLevel, _tmpCbModuleParentBlockUid, _tmpCbTitle, _tmpCbDescription, _tmpCbCompletionCriteria, _tmpCbHideUntilDate, _tmpCbDeadlineDate, _tmpCbLateSubmissionPenalty, _tmpCbGracePeriodDate, _tmpCbMaxPoints, _tmpCbMinPoints, _tmpCbIndex, _tmpCbClazzUid, _tmpCbClazzSourcedId, _tmpCbActive, _tmpCbHidden, _tmpCbEntityUid, _tmpCbLct, _tmpCbSourcedId, _tmpCbMetadata, _tmpCbCreatedByAppId);
                        } else {
                            _tmpBlock = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfContentEntryUid) && _cursor.isNull(_cursorIndexOfTitle) && _cursor.isNull(_cursorIndexOfDescription) && _cursor.isNull(_cursorIndexOfEntryId) && _cursor.isNull(_cursorIndexOfAuthor) && _cursor.isNull(_cursorIndexOfPublisher) && _cursor.isNull(_cursorIndexOfLicenseType) && _cursor.isNull(_cursorIndexOfLicenseName) && _cursor.isNull(_cursorIndexOfLicenseUrl) && _cursor.isNull(_cursorIndexOfSourceUrl) && _cursor.isNull(_cursorIndexOfThumbnailUrl) && _cursor.isNull(_cursorIndexOfLastModified) && _cursor.isNull(_cursorIndexOfPrimaryLanguageUid) && _cursor.isNull(_cursorIndexOfLanguageVariantUid) && _cursor.isNull(_cursorIndexOfContentFlags) && _cursor.isNull(_cursorIndexOfLeaf) && _cursor.isNull(_cursorIndexOfPublik) && _cursor.isNull(_cursorIndexOfCeInactive) && _cursor.isNull(_cursorIndexOfCompletionCriteria) && _cursor.isNull(_cursorIndexOfMinScore) && _cursor.isNull(_cursorIndexOfContentTypeFlag) && _cursor.isNull(_cursorIndexOfContentOwner) && _cursor.isNull(_cursorIndexOfContentOwnerType) && _cursor.isNull(_cursorIndexOfContentEntryLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfContentEntryLastChangedBy) && _cursor.isNull(_cursorIndexOfContentEntryLct))) {
                            _tmpContentEntry = new ContentEntry();
                            long _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
                            _tmpContentEntry.setContentEntryUid(_tmpContentEntryUid);
                            String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                            _tmpContentEntry.setTitle(_tmpTitle);
                            String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                            _tmpContentEntry.setDescription(_tmpDescription);
                            String _tmpEntryId = _cursor.isNull(_cursorIndexOfEntryId) ? null : _cursor.getString(_cursorIndexOfEntryId);
                            _tmpContentEntry.setEntryId(_tmpEntryId);
                            String _tmpAuthor = _cursor.isNull(_cursorIndexOfAuthor) ? null : _cursor.getString(_cursorIndexOfAuthor);
                            _tmpContentEntry.setAuthor(_tmpAuthor);
                            String _tmpPublisher = _cursor.isNull(_cursorIndexOfPublisher) ? null : _cursor.getString(_cursorIndexOfPublisher);
                            _tmpContentEntry.setPublisher(_tmpPublisher);
                            int _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
                            _tmpContentEntry.setLicenseType(_tmpLicenseType);
                            String _tmpLicenseName = _cursor.isNull(_cursorIndexOfLicenseName) ? null : _cursor.getString(_cursorIndexOfLicenseName);
                            _tmpContentEntry.setLicenseName(_tmpLicenseName);
                            String _tmpLicenseUrl = _cursor.isNull(_cursorIndexOfLicenseUrl) ? null : _cursor.getString(_cursorIndexOfLicenseUrl);
                            _tmpContentEntry.setLicenseUrl(_tmpLicenseUrl);
                            String _tmpSourceUrl = _cursor.isNull(_cursorIndexOfSourceUrl) ? null : _cursor.getString(_cursorIndexOfSourceUrl);
                            _tmpContentEntry.setSourceUrl(_tmpSourceUrl);
                            String _tmpThumbnailUrl = _cursor.isNull(_cursorIndexOfThumbnailUrl) ? null : _cursor.getString(_cursorIndexOfThumbnailUrl);
                            _tmpContentEntry.setThumbnailUrl(_tmpThumbnailUrl);
                            long _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
                            _tmpContentEntry.setLastModified(_tmpLastModified);
                            long _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
                            _tmpContentEntry.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
                            long _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
                            _tmpContentEntry.setLanguageVariantUid(_tmpLanguageVariantUid);
                            int _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
                            _tmpContentEntry.setContentFlags(_tmpContentFlags);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfLeaf);
                            boolean _tmpLeaf = _tmp_2 != 0;
                            _tmpContentEntry.setLeaf(_tmpLeaf);
                            int _tmp_3 = _cursor.getInt(_cursorIndexOfPublik);
                            boolean _tmpPublik = _tmp_3 != 0;
                            _tmpContentEntry.setPublik(_tmpPublik);
                            int _tmp_4 = _cursor.getInt(_cursorIndexOfCeInactive);
                            boolean _tmpCeInactive = _tmp_4 != 0;
                            _tmpContentEntry.setCeInactive(_tmpCeInactive);
                            int _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
                            _tmpContentEntry.setCompletionCriteria(_tmpCompletionCriteria);
                            int _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
                            _tmpContentEntry.setMinScore(_tmpMinScore);
                            int _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
                            _tmpContentEntry.setContentTypeFlag(_tmpContentTypeFlag);
                            long _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
                            _tmpContentEntry.setContentOwner(_tmpContentOwner);
                            int _tmpContentOwnerType = _cursor.getInt(_cursorIndexOfContentOwnerType);
                            _tmpContentEntry.setContentOwnerType(_tmpContentOwnerType);
                            long _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
                            _tmpContentEntry.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
                            long _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
                            _tmpContentEntry.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
                            int _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
                            _tmpContentEntry.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
                            long _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
                            _tmpContentEntry.setContentEntryLct(_tmpContentEntryLct);
                        } else {
                            _tmpContentEntry = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCbpUid) && _cursor.isNull(_cursorIndexOfCbpLct) && _cursor.isNull(_cursorIndexOfCbpPictureUri) && _cursor.isNull(_cursorIndexOfCbpThumbnailUri))) {
                            long _tmpCbpUid = _cursor.getLong(_cursorIndexOfCbpUid);
                            long _tmpCbpLct = _cursor.getLong(_cursorIndexOfCbpLct);
                            String _tmpCbpPictureUri = _cursor.isNull(_cursorIndexOfCbpPictureUri) ? null : _cursor.getString(_cursorIndexOfCbpPictureUri);
                            String _tmpCbpThumbnailUri = _cursor.isNull(_cursorIndexOfCbpThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCbpThumbnailUri);
                            _tmpCourseBlockPicture = new CourseBlockPicture(_tmpCbpUid, _tmpCbpLct, _tmpCbpPictureUri, _tmpCbpThumbnailUri);
                        } else {
                            _tmpCourseBlockPicture = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfCepUid) && _cursor.isNull(_cursorIndexOfCepLct) && _cursor.isNull(_cursorIndexOfCepPictureUri) && _cursor.isNull(_cursorIndexOfCepThumbnailUri))) {
                            long _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
                            long _tmpCepLct = _cursor.getLong(_cursorIndexOfCepLct);
                            String _tmpCepPictureUri = _cursor.isNull(_cursorIndexOfCepPictureUri) ? null : _cursor.getString(_cursorIndexOfCepPictureUri);
                            String _tmpCepThumbnailUri = _cursor.isNull(_cursorIndexOfCepThumbnailUri) ? null : _cursor.getString(_cursorIndexOfCepThumbnailUri);
                            _tmpContentEntryPicture2 = new ContentEntryPicture2(_tmpCepUid, _tmpCepLct, _tmpCepPictureUri, _tmpCepThumbnailUri);
                        } else {
                            _tmpContentEntryPicture2 = null;
                        }
                        CourseBlockAndGradebookDisplayDetails _item = new CourseBlockAndGradebookDisplayDetails(_tmpBlock, _tmpCourseBlockPicture, _tmpContentEntry, _tmpContentEntryPicture2);
                        _result2.add(_item);
                    }
                    ArrayList<CourseBlockAndGradebookDisplayDetails> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findCourseBlockAndClazzUidByCbUid(long cbUid, long accountPersonUid, Continuation<? super CourseBlockUidAndClazzUid> $completion) {
        String _sql = "\n        SELECT CourseBlock.cbUid AS courseBlockUid, \n               CourseBlock.cbClazzUid AS clazzUid\n          FROM CourseBlock\n         WHERE cbUid = ?\n           AND ? != 0     \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseBlock.cbUid AS courseBlockUid, \n               CourseBlock.cbClazzUid AS clazzUid\n          FROM CourseBlock\n         WHERE cbUid = ?\n           AND ? != 0     \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, cbUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseBlockUidAndClazzUid>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseBlockUidAndClazzUid call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseBlockDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseBlockUidAndClazzUid _result2;
                    boolean _cursorIndexOfCourseBlockUid = false;
                    boolean _cursorIndexOfClazzUid = true;
                    if (_cursor.moveToFirst()) {
                        long _tmpCourseBlockUid = _cursor.getLong(0);
                        long _tmpClazzUid = _cursor.getLong(1);
                        _result2 = new CourseBlockUidAndClazzUid(_tmpClazzUid, _tmpCourseBlockUid);
                    } else {
                        _result2 = null;
                    }
                    CourseBlockUidAndClazzUid courseBlockUidAndClazzUid = _result2;
                    return courseBlockUidAndClazzUid;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

