/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.OfflineItemDao;
import com.ustadmobile.lib.db.composites.OfflineItemAndState;
import com.ustadmobile.lib.db.composites.TransferJobAndTotals;
import com.ustadmobile.lib.db.entities.OfflineItem;
import com.ustadmobile.lib.db.entities.TransferJob;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class OfflineItemDao_Impl
extends OfflineItemDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OfflineItem> __insertionAdapterOfOfflineItem;
    private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByOfflineItemUid;

    public OfflineItemDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOfflineItem = new EntityInsertionAdapter<OfflineItem>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `OfflineItem` (`oiUid`,`oiNodeId`,`oiClazzUid`,`oiCourseBlockUid`,`oiContentEntryUid`,`oiActive`,`oiLct`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull OfflineItem entity) {
                statement.bindLong(1, entity.getOiUid());
                statement.bindLong(2, entity.getOiNodeId());
                statement.bindLong(3, entity.getOiClazzUid());
                statement.bindLong(4, entity.getOiCourseBlockUid());
                statement.bindLong(5, entity.getOiContentEntryUid());
                int _tmp = entity.getOiActive() ? 1 : 0;
                statement.bindLong(6, (long)_tmp);
                statement.bindLong(7, entity.getOiLct());
            }
        };
        this.__preparedStmtOfUpdateActiveByOfflineItemUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE OfflineItem\n           SET oiActive = ?\n         WHERE oiUid = ?   \n    ";
                return "\n        UPDATE OfflineItem\n           SET oiActive = ?\n         WHERE oiUid = ?   \n    ";
            }
        };
    }

    @Override
    public Object insertAsync(final OfflineItem item, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                OfflineItemDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = OfflineItemDao_Impl.this.__insertionAdapterOfOfflineItem.insertAndReturnId((Object)item);
                    OfflineItemDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    OfflineItemDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateActiveByOfflineItemUid(final long oiUid, final boolean active, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = OfflineItemDao_Impl.this.__preparedStmtOfUpdateActiveByOfflineItemUid.acquire();
                int _argIndex = 1;
                int _tmp = active ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, oiUid);
                try {
                    Unit unit;
                    OfflineItemDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        OfflineItemDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        OfflineItemDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    OfflineItemDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    OfflineItemDao_Impl.this.__preparedStmtOfUpdateActiveByOfflineItemUid.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Flow<OfflineItemAndState> findByContentEntryUid(long contentEntryUid, long nodeId) {
        String _sql = "\n        SELECT OfflineItem.*,\n               TransferJob.*,\n               \n        (SELECT SUM(TransferJobItem.tjTotalSize)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS totalSize,\n                (SELECT SUM(TransferJobItem.tjTransferred)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS transferred \n    ,\n               CAST(OfflineItem.oiActive AS INTEGER) = 1 AND (SELECT EXISTS(\n                       SELECT CompletedJob.tjUid\n                         FROM TransferJob CompletedJob\n                        WHERE CompletedJob.tjTableId = 738\n                          AND CompletedJob.tjEntityUid IN  \n                              \n        (SELECT ContentEntryVersion.cevUid\n                         FROM ContentEntryVersion\n                        WHERE ContentEntryVersion.cevContentEntryUid = ?)\n    \n                          AND CompletedJob.tjStatus = 21\n                          AND CompletedJob.tjType = 2\n                          AND CompletedJob.tjTimeCreated >= OfflineItem.oiLct\n                        LIMIT 1      \n               )) AS readyForOffline,\n               NULL AS latestErrorStr\n          FROM OfflineItem\n               LEFT JOIN TransferJob \n                         ON TransferJob.tjUid = \n                         (SELECT TransferJob.tjUid\n                            FROM TransferJob\n                           WHERE TransferJob.tjTableId = 738\n                             AND TransferJob.tjEntityUid IN  \n                                 \n        (SELECT ContentEntryVersion.cevUid\n                         FROM ContentEntryVersion\n                        WHERE ContentEntryVersion.cevContentEntryUid = ?)\n    \n                             AND TransferJob.tjStatus < 21\n                        ORDER BY TransferJob.tjTimeCreated DESC     \n                           LIMIT 1)\n         WHERE OfflineItem.oiNodeId = ?\n           AND OfflineItem.oiContentEntryUid = ?\n      ORDER BY OfflineItem.oiLct DESC\n         LIMIT 1     \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT OfflineItem.*,\n               TransferJob.*,\n               \n        (SELECT SUM(TransferJobItem.tjTotalSize)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS totalSize,\n                (SELECT SUM(TransferJobItem.tjTransferred)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS transferred \n    ,\n               CAST(OfflineItem.oiActive AS INTEGER) = 1 AND (SELECT EXISTS(\n                       SELECT CompletedJob.tjUid\n                         FROM TransferJob CompletedJob\n                        WHERE CompletedJob.tjTableId = 738\n                          AND CompletedJob.tjEntityUid IN  \n                              \n        (SELECT ContentEntryVersion.cevUid\n                         FROM ContentEntryVersion\n                        WHERE ContentEntryVersion.cevContentEntryUid = ?)\n    \n                          AND CompletedJob.tjStatus = 21\n                          AND CompletedJob.tjType = 2\n                          AND CompletedJob.tjTimeCreated >= OfflineItem.oiLct\n                        LIMIT 1      \n               )) AS readyForOffline,\n               NULL AS latestErrorStr\n          FROM OfflineItem\n               LEFT JOIN TransferJob \n                         ON TransferJob.tjUid = \n                         (SELECT TransferJob.tjUid\n                            FROM TransferJob\n                           WHERE TransferJob.tjTableId = 738\n                             AND TransferJob.tjEntityUid IN  \n                                 \n        (SELECT ContentEntryVersion.cevUid\n                         FROM ContentEntryVersion\n                        WHERE ContentEntryVersion.cevContentEntryUid = ?)\n    \n                             AND TransferJob.tjStatus < 21\n                        ORDER BY TransferJob.tjTimeCreated DESC     \n                           LIMIT 1)\n         WHERE OfflineItem.oiNodeId = ?\n           AND OfflineItem.oiContentEntryUid = ?\n      ORDER BY OfflineItem.oiLct DESC\n         LIMIT 1     \n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, nodeId);
        _argIndex = 4;
        _statement.bindLong(_argIndex, contentEntryUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"TransferJobItem", "TransferJob", "ContentEntryVersion", "OfflineItem"}, (Callable)new Callable<OfflineItemAndState>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public OfflineItemAndState call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)OfflineItemDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    OfflineItemAndState _result2;
                    int _cursorIndexOfOiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"oiUid");
                    int _cursorIndexOfOiNodeId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"oiNodeId");
                    int _cursorIndexOfOiClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"oiClazzUid");
                    int _cursorIndexOfOiCourseBlockUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"oiCourseBlockUid");
                    int _cursorIndexOfOiContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"oiContentEntryUid");
                    int _cursorIndexOfOiActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"oiActive");
                    int _cursorIndexOfOiLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"oiLct");
                    int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUid");
                    int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjType");
                    int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjStatus");
                    int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjName");
                    int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUuid");
                    int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTableId");
                    int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjEntityUid");
                    int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTimeCreated");
                    int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjCreationType");
                    int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjOiUid");
                    int _cursorIndexOfTotalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"totalSize");
                    int _cursorIndexOfTransferred = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferred");
                    int _cursorIndexOfReadyForOffline = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readyForOffline");
                    int _cursorIndexOfLatestErrorStr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestErrorStr");
                    if (_cursor.moveToFirst()) {
                        TransferJobAndTotals _tmpActiveDownload;
                        OfflineItem _tmpOfflineItem;
                        boolean _tmpReadyForOffline;
                        int _tmp = _cursor.getInt(_cursorIndexOfReadyForOffline);
                        boolean bl = _tmpReadyForOffline = _tmp != 0;
                        if (!(_cursor.isNull(_cursorIndexOfOiUid) && _cursor.isNull(_cursorIndexOfOiNodeId) && _cursor.isNull(_cursorIndexOfOiClazzUid) && _cursor.isNull(_cursorIndexOfOiCourseBlockUid) && _cursor.isNull(_cursorIndexOfOiContentEntryUid) && _cursor.isNull(_cursorIndexOfOiActive) && _cursor.isNull(_cursorIndexOfOiLct))) {
                            long _tmpOiUid = _cursor.getLong(_cursorIndexOfOiUid);
                            long _tmpOiNodeId = _cursor.getLong(_cursorIndexOfOiNodeId);
                            long _tmpOiClazzUid = _cursor.getLong(_cursorIndexOfOiClazzUid);
                            long _tmpOiCourseBlockUid = _cursor.getLong(_cursorIndexOfOiCourseBlockUid);
                            long _tmpOiContentEntryUid = _cursor.getLong(_cursorIndexOfOiContentEntryUid);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfOiActive);
                            boolean _tmpOiActive = _tmp_1 != 0;
                            long _tmpOiLct = _cursor.getLong(_cursorIndexOfOiLct);
                            _tmpOfflineItem = new OfflineItem(_tmpOiUid, _tmpOiNodeId, _tmpOiClazzUid, _tmpOiCourseBlockUid, _tmpOiContentEntryUid, _tmpOiActive, _tmpOiLct);
                        } else {
                            _tmpOfflineItem = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfTotalSize) && _cursor.isNull(_cursorIndexOfTransferred) && _cursor.isNull(_cursorIndexOfLatestErrorStr) && _cursor.isNull(_cursorIndexOfTjUid) && _cursor.isNull(_cursorIndexOfTjType) && _cursor.isNull(_cursorIndexOfTjStatus) && _cursor.isNull(_cursorIndexOfTjName) && _cursor.isNull(_cursorIndexOfTjUuid) && _cursor.isNull(_cursorIndexOfTjTableId) && _cursor.isNull(_cursorIndexOfTjEntityUid) && _cursor.isNull(_cursorIndexOfTjTimeCreated) && _cursor.isNull(_cursorIndexOfTjCreationType) && _cursor.isNull(_cursorIndexOfTjOiUid))) {
                            TransferJob _tmpTransferJob;
                            long _tmpTotalSize = _cursor.getLong(_cursorIndexOfTotalSize);
                            long _tmpTransferred = _cursor.getLong(_cursorIndexOfTransferred);
                            String _tmpLatestErrorStr = _cursor.isNull(_cursorIndexOfLatestErrorStr) ? null : _cursor.getString(_cursorIndexOfLatestErrorStr);
                            if (!(_cursor.isNull(_cursorIndexOfTjUid) && _cursor.isNull(_cursorIndexOfTjType) && _cursor.isNull(_cursorIndexOfTjStatus) && _cursor.isNull(_cursorIndexOfTjName) && _cursor.isNull(_cursorIndexOfTjUuid) && _cursor.isNull(_cursorIndexOfTjTableId) && _cursor.isNull(_cursorIndexOfTjEntityUid) && _cursor.isNull(_cursorIndexOfTjTimeCreated) && _cursor.isNull(_cursorIndexOfTjCreationType) && _cursor.isNull(_cursorIndexOfTjOiUid))) {
                                int _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
                                int _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
                                int _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
                                String _tmpTjName = _cursor.isNull(_cursorIndexOfTjName) ? null : _cursor.getString(_cursorIndexOfTjName);
                                String _tmpTjUuid = _cursor.isNull(_cursorIndexOfTjUuid) ? null : _cursor.getString(_cursorIndexOfTjUuid);
                                int _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
                                long _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
                                long _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
                                int _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
                                long _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
                                _tmpTransferJob = new TransferJob(_tmpTjUid, _tmpTjType, _tmpTjStatus, _tmpTjName, _tmpTjUuid, _tmpTjTableId, _tmpTjEntityUid, _tmpTjTimeCreated, _tmpTjCreationType, _tmpTjOiUid);
                            } else {
                                _tmpTransferJob = null;
                            }
                            _tmpActiveDownload = new TransferJobAndTotals(_tmpTransferJob, _tmpTotalSize, _tmpTransferred, _tmpLatestErrorStr);
                        } else {
                            _tmpActiveDownload = null;
                        }
                        _result2 = new OfflineItemAndState(_tmpOfflineItem, _tmpActiveDownload, _tmpReadyForOffline);
                    } else {
                        _result2 = null;
                    }
                    OfflineItemAndState offlineItemAndState = _result2;
                    return offlineItemAndState;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

