/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.PeerReviewerAllocationDao;
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class PeerReviewerAllocationDao_Impl
extends PeerReviewerAllocationDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PeerReviewerAllocation> __insertionAdapterOfPeerReviewerAllocation;
    private final EntityInsertionAdapter<PeerReviewerAllocation> __insertionAdapterOfPeerReviewerAllocation_1;
    private final EntityDeletionOrUpdateAdapter<PeerReviewerAllocation> __updateAdapterOfPeerReviewerAllocation;
    private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

    public PeerReviewerAllocationDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPeerReviewerAllocation = new EntityInsertionAdapter<PeerReviewerAllocation>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PeerReviewerAllocation` (`praUid`,`praMarkerSubmitterUid`,`praToMarkerSubmitterUid`,`praAssignmentUid`,`praActive`,`praLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PeerReviewerAllocation entity) {
                statement.bindLong(1, entity.getPraUid());
                statement.bindLong(2, entity.getPraMarkerSubmitterUid());
                statement.bindLong(3, entity.getPraToMarkerSubmitterUid());
                statement.bindLong(4, entity.getPraAssignmentUid());
                int _tmp = entity.getPraActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                statement.bindLong(6, entity.getPraLct());
            }
        };
        this.__insertionAdapterOfPeerReviewerAllocation_1 = new EntityInsertionAdapter<PeerReviewerAllocation>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `PeerReviewerAllocation` (`praUid`,`praMarkerSubmitterUid`,`praToMarkerSubmitterUid`,`praAssignmentUid`,`praActive`,`praLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PeerReviewerAllocation entity) {
                statement.bindLong(1, entity.getPraUid());
                statement.bindLong(2, entity.getPraMarkerSubmitterUid());
                statement.bindLong(3, entity.getPraToMarkerSubmitterUid());
                statement.bindLong(4, entity.getPraAssignmentUid());
                int _tmp = entity.getPraActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                statement.bindLong(6, entity.getPraLct());
            }
        };
        this.__updateAdapterOfPeerReviewerAllocation = new EntityDeletionOrUpdateAdapter<PeerReviewerAllocation>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `PeerReviewerAllocation` SET `praUid` = ?,`praMarkerSubmitterUid` = ?,`praToMarkerSubmitterUid` = ?,`praAssignmentUid` = ?,`praActive` = ?,`praLct` = ? WHERE `praUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PeerReviewerAllocation entity) {
                statement.bindLong(1, entity.getPraUid());
                statement.bindLong(2, entity.getPraMarkerSubmitterUid());
                statement.bindLong(3, entity.getPraToMarkerSubmitterUid());
                statement.bindLong(4, entity.getPraAssignmentUid());
                int _tmp = entity.getPraActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                statement.bindLong(6, entity.getPraLct());
                statement.bindLong(7, entity.getPraUid());
            }
        };
        this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE PeerReviewerAllocation \n           SET praActive = ?, \n               praLct = ?\n         WHERE praUid = ?";
                return "\n        UPDATE PeerReviewerAllocation \n           SET praActive = ?, \n               praLct = ?\n         WHERE praUid = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(PeerReviewerAllocation entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfPeerReviewerAllocation.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final PeerReviewerAllocation entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PeerReviewerAllocationDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PeerReviewerAllocationDao_Impl.this.__insertionAdapterOfPeerReviewerAllocation.insertAndReturnId((Object)entity);
                    PeerReviewerAllocationDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PeerReviewerAllocationDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends PeerReviewerAllocation> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPeerReviewerAllocation.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object replaceListAsync(final List<PeerReviewerAllocation> entries, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                PeerReviewerAllocationDao_Impl.this.__db.beginTransaction();
                try {
                    PeerReviewerAllocationDao_Impl.this.__insertionAdapterOfPeerReviewerAllocation_1.insert((Iterable)entries);
                    PeerReviewerAllocationDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PeerReviewerAllocationDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertList(final List<PeerReviewerAllocation> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                PeerReviewerAllocationDao_Impl.this.__db.beginTransaction();
                try {
                    PeerReviewerAllocationDao_Impl.this.__insertionAdapterOfPeerReviewerAllocation_1.insert((Iterable)entityList);
                    PeerReviewerAllocationDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PeerReviewerAllocationDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(PeerReviewerAllocation entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPeerReviewerAllocation.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateActiveByUid(final long cbUid, final boolean active, final long changeTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PeerReviewerAllocationDao_Impl.this.__preparedStmtOfUpdateActiveByUid.acquire();
                int _argIndex = 1;
                int _tmp = active ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, changeTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, cbUid);
                try {
                    Unit unit;
                    PeerReviewerAllocationDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        PeerReviewerAllocationDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        PeerReviewerAllocationDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    PeerReviewerAllocationDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    PeerReviewerAllocationDao_Impl.this.__preparedStmtOfUpdateActiveByUid.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object getAllPeerReviewerAllocations(List<Long> assignmentUid, Continuation<? super List<PeerReviewerAllocation>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        SELECT *");
        _stringBuilder.append("\n");
        _stringBuilder.append("         FROM PeerReviewerAllocation");
        _stringBuilder.append("\n");
        _stringBuilder.append("        WHERE praAssignmentUid IN (");
        int _inputSize = assignmentUid.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("          AND praActive ");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : assignmentUid) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PeerReviewerAllocation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PeerReviewerAllocation> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PeerReviewerAllocationDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praUid");
                    int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praMarkerSubmitterUid");
                    int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praToMarkerSubmitterUid");
                    int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praAssignmentUid");
                    int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praActive");
                    int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praLct");
                    ArrayList<PeerReviewerAllocation> _result2 = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
                        long _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
                        long _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
                        long _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfPraActive);
                        boolean _tmpPraActive = _tmp != 0;
                        long _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
                        PeerReviewerAllocation _item_1 = new PeerReviewerAllocation(_tmpPraUid, _tmpPraMarkerSubmitterUid, _tmpPraToMarkerSubmitterUid, _tmpPraAssignmentUid, _tmpPraActive, _tmpPraLct);
                        _result2.add(_item_1);
                    }
                    ArrayList<PeerReviewerAllocation> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getAllPeerReviewerAllocationsByClazzUid(long clazzUid, boolean includeInactive, Continuation<? super List<PeerReviewerAllocation>> $completion) {
        String _sql = "\n        SELECT PeerReviewerAllocation.*\n          FROM PeerReviewerAllocation\n         WHERE PeerReviewerAllocation.praAssignmentUid IN\n               (SELECT CourseBlock.cbEntityUid\n                  FROM CourseBlock\n                 WHERE CourseBlock.cbClazzUid = ?\n                   AND CourseBlock.cbType = 103\n                   AND (CAST(? AS INTEGER) = 1 OR CourseBlock.cbActive))\n           AND (CAST(? AS INTEGER) = 1 OR PeerReviewerAllocation.praActive)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT PeerReviewerAllocation.*\n          FROM PeerReviewerAllocation\n         WHERE PeerReviewerAllocation.praAssignmentUid IN\n               (SELECT CourseBlock.cbEntityUid\n                  FROM CourseBlock\n                 WHERE CourseBlock.cbClazzUid = ?\n                   AND CourseBlock.cbType = 103\n                   AND (CAST(? AS INTEGER) = 1 OR CourseBlock.cbActive))\n           AND (CAST(? AS INTEGER) = 1 OR PeerReviewerAllocation.praActive)\n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        int _tmp = includeInactive ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 3;
        int _tmp_1 = includeInactive ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PeerReviewerAllocation>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PeerReviewerAllocation> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PeerReviewerAllocationDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praUid");
                    int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praMarkerSubmitterUid");
                    int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praToMarkerSubmitterUid");
                    int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praAssignmentUid");
                    int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praActive");
                    int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"praLct");
                    ArrayList<PeerReviewerAllocation> _result2 = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
                        long _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
                        long _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
                        long _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfPraActive);
                        boolean _tmpPraActive = _tmp_2 != 0;
                        long _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
                        PeerReviewerAllocation _item = new PeerReviewerAllocation(_tmpPraUid, _tmpPraMarkerSubmitterUid, _tmpPraToMarkerSubmitterUid, _tmpPraAssignmentUid, _tmpPraActive, _tmpPraLct);
                        _result2.add(_item);
                    }
                    ArrayList<PeerReviewerAllocation> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

