/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.RawQuery;
import androidx.room.Update;
import androidx.sqlite.db.SupportSQLiteQuery;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.entities.Report;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH'J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH'J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u00112\u0006\u0010\f\u001a\u00020\rH'J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH'J\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00112\u0006\u0010\u0018\u001a\u00020\nH'J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH'J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH'J,\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010#\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010'\u00a8\u0006("}, d2={"Lcom/ustadmobile/core/db/dao/ReportDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Report;", "()V", "findAllActiveReport", "Landroidx/paging/PagingSource;", "", "searchBit", "", "personUid", "", "sortOrder", "isTemplate", "", "findAllActiveReportList", "", "findAllActiveReportLive", "Lkotlinx/coroutines/flow/Flow;", "findByUid", "entityUid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidList", "uidList", "findByUidLive", "uid", "getResults", "query", "Landroidx/sqlite/db/SupportSQLiteQuery;", "Lcom/ustadmobile/door/DoorQuery;", "replaceList", "", "entityList", "toggleVisibilityReportItems", "toggleVisibility", "selectedItem", "updateTime", "(ZLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/Report;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_debug"})
@Dao
public abstract class ReportDao
implements BaseDao<Report> {
    @RawQuery(observedEntities={})
    @NotNull
    public abstract List<Report> getResults(@NotNull SupportSQLiteQuery var1);

    @Query(value="SELECT * FROM REPORT WHERE NOT reportInactive \n        AND reportOwnerUid = :personUid\n        AND isTemplate = :isTemplate\n        AND reportTitle LIKE :searchBit\n        ORDER BY priority, CASE(:sortOrder)\n            WHEN 1 THEN Report.reportTitle\n            ELSE ''\n        END ASC,\n        CASE(:sortOrder)\n            WHEN 2 THEN Report.reportTitle\n            ELSE ''\n        END DESC\n            ")
    @NotNull
    public abstract PagingSource<Integer, Report> findAllActiveReport(@NotNull String var1, long var2, int var4, boolean var5);

    @Query(value="SELECT * FROM Report WHERE reportUid = :entityUid")
    @Nullable
    public abstract Object findByUid(long var1, @NotNull Continuation<? super Report> var3);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull Report var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="SELECT * From Report WHERE  reportUid = :uid")
    @NotNull
    public abstract Flow<Report> findByUidLive(long var1);

    @Query(value="SELECT * FROM REPORT WHERE NOT reportInactive \n        AND isTemplate = :isTemplate\n        ORDER BY priority ASC\n            ")
    @NotNull
    public abstract Flow<List<Report>> findAllActiveReportLive(boolean var1);

    @Query(value="SELECT * FROM REPORT WHERE NOT reportInactive \n        AND isTemplate = :isTemplate\n        ORDER BY priority ASC\n            ")
    @NotNull
    public abstract List<Report> findAllActiveReportList(boolean var1);

    @Query(value="SELECT reportUid FROM Report WHERE reportUid IN (:uidList)")
    @NotNull
    public abstract List<Long> findByUidList(@NotNull List<Long> var1);

    @Query(value="\n        UPDATE Report \n           SET reportInactive = :toggleVisibility,\n               reportLct = :updateTime \n         WHERE reportUid IN (:selectedItem)\n    ")
    @Nullable
    public abstract Object toggleVisibilityReportItems(boolean var1, @NotNull List<Long> var2, long var3, @NotNull Continuation<? super Unit> var5);

    @Insert(entity=Object.class, onConflict=1)
    public abstract void replaceList(@NotNull List<? extends Report> var1);
}

