/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ReportDao;
import com.ustadmobile.lib.db.entities.Report;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ReportDao_Impl
extends ReportDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Report> __insertionAdapterOfReport;
    private final EntityInsertionAdapter<Report> __insertionAdapterOfReport_1;
    private final EntityDeletionOrUpdateAdapter<Report> __updateAdapterOfReport;

    public ReportDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfReport = new EntityInsertionAdapter<Report>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Report` (`reportUid`,`reportOwnerUid`,`xAxis`,`reportDateRangeSelection`,`fromDate`,`fromRelTo`,`fromRelOffSet`,`fromRelUnit`,`toDate`,`toRelTo`,`toRelOffSet`,`toRelUnit`,`reportTitle`,`reportDescription`,`reportSeries`,`reportInactive`,`isTemplate`,`priority`,`reportTitleId`,`reportDescId`,`reportMasterChangeSeqNum`,`reportLocalChangeSeqNum`,`reportLastChangedBy`,`reportLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Report entity) {
                statement.bindLong(1, entity.getReportUid());
                statement.bindLong(2, entity.getReportOwnerUid());
                statement.bindLong(3, (long)entity.getXAxis());
                statement.bindLong(4, (long)entity.getReportDateRangeSelection());
                statement.bindLong(5, entity.getFromDate());
                statement.bindLong(6, (long)entity.getFromRelTo());
                statement.bindLong(7, (long)entity.getFromRelOffSet());
                statement.bindLong(8, (long)entity.getFromRelUnit());
                statement.bindLong(9, entity.getToDate());
                statement.bindLong(10, (long)entity.getToRelTo());
                statement.bindLong(11, (long)entity.getToRelOffSet());
                statement.bindLong(12, (long)entity.getToRelUnit());
                if (entity.getReportTitle() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindString(13, entity.getReportTitle());
                }
                if (entity.getReportDescription() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getReportDescription());
                }
                if (entity.getReportSeries() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getReportSeries());
                }
                int _tmp = entity.getReportInactive() ? 1 : 0;
                statement.bindLong(16, (long)_tmp);
                int _tmp_1 = entity.isTemplate() ? 1 : 0;
                statement.bindLong(17, (long)_tmp_1);
                statement.bindLong(18, (long)entity.getPriority());
                statement.bindLong(19, (long)entity.getReportTitleId());
                statement.bindLong(20, (long)entity.getReportDescId());
                statement.bindLong(21, entity.getReportMasterChangeSeqNum());
                statement.bindLong(22, entity.getReportLocalChangeSeqNum());
                statement.bindLong(23, (long)entity.getReportLastChangedBy());
                statement.bindLong(24, entity.getReportLct());
            }
        };
        this.__insertionAdapterOfReport_1 = new EntityInsertionAdapter<Report>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `Report` (`reportUid`,`reportOwnerUid`,`xAxis`,`reportDateRangeSelection`,`fromDate`,`fromRelTo`,`fromRelOffSet`,`fromRelUnit`,`toDate`,`toRelTo`,`toRelOffSet`,`toRelUnit`,`reportTitle`,`reportDescription`,`reportSeries`,`reportInactive`,`isTemplate`,`priority`,`reportTitleId`,`reportDescId`,`reportMasterChangeSeqNum`,`reportLocalChangeSeqNum`,`reportLastChangedBy`,`reportLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Report entity) {
                statement.bindLong(1, entity.getReportUid());
                statement.bindLong(2, entity.getReportOwnerUid());
                statement.bindLong(3, (long)entity.getXAxis());
                statement.bindLong(4, (long)entity.getReportDateRangeSelection());
                statement.bindLong(5, entity.getFromDate());
                statement.bindLong(6, (long)entity.getFromRelTo());
                statement.bindLong(7, (long)entity.getFromRelOffSet());
                statement.bindLong(8, (long)entity.getFromRelUnit());
                statement.bindLong(9, entity.getToDate());
                statement.bindLong(10, (long)entity.getToRelTo());
                statement.bindLong(11, (long)entity.getToRelOffSet());
                statement.bindLong(12, (long)entity.getToRelUnit());
                if (entity.getReportTitle() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindString(13, entity.getReportTitle());
                }
                if (entity.getReportDescription() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getReportDescription());
                }
                if (entity.getReportSeries() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getReportSeries());
                }
                int _tmp = entity.getReportInactive() ? 1 : 0;
                statement.bindLong(16, (long)_tmp);
                int _tmp_1 = entity.isTemplate() ? 1 : 0;
                statement.bindLong(17, (long)_tmp_1);
                statement.bindLong(18, (long)entity.getPriority());
                statement.bindLong(19, (long)entity.getReportTitleId());
                statement.bindLong(20, (long)entity.getReportDescId());
                statement.bindLong(21, entity.getReportMasterChangeSeqNum());
                statement.bindLong(22, entity.getReportLocalChangeSeqNum());
                statement.bindLong(23, (long)entity.getReportLastChangedBy());
                statement.bindLong(24, entity.getReportLct());
            }
        };
        this.__updateAdapterOfReport = new EntityDeletionOrUpdateAdapter<Report>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `Report` SET `reportUid` = ?,`reportOwnerUid` = ?,`xAxis` = ?,`reportDateRangeSelection` = ?,`fromDate` = ?,`fromRelTo` = ?,`fromRelOffSet` = ?,`fromRelUnit` = ?,`toDate` = ?,`toRelTo` = ?,`toRelOffSet` = ?,`toRelUnit` = ?,`reportTitle` = ?,`reportDescription` = ?,`reportSeries` = ?,`reportInactive` = ?,`isTemplate` = ?,`priority` = ?,`reportTitleId` = ?,`reportDescId` = ?,`reportMasterChangeSeqNum` = ?,`reportLocalChangeSeqNum` = ?,`reportLastChangedBy` = ?,`reportLct` = ? WHERE `reportUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Report entity) {
                statement.bindLong(1, entity.getReportUid());
                statement.bindLong(2, entity.getReportOwnerUid());
                statement.bindLong(3, (long)entity.getXAxis());
                statement.bindLong(4, (long)entity.getReportDateRangeSelection());
                statement.bindLong(5, entity.getFromDate());
                statement.bindLong(6, (long)entity.getFromRelTo());
                statement.bindLong(7, (long)entity.getFromRelOffSet());
                statement.bindLong(8, (long)entity.getFromRelUnit());
                statement.bindLong(9, entity.getToDate());
                statement.bindLong(10, (long)entity.getToRelTo());
                statement.bindLong(11, (long)entity.getToRelOffSet());
                statement.bindLong(12, (long)entity.getToRelUnit());
                if (entity.getReportTitle() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindString(13, entity.getReportTitle());
                }
                if (entity.getReportDescription() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getReportDescription());
                }
                if (entity.getReportSeries() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getReportSeries());
                }
                int _tmp = entity.getReportInactive() ? 1 : 0;
                statement.bindLong(16, (long)_tmp);
                int _tmp_1 = entity.isTemplate() ? 1 : 0;
                statement.bindLong(17, (long)_tmp_1);
                statement.bindLong(18, (long)entity.getPriority());
                statement.bindLong(19, (long)entity.getReportTitleId());
                statement.bindLong(20, (long)entity.getReportDescId());
                statement.bindLong(21, entity.getReportMasterChangeSeqNum());
                statement.bindLong(22, entity.getReportLocalChangeSeqNum());
                statement.bindLong(23, (long)entity.getReportLastChangedBy());
                statement.bindLong(24, entity.getReportLct());
                statement.bindLong(25, entity.getReportUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Report entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfReport.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final Report entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ReportDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ReportDao_Impl.this.__insertionAdapterOfReport.insertAndReturnId((Object)entity);
                    ReportDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ReportDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends Report> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfReport.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void replaceList(List<? extends Report> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfReport_1.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Report entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfReport.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final Report entity, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ReportDao_Impl.this.__db.beginTransaction();
                try {
                    ReportDao_Impl.this.__updateAdapterOfReport.handle((Object)entity);
                    ReportDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ReportDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, Report> findAllActiveReport(String searchBit, long personUid, int sortOrder, boolean isTemplate) {
        String _sql = "SELECT * FROM REPORT WHERE NOT reportInactive \n        AND reportOwnerUid = ?\n        AND isTemplate = ?\n        AND reportTitle LIKE ?\n        ORDER BY priority, CASE(?)\n            WHEN 1 THEN Report.reportTitle\n            ELSE ''\n        END ASC,\n        CASE(?)\n            WHEN 2 THEN Report.reportTitle\n            ELSE ''\n        END DESC\n            ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM REPORT WHERE NOT reportInactive \n        AND reportOwnerUid = ?\n        AND isTemplate = ?\n        AND reportTitle LIKE ?\n        ORDER BY priority, CASE(?)\n            WHEN 1 THEN Report.reportTitle\n            ELSE ''\n        END ASC,\n        CASE(?)\n            WHEN 2 THEN Report.reportTitle\n            ELSE ''\n        END DESC\n            ", (int)5);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 2;
        int _tmp = isTemplate ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 3;
        _statement.bindString(_argIndex, searchBit);
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<Report>(_statement, this.__db, new String[]{"REPORT"}){

            @NonNull
            protected List<Report> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportUid");
                int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportOwnerUid");
                int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"xAxis");
                int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportDateRangeSelection");
                int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fromDate");
                int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fromRelTo");
                int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fromRelOffSet");
                int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fromRelUnit");
                int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"toDate");
                int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"toRelTo");
                int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"toRelOffSet");
                int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"toRelUnit");
                int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportTitle");
                int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportDescription");
                int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportSeries");
                int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportInactive");
                int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isTemplate");
                int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"priority");
                int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportTitleId");
                int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportDescId");
                int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportMasterChangeSeqNum");
                int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportLocalChangeSeqNum");
                int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportLastChangedBy");
                int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"reportLct");
                ArrayList<Report> _result2 = new ArrayList<Report>(cursor.getCount());
                while (cursor.moveToNext()) {
                    Report _item = new Report();
                    long _tmpReportUid = cursor.getLong(_cursorIndexOfReportUid);
                    _item.setReportUid(_tmpReportUid);
                    long _tmpReportOwnerUid = cursor.getLong(_cursorIndexOfReportOwnerUid);
                    _item.setReportOwnerUid(_tmpReportOwnerUid);
                    int _tmpXAxis = cursor.getInt(_cursorIndexOfXAxis);
                    _item.setXAxis(_tmpXAxis);
                    int _tmpReportDateRangeSelection = cursor.getInt(_cursorIndexOfReportDateRangeSelection);
                    _item.setReportDateRangeSelection(_tmpReportDateRangeSelection);
                    long _tmpFromDate = cursor.getLong(_cursorIndexOfFromDate);
                    _item.setFromDate(_tmpFromDate);
                    int _tmpFromRelTo = cursor.getInt(_cursorIndexOfFromRelTo);
                    _item.setFromRelTo(_tmpFromRelTo);
                    int _tmpFromRelOffSet = cursor.getInt(_cursorIndexOfFromRelOffSet);
                    _item.setFromRelOffSet(_tmpFromRelOffSet);
                    int _tmpFromRelUnit = cursor.getInt(_cursorIndexOfFromRelUnit);
                    _item.setFromRelUnit(_tmpFromRelUnit);
                    long _tmpToDate = cursor.getLong(_cursorIndexOfToDate);
                    _item.setToDate(_tmpToDate);
                    int _tmpToRelTo = cursor.getInt(_cursorIndexOfToRelTo);
                    _item.setToRelTo(_tmpToRelTo);
                    int _tmpToRelOffSet = cursor.getInt(_cursorIndexOfToRelOffSet);
                    _item.setToRelOffSet(_tmpToRelOffSet);
                    int _tmpToRelUnit = cursor.getInt(_cursorIndexOfToRelUnit);
                    _item.setToRelUnit(_tmpToRelUnit);
                    String _tmpReportTitle = cursor.isNull(_cursorIndexOfReportTitle) ? null : cursor.getString(_cursorIndexOfReportTitle);
                    _item.setReportTitle(_tmpReportTitle);
                    String _tmpReportDescription = cursor.isNull(_cursorIndexOfReportDescription) ? null : cursor.getString(_cursorIndexOfReportDescription);
                    _item.setReportDescription(_tmpReportDescription);
                    String _tmpReportSeries = cursor.isNull(_cursorIndexOfReportSeries) ? null : cursor.getString(_cursorIndexOfReportSeries);
                    _item.setReportSeries(_tmpReportSeries);
                    int _tmp_1 = cursor.getInt(_cursorIndexOfReportInactive);
                    boolean _tmpReportInactive = _tmp_1 != 0;
                    _item.setReportInactive(_tmpReportInactive);
                    int _tmp_2 = cursor.getInt(_cursorIndexOfIsTemplate);
                    boolean _tmpIsTemplate = _tmp_2 != 0;
                    _item.setTemplate(_tmpIsTemplate);
                    int _tmpPriority = cursor.getInt(_cursorIndexOfPriority);
                    _item.setPriority(_tmpPriority);
                    int _tmpReportTitleId = cursor.getInt(_cursorIndexOfReportTitleId);
                    _item.setReportTitleId(_tmpReportTitleId);
                    int _tmpReportDescId = cursor.getInt(_cursorIndexOfReportDescId);
                    _item.setReportDescId(_tmpReportDescId);
                    long _tmpReportMasterChangeSeqNum = cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
                    _item.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
                    long _tmpReportLocalChangeSeqNum = cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
                    _item.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
                    int _tmpReportLastChangedBy = cursor.getInt(_cursorIndexOfReportLastChangedBy);
                    _item.setReportLastChangedBy(_tmpReportLastChangedBy);
                    long _tmpReportLct = cursor.getLong(_cursorIndexOfReportLct);
                    _item.setReportLct(_tmpReportLct);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object findByUid(long entityUid, Continuation<? super Report> $completion) {
        String _sql = "SELECT * FROM Report WHERE reportUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Report WHERE reportUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, entityUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Report>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Report call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ReportDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Report _result2;
                    int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUid");
                    int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOwnerUid");
                    int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xAxis");
                    int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDateRangeSelection");
                    int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromDate");
                    int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelTo");
                    int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelOffSet");
                    int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelUnit");
                    int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toDate");
                    int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelTo");
                    int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelOffSet");
                    int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelUnit");
                    int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitle");
                    int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDescription");
                    int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportSeries");
                    int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportInactive");
                    int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isTemplate");
                    int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                    int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitleId");
                    int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDescId");
                    int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportMasterChangeSeqNum");
                    int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLocalChangeSeqNum");
                    int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLastChangedBy");
                    int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Report();
                        long _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
                        _result2.setReportUid(_tmpReportUid);
                        long _tmpReportOwnerUid = _cursor.getLong(_cursorIndexOfReportOwnerUid);
                        _result2.setReportOwnerUid(_tmpReportOwnerUid);
                        int _tmpXAxis = _cursor.getInt(_cursorIndexOfXAxis);
                        _result2.setXAxis(_tmpXAxis);
                        int _tmpReportDateRangeSelection = _cursor.getInt(_cursorIndexOfReportDateRangeSelection);
                        _result2.setReportDateRangeSelection(_tmpReportDateRangeSelection);
                        long _tmpFromDate = _cursor.getLong(_cursorIndexOfFromDate);
                        _result2.setFromDate(_tmpFromDate);
                        int _tmpFromRelTo = _cursor.getInt(_cursorIndexOfFromRelTo);
                        _result2.setFromRelTo(_tmpFromRelTo);
                        int _tmpFromRelOffSet = _cursor.getInt(_cursorIndexOfFromRelOffSet);
                        _result2.setFromRelOffSet(_tmpFromRelOffSet);
                        int _tmpFromRelUnit = _cursor.getInt(_cursorIndexOfFromRelUnit);
                        _result2.setFromRelUnit(_tmpFromRelUnit);
                        long _tmpToDate = _cursor.getLong(_cursorIndexOfToDate);
                        _result2.setToDate(_tmpToDate);
                        int _tmpToRelTo = _cursor.getInt(_cursorIndexOfToRelTo);
                        _result2.setToRelTo(_tmpToRelTo);
                        int _tmpToRelOffSet = _cursor.getInt(_cursorIndexOfToRelOffSet);
                        _result2.setToRelOffSet(_tmpToRelOffSet);
                        int _tmpToRelUnit = _cursor.getInt(_cursorIndexOfToRelUnit);
                        _result2.setToRelUnit(_tmpToRelUnit);
                        String _tmpReportTitle = _cursor.isNull(_cursorIndexOfReportTitle) ? null : _cursor.getString(_cursorIndexOfReportTitle);
                        _result2.setReportTitle(_tmpReportTitle);
                        String _tmpReportDescription = _cursor.isNull(_cursorIndexOfReportDescription) ? null : _cursor.getString(_cursorIndexOfReportDescription);
                        _result2.setReportDescription(_tmpReportDescription);
                        String _tmpReportSeries = _cursor.isNull(_cursorIndexOfReportSeries) ? null : _cursor.getString(_cursorIndexOfReportSeries);
                        _result2.setReportSeries(_tmpReportSeries);
                        int _tmp = _cursor.getInt(_cursorIndexOfReportInactive);
                        boolean _tmpReportInactive = _tmp != 0;
                        _result2.setReportInactive(_tmpReportInactive);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsTemplate);
                        boolean _tmpIsTemplate = _tmp_1 != 0;
                        _result2.setTemplate(_tmpIsTemplate);
                        int _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
                        _result2.setPriority(_tmpPriority);
                        int _tmpReportTitleId = _cursor.getInt(_cursorIndexOfReportTitleId);
                        _result2.setReportTitleId(_tmpReportTitleId);
                        int _tmpReportDescId = _cursor.getInt(_cursorIndexOfReportDescId);
                        _result2.setReportDescId(_tmpReportDescId);
                        long _tmpReportMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
                        _result2.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
                        long _tmpReportLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
                        _result2.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
                        int _tmpReportLastChangedBy = _cursor.getInt(_cursorIndexOfReportLastChangedBy);
                        _result2.setReportLastChangedBy(_tmpReportLastChangedBy);
                        long _tmpReportLct = _cursor.getLong(_cursorIndexOfReportLct);
                        _result2.setReportLct(_tmpReportLct);
                    } else {
                        _result2 = null;
                    }
                    Report report = _result2;
                    return report;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Report> findByUidLive(long uid) {
        String _sql = "SELECT * From Report WHERE  reportUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * From Report WHERE  reportUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Report"}, (Callable)new Callable<Report>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Report call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ReportDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Report _result2;
                    int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUid");
                    int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOwnerUid");
                    int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xAxis");
                    int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDateRangeSelection");
                    int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromDate");
                    int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelTo");
                    int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelOffSet");
                    int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelUnit");
                    int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toDate");
                    int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelTo");
                    int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelOffSet");
                    int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelUnit");
                    int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitle");
                    int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDescription");
                    int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportSeries");
                    int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportInactive");
                    int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isTemplate");
                    int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                    int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitleId");
                    int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDescId");
                    int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportMasterChangeSeqNum");
                    int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLocalChangeSeqNum");
                    int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLastChangedBy");
                    int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Report();
                        long _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
                        _result2.setReportUid(_tmpReportUid);
                        long _tmpReportOwnerUid = _cursor.getLong(_cursorIndexOfReportOwnerUid);
                        _result2.setReportOwnerUid(_tmpReportOwnerUid);
                        int _tmpXAxis = _cursor.getInt(_cursorIndexOfXAxis);
                        _result2.setXAxis(_tmpXAxis);
                        int _tmpReportDateRangeSelection = _cursor.getInt(_cursorIndexOfReportDateRangeSelection);
                        _result2.setReportDateRangeSelection(_tmpReportDateRangeSelection);
                        long _tmpFromDate = _cursor.getLong(_cursorIndexOfFromDate);
                        _result2.setFromDate(_tmpFromDate);
                        int _tmpFromRelTo = _cursor.getInt(_cursorIndexOfFromRelTo);
                        _result2.setFromRelTo(_tmpFromRelTo);
                        int _tmpFromRelOffSet = _cursor.getInt(_cursorIndexOfFromRelOffSet);
                        _result2.setFromRelOffSet(_tmpFromRelOffSet);
                        int _tmpFromRelUnit = _cursor.getInt(_cursorIndexOfFromRelUnit);
                        _result2.setFromRelUnit(_tmpFromRelUnit);
                        long _tmpToDate = _cursor.getLong(_cursorIndexOfToDate);
                        _result2.setToDate(_tmpToDate);
                        int _tmpToRelTo = _cursor.getInt(_cursorIndexOfToRelTo);
                        _result2.setToRelTo(_tmpToRelTo);
                        int _tmpToRelOffSet = _cursor.getInt(_cursorIndexOfToRelOffSet);
                        _result2.setToRelOffSet(_tmpToRelOffSet);
                        int _tmpToRelUnit = _cursor.getInt(_cursorIndexOfToRelUnit);
                        _result2.setToRelUnit(_tmpToRelUnit);
                        String _tmpReportTitle = _cursor.isNull(_cursorIndexOfReportTitle) ? null : _cursor.getString(_cursorIndexOfReportTitle);
                        _result2.setReportTitle(_tmpReportTitle);
                        String _tmpReportDescription = _cursor.isNull(_cursorIndexOfReportDescription) ? null : _cursor.getString(_cursorIndexOfReportDescription);
                        _result2.setReportDescription(_tmpReportDescription);
                        String _tmpReportSeries = _cursor.isNull(_cursorIndexOfReportSeries) ? null : _cursor.getString(_cursorIndexOfReportSeries);
                        _result2.setReportSeries(_tmpReportSeries);
                        int _tmp = _cursor.getInt(_cursorIndexOfReportInactive);
                        boolean _tmpReportInactive = _tmp != 0;
                        _result2.setReportInactive(_tmpReportInactive);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsTemplate);
                        boolean _tmpIsTemplate = _tmp_1 != 0;
                        _result2.setTemplate(_tmpIsTemplate);
                        int _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
                        _result2.setPriority(_tmpPriority);
                        int _tmpReportTitleId = _cursor.getInt(_cursorIndexOfReportTitleId);
                        _result2.setReportTitleId(_tmpReportTitleId);
                        int _tmpReportDescId = _cursor.getInt(_cursorIndexOfReportDescId);
                        _result2.setReportDescId(_tmpReportDescId);
                        long _tmpReportMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
                        _result2.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
                        long _tmpReportLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
                        _result2.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
                        int _tmpReportLastChangedBy = _cursor.getInt(_cursorIndexOfReportLastChangedBy);
                        _result2.setReportLastChangedBy(_tmpReportLastChangedBy);
                        long _tmpReportLct = _cursor.getLong(_cursorIndexOfReportLct);
                        _result2.setReportLct(_tmpReportLct);
                    } else {
                        _result2 = null;
                    }
                    Report report = _result2;
                    return report;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<Report>> findAllActiveReportLive(boolean isTemplate) {
        String _sql = "SELECT * FROM REPORT WHERE NOT reportInactive \n        AND isTemplate = ?\n        ORDER BY priority ASC\n            ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM REPORT WHERE NOT reportInactive \n        AND isTemplate = ?\n        ORDER BY priority ASC\n            ", (int)1);
        int _argIndex = 1;
        int _tmp = isTemplate ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"REPORT"}, (Callable)new Callable<List<Report>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Report> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ReportDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUid");
                    int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOwnerUid");
                    int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xAxis");
                    int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDateRangeSelection");
                    int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromDate");
                    int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelTo");
                    int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelOffSet");
                    int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelUnit");
                    int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toDate");
                    int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelTo");
                    int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelOffSet");
                    int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelUnit");
                    int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitle");
                    int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDescription");
                    int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportSeries");
                    int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportInactive");
                    int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isTemplate");
                    int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
                    int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitleId");
                    int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDescId");
                    int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportMasterChangeSeqNum");
                    int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLocalChangeSeqNum");
                    int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLastChangedBy");
                    int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLct");
                    ArrayList<Report> _result2 = new ArrayList<Report>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Report _item = new Report();
                        long _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
                        _item.setReportUid(_tmpReportUid);
                        long _tmpReportOwnerUid = _cursor.getLong(_cursorIndexOfReportOwnerUid);
                        _item.setReportOwnerUid(_tmpReportOwnerUid);
                        int _tmpXAxis = _cursor.getInt(_cursorIndexOfXAxis);
                        _item.setXAxis(_tmpXAxis);
                        int _tmpReportDateRangeSelection = _cursor.getInt(_cursorIndexOfReportDateRangeSelection);
                        _item.setReportDateRangeSelection(_tmpReportDateRangeSelection);
                        long _tmpFromDate = _cursor.getLong(_cursorIndexOfFromDate);
                        _item.setFromDate(_tmpFromDate);
                        int _tmpFromRelTo = _cursor.getInt(_cursorIndexOfFromRelTo);
                        _item.setFromRelTo(_tmpFromRelTo);
                        int _tmpFromRelOffSet = _cursor.getInt(_cursorIndexOfFromRelOffSet);
                        _item.setFromRelOffSet(_tmpFromRelOffSet);
                        int _tmpFromRelUnit = _cursor.getInt(_cursorIndexOfFromRelUnit);
                        _item.setFromRelUnit(_tmpFromRelUnit);
                        long _tmpToDate = _cursor.getLong(_cursorIndexOfToDate);
                        _item.setToDate(_tmpToDate);
                        int _tmpToRelTo = _cursor.getInt(_cursorIndexOfToRelTo);
                        _item.setToRelTo(_tmpToRelTo);
                        int _tmpToRelOffSet = _cursor.getInt(_cursorIndexOfToRelOffSet);
                        _item.setToRelOffSet(_tmpToRelOffSet);
                        int _tmpToRelUnit = _cursor.getInt(_cursorIndexOfToRelUnit);
                        _item.setToRelUnit(_tmpToRelUnit);
                        String _tmpReportTitle = _cursor.isNull(_cursorIndexOfReportTitle) ? null : _cursor.getString(_cursorIndexOfReportTitle);
                        _item.setReportTitle(_tmpReportTitle);
                        String _tmpReportDescription = _cursor.isNull(_cursorIndexOfReportDescription) ? null : _cursor.getString(_cursorIndexOfReportDescription);
                        _item.setReportDescription(_tmpReportDescription);
                        String _tmpReportSeries = _cursor.isNull(_cursorIndexOfReportSeries) ? null : _cursor.getString(_cursorIndexOfReportSeries);
                        _item.setReportSeries(_tmpReportSeries);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfReportInactive);
                        boolean _tmpReportInactive = _tmp_1 != 0;
                        _item.setReportInactive(_tmpReportInactive);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsTemplate);
                        boolean _tmpIsTemplate = _tmp_2 != 0;
                        _item.setTemplate(_tmpIsTemplate);
                        int _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
                        _item.setPriority(_tmpPriority);
                        int _tmpReportTitleId = _cursor.getInt(_cursorIndexOfReportTitleId);
                        _item.setReportTitleId(_tmpReportTitleId);
                        int _tmpReportDescId = _cursor.getInt(_cursorIndexOfReportDescId);
                        _item.setReportDescId(_tmpReportDescId);
                        long _tmpReportMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
                        _item.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
                        long _tmpReportLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
                        _item.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
                        int _tmpReportLastChangedBy = _cursor.getInt(_cursorIndexOfReportLastChangedBy);
                        _item.setReportLastChangedBy(_tmpReportLastChangedBy);
                        long _tmpReportLct = _cursor.getLong(_cursorIndexOfReportLct);
                        _item.setReportLct(_tmpReportLct);
                        _result2.add(_item);
                    }
                    ArrayList<Report> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Report> findAllActiveReportList(boolean isTemplate) {
        String _sql = "SELECT * FROM REPORT WHERE NOT reportInactive \n        AND isTemplate = ?\n        ORDER BY priority ASC\n            ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM REPORT WHERE NOT reportInactive \n        AND isTemplate = ?\n        ORDER BY priority ASC\n            ", (int)1);
        int _argIndex = 1;
        int _tmp = isTemplate ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfReportUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUid");
            int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportOwnerUid");
            int _cursorIndexOfXAxis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"xAxis");
            int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDateRangeSelection");
            int _cursorIndexOfFromDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromDate");
            int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelTo");
            int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelOffSet");
            int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fromRelUnit");
            int _cursorIndexOfToDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toDate");
            int _cursorIndexOfToRelTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelTo");
            int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelOffSet");
            int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"toRelUnit");
            int _cursorIndexOfReportTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitle");
            int _cursorIndexOfReportDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDescription");
            int _cursorIndexOfReportSeries = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportSeries");
            int _cursorIndexOfReportInactive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportInactive");
            int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isTemplate");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priority");
            int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportTitleId");
            int _cursorIndexOfReportDescId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportDescId");
            int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportMasterChangeSeqNum");
            int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLocalChangeSeqNum");
            int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLastChangedBy");
            int _cursorIndexOfReportLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportLct");
            ArrayList<Report> _result2 = new ArrayList<Report>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Report _item = new Report();
                long _tmpReportUid = _cursor.getLong(_cursorIndexOfReportUid);
                _item.setReportUid(_tmpReportUid);
                long _tmpReportOwnerUid = _cursor.getLong(_cursorIndexOfReportOwnerUid);
                _item.setReportOwnerUid(_tmpReportOwnerUid);
                int _tmpXAxis = _cursor.getInt(_cursorIndexOfXAxis);
                _item.setXAxis(_tmpXAxis);
                int _tmpReportDateRangeSelection = _cursor.getInt(_cursorIndexOfReportDateRangeSelection);
                _item.setReportDateRangeSelection(_tmpReportDateRangeSelection);
                long _tmpFromDate = _cursor.getLong(_cursorIndexOfFromDate);
                _item.setFromDate(_tmpFromDate);
                int _tmpFromRelTo = _cursor.getInt(_cursorIndexOfFromRelTo);
                _item.setFromRelTo(_tmpFromRelTo);
                int _tmpFromRelOffSet = _cursor.getInt(_cursorIndexOfFromRelOffSet);
                _item.setFromRelOffSet(_tmpFromRelOffSet);
                int _tmpFromRelUnit = _cursor.getInt(_cursorIndexOfFromRelUnit);
                _item.setFromRelUnit(_tmpFromRelUnit);
                long _tmpToDate = _cursor.getLong(_cursorIndexOfToDate);
                _item.setToDate(_tmpToDate);
                int _tmpToRelTo = _cursor.getInt(_cursorIndexOfToRelTo);
                _item.setToRelTo(_tmpToRelTo);
                int _tmpToRelOffSet = _cursor.getInt(_cursorIndexOfToRelOffSet);
                _item.setToRelOffSet(_tmpToRelOffSet);
                int _tmpToRelUnit = _cursor.getInt(_cursorIndexOfToRelUnit);
                _item.setToRelUnit(_tmpToRelUnit);
                String _tmpReportTitle = _cursor.isNull(_cursorIndexOfReportTitle) ? null : _cursor.getString(_cursorIndexOfReportTitle);
                _item.setReportTitle(_tmpReportTitle);
                String _tmpReportDescription = _cursor.isNull(_cursorIndexOfReportDescription) ? null : _cursor.getString(_cursorIndexOfReportDescription);
                _item.setReportDescription(_tmpReportDescription);
                String _tmpReportSeries = _cursor.isNull(_cursorIndexOfReportSeries) ? null : _cursor.getString(_cursorIndexOfReportSeries);
                _item.setReportSeries(_tmpReportSeries);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfReportInactive);
                boolean _tmpReportInactive = _tmp_1 != 0;
                _item.setReportInactive(_tmpReportInactive);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsTemplate);
                boolean _tmpIsTemplate = _tmp_2 != 0;
                _item.setTemplate(_tmpIsTemplate);
                int _tmpPriority = _cursor.getInt(_cursorIndexOfPriority);
                _item.setPriority(_tmpPriority);
                int _tmpReportTitleId = _cursor.getInt(_cursorIndexOfReportTitleId);
                _item.setReportTitleId(_tmpReportTitleId);
                int _tmpReportDescId = _cursor.getInt(_cursorIndexOfReportDescId);
                _item.setReportDescId(_tmpReportDescId);
                long _tmpReportMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
                _item.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
                long _tmpReportLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
                _item.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
                int _tmpReportLastChangedBy = _cursor.getInt(_cursorIndexOfReportLastChangedBy);
                _item.setReportLastChangedBy(_tmpReportLastChangedBy);
                long _tmpReportLct = _cursor.getLong(_cursorIndexOfReportLct);
                _item.setReportLct(_tmpReportLct);
                _result2.add(_item);
            }
            ArrayList<Report> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> findByUidList(List<Long> uidList) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT reportUid FROM Report WHERE reportUid IN (");
        int _inputSize = uidList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : uidList) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<Long> _result2 = new ArrayList<Long>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Long _item_1 = _cursor.getLong(0);
                _result2.add(_item_1);
            }
            ArrayList<Long> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object toggleVisibilityReportItems(final boolean toggleVisibility, final List<Long> selectedItem, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("\n");
                _stringBuilder.append("        UPDATE Report ");
                _stringBuilder.append("\n");
                _stringBuilder.append("           SET reportInactive = ");
                _stringBuilder.append("?");
                _stringBuilder.append(",");
                _stringBuilder.append("\n");
                _stringBuilder.append("               reportLct = ");
                _stringBuilder.append("?");
                _stringBuilder.append(" ");
                _stringBuilder.append("\n");
                _stringBuilder.append("         WHERE reportUid IN (");
                int _inputSize = selectedItem.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                _stringBuilder.append("\n");
                _stringBuilder.append("    ");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ReportDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                int _tmp = toggleVisibility ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                Unit unit = selectedItem.iterator();
                while (unit.hasNext()) {
                    long _item = (Long)unit.next();
                    _stmt.bindLong(_argIndex, _item);
                    ++_argIndex;
                }
                ReportDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ReportDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ReportDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Report> getResults(SupportSQLiteQuery query) {
        this.__db.assertNotSuspendingTransaction();
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)query, (boolean)false, null);){
            ArrayList<Report> _result2 = new ArrayList<Report>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Report _item = this.__entityCursorConverter_comUstadmobileLibDbEntitiesReport(_cursor);
                _result2.add(_item);
            }
            ArrayList<Report> arrayList = _result2;
            return arrayList;
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private Report __entityCursorConverter_comUstadmobileLibDbEntitiesReport(@NonNull Cursor cursor) {
        int _cursorIndexOfReportUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportUid");
        int _cursorIndexOfReportOwnerUid = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportOwnerUid");
        int _cursorIndexOfXAxis = CursorUtil.getColumnIndex((Cursor)cursor, (String)"xAxis");
        int _cursorIndexOfReportDateRangeSelection = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportDateRangeSelection");
        int _cursorIndexOfFromDate = CursorUtil.getColumnIndex((Cursor)cursor, (String)"fromDate");
        int _cursorIndexOfFromRelTo = CursorUtil.getColumnIndex((Cursor)cursor, (String)"fromRelTo");
        int _cursorIndexOfFromRelOffSet = CursorUtil.getColumnIndex((Cursor)cursor, (String)"fromRelOffSet");
        int _cursorIndexOfFromRelUnit = CursorUtil.getColumnIndex((Cursor)cursor, (String)"fromRelUnit");
        int _cursorIndexOfToDate = CursorUtil.getColumnIndex((Cursor)cursor, (String)"toDate");
        int _cursorIndexOfToRelTo = CursorUtil.getColumnIndex((Cursor)cursor, (String)"toRelTo");
        int _cursorIndexOfToRelOffSet = CursorUtil.getColumnIndex((Cursor)cursor, (String)"toRelOffSet");
        int _cursorIndexOfToRelUnit = CursorUtil.getColumnIndex((Cursor)cursor, (String)"toRelUnit");
        int _cursorIndexOfReportTitle = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportTitle");
        int _cursorIndexOfReportDescription = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportDescription");
        int _cursorIndexOfReportSeries = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportSeries");
        int _cursorIndexOfReportInactive = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportInactive");
        int _cursorIndexOfIsTemplate = CursorUtil.getColumnIndex((Cursor)cursor, (String)"isTemplate");
        int _cursorIndexOfPriority = CursorUtil.getColumnIndex((Cursor)cursor, (String)"priority");
        int _cursorIndexOfReportTitleId = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportTitleId");
        int _cursorIndexOfReportDescId = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportDescId");
        int _cursorIndexOfReportMasterChangeSeqNum = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportMasterChangeSeqNum");
        int _cursorIndexOfReportLocalChangeSeqNum = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportLocalChangeSeqNum");
        int _cursorIndexOfReportLastChangedBy = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportLastChangedBy");
        int _cursorIndexOfReportLct = CursorUtil.getColumnIndex((Cursor)cursor, (String)"reportLct");
        Report _entity = new Report();
        if (_cursorIndexOfReportUid != -1) {
            long _tmpReportUid = cursor.getLong(_cursorIndexOfReportUid);
            _entity.setReportUid(_tmpReportUid);
        }
        if (_cursorIndexOfReportOwnerUid != -1) {
            long _tmpReportOwnerUid = cursor.getLong(_cursorIndexOfReportOwnerUid);
            _entity.setReportOwnerUid(_tmpReportOwnerUid);
        }
        if (_cursorIndexOfXAxis != -1) {
            int _tmpXAxis = cursor.getInt(_cursorIndexOfXAxis);
            _entity.setXAxis(_tmpXAxis);
        }
        if (_cursorIndexOfReportDateRangeSelection != -1) {
            int _tmpReportDateRangeSelection = cursor.getInt(_cursorIndexOfReportDateRangeSelection);
            _entity.setReportDateRangeSelection(_tmpReportDateRangeSelection);
        }
        if (_cursorIndexOfFromDate != -1) {
            long _tmpFromDate = cursor.getLong(_cursorIndexOfFromDate);
            _entity.setFromDate(_tmpFromDate);
        }
        if (_cursorIndexOfFromRelTo != -1) {
            int _tmpFromRelTo = cursor.getInt(_cursorIndexOfFromRelTo);
            _entity.setFromRelTo(_tmpFromRelTo);
        }
        if (_cursorIndexOfFromRelOffSet != -1) {
            int _tmpFromRelOffSet = cursor.getInt(_cursorIndexOfFromRelOffSet);
            _entity.setFromRelOffSet(_tmpFromRelOffSet);
        }
        if (_cursorIndexOfFromRelUnit != -1) {
            int _tmpFromRelUnit = cursor.getInt(_cursorIndexOfFromRelUnit);
            _entity.setFromRelUnit(_tmpFromRelUnit);
        }
        if (_cursorIndexOfToDate != -1) {
            long _tmpToDate = cursor.getLong(_cursorIndexOfToDate);
            _entity.setToDate(_tmpToDate);
        }
        if (_cursorIndexOfToRelTo != -1) {
            int _tmpToRelTo = cursor.getInt(_cursorIndexOfToRelTo);
            _entity.setToRelTo(_tmpToRelTo);
        }
        if (_cursorIndexOfToRelOffSet != -1) {
            int _tmpToRelOffSet = cursor.getInt(_cursorIndexOfToRelOffSet);
            _entity.setToRelOffSet(_tmpToRelOffSet);
        }
        if (_cursorIndexOfToRelUnit != -1) {
            int _tmpToRelUnit = cursor.getInt(_cursorIndexOfToRelUnit);
            _entity.setToRelUnit(_tmpToRelUnit);
        }
        if (_cursorIndexOfReportTitle != -1) {
            String _tmpReportTitle = cursor.isNull(_cursorIndexOfReportTitle) ? null : cursor.getString(_cursorIndexOfReportTitle);
            _entity.setReportTitle(_tmpReportTitle);
        }
        if (_cursorIndexOfReportDescription != -1) {
            String _tmpReportDescription = cursor.isNull(_cursorIndexOfReportDescription) ? null : cursor.getString(_cursorIndexOfReportDescription);
            _entity.setReportDescription(_tmpReportDescription);
        }
        if (_cursorIndexOfReportSeries != -1) {
            String _tmpReportSeries = cursor.isNull(_cursorIndexOfReportSeries) ? null : cursor.getString(_cursorIndexOfReportSeries);
            _entity.setReportSeries(_tmpReportSeries);
        }
        if (_cursorIndexOfReportInactive != -1) {
            int _tmp = cursor.getInt(_cursorIndexOfReportInactive);
            boolean _tmpReportInactive = _tmp != 0;
            _entity.setReportInactive(_tmpReportInactive);
        }
        if (_cursorIndexOfIsTemplate != -1) {
            int _tmp_1 = cursor.getInt(_cursorIndexOfIsTemplate);
            boolean _tmpIsTemplate = _tmp_1 != 0;
            _entity.setTemplate(_tmpIsTemplate);
        }
        if (_cursorIndexOfPriority != -1) {
            int _tmpPriority = cursor.getInt(_cursorIndexOfPriority);
            _entity.setPriority(_tmpPriority);
        }
        if (_cursorIndexOfReportTitleId != -1) {
            int _tmpReportTitleId = cursor.getInt(_cursorIndexOfReportTitleId);
            _entity.setReportTitleId(_tmpReportTitleId);
        }
        if (_cursorIndexOfReportDescId != -1) {
            int _tmpReportDescId = cursor.getInt(_cursorIndexOfReportDescId);
            _entity.setReportDescId(_tmpReportDescId);
        }
        if (_cursorIndexOfReportMasterChangeSeqNum != -1) {
            long _tmpReportMasterChangeSeqNum = cursor.getLong(_cursorIndexOfReportMasterChangeSeqNum);
            _entity.setReportMasterChangeSeqNum(_tmpReportMasterChangeSeqNum);
        }
        if (_cursorIndexOfReportLocalChangeSeqNum != -1) {
            long _tmpReportLocalChangeSeqNum = cursor.getLong(_cursorIndexOfReportLocalChangeSeqNum);
            _entity.setReportLocalChangeSeqNum(_tmpReportLocalChangeSeqNum);
        }
        if (_cursorIndexOfReportLastChangedBy != -1) {
            int _tmpReportLastChangedBy = cursor.getInt(_cursorIndexOfReportLastChangedBy);
            _entity.setReportLastChangedBy(_tmpReportLastChangedBy);
        }
        if (_cursorIndexOfReportLct != -1) {
            long _tmpReportLct = cursor.getLong(_cursorIndexOfReportLct);
            _entity.setReportLct(_tmpReportLct);
        }
        return _entity;
    }
}

