/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.composites.EditAndViewPermission;
import com.ustadmobile.lib.db.composites.PermissionPair;
import com.ustadmobile.lib.db.entities.SystemPermission;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u00a7@\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H'J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H'J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H'J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"Lcom/ustadmobile/core/db/dao/SystemPermissionDao;", "", "()V", "findAllByPersonUid", "", "Lcom/ustadmobile/lib/db/entities/SystemPermission;", "accountPersonUid", "", "includeDeleted", "", "(JZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllByPersonUidEntities", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByPersonUid", "findByPersonUidAsFlow", "Lkotlinx/coroutines/flow/Flow;", "personHasEditAndViewPermissionForPersonAsFlow", "Lcom/ustadmobile/lib/db/composites/EditAndViewPermission;", "otherPersonUid", "personHasSystemPermission", "permission", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "personHasSystemPermissionAsFlow", "personHasSystemPermissionPair", "Lcom/ustadmobile/lib/db/composites/PermissionPair;", "firstPermission", "secondPermission", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "personHasSystemPermissionPairAsFlow", "upsertAsync", "", "systemPermissions", "(Lcom/ustadmobile/lib/db/entities/SystemPermission;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_debug"})
@Dao
public abstract class SystemPermissionDao {
    @Query(value="\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n           AND (CAST(:includeDeleted AS INTEGER) = 1 OR NOT SystemPermission.spIsDeleted)\n    ")
    @Nullable
    public abstract Object findAllByPersonUid(long var1, boolean var3, @NotNull Continuation<? super List<SystemPermission>> var4);

    @Query(value="\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n         ")
    @Nullable
    public abstract Object findAllByPersonUidEntities(long var1, @NotNull Continuation<? super List<SystemPermission>> var3);

    @Query(value="\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n         LIMIT 1\n    ")
    @NotNull
    public abstract Flow<SystemPermission> findByPersonUidAsFlow(long var1);

    @Query(value="\n        SELECT SystemPermission.*\n          FROM SystemPermission\n         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n         LIMIT 1\n    ")
    @Nullable
    public abstract Object findByPersonUid(long var1, @NotNull Continuation<? super SystemPermission> var3);

    @Query(value="\n        SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n          :permission\n        \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n      \n    ")
    @Nullable
    public abstract Object personHasSystemPermission(long var1, long var3, @NotNull Continuation<? super Boolean> var5);

    @Query(value="\n        SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n          :permission\n        \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n      \n    ")
    @NotNull
    public abstract Flow<Boolean> personHasSystemPermissionAsFlow(long var1, long var3);

    @Query(value="\n        SELECT (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                :firstPermission\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as firstPermission,\n                (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                :secondPermission\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as secondPermission\n    ")
    @NotNull
    public abstract Flow<PermissionPair> personHasSystemPermissionPairAsFlow(long var1, long var3, long var5);

    @Query(value="\n        SELECT (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                :firstPermission\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as firstPermission,\n                (\n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n    \n                :secondPermission\n                \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    ) as secondPermission\n    ")
    @Nullable
    public abstract Object personHasSystemPermissionPair(long var1, long var3, long var5, @NotNull Continuation<? super PermissionPair> var7);

    @Query(value="\n        /* Similar to the query used on list all persons, however it uses the the otherpersonuid param \n         * in the WHERE clauses to narrow down the search. \n         */\n        WITH CanViewPersonUidsViaCoursePermission(personUid) AS\n              /* Select personUids that can be viewed based on CoursePermission given to the active\n               * user for their enrolment role in that course\n              */\n              (SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM ClazzEnrolment ClazzEnrolment_ForActiveUser\n                      JOIN CoursePermission \n                           ON CoursePermission.cpClazzUid = ClazzEnrolment_ForActiveUser.clazzEnrolmentClazzUid\n                          AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForActiveUser.clazzEnrolmentRole\n                          AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                              AND ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid = :otherPersonUid\n                WHERE :accountPersonUid != 0\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentPersonUid = :accountPersonUid\n                  AND ClazzEnrolment_ForActiveUser.clazzEnrolmentActive\n              \n               UNION\n               /* Select personUids that can be viewed based on CoursePermission for the active user\n                  where the CoursePermission is granted directly to them\n                */   \n               SELECT DISTINCT ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid AS personUid\n                 FROM CoursePermission\n                      JOIN ClazzEnrolment ClazzEnrolment_ForClazzMember\n                           ON ClazzEnrolment_ForClazzMember.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                              AND ClazzEnrolment_ForClazzMember.clazzEnrolmentPersonUid = :otherPersonUid\n                WHERE :accountPersonUid != 0\n                  AND CoursePermission.cpToPersonUid = :accountPersonUid)\n                  \n        SELECT (    (SELECT :accountPersonUid = :otherPersonUid)\n                 OR EXISTS(SELECT 1\n                             FROM PersonParentJoin\n                            WHERE PersonParentJoin.ppjMinorPersonUid = :otherPersonUid\n                              AND PersonParentJoin.ppjParentPersonUid = :accountPersonUid)\n                 OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            8192\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                 OR (SELECT :otherPersonUid IN \n                             (SELECT CanViewPersonUidsViaCoursePermission.personUid\n                                 FROM CanViewPersonUidsViaCoursePermission))           \n               ) AS hasViewPermission,\n               \n               (   (SELECT :accountPersonUid = :otherPersonUid)\n                OR EXISTS(SELECT 1\n                             FROM PersonParentJoin\n                            WHERE PersonParentJoin.ppjMinorPersonUid = :otherPersonUid\n                              AND PersonParentJoin.ppjParentPersonUid = :accountPersonUid)\n                OR (SELECT \n        EXISTS(SELECT 1\n                 FROM SystemPermission\n                WHERE :accountPersonUid != 0 \n                  AND SystemPermission.spToPersonUid = :accountPersonUid\n                  AND (SystemPermission.spPermissionsFlag &\n     \n                            32768\n                            \n        ) > 0\n                  AND NOT SystemPermission.spIsDeleted)\n    )\n                ) AS hasEditPermission\n    ")
    @NotNull
    public abstract Flow<EditAndViewPermission> personHasEditAndViewPermissionForPersonAsFlow(long var1, long var3);

    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsertAsync(@NotNull SystemPermission var1, @NotNull Continuation<? super Unit> var2);
}

