/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.TransferJobDao;
import com.ustadmobile.lib.db.composites.TransferJobAndTotals;
import com.ustadmobile.lib.db.entities.TransferJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class TransferJobDao_Impl
extends TransferJobDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<TransferJob> __insertionAdapterOfTransferJob;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatus;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStatusIfComplete;

    public TransferJobDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTransferJob = new EntityInsertionAdapter<TransferJob>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `TransferJob` (`tjUid`,`tjType`,`tjStatus`,`tjName`,`tjUuid`,`tjTableId`,`tjEntityUid`,`tjTimeCreated`,`tjCreationType`,`tjOiUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull TransferJob entity) {
                statement.bindLong(1, (long)entity.getTjUid());
                statement.bindLong(2, (long)entity.getTjType());
                statement.bindLong(3, (long)entity.getTjStatus());
                if (entity.getTjName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getTjName());
                }
                if (entity.getTjUuid() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getTjUuid());
                }
                statement.bindLong(6, (long)entity.getTjTableId());
                statement.bindLong(7, entity.getTjEntityUid());
                statement.bindLong(8, entity.getTjTimeCreated());
                statement.bindLong(9, (long)entity.getTjCreationType());
                statement.bindLong(10, entity.getTjOiUid());
            }
        };
        this.__preparedStmtOfUpdateStatus = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE TransferJob\n           SET tjStatus = ?\n         WHERE tjUid = ?  \n    ";
                return "\n        UPDATE TransferJob\n           SET tjStatus = ?\n         WHERE tjUid = ?  \n    ";
            }
        };
        this.__preparedStmtOfUpdateStatusIfComplete = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE TransferJob\n           SET tjStatus = 21\n         WHERE tjUid = ?\n          AND NOT EXISTS(\n              SELECT TransferJobItem.tjiUid\n                FROM TransferJobItem\n               WHERE TransferJobItem.tjiTjUid = ?\n                 AND TransferJobItem.tjiStatus != 21) \n    ";
                return "\n        UPDATE TransferJob\n           SET tjStatus = 21\n         WHERE tjUid = ?\n          AND NOT EXISTS(\n              SELECT TransferJobItem.tjiUid\n                FROM TransferJobItem\n               WHERE TransferJobItem.tjiTjUid = ?\n                 AND TransferJobItem.tjiStatus != 21) \n    ";
            }
        };
    }

    @Override
    public Object insert(final TransferJob job, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                TransferJobDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = TransferJobDao_Impl.this.__insertionAdapterOfTransferJob.insertAndReturnId((Object)job);
                    TransferJobDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    TransferJobDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateStatus(final int jobUid, final int status, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TransferJobDao_Impl.this.__preparedStmtOfUpdateStatus.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)status);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)jobUid);
                try {
                    Unit unit;
                    TransferJobDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        TransferJobDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        TransferJobDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    TransferJobDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    TransferJobDao_Impl.this.__preparedStmtOfUpdateStatus.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateStatusIfComplete(final int jobUid, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                SupportSQLiteStatement _stmt = TransferJobDao_Impl.this.__preparedStmtOfUpdateStatusIfComplete.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)jobUid);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)jobUid);
                try {
                    Integer n;
                    TransferJobDao_Impl.this.__db.beginTransaction();
                    try {
                        Integer _result2 = _stmt.executeUpdateDelete();
                        TransferJobDao_Impl.this.__db.setTransactionSuccessful();
                        n = _result2;
                    }
                    catch (Throwable throwable) {
                        TransferJobDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    TransferJobDao_Impl.this.__db.endTransaction();
                    return n;
                }
                finally {
                    TransferJobDao_Impl.this.__preparedStmtOfUpdateStatusIfComplete.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUid(int jobUid, Continuation<? super TransferJob> $completion) {
        String _sql = "\n        SELECT TransferJob.*\n          FROM TransferJob\n         WHERE TransferJob.tjUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT TransferJob.*\n          FROM TransferJob\n         WHERE TransferJob.tjUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)jobUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<TransferJob>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public TransferJob call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    TransferJob _result2;
                    int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUid");
                    int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjType");
                    int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjStatus");
                    int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjName");
                    int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUuid");
                    int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTableId");
                    int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjEntityUid");
                    int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTimeCreated");
                    int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjCreationType");
                    int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjOiUid");
                    if (_cursor.moveToFirst()) {
                        int _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
                        int _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
                        int _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
                        String _tmpTjName = _cursor.isNull(_cursorIndexOfTjName) ? null : _cursor.getString(_cursorIndexOfTjName);
                        String _tmpTjUuid = _cursor.isNull(_cursorIndexOfTjUuid) ? null : _cursor.getString(_cursorIndexOfTjUuid);
                        int _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
                        long _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
                        long _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
                        int _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
                        long _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
                        _result2 = new TransferJob(_tmpTjUid, _tmpTjType, _tmpTjStatus, _tmpTjName, _tmpTjUuid, _tmpTjTableId, _tmpTjEntityUid, _tmpTjTimeCreated, _tmpTjCreationType, _tmpTjOiUid);
                    } else {
                        _result2 = null;
                    }
                    TransferJob transferJob = _result2;
                    return transferJob;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<TransferJob> findByUidAsFlow(int jobUid) {
        String _sql = "\n        SELECT TransferJob.*\n          FROM TransferJob\n         WHERE TransferJob.tjUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT TransferJob.*\n          FROM TransferJob\n         WHERE TransferJob.tjUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)jobUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"TransferJob"}, (Callable)new Callable<TransferJob>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public TransferJob call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    TransferJob _result2;
                    int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUid");
                    int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjType");
                    int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjStatus");
                    int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjName");
                    int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUuid");
                    int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTableId");
                    int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjEntityUid");
                    int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTimeCreated");
                    int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjCreationType");
                    int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjOiUid");
                    if (_cursor.moveToFirst()) {
                        int _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
                        int _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
                        int _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
                        String _tmpTjName = _cursor.isNull(_cursorIndexOfTjName) ? null : _cursor.getString(_cursorIndexOfTjName);
                        String _tmpTjUuid = _cursor.isNull(_cursorIndexOfTjUuid) ? null : _cursor.getString(_cursorIndexOfTjUuid);
                        int _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
                        long _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
                        long _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
                        int _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
                        long _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
                        _result2 = new TransferJob(_tmpTjUid, _tmpTjType, _tmpTjStatus, _tmpTjName, _tmpTjUuid, _tmpTjTableId, _tmpTjEntityUid, _tmpTjTimeCreated, _tmpTjCreationType, _tmpTjOiUid);
                    } else {
                        _result2 = null;
                    }
                    TransferJob transferJob = _result2;
                    return transferJob;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object getJobStatus(int jobUid, Continuation<? super Integer> $completion) {
        String _sql = "\n        SELECT COALESCE(\n            (SELECT TransferJob.tjStatus\n               FROM TransferJob\n              WHERE tjUid = ?), 0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COALESCE(\n            (SELECT TransferJob.tjStatus\n               FROM TransferJob\n              WHERE tjUid = ?), 0)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)jobUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Integer call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _result2;
                    if (_cursor.moveToFirst()) {
                        int _tmp = _cursor.getInt(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0;
                    }
                    Integer n = _result2;
                    return n;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findJobByEntityAndTableUid(int tableId, long entityUid, Continuation<? super List<TransferJob>> $completion) {
        String _sql = "\n        SELECT TransferJob.*\n          FROM TransferJob\n         WHERE EXISTS(\n               SELECT TransferJobItem.tjiUid\n                 FROM TransferJobItem\n                WHERE TransferJobItem.tjiTjUid = TransferJob.tjUid\n                  AND TransferJobItem.tjiTableId = ?\n                  AND TransferJobItem.tjiEntityUid = ?) \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT TransferJob.*\n          FROM TransferJob\n         WHERE EXISTS(\n               SELECT TransferJobItem.tjiUid\n                 FROM TransferJobItem\n                WHERE TransferJobItem.tjiTjUid = TransferJob.tjUid\n                  AND TransferJobItem.tjiTableId = ?\n                  AND TransferJobItem.tjiEntityUid = ?) \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)tableId);
        _argIndex = 2;
        _statement.bindLong(_argIndex, entityUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<TransferJob>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<TransferJob> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUid");
                    int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjType");
                    int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjStatus");
                    int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjName");
                    int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUuid");
                    int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTableId");
                    int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjEntityUid");
                    int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTimeCreated");
                    int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjCreationType");
                    int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjOiUid");
                    ArrayList<TransferJob> _result2 = new ArrayList<TransferJob>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
                        int _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
                        int _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
                        String _tmpTjName = _cursor.isNull(_cursorIndexOfTjName) ? null : _cursor.getString(_cursorIndexOfTjName);
                        String _tmpTjUuid = _cursor.isNull(_cursorIndexOfTjUuid) ? null : _cursor.getString(_cursorIndexOfTjUuid);
                        int _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
                        long _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
                        long _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
                        int _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
                        long _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
                        TransferJob _item = new TransferJob(_tmpTjUid, _tmpTjType, _tmpTjStatus, _tmpTjName, _tmpTjUuid, _tmpTjTableId, _tmpTjEntityUid, _tmpTjTimeCreated, _tmpTjCreationType, _tmpTjOiUid);
                        _result2.add(_item);
                    }
                    ArrayList<TransferJob> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<TransferJobAndTotals>> findByContentEntryUidWithTotalsAsFlow(long contentEntryUid, int jobType) {
        String _sql = "\n        SELECT TransferJob.*,\n               \n        (SELECT SUM(TransferJobItem.tjTotalSize)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS totalSize,\n                (SELECT SUM(TransferJobItem.tjTransferred)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS transferred \n    ,\n               TransferJobError.tjeErrorStr AS latestErrorStr\n          FROM TransferJob\n               LEFT JOIN TransferJobError\n                         ON TransferJobError.tjeId = \n                            (SELECT TransferJobError.tjeId\n                               FROM TransferJobError\n                              WHERE TransferJob.tjStatus = 22\n                                AND TransferJobError.tjeTjUid = TransferJob.tjUid\n                           ORDER BY TransferJobError.tjeDismissed DESC \n                              LIMIT 1)\n         WHERE TransferJob.tjTableId = 738\n           AND TransferJob.tjEntityUid IN \n               \n        (SELECT ContentEntryVersion.cevUid\n                         FROM ContentEntryVersion\n                        WHERE ContentEntryVersion.cevContentEntryUid = ?)\n     \n           AND (   TransferJob.tjStatus < 21\n                OR (TransferJobError.tjeErrorStr IS NOT NULL AND NOT TransferJobError.tjeDismissed))\n           AND TransferJob.tjType = ?   \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT TransferJob.*,\n               \n        (SELECT SUM(TransferJobItem.tjTotalSize)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS totalSize,\n                (SELECT SUM(TransferJobItem.tjTransferred)\n                   FROM TransferJobItem\n                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS transferred \n    ,\n               TransferJobError.tjeErrorStr AS latestErrorStr\n          FROM TransferJob\n               LEFT JOIN TransferJobError\n                         ON TransferJobError.tjeId = \n                            (SELECT TransferJobError.tjeId\n                               FROM TransferJobError\n                              WHERE TransferJob.tjStatus = 22\n                                AND TransferJobError.tjeTjUid = TransferJob.tjUid\n                           ORDER BY TransferJobError.tjeDismissed DESC \n                              LIMIT 1)\n         WHERE TransferJob.tjTableId = 738\n           AND TransferJob.tjEntityUid IN \n               \n        (SELECT ContentEntryVersion.cevUid\n                         FROM ContentEntryVersion\n                        WHERE ContentEntryVersion.cevContentEntryUid = ?)\n     \n           AND (   TransferJob.tjStatus < 21\n                OR (TransferJobError.tjeErrorStr IS NOT NULL AND NOT TransferJobError.tjeDismissed))\n           AND TransferJob.tjType = ?   \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)jobType);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"TransferJobItem", "TransferJob", "TransferJobError", "ContentEntryVersion"}, (Callable)new Callable<List<TransferJobAndTotals>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<TransferJobAndTotals> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUid");
                    int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjType");
                    int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjStatus");
                    int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjName");
                    int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjUuid");
                    int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTableId");
                    int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjEntityUid");
                    int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjTimeCreated");
                    int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjCreationType");
                    int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjOiUid");
                    int _cursorIndexOfTotalSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"totalSize");
                    int _cursorIndexOfTransferred = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"transferred");
                    int _cursorIndexOfLatestErrorStr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"latestErrorStr");
                    ArrayList<TransferJobAndTotals> _result2 = new ArrayList<TransferJobAndTotals>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        TransferJob _tmpTransferJob;
                        long _tmpTotalSize = _cursor.getLong(_cursorIndexOfTotalSize);
                        long _tmpTransferred = _cursor.getLong(_cursorIndexOfTransferred);
                        String _tmpLatestErrorStr = _cursor.isNull(_cursorIndexOfLatestErrorStr) ? null : _cursor.getString(_cursorIndexOfLatestErrorStr);
                        if (!(_cursor.isNull(_cursorIndexOfTjUid) && _cursor.isNull(_cursorIndexOfTjType) && _cursor.isNull(_cursorIndexOfTjStatus) && _cursor.isNull(_cursorIndexOfTjName) && _cursor.isNull(_cursorIndexOfTjUuid) && _cursor.isNull(_cursorIndexOfTjTableId) && _cursor.isNull(_cursorIndexOfTjEntityUid) && _cursor.isNull(_cursorIndexOfTjTimeCreated) && _cursor.isNull(_cursorIndexOfTjCreationType) && _cursor.isNull(_cursorIndexOfTjOiUid))) {
                            int _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
                            int _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
                            int _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
                            String _tmpTjName = _cursor.isNull(_cursorIndexOfTjName) ? null : _cursor.getString(_cursorIndexOfTjName);
                            String _tmpTjUuid = _cursor.isNull(_cursorIndexOfTjUuid) ? null : _cursor.getString(_cursorIndexOfTjUuid);
                            int _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
                            long _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
                            long _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
                            int _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
                            long _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
                            _tmpTransferJob = new TransferJob(_tmpTjUid, _tmpTjType, _tmpTjStatus, _tmpTjName, _tmpTjUuid, _tmpTjTableId, _tmpTjEntityUid, _tmpTjTimeCreated, _tmpTjCreationType, _tmpTjOiUid);
                        } else {
                            _tmpTransferJob = null;
                        }
                        TransferJobAndTotals _item = new TransferJobAndTotals(_tmpTransferJob, _tmpTotalSize, _tmpTransferred, _tmpLatestErrorStr);
                        _result2.add(_item);
                    }
                    ArrayList<TransferJobAndTotals> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findOfflineItemUidForTransferJobUid(int jobUid, Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT COALESCE(\n               (SELECT TransferJob.tjOiUid\n                  FROM TransferJob\n                 WHERE TransferJob.tjUid = ?), 0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COALESCE(\n               (SELECT TransferJob.tjOiUid\n                  FROM TransferJob\n                 WHERE TransferJob.tjUid = ?), 0)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)jobUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

