/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.ActivityExtensionDao;
import com.ustadmobile.lib.db.entities.xapi.ActivityExtensionEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ActivityExtensionDao_Impl
extends ActivityExtensionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ActivityExtensionEntity> __insertionAdapterOfActivityExtensionEntity;

    public ActivityExtensionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfActivityExtensionEntity = new EntityInsertionAdapter<ActivityExtensionEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ActivityExtensionEntity` (`aeeActivityUid`,`aeeKeyHash`,`aeeKey`,`aeeJson`,`aeeLastMod`,`aeeIsDeleted`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ActivityExtensionEntity entity) {
                statement.bindLong(1, entity.getAeeActivityUid());
                statement.bindLong(2, entity.getAeeKeyHash());
                if (entity.getAeeKey() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getAeeKey());
                }
                if (entity.getAeeJson() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getAeeJson());
                }
                statement.bindLong(5, entity.getAeeLastMod());
                int _tmp = entity.getAeeIsDeleted() ? 1 : 0;
                statement.bindLong(6, (long)_tmp);
            }
        };
    }

    @Override
    public Object upsertListAsync(final List<ActivityExtensionEntity> list, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ActivityExtensionDao_Impl.this.__db.beginTransaction();
                try {
                    ActivityExtensionDao_Impl.this.__insertionAdapterOfActivityExtensionEntity.insert((Iterable)list);
                    ActivityExtensionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ActivityExtensionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllByActivityUid(long activityUid, Continuation<? super List<ActivityExtensionEntity>> $completion) {
        String _sql = "\n        SELECT ActivityExtensionEntity.*\n          FROM ActivityExtensionEntity\n         WHERE ActivityExtensionEntity.aeeActivityUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ActivityExtensionEntity.*\n          FROM ActivityExtensionEntity\n         WHERE ActivityExtensionEntity.aeeActivityUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, activityUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ActivityExtensionEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ActivityExtensionEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActivityExtensionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfAeeActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aeeActivityUid");
                    int _cursorIndexOfAeeKeyHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aeeKeyHash");
                    int _cursorIndexOfAeeKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aeeKey");
                    int _cursorIndexOfAeeJson = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aeeJson");
                    int _cursorIndexOfAeeLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aeeLastMod");
                    int _cursorIndexOfAeeIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"aeeIsDeleted");
                    ArrayList<ActivityExtensionEntity> _result2 = new ArrayList<ActivityExtensionEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpAeeActivityUid = _cursor.getLong(_cursorIndexOfAeeActivityUid);
                        long _tmpAeeKeyHash = _cursor.getLong(_cursorIndexOfAeeKeyHash);
                        String _tmpAeeKey = _cursor.isNull(_cursorIndexOfAeeKey) ? null : _cursor.getString(_cursorIndexOfAeeKey);
                        String _tmpAeeJson = _cursor.isNull(_cursorIndexOfAeeJson) ? null : _cursor.getString(_cursorIndexOfAeeJson);
                        long _tmpAeeLastMod = _cursor.getLong(_cursorIndexOfAeeLastMod);
                        int _tmp = _cursor.getInt(_cursorIndexOfAeeIsDeleted);
                        boolean _tmpAeeIsDeleted = _tmp != 0;
                        ActivityExtensionEntity _item = new ActivityExtensionEntity(_tmpAeeActivityUid, _tmpAeeKeyHash, _tmpAeeKey, _tmpAeeJson, _tmpAeeLastMod, _tmpAeeIsDeleted);
                        _result2.add(_item);
                    }
                    ArrayList<ActivityExtensionEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

