/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.ActivityLangMapEntryDao;
import com.ustadmobile.lib.db.entities.xapi.ActivityLangMapEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ActivityLangMapEntryDao_Impl
extends ActivityLangMapEntryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ActivityLangMapEntry> __insertionAdapterOfActivityLangMapEntry;
    private final SharedSQLiteStatement __preparedStmtOfUpsertIfInteractionEntityExists;
    private final SharedSQLiteStatement __preparedStmtOfUpdateIfChanged;

    public ActivityLangMapEntryDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfActivityLangMapEntry = new EntityInsertionAdapter<ActivityLangMapEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ActivityLangMapEntry` (`almeActivityUid`,`almeHash`,`almeLangCode`,`almePropName`,`almeValue`,`almeAieHash`,`almeLastMod`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ActivityLangMapEntry entity) {
                statement.bindLong(1, entity.getAlmeActivityUid());
                statement.bindLong(2, entity.getAlmeHash());
                if (entity.getAlmeLangCode() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getAlmeLangCode());
                }
                if (entity.getAlmePropName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getAlmePropName());
                }
                if (entity.getAlmeValue() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getAlmeValue());
                }
                statement.bindLong(6, entity.getAlmeAieHash());
                statement.bindLong(7, entity.getAlmeLastMod());
            }
        };
        this.__preparedStmtOfUpsertIfInteractionEntityExists = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        INSERT OR REPLACE \n        INTO ActivityLangMapEntry(almeActivityUid, almeHash, almeLangCode, almePropName, almeValue, almeAieHash, almeLastMod)\n        SELECT ? AS almeActivityUid,\n               ? AS almeHash,\n               ? AS almeLangCode,\n               ? AS almePropName,\n               ? AS almeValue,\n               ? AS almeAieHash,\n               ? AS almeLastMod\n         WHERE EXISTS(SELECT 1\n                        FROM ActivityInteractionEntity\n                       WHERE ActivityInteractionEntity.aieActivityUid = ?\n                         AND ActivityInteractionEntity.aieHash = ?)\n          \n    ";
                return "\n        INSERT OR REPLACE \n        INTO ActivityLangMapEntry(almeActivityUid, almeHash, almeLangCode, almePropName, almeValue, almeAieHash, almeLastMod)\n        SELECT ? AS almeActivityUid,\n               ? AS almeHash,\n               ? AS almeLangCode,\n               ? AS almePropName,\n               ? AS almeValue,\n               ? AS almeAieHash,\n               ? AS almeLastMod\n         WHERE EXISTS(SELECT 1\n                        FROM ActivityInteractionEntity\n                       WHERE ActivityInteractionEntity.aieActivityUid = ?\n                         AND ActivityInteractionEntity.aieHash = ?)\n          \n    ";
            }
        };
        this.__preparedStmtOfUpdateIfChanged = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ActivityLangMapEntry\n           SET almeValue = ?,\n               almeLastMod = ?\n         WHERE almeActivityUid = ?\n           AND almeHash = ?\n           AND almeValue != ?       \n    ";
                return "\n        UPDATE ActivityLangMapEntry\n           SET almeValue = ?,\n               almeLastMod = ?\n         WHERE almeActivityUid = ?\n           AND almeHash = ?\n           AND almeValue != ?       \n    ";
            }
        };
    }

    @Override
    public Object upsertList(final List<ActivityLangMapEntry> entities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                ActivityLangMapEntryDao_Impl.this.__db.beginTransaction();
                try {
                    ActivityLangMapEntryDao_Impl.this.__insertionAdapterOfActivityLangMapEntry.insert((Iterable)entities);
                    ActivityLangMapEntryDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ActivityLangMapEntryDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertIfInteractionEntityExists(final long almeActivityUid, final long almeHash, final String almePropName, final String almeLangCode, final String almeValue, final long almeAieHash, final long almeLastMod, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ActivityLangMapEntryDao_Impl.this.__preparedStmtOfUpsertIfInteractionEntityExists.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, almeActivityUid);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, almeHash);
                _argIndex = 3;
                if (almeLangCode == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, almeLangCode);
                }
                _argIndex = 4;
                if (almePropName == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, almePropName);
                }
                _argIndex = 5;
                if (almeValue == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, almeValue);
                }
                _argIndex = 6;
                _stmt.bindLong(_argIndex, almeAieHash);
                _argIndex = 7;
                _stmt.bindLong(_argIndex, almeLastMod);
                _argIndex = 8;
                _stmt.bindLong(_argIndex, almeActivityUid);
                _argIndex = 9;
                _stmt.bindLong(_argIndex, almeAieHash);
                try {
                    Unit unit;
                    ActivityLangMapEntryDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeInsert();
                        ActivityLangMapEntryDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ActivityLangMapEntryDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ActivityLangMapEntryDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ActivityLangMapEntryDao_Impl.this.__preparedStmtOfUpsertIfInteractionEntityExists.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateIfChanged(final long almeActivityUid, final long almeHash, final String almeValue, final long almeLastMod, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ActivityLangMapEntryDao_Impl.this.__preparedStmtOfUpdateIfChanged.acquire();
                int _argIndex = 1;
                if (almeValue == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, almeValue);
                }
                _argIndex = 2;
                _stmt.bindLong(_argIndex, almeLastMod);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, almeActivityUid);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, almeHash);
                _argIndex = 5;
                if (almeValue == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, almeValue);
                }
                try {
                    Unit unit;
                    ActivityLangMapEntryDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ActivityLangMapEntryDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ActivityLangMapEntryDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ActivityLangMapEntryDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ActivityLangMapEntryDao_Impl.this.__preparedStmtOfUpdateIfChanged.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllByActivityUid(long activityUid, Continuation<? super List<ActivityLangMapEntry>> $completion) {
        String _sql = "\n        SELECT ActivityLangMapEntry.*\n          FROM ActivityLangMapEntry\n         WHERE ActivityLangMapEntry.almeActivityUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ActivityLangMapEntry.*\n          FROM ActivityLangMapEntry\n         WHERE ActivityLangMapEntry.almeActivityUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, activityUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ActivityLangMapEntry>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ActivityLangMapEntry> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActivityLangMapEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfAlmeActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeActivityUid");
                    int _cursorIndexOfAlmeHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeHash");
                    int _cursorIndexOfAlmeLangCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeLangCode");
                    int _cursorIndexOfAlmePropName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almePropName");
                    int _cursorIndexOfAlmeValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeValue");
                    int _cursorIndexOfAlmeAieHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeAieHash");
                    int _cursorIndexOfAlmeLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"almeLastMod");
                    ArrayList<ActivityLangMapEntry> _result2 = new ArrayList<ActivityLangMapEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpAlmeActivityUid = _cursor.getLong(_cursorIndexOfAlmeActivityUid);
                        long _tmpAlmeHash = _cursor.getLong(_cursorIndexOfAlmeHash);
                        String _tmpAlmeLangCode = _cursor.isNull(_cursorIndexOfAlmeLangCode) ? null : _cursor.getString(_cursorIndexOfAlmeLangCode);
                        String _tmpAlmePropName = _cursor.isNull(_cursorIndexOfAlmePropName) ? null : _cursor.getString(_cursorIndexOfAlmePropName);
                        String _tmpAlmeValue = _cursor.isNull(_cursorIndexOfAlmeValue) ? null : _cursor.getString(_cursorIndexOfAlmeValue);
                        long _tmpAlmeAieHash = _cursor.getLong(_cursorIndexOfAlmeAieHash);
                        long _tmpAlmeLastMod = _cursor.getLong(_cursorIndexOfAlmeLastMod);
                        ActivityLangMapEntry _item = new ActivityLangMapEntry(_tmpAlmeActivityUid, _tmpAlmeHash, _tmpAlmeLangCode, _tmpAlmePropName, _tmpAlmeValue, _tmpAlmeAieHash, _tmpAlmeLastMod);
                        _result2.add(_item);
                    }
                    ArrayList<ActivityLangMapEntry> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

