package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PeerReviewerAllocationDao_Impl extends PeerReviewerAllocationDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PeerReviewerAllocation> __insertionAdapterOfPeerReviewerAllocation;

  private final EntityInsertionAdapter<PeerReviewerAllocation> __insertionAdapterOfPeerReviewerAllocation_1;

  private final EntityDeletionOrUpdateAdapter<PeerReviewerAllocation> __updateAdapterOfPeerReviewerAllocation;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

  public PeerReviewerAllocationDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPeerReviewerAllocation = new EntityInsertionAdapter<PeerReviewerAllocation>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PeerReviewerAllocation` (`praUid`,`praMarkerSubmitterUid`,`praToMarkerSubmitterUid`,`praAssignmentUid`,`praActive`,`praLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PeerReviewerAllocation entity) {
        statement.bindLong(1, entity.getPraUid());
        statement.bindLong(2, entity.getPraMarkerSubmitterUid());
        statement.bindLong(3, entity.getPraToMarkerSubmitterUid());
        statement.bindLong(4, entity.getPraAssignmentUid());
        final int _tmp = entity.getPraActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
        statement.bindLong(6, entity.getPraLct());
      }
    };
    this.__insertionAdapterOfPeerReviewerAllocation_1 = new EntityInsertionAdapter<PeerReviewerAllocation>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `PeerReviewerAllocation` (`praUid`,`praMarkerSubmitterUid`,`praToMarkerSubmitterUid`,`praAssignmentUid`,`praActive`,`praLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PeerReviewerAllocation entity) {
        statement.bindLong(1, entity.getPraUid());
        statement.bindLong(2, entity.getPraMarkerSubmitterUid());
        statement.bindLong(3, entity.getPraToMarkerSubmitterUid());
        statement.bindLong(4, entity.getPraAssignmentUid());
        final int _tmp = entity.getPraActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
        statement.bindLong(6, entity.getPraLct());
      }
    };
    this.__updateAdapterOfPeerReviewerAllocation = new EntityDeletionOrUpdateAdapter<PeerReviewerAllocation>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PeerReviewerAllocation` SET `praUid` = ?,`praMarkerSubmitterUid` = ?,`praToMarkerSubmitterUid` = ?,`praAssignmentUid` = ?,`praActive` = ?,`praLct` = ? WHERE `praUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PeerReviewerAllocation entity) {
        statement.bindLong(1, entity.getPraUid());
        statement.bindLong(2, entity.getPraMarkerSubmitterUid());
        statement.bindLong(3, entity.getPraToMarkerSubmitterUid());
        statement.bindLong(4, entity.getPraAssignmentUid());
        final int _tmp = entity.getPraActive() ? 1 : 0;
        statement.bindLong(5, _tmp);
        statement.bindLong(6, entity.getPraLct());
        statement.bindLong(7, entity.getPraUid());
      }
    };
    this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE PeerReviewerAllocation \n"
                + "           SET praActive = ?, \n"
                + "               praLct = ?\n"
                + "         WHERE praUid = ?";
        return _query;
      }
    };
  }

  @Override
  public long insert(final PeerReviewerAllocation entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfPeerReviewerAllocation.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final PeerReviewerAllocation entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPeerReviewerAllocation.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends PeerReviewerAllocation> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPeerReviewerAllocation.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replaceListAsync(final List<PeerReviewerAllocation> entries,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPeerReviewerAllocation_1.insert(entries);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertList(final List<PeerReviewerAllocation> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPeerReviewerAllocation_1.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void update(final PeerReviewerAllocation entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPeerReviewerAllocation.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateActiveByUid(final long cbUid, final boolean active, final long changeTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByUid.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cbUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateActiveByUid.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object getAllPeerReviewerAllocations(final List<Long> assignmentUid,
      final Continuation<? super List<PeerReviewerAllocation>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT *");
    _stringBuilder.append("\n");
    _stringBuilder.append("         FROM PeerReviewerAllocation");
    _stringBuilder.append("\n");
    _stringBuilder.append("        WHERE praAssignmentUid IN (");
    final int _inputSize = assignmentUid.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("          AND praActive ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : assignmentUid) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PeerReviewerAllocation>>() {
      @Override
      @NonNull
      public List<PeerReviewerAllocation> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praUid");
          final int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praMarkerSubmitterUid");
          final int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praToMarkerSubmitterUid");
          final int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praAssignmentUid");
          final int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow(_cursor, "praActive");
          final int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow(_cursor, "praLct");
          final List<PeerReviewerAllocation> _result = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PeerReviewerAllocation _item_1;
            final long _tmpPraUid;
            _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
            final long _tmpPraMarkerSubmitterUid;
            _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
            final long _tmpPraToMarkerSubmitterUid;
            _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
            final long _tmpPraAssignmentUid;
            _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
            final boolean _tmpPraActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPraActive);
            _tmpPraActive = _tmp != 0;
            final long _tmpPraLct;
            _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
            _item_1 = new PeerReviewerAllocation(_tmpPraUid,_tmpPraMarkerSubmitterUid,_tmpPraToMarkerSubmitterUid,_tmpPraAssignmentUid,_tmpPraActive,_tmpPraLct);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getAllPeerReviewerAllocationsByClazzUid(final long clazzUid,
      final boolean includeInactive,
      final Continuation<? super List<PeerReviewerAllocation>> $completion) {
    final String _sql = "\n"
            + "        SELECT PeerReviewerAllocation.*\n"
            + "          FROM PeerReviewerAllocation\n"
            + "         WHERE PeerReviewerAllocation.praAssignmentUid IN\n"
            + "               (SELECT CourseBlock.cbEntityUid\n"
            + "                  FROM CourseBlock\n"
            + "                 WHERE CourseBlock.cbClazzUid = ?\n"
            + "                   AND CourseBlock.cbType = 103\n"
            + "                   AND (CAST(? AS INTEGER) = 1 OR CourseBlock.cbActive))\n"
            + "           AND (CAST(? AS INTEGER) = 1 OR PeerReviewerAllocation.praActive)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    final int _tmp = includeInactive ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 3;
    final int _tmp_1 = includeInactive ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp_1);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PeerReviewerAllocation>>() {
      @Override
      @NonNull
      public List<PeerReviewerAllocation> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPraUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praUid");
          final int _cursorIndexOfPraMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praMarkerSubmitterUid");
          final int _cursorIndexOfPraToMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praToMarkerSubmitterUid");
          final int _cursorIndexOfPraAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "praAssignmentUid");
          final int _cursorIndexOfPraActive = CursorUtil.getColumnIndexOrThrow(_cursor, "praActive");
          final int _cursorIndexOfPraLct = CursorUtil.getColumnIndexOrThrow(_cursor, "praLct");
          final List<PeerReviewerAllocation> _result = new ArrayList<PeerReviewerAllocation>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PeerReviewerAllocation _item;
            final long _tmpPraUid;
            _tmpPraUid = _cursor.getLong(_cursorIndexOfPraUid);
            final long _tmpPraMarkerSubmitterUid;
            _tmpPraMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraMarkerSubmitterUid);
            final long _tmpPraToMarkerSubmitterUid;
            _tmpPraToMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfPraToMarkerSubmitterUid);
            final long _tmpPraAssignmentUid;
            _tmpPraAssignmentUid = _cursor.getLong(_cursorIndexOfPraAssignmentUid);
            final boolean _tmpPraActive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfPraActive);
            _tmpPraActive = _tmp_2 != 0;
            final long _tmpPraLct;
            _tmpPraLct = _cursor.getLong(_cursorIndexOfPraLct);
            _item = new PeerReviewerAllocation(_tmpPraUid,_tmpPraMarkerSubmitterUid,_tmpPraToMarkerSubmitterUid,_tmpPraAssignmentUid,_tmpPraActive,_tmpPraLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
