package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ParentEnrolmentRequired;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonParentJoin;
import com.ustadmobile.lib.db.entities.PersonParentJoinAndMinorPerson;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonParentJoinDao_Impl extends PersonParentJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonParentJoin> __insertionAdapterOfPersonParentJoin;

  private final EntityInsertionAdapter<PersonParentJoin> __insertionAdapterOfPersonParentJoin_1;

  private final EntityDeletionOrUpdateAdapter<PersonParentJoin> __updateAdapterOfPersonParentJoin;

  public PersonParentJoinDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonParentJoin = new EntityInsertionAdapter<PersonParentJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PersonParentJoin` (`ppjUid`,`ppjPcsn`,`ppjLcsn`,`ppjLcb`,`ppjLct`,`ppjParentPersonUid`,`ppjMinorPersonUid`,`ppjRelationship`,`ppjEmail`,`ppjPhone`,`ppjInactive`,`ppjStatus`,`ppjApprovalTiemstamp`,`ppjApprovalIpAddr`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonParentJoin entity) {
        statement.bindLong(1, entity.getPpjUid());
        statement.bindLong(2, entity.getPpjPcsn());
        statement.bindLong(3, entity.getPpjLcsn());
        statement.bindLong(4, entity.getPpjLcb());
        statement.bindLong(5, entity.getPpjLct());
        statement.bindLong(6, entity.getPpjParentPersonUid());
        statement.bindLong(7, entity.getPpjMinorPersonUid());
        statement.bindLong(8, entity.getPpjRelationship());
        if (entity.getPpjEmail() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getPpjEmail());
        }
        if (entity.getPpjPhone() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getPpjPhone());
        }
        final int _tmp = entity.getPpjInactive() ? 1 : 0;
        statement.bindLong(11, _tmp);
        statement.bindLong(12, entity.getPpjStatus());
        statement.bindLong(13, entity.getPpjApprovalTiemstamp());
        if (entity.getPpjApprovalIpAddr() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getPpjApprovalIpAddr());
        }
      }
    };
    this.__insertionAdapterOfPersonParentJoin_1 = new EntityInsertionAdapter<PersonParentJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `PersonParentJoin` (`ppjUid`,`ppjPcsn`,`ppjLcsn`,`ppjLcb`,`ppjLct`,`ppjParentPersonUid`,`ppjMinorPersonUid`,`ppjRelationship`,`ppjEmail`,`ppjPhone`,`ppjInactive`,`ppjStatus`,`ppjApprovalTiemstamp`,`ppjApprovalIpAddr`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonParentJoin entity) {
        statement.bindLong(1, entity.getPpjUid());
        statement.bindLong(2, entity.getPpjPcsn());
        statement.bindLong(3, entity.getPpjLcsn());
        statement.bindLong(4, entity.getPpjLcb());
        statement.bindLong(5, entity.getPpjLct());
        statement.bindLong(6, entity.getPpjParentPersonUid());
        statement.bindLong(7, entity.getPpjMinorPersonUid());
        statement.bindLong(8, entity.getPpjRelationship());
        if (entity.getPpjEmail() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getPpjEmail());
        }
        if (entity.getPpjPhone() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getPpjPhone());
        }
        final int _tmp = entity.getPpjInactive() ? 1 : 0;
        statement.bindLong(11, _tmp);
        statement.bindLong(12, entity.getPpjStatus());
        statement.bindLong(13, entity.getPpjApprovalTiemstamp());
        if (entity.getPpjApprovalIpAddr() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getPpjApprovalIpAddr());
        }
      }
    };
    this.__updateAdapterOfPersonParentJoin = new EntityDeletionOrUpdateAdapter<PersonParentJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `PersonParentJoin` SET `ppjUid` = ?,`ppjPcsn` = ?,`ppjLcsn` = ?,`ppjLcb` = ?,`ppjLct` = ?,`ppjParentPersonUid` = ?,`ppjMinorPersonUid` = ?,`ppjRelationship` = ?,`ppjEmail` = ?,`ppjPhone` = ?,`ppjInactive` = ?,`ppjStatus` = ?,`ppjApprovalTiemstamp` = ?,`ppjApprovalIpAddr` = ? WHERE `ppjUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonParentJoin entity) {
        statement.bindLong(1, entity.getPpjUid());
        statement.bindLong(2, entity.getPpjPcsn());
        statement.bindLong(3, entity.getPpjLcsn());
        statement.bindLong(4, entity.getPpjLcb());
        statement.bindLong(5, entity.getPpjLct());
        statement.bindLong(6, entity.getPpjParentPersonUid());
        statement.bindLong(7, entity.getPpjMinorPersonUid());
        statement.bindLong(8, entity.getPpjRelationship());
        if (entity.getPpjEmail() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getPpjEmail());
        }
        if (entity.getPpjPhone() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getPpjPhone());
        }
        final int _tmp = entity.getPpjInactive() ? 1 : 0;
        statement.bindLong(11, _tmp);
        statement.bindLong(12, entity.getPpjStatus());
        statement.bindLong(13, entity.getPpjApprovalTiemstamp());
        if (entity.getPpjApprovalIpAddr() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getPpjApprovalIpAddr());
        }
        statement.bindLong(15, entity.getPpjUid());
      }
    };
  }

  @Override
  public Object insertListAsync(final List<PersonParentJoin> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPersonParentJoin.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertAsync(final PersonParentJoin entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPersonParentJoin_1.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateAsync(final PersonParentJoin personParentJoin,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfPersonParentJoin.handle(personParentJoin);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidWithMinorAsync(final long uid,
      final Continuation<? super PersonParentJoinAndMinorPerson> $completion) {
    final String _sql = "\n"
            + "        SELECT PersonParentJoin.*, Person.*\n"
            + "          FROM PersonParentJoin\n"
            + "     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n"
            + "         WHERE PersonParentJoin.ppjUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonParentJoinAndMinorPerson>() {
      @Override
      @Nullable
      public PersonParentJoinAndMinorPerson call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final PersonParentJoinAndMinorPerson _result;
          if (_cursor.moveToFirst()) {
            final PersonParentJoin _tmpPersonParentJoin;
            if (!(_cursor.isNull(_cursorIndexOfPpjUid) && _cursor.isNull(_cursorIndexOfPpjPcsn) && _cursor.isNull(_cursorIndexOfPpjLcsn) && _cursor.isNull(_cursorIndexOfPpjLcb) && _cursor.isNull(_cursorIndexOfPpjLct) && _cursor.isNull(_cursorIndexOfPpjParentPersonUid) && _cursor.isNull(_cursorIndexOfPpjMinorPersonUid) && _cursor.isNull(_cursorIndexOfPpjRelationship) && _cursor.isNull(_cursorIndexOfPpjEmail) && _cursor.isNull(_cursorIndexOfPpjPhone) && _cursor.isNull(_cursorIndexOfPpjInactive) && _cursor.isNull(_cursorIndexOfPpjStatus) && _cursor.isNull(_cursorIndexOfPpjApprovalTiemstamp) && _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr))) {
              final long _tmpPpjUid;
              _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
              final long _tmpPpjPcsn;
              _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
              final long _tmpPpjLcsn;
              _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
              final int _tmpPpjLcb;
              _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
              final long _tmpPpjLct;
              _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
              final long _tmpPpjParentPersonUid;
              _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
              final long _tmpPpjMinorPersonUid;
              _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
              final int _tmpPpjRelationship;
              _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
              final String _tmpPpjEmail;
              if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
                _tmpPpjEmail = null;
              } else {
                _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
              }
              final String _tmpPpjPhone;
              if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
                _tmpPpjPhone = null;
              } else {
                _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
              }
              final boolean _tmpPpjInactive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfPpjInactive);
              _tmpPpjInactive = _tmp != 0;
              final int _tmpPpjStatus;
              _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
              final long _tmpPpjApprovalTiemstamp;
              _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
              final String _tmpPpjApprovalIpAddr;
              if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
                _tmpPpjApprovalIpAddr = null;
              } else {
                _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
              }
              _tmpPersonParentJoin = new PersonParentJoin(_tmpPpjUid,_tmpPpjPcsn,_tmpPpjLcsn,_tmpPpjLcb,_tmpPpjLct,_tmpPpjParentPersonUid,_tmpPpjMinorPersonUid,_tmpPpjRelationship,_tmpPpjEmail,_tmpPpjPhone,_tmpPpjInactive,_tmpPpjStatus,_tmpPpjApprovalTiemstamp,_tmpPpjApprovalIpAddr);
            } else {
              _tmpPersonParentJoin = null;
            }
            final Person _tmpMinorPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp_1 != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_2 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_3 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpMinorPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpMinorPerson = null;
            }
            _result = new PersonParentJoinAndMinorPerson(_tmpPersonParentJoin,_tmpMinorPerson);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidWithMinorAsyncFromWeb(final long uid,
      final Continuation<? super PersonParentJoinAndMinorPerson> $completion) {
    final String _sql = "\n"
            + "        SELECT PersonParentJoin.*, Person.*\n"
            + "          FROM PersonParentJoin\n"
            + "     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n"
            + "         WHERE PersonParentJoin.ppjUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonParentJoinAndMinorPerson>() {
      @Override
      @Nullable
      public PersonParentJoinAndMinorPerson call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final PersonParentJoinAndMinorPerson _result;
          if (_cursor.moveToFirst()) {
            final PersonParentJoin _tmpPersonParentJoin;
            if (!(_cursor.isNull(_cursorIndexOfPpjUid) && _cursor.isNull(_cursorIndexOfPpjPcsn) && _cursor.isNull(_cursorIndexOfPpjLcsn) && _cursor.isNull(_cursorIndexOfPpjLcb) && _cursor.isNull(_cursorIndexOfPpjLct) && _cursor.isNull(_cursorIndexOfPpjParentPersonUid) && _cursor.isNull(_cursorIndexOfPpjMinorPersonUid) && _cursor.isNull(_cursorIndexOfPpjRelationship) && _cursor.isNull(_cursorIndexOfPpjEmail) && _cursor.isNull(_cursorIndexOfPpjPhone) && _cursor.isNull(_cursorIndexOfPpjInactive) && _cursor.isNull(_cursorIndexOfPpjStatus) && _cursor.isNull(_cursorIndexOfPpjApprovalTiemstamp) && _cursor.isNull(_cursorIndexOfPpjApprovalIpAddr))) {
              final long _tmpPpjUid;
              _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
              final long _tmpPpjPcsn;
              _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
              final long _tmpPpjLcsn;
              _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
              final int _tmpPpjLcb;
              _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
              final long _tmpPpjLct;
              _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
              final long _tmpPpjParentPersonUid;
              _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
              final long _tmpPpjMinorPersonUid;
              _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
              final int _tmpPpjRelationship;
              _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
              final String _tmpPpjEmail;
              if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
                _tmpPpjEmail = null;
              } else {
                _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
              }
              final String _tmpPpjPhone;
              if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
                _tmpPpjPhone = null;
              } else {
                _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
              }
              final boolean _tmpPpjInactive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfPpjInactive);
              _tmpPpjInactive = _tmp != 0;
              final int _tmpPpjStatus;
              _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
              final long _tmpPpjApprovalTiemstamp;
              _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
              final String _tmpPpjApprovalIpAddr;
              if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
                _tmpPpjApprovalIpAddr = null;
              } else {
                _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
              }
              _tmpPersonParentJoin = new PersonParentJoin(_tmpPpjUid,_tmpPpjPcsn,_tmpPpjLcsn,_tmpPpjLcb,_tmpPpjLct,_tmpPpjParentPersonUid,_tmpPpjMinorPersonUid,_tmpPpjRelationship,_tmpPpjEmail,_tmpPpjPhone,_tmpPpjInactive,_tmpPpjStatus,_tmpPpjApprovalTiemstamp,_tmpPpjApprovalIpAddr);
            } else {
              _tmpPersonParentJoin = null;
            }
            final Person _tmpMinorPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp_1 != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_2 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_3 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpMinorPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpMinorPerson = null;
            }
            _result = new PersonParentJoinAndMinorPerson(_tmpPersonParentJoin,_tmpMinorPerson);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByMinorPersonUid(final long minorPersonUid,
      final Continuation<? super List<PersonParentJoin>> $completion) {
    final String _sql = "\n"
            + "        SELECT PersonParentJoin.*\n"
            + "          FROM PersonParentJoin\n"
            + "         WHERE ppjMinorPersonUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, minorPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonParentJoin>>() {
      @Override
      @NonNull
      public List<PersonParentJoin> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final List<PersonParentJoin> _result = new ArrayList<PersonParentJoin>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonParentJoin _item;
            final long _tmpPpjUid;
            _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
            final long _tmpPpjPcsn;
            _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
            final long _tmpPpjLcsn;
            _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
            final int _tmpPpjLcb;
            _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
            final long _tmpPpjLct;
            _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
            final long _tmpPpjParentPersonUid;
            _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
            final long _tmpPpjMinorPersonUid;
            _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
            final int _tmpPpjRelationship;
            _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
            final String _tmpPpjEmail;
            if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
              _tmpPpjEmail = null;
            } else {
              _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
            }
            final String _tmpPpjPhone;
            if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
              _tmpPpjPhone = null;
            } else {
              _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
            }
            final boolean _tmpPpjInactive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPpjInactive);
            _tmpPpjInactive = _tmp != 0;
            final int _tmpPpjStatus;
            _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
            final long _tmpPpjApprovalTiemstamp;
            _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
            final String _tmpPpjApprovalIpAddr;
            if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
              _tmpPpjApprovalIpAddr = null;
            } else {
              _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
            }
            _item = new PersonParentJoin(_tmpPpjUid,_tmpPpjPcsn,_tmpPpjLcsn,_tmpPpjLcb,_tmpPpjLct,_tmpPpjParentPersonUid,_tmpPpjMinorPersonUid,_tmpPpjRelationship,_tmpPpjEmail,_tmpPpjPhone,_tmpPpjInactive,_tmpPpjStatus,_tmpPpjApprovalTiemstamp,_tmpPpjApprovalIpAddr);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByMinorPersonUidForConsent(final long minorPersonUid,
      final Continuation<? super PersonParentJoin> $completion) {
    final String _sql = "\n"
            + "        SELECT PersonParentJoin.*\n"
            + "          FROM PersonParentJoin\n"
            + "         WHERE ppjMinorPersonUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, minorPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonParentJoin>() {
      @Override
      @NonNull
      public PersonParentJoin call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final PersonParentJoin _result;
          if (_cursor.moveToFirst()) {
            final long _tmpPpjUid;
            _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
            final long _tmpPpjPcsn;
            _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
            final long _tmpPpjLcsn;
            _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
            final int _tmpPpjLcb;
            _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
            final long _tmpPpjLct;
            _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
            final long _tmpPpjParentPersonUid;
            _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
            final long _tmpPpjMinorPersonUid;
            _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
            final int _tmpPpjRelationship;
            _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
            final String _tmpPpjEmail;
            if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
              _tmpPpjEmail = null;
            } else {
              _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
            }
            final String _tmpPpjPhone;
            if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
              _tmpPpjPhone = null;
            } else {
              _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
            }
            final boolean _tmpPpjInactive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPpjInactive);
            _tmpPpjInactive = _tmp != 0;
            final int _tmpPpjStatus;
            _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
            final long _tmpPpjApprovalTiemstamp;
            _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
            final String _tmpPpjApprovalIpAddr;
            if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
              _tmpPpjApprovalIpAddr = null;
            } else {
              _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
            }
            _result = new PersonParentJoin(_tmpPpjUid,_tmpPpjPcsn,_tmpPpjLcsn,_tmpPpjLcb,_tmpPpjLct,_tmpPpjParentPersonUid,_tmpPpjMinorPersonUid,_tmpPpjRelationship,_tmpPpjEmail,_tmpPpjPhone,_tmpPpjInactive,_tmpPpjStatus,_tmpPpjApprovalTiemstamp,_tmpPpjApprovalIpAddr);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByMinorPersonUidWhereParentNotEnrolledInClazz(final long minorPersonUid,
      final long clazzUidFilter,
      final Continuation<? super List<ParentEnrolmentRequired>> $completion) {
    final String _sql = "\n"
            + "        SELECT PersonParentJoin.ppjParentPersonUid AS parentPersonUid,\n"
            + "               ChildEnrolment.clazzEnrolmentClazzUid AS clazzUid\n"
            + "          FROM PersonParentJoin\n"
            + "               JOIN ClazzEnrolment ChildEnrolment \n"
            + "                    ON ChildEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                   AND (? = 0 OR ChildEnrolment.clazzEnrolmentClazzUid = ?)\n"
            + "         WHERE PersonParentJoin.ppjMinorPersonUid = ?\n"
            + "           AND PersonParentJoin.ppjParentPersonUid != 0\n"
            + "           AND NOT EXISTS(\n"
            + "               SELECT clazzEnrolmentUid \n"
            + "                 FROM ClazzEnrolment\n"
            + "                WHERE ClazzEnrolment.clazzEnrolmentPersonUid = PersonParentJoin.ppjParentPersonUid\n"
            + "                  AND ClazzEnrolment.clazzEnrolmentClazzUid = ChildEnrolment.clazzEnrolmentClazzUid\n"
            + "                  AND ClazzEnrolment.clazzEnrolmentRole = 1003\n"
            + "                  AND CAST(ClazzEnrolment.clazzEnrolmentActive AS INTEGER) = 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, minorPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUidFilter);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUidFilter);
    _argIndex = 4;
    _statement.bindLong(_argIndex, minorPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ParentEnrolmentRequired>>() {
      @Override
      @NonNull
      public List<ParentEnrolmentRequired> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfParentPersonUid = 0;
          final int _cursorIndexOfClazzUid = 1;
          final List<ParentEnrolmentRequired> _result = new ArrayList<ParentEnrolmentRequired>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ParentEnrolmentRequired _item;
            final long _tmpParentPersonUid;
            _tmpParentPersonUid = _cursor.getLong(_cursorIndexOfParentPersonUid);
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _item = new ParentEnrolmentRequired(_tmpParentPersonUid,_tmpClazzUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object isParentOf(final long userPersonUid, final long minorPersonUid,
      final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT EXISTS(\n"
            + "               SELECT ppjUid\n"
            + "                 FROM PersonParentJoin\n"
            + "                WHERE ppjMinorPersonUid = ?\n"
            + "                      AND ppjParentPersonUid = ?\n"
            + "                      AND CAST(ppjInactive AS INTEGER) = 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, minorPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, userPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object isMinorApproved(final long minorPersonUid,
      final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT EXISTS(\n"
            + "               SELECT ppjUid\n"
            + "                 FROM PersonParentJoin\n"
            + "                WHERE ppjMinorPersonUid = ?\n"
            + "                  AND CAST(ppjInactive AS INTEGER) = 0\n"
            + "                  AND ppjStatus = 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, minorPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
