package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.ActivityInteractionEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ActivityInteractionDao_Impl extends ActivityInteractionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ActivityInteractionEntity> __insertionAdapterOfActivityInteractionEntity;

  public ActivityInteractionDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfActivityInteractionEntity = new EntityInsertionAdapter<ActivityInteractionEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `ActivityInteractionEntity` (`aieActivityUid`,`aieHash`,`aieProp`,`aieId`,`aieLastMod`,`aieIsDeleted`) VALUES (?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ActivityInteractionEntity entity) {
        statement.bindLong(1, entity.getAieActivityUid());
        statement.bindLong(2, entity.getAieHash());
        statement.bindLong(3, entity.getAieProp());
        if (entity.getAieId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getAieId());
        }
        statement.bindLong(5, entity.getAieLastMod());
        final int _tmp = entity.getAieIsDeleted() ? 1 : 0;
        statement.bindLong(6, _tmp);
      }
    };
  }

  @Override
  public Object insertOrIgnoreAsync(final List<ActivityInteractionEntity> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfActivityInteractionEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findActivityUidsWithInteractionEntitiesAsync(final List<Long> activityUids,
      final Continuation<? super List<Long>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT DISTINCT ActivityInteractionEntity.aieActivityUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM ActivityInteractionEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE ActivityInteractionEntity.aieActivityUid IN (");
    final int _inputSize = activityUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : activityUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      @NonNull
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Long _item_1;
            _item_1 = _cursor.getLong(0);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllByActivityUidAsync(final long activityUid,
      final Continuation<? super List<ActivityInteractionEntity>> $completion) {
    final String _sql = "\n"
            + "        SELECT ActivityInteractionEntity.*\n"
            + "          FROM ActivityInteractionEntity\n"
            + "         WHERE ActivityInteractionEntity.aieActivityUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, activityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ActivityInteractionEntity>>() {
      @Override
      @NonNull
      public List<ActivityInteractionEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfAieActivityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "aieActivityUid");
          final int _cursorIndexOfAieHash = CursorUtil.getColumnIndexOrThrow(_cursor, "aieHash");
          final int _cursorIndexOfAieProp = CursorUtil.getColumnIndexOrThrow(_cursor, "aieProp");
          final int _cursorIndexOfAieId = CursorUtil.getColumnIndexOrThrow(_cursor, "aieId");
          final int _cursorIndexOfAieLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "aieLastMod");
          final int _cursorIndexOfAieIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "aieIsDeleted");
          final List<ActivityInteractionEntity> _result = new ArrayList<ActivityInteractionEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ActivityInteractionEntity _item;
            final long _tmpAieActivityUid;
            _tmpAieActivityUid = _cursor.getLong(_cursorIndexOfAieActivityUid);
            final long _tmpAieHash;
            _tmpAieHash = _cursor.getLong(_cursorIndexOfAieHash);
            final int _tmpAieProp;
            _tmpAieProp = _cursor.getInt(_cursorIndexOfAieProp);
            final String _tmpAieId;
            if (_cursor.isNull(_cursorIndexOfAieId)) {
              _tmpAieId = null;
            } else {
              _tmpAieId = _cursor.getString(_cursorIndexOfAieId);
            }
            final long _tmpAieLastMod;
            _tmpAieLastMod = _cursor.getLong(_cursorIndexOfAieLastMod);
            final boolean _tmpAieIsDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfAieIsDeleted);
            _tmpAieIsDeleted = _tmp != 0;
            _item = new ActivityInteractionEntity(_tmpAieActivityUid,_tmpAieHash,_tmpAieProp,_tmpAieId,_tmpAieLastMod,_tmpAieIsDeleted);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
