package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.OfflineItemAndState;
import com.ustadmobile.lib.db.composites.TransferJobAndTotals;
import com.ustadmobile.lib.db.entities.OfflineItem;
import com.ustadmobile.lib.db.entities.TransferJob;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class OfflineItemDao_Impl extends OfflineItemDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<OfflineItem> __insertionAdapterOfOfflineItem;

  private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByOfflineItemUid;

  public OfflineItemDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfOfflineItem = new EntityInsertionAdapter<OfflineItem>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `OfflineItem` (`oiUid`,`oiNodeId`,`oiClazzUid`,`oiCourseBlockUid`,`oiContentEntryUid`,`oiActive`,`oiLct`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final OfflineItem entity) {
        statement.bindLong(1, entity.getOiUid());
        statement.bindLong(2, entity.getOiNodeId());
        statement.bindLong(3, entity.getOiClazzUid());
        statement.bindLong(4, entity.getOiCourseBlockUid());
        statement.bindLong(5, entity.getOiContentEntryUid());
        final int _tmp = entity.getOiActive() ? 1 : 0;
        statement.bindLong(6, _tmp);
        statement.bindLong(7, entity.getOiLct());
      }
    };
    this.__preparedStmtOfUpdateActiveByOfflineItemUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE OfflineItem\n"
                + "           SET oiActive = ?\n"
                + "         WHERE oiUid = ?   \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final OfflineItem item, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfOfflineItem.insertAndReturnId(item);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateActiveByOfflineItemUid(final long oiUid, final boolean active,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateActiveByOfflineItemUid.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, oiUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateActiveByOfflineItemUid.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Flow<OfflineItemAndState> findByContentEntryUid(final long contentEntryUid,
      final long nodeId) {
    final String _sql = "\n"
            + "        SELECT OfflineItem.*,\n"
            + "               TransferJob.*,\n"
            + "               \n"
            + "        (SELECT SUM(TransferJobItem.tjTotalSize)\n"
            + "                   FROM TransferJobItem\n"
            + "                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS totalSize,\n"
            + "                (SELECT SUM(TransferJobItem.tjTransferred)\n"
            + "                   FROM TransferJobItem\n"
            + "                  WHERE TransferJobItem.tjiTjUid =  TransferJob.tjUid) AS transferred \n"
            + "    ,\n"
            + "               CAST(OfflineItem.oiActive AS INTEGER) = 1 AND (SELECT EXISTS(\n"
            + "                       SELECT CompletedJob.tjUid\n"
            + "                         FROM TransferJob CompletedJob\n"
            + "                        WHERE CompletedJob.tjTableId = 738\n"
            + "                          AND CompletedJob.tjEntityUid IN  \n"
            + "                              \n"
            + "        (SELECT ContentEntryVersion.cevUid\n"
            + "                         FROM ContentEntryVersion\n"
            + "                        WHERE ContentEntryVersion.cevContentEntryUid = ?)\n"
            + "    \n"
            + "                          AND CompletedJob.tjStatus = 21\n"
            + "                          AND CompletedJob.tjType = 2\n"
            + "                          AND CompletedJob.tjTimeCreated >= OfflineItem.oiLct\n"
            + "                        LIMIT 1      \n"
            + "               )) AS readyForOffline,\n"
            + "               NULL AS latestErrorStr\n"
            + "          FROM OfflineItem\n"
            + "               LEFT JOIN TransferJob \n"
            + "                         ON TransferJob.tjUid = \n"
            + "                         (SELECT TransferJob.tjUid\n"
            + "                            FROM TransferJob\n"
            + "                           WHERE TransferJob.tjTableId = 738\n"
            + "                             AND TransferJob.tjEntityUid IN  \n"
            + "                                 \n"
            + "        (SELECT ContentEntryVersion.cevUid\n"
            + "                         FROM ContentEntryVersion\n"
            + "                        WHERE ContentEntryVersion.cevContentEntryUid = ?)\n"
            + "    \n"
            + "                             AND TransferJob.tjStatus < 21\n"
            + "                        ORDER BY TransferJob.tjTimeCreated DESC     \n"
            + "                           LIMIT 1)\n"
            + "         WHERE OfflineItem.oiNodeId = ?\n"
            + "           AND OfflineItem.oiContentEntryUid = ?\n"
            + "      ORDER BY OfflineItem.oiLct DESC\n"
            + "         LIMIT 1     \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, nodeId);
    _argIndex = 4;
    _statement.bindLong(_argIndex, contentEntryUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"TransferJobItem", "TransferJob",
        "ContentEntryVersion", "OfflineItem"}, new Callable<OfflineItemAndState>() {
      @Override
      @Nullable
      public OfflineItemAndState call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfOiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "oiUid");
          final int _cursorIndexOfOiNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "oiNodeId");
          final int _cursorIndexOfOiClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "oiClazzUid");
          final int _cursorIndexOfOiCourseBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "oiCourseBlockUid");
          final int _cursorIndexOfOiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "oiContentEntryUid");
          final int _cursorIndexOfOiActive = CursorUtil.getColumnIndexOrThrow(_cursor, "oiActive");
          final int _cursorIndexOfOiLct = CursorUtil.getColumnIndexOrThrow(_cursor, "oiLct");
          final int _cursorIndexOfTjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUid");
          final int _cursorIndexOfTjType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjType");
          final int _cursorIndexOfTjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "tjStatus");
          final int _cursorIndexOfTjName = CursorUtil.getColumnIndexOrThrow(_cursor, "tjName");
          final int _cursorIndexOfTjUuid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjUuid");
          final int _cursorIndexOfTjTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTableId");
          final int _cursorIndexOfTjEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjEntityUid");
          final int _cursorIndexOfTjTimeCreated = CursorUtil.getColumnIndexOrThrow(_cursor, "tjTimeCreated");
          final int _cursorIndexOfTjCreationType = CursorUtil.getColumnIndexOrThrow(_cursor, "tjCreationType");
          final int _cursorIndexOfTjOiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "tjOiUid");
          final int _cursorIndexOfTotalSize = CursorUtil.getColumnIndexOrThrow(_cursor, "totalSize");
          final int _cursorIndexOfTransferred = CursorUtil.getColumnIndexOrThrow(_cursor, "transferred");
          final int _cursorIndexOfReadyForOffline = CursorUtil.getColumnIndexOrThrow(_cursor, "readyForOffline");
          final int _cursorIndexOfLatestErrorStr = CursorUtil.getColumnIndexOrThrow(_cursor, "latestErrorStr");
          final OfflineItemAndState _result;
          if (_cursor.moveToFirst()) {
            final boolean _tmpReadyForOffline;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfReadyForOffline);
            _tmpReadyForOffline = _tmp != 0;
            final OfflineItem _tmpOfflineItem;
            if (!(_cursor.isNull(_cursorIndexOfOiUid) && _cursor.isNull(_cursorIndexOfOiNodeId) && _cursor.isNull(_cursorIndexOfOiClazzUid) && _cursor.isNull(_cursorIndexOfOiCourseBlockUid) && _cursor.isNull(_cursorIndexOfOiContentEntryUid) && _cursor.isNull(_cursorIndexOfOiActive) && _cursor.isNull(_cursorIndexOfOiLct))) {
              final long _tmpOiUid;
              _tmpOiUid = _cursor.getLong(_cursorIndexOfOiUid);
              final long _tmpOiNodeId;
              _tmpOiNodeId = _cursor.getLong(_cursorIndexOfOiNodeId);
              final long _tmpOiClazzUid;
              _tmpOiClazzUid = _cursor.getLong(_cursorIndexOfOiClazzUid);
              final long _tmpOiCourseBlockUid;
              _tmpOiCourseBlockUid = _cursor.getLong(_cursorIndexOfOiCourseBlockUid);
              final long _tmpOiContentEntryUid;
              _tmpOiContentEntryUid = _cursor.getLong(_cursorIndexOfOiContentEntryUid);
              final boolean _tmpOiActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfOiActive);
              _tmpOiActive = _tmp_1 != 0;
              final long _tmpOiLct;
              _tmpOiLct = _cursor.getLong(_cursorIndexOfOiLct);
              _tmpOfflineItem = new OfflineItem(_tmpOiUid,_tmpOiNodeId,_tmpOiClazzUid,_tmpOiCourseBlockUid,_tmpOiContentEntryUid,_tmpOiActive,_tmpOiLct);
            } else {
              _tmpOfflineItem = null;
            }
            final TransferJobAndTotals _tmpActiveDownload;
            if (!(_cursor.isNull(_cursorIndexOfTotalSize) && _cursor.isNull(_cursorIndexOfTransferred) && _cursor.isNull(_cursorIndexOfLatestErrorStr) && _cursor.isNull(_cursorIndexOfTjUid) && _cursor.isNull(_cursorIndexOfTjType) && _cursor.isNull(_cursorIndexOfTjStatus) && _cursor.isNull(_cursorIndexOfTjName) && _cursor.isNull(_cursorIndexOfTjUuid) && _cursor.isNull(_cursorIndexOfTjTableId) && _cursor.isNull(_cursorIndexOfTjEntityUid) && _cursor.isNull(_cursorIndexOfTjTimeCreated) && _cursor.isNull(_cursorIndexOfTjCreationType) && _cursor.isNull(_cursorIndexOfTjOiUid))) {
              final long _tmpTotalSize;
              _tmpTotalSize = _cursor.getLong(_cursorIndexOfTotalSize);
              final long _tmpTransferred;
              _tmpTransferred = _cursor.getLong(_cursorIndexOfTransferred);
              final String _tmpLatestErrorStr;
              if (_cursor.isNull(_cursorIndexOfLatestErrorStr)) {
                _tmpLatestErrorStr = null;
              } else {
                _tmpLatestErrorStr = _cursor.getString(_cursorIndexOfLatestErrorStr);
              }
              final TransferJob _tmpTransferJob;
              if (!(_cursor.isNull(_cursorIndexOfTjUid) && _cursor.isNull(_cursorIndexOfTjType) && _cursor.isNull(_cursorIndexOfTjStatus) && _cursor.isNull(_cursorIndexOfTjName) && _cursor.isNull(_cursorIndexOfTjUuid) && _cursor.isNull(_cursorIndexOfTjTableId) && _cursor.isNull(_cursorIndexOfTjEntityUid) && _cursor.isNull(_cursorIndexOfTjTimeCreated) && _cursor.isNull(_cursorIndexOfTjCreationType) && _cursor.isNull(_cursorIndexOfTjOiUid))) {
                final int _tmpTjUid;
                _tmpTjUid = _cursor.getInt(_cursorIndexOfTjUid);
                final int _tmpTjType;
                _tmpTjType = _cursor.getInt(_cursorIndexOfTjType);
                final int _tmpTjStatus;
                _tmpTjStatus = _cursor.getInt(_cursorIndexOfTjStatus);
                final String _tmpTjName;
                if (_cursor.isNull(_cursorIndexOfTjName)) {
                  _tmpTjName = null;
                } else {
                  _tmpTjName = _cursor.getString(_cursorIndexOfTjName);
                }
                final String _tmpTjUuid;
                if (_cursor.isNull(_cursorIndexOfTjUuid)) {
                  _tmpTjUuid = null;
                } else {
                  _tmpTjUuid = _cursor.getString(_cursorIndexOfTjUuid);
                }
                final int _tmpTjTableId;
                _tmpTjTableId = _cursor.getInt(_cursorIndexOfTjTableId);
                final long _tmpTjEntityUid;
                _tmpTjEntityUid = _cursor.getLong(_cursorIndexOfTjEntityUid);
                final long _tmpTjTimeCreated;
                _tmpTjTimeCreated = _cursor.getLong(_cursorIndexOfTjTimeCreated);
                final int _tmpTjCreationType;
                _tmpTjCreationType = _cursor.getInt(_cursorIndexOfTjCreationType);
                final long _tmpTjOiUid;
                _tmpTjOiUid = _cursor.getLong(_cursorIndexOfTjOiUid);
                _tmpTransferJob = new TransferJob(_tmpTjUid,_tmpTjType,_tmpTjStatus,_tmpTjName,_tmpTjUuid,_tmpTjTableId,_tmpTjEntityUid,_tmpTjTimeCreated,_tmpTjCreationType,_tmpTjOiUid);
              } else {
                _tmpTransferJob = null;
              }
              _tmpActiveDownload = new TransferJobAndTotals(_tmpTransferJob,_tmpTotalSize,_tmpTransferred,_tmpLatestErrorStr);
            } else {
              _tmpActiveDownload = null;
            }
            _result = new OfflineItemAndState(_tmpOfflineItem,_tmpActiveDownload,_tmpReadyForOffline);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
