package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ContentEntry
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin
import kotlin.Boolean
import kotlin.Long
import kotlin.collections.List

public class ContentEntryParentChildJoinDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: ContentEntryParentChildJoinDao,
) : ContentEntryParentChildJoinDao() {
  override suspend fun insertListAsync(entityList: List<ContentEntryParentChildJoin>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.cepcjUid == 0L) {
        val _newPk = _pkManager.nextIdAsync(7)
        it.cepcjUid = _newPk
        _generatedPks += _newPk
      }
      it.cepcjLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertListAsync(entityList)
  }

  override fun publicContentEntryParentChildJoins(): List<ContentEntryParentChildJoin> =
      _dao.publicContentEntryParentChildJoins()

  override fun all(): List<ContentEntryParentChildJoin> = _dao.all()

  override fun findParentByChildUuids(childEntryContentUid: Long): ContentEntryParentChildJoin? =
      _dao.findParentByChildUuids(childEntryContentUid)

  override fun findListOfParentsByChildUuid(childEntryContentUid: Long):
      List<ContentEntryParentChildJoin> = _dao.findListOfParentsByChildUuid(childEntryContentUid)

  override suspend fun findListOfChildsByParentUuid(parentUid: Long):
      List<ContentEntryParentChildJoin> = _dao.findListOfChildsByParentUuid(parentUid)

  override fun findJoinByParentChildUuids(parentUid: Long, childUid: Long):
      ContentEntryParentChildJoin? = _dao.findJoinByParentChildUuids(parentUid, childUid)

  override suspend fun selectTopEntries(): List<ContentEntry> = _dao.selectTopEntries()

  override fun replaceList(entries: List<ContentEntryParentChildJoin>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entries.iterator().forEach  {
      if(it.cepcjUid == 0L) {
        val _newPk = _pkManager.nextId(7)
        it.cepcjUid = _newPk
        _generatedPks += _newPk
      }
      it.cepcjLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.replaceList(entries)
  }

  override fun insertWithReplace(parentChildJoinDao: ContentEntryParentChildJoin) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(parentChildJoinDao.cepcjUid == 0L) {
      val _newPk = _pkManager.nextId(7)
      parentChildJoinDao.cepcjUid = _newPk
    }
    parentChildJoinDao.cepcjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertWithReplace(parentChildJoinDao)
  }

  override suspend fun moveListOfEntriesToNewParent(
    contentEntryUid: Long,
    selectedItems: List<Long>,
    updateTime: Long,
  ) {
    _dao.moveListOfEntriesToNewParent(contentEntryUid, selectedItems, updateTime)
  }

  override suspend fun setEntriesDeleted(
    selectedUids: List<Long>,
    isDeleted: Boolean,
    updateTime: Long,
  ) {
    _dao.setEntriesDeleted(selectedUids, isDeleted, updateTime)
  }

  override suspend fun findByUid(uid: Long): ContentEntryParentChildJoin? = _dao.findByUid(uid)

  public override fun insert(entity: ContentEntryParentChildJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.cepcjUid == 0L) {
      val _newPk = _pkManager.nextId(7)
      entity.cepcjUid = _newPk
    }
    entity.cepcjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.cepcjUid
  }

  public override suspend fun insertAsync(entity: ContentEntryParentChildJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.cepcjUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(7)
      entity.cepcjUid = _newPk
    }
    entity.cepcjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.cepcjUid
  }

  public override fun insertList(entityList: List<ContentEntryParentChildJoin>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.cepcjUid == 0L) {
        val _newPk = _pkManager.nextId(7)
        it.cepcjUid = _newPk
        _generatedPks += _newPk
      }
      it.cepcjLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun update(entity: ContentEntryParentChildJoin) {
    entity.cepcjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
