/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.io.Serializable;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;

public class WeeklyCalendar
extends BaseCalendar
implements Serializable,
Calendar {
    static final long serialVersionUID = -6809298821229007586L;
    private boolean[] excludeDays = new boolean[8];
    private boolean excludeAll = false;

    public WeeklyCalendar() {
        this(null, null);
    }

    public WeeklyCalendar(Calendar calendar) {
        this(calendar, null);
    }

    public WeeklyCalendar(TimeZone timeZone) {
        super(null, timeZone);
    }

    public WeeklyCalendar(Calendar calendar, TimeZone timeZone) {
        super(calendar, timeZone);
        this.excludeDays[1] = true;
        this.excludeDays[7] = true;
        this.excludeAll = this.areAllDaysExcluded();
    }

    @Override
    public Object clone() {
        WeeklyCalendar weeklyCalendar = (WeeklyCalendar)super.clone();
        ((WeeklyCalendar)super.clone()).excludeDays = (boolean[])this.excludeDays.clone();
        return weeklyCalendar;
    }

    public boolean[] getDaysExcluded() {
        return this.excludeDays;
    }

    public boolean isDayExcluded(int n) {
        return this.excludeDays[n];
    }

    public void setDaysExcluded(boolean[] blArray) {
        if (blArray == null) {
            return;
        }
        this.excludeDays = blArray;
        this.excludeAll = this.areAllDaysExcluded();
    }

    public void setDayExcluded(int n, boolean bl) {
        this.excludeDays[n] = bl;
        this.excludeAll = this.areAllDaysExcluded();
    }

    public boolean areAllDaysExcluded() {
        return this.isDayExcluded(1) && this.isDayExcluded(2) && this.isDayExcluded(3) && this.isDayExcluded(4) && this.isDayExcluded(5) && this.isDayExcluded(6) && this.isDayExcluded(7);
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (this.excludeAll) {
            return false;
        }
        if (!super.isTimeIncluded(l)) {
            return false;
        }
        java.util.Calendar calendar = this.createJavaCalendar(l);
        int n = calendar.get(7);
        return !this.isDayExcluded(n);
    }

    @Override
    public long getNextIncludedTime(long l) {
        java.util.Calendar calendar;
        int n;
        if (this.excludeAll) {
            return 0L;
        }
        long l2 = super.getNextIncludedTime(l);
        if (l2 > 0L && l2 > l) {
            l = l2;
        }
        if (!this.isDayExcluded(n = (calendar = this.getStartOfDayJavaCalendar(l)).get(7))) {
            return l;
        }
        while (this.isDayExcluded(n)) {
            calendar.add(5, 1);
            n = calendar.get(7);
        }
        return calendar.getTime().getTime();
    }
}

