/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.util.HashSet;
import org.quartz.impl.jdbcjobstore.Constants;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.TablePrefixAware;
import org.quartz.impl.jdbcjobstore.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBSemaphore
implements Constants,
Semaphore,
StdJDBCConstants,
TablePrefixAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    ThreadLocal<HashSet<String>> lockOwners = new ThreadLocal();
    private String sql;
    private String insertSql;
    private String tablePrefix;
    private String schedName;
    private String expandedSQL;
    private String expandedInsertSQL;
    private String schedNameLiteral = null;

    public DBSemaphore(String string, String string2, String string3, String string4) {
        this.tablePrefix = string;
        this.schedName = string2;
        this.setSQL(string3);
        this.setInsertSQL(string4);
    }

    protected Logger getLog() {
        return this.log;
    }

    private HashSet<String> getThreadLocks() {
        HashSet<String> hashSet = this.lockOwners.get();
        if (hashSet == null) {
            hashSet = new HashSet();
            this.lockOwners.set(hashSet);
        }
        return hashSet;
    }

    protected abstract void executeSQL(Connection var1, String var2, String var3, String var4);

    @Override
    public boolean obtainLock(Connection connection, String string) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '" + string + "' is desired by: " + Thread.currentThread().getName());
        }
        if (!this.isLockOwner(string)) {
            this.executeSQL(connection, string, this.expandedSQL, this.expandedInsertSQL);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Lock '" + string + "' given to: " + Thread.currentThread().getName());
            }
            this.getThreadLocks().add(string);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Lock '" + string + "' Is already owned by: " + Thread.currentThread().getName());
        }
        return true;
    }

    @Override
    public void releaseLock(String string) {
        if (this.isLockOwner(string)) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Lock '" + string + "' returned by: " + Thread.currentThread().getName());
            }
            this.getThreadLocks().remove(string);
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().warn("Lock '" + string + "' attempt to return by: " + Thread.currentThread().getName() + " -- but not owner!", (Throwable)new Exception("stack-trace of wrongful returner"));
        }
    }

    public boolean isLockOwner(String string) {
        return this.getThreadLocks().contains(string);
    }

    @Override
    public boolean requiresConnection() {
        return true;
    }

    protected String getSQL() {
        return this.sql;
    }

    protected void setSQL(String string) {
        if (string != null && string.trim().length() != 0) {
            this.sql = string.trim();
        }
        this.setExpandedSQL();
    }

    protected void setInsertSQL(String string) {
        if (string != null && string.trim().length() != 0) {
            this.insertSql = string.trim();
        }
        this.setExpandedSQL();
    }

    private void setExpandedSQL() {
        if (this.getTablePrefix() != null && this.getSchedName() != null && this.sql != null && this.insertSql != null) {
            this.expandedSQL = Util.rtp(this.sql, this.getTablePrefix(), this.getSchedulerNameLiteral());
            this.expandedInsertSQL = Util.rtp(this.insertSql, this.getTablePrefix(), this.getSchedulerNameLiteral());
        }
    }

    protected String getSchedulerNameLiteral() {
        if (this.schedNameLiteral == null) {
            this.schedNameLiteral = "'" + this.schedName + "'";
        }
        return this.schedNameLiteral;
    }

    public String getSchedName() {
        return this.schedName;
    }

    @Override
    public void setSchedName(String string) {
        this.schedName = string;
        this.setExpandedSQL();
    }

    protected String getTablePrefix() {
        return this.tablePrefix;
    }

    @Override
    public void setTablePrefix(String string) {
        this.tablePrefix = string;
        this.setExpandedSQL();
    }
}

