/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap$PlatformMutabilityMapping;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementUtilsKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.TypeSystemCommonBackendContext;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;

public final class TypeSignatureMappingKt {
    public static final <T> T boxTypeIfNeeded(JvmTypeFactory<T> jvmTypeFactory, T t, boolean bl) {
        Intrinsics.checkNotNullParameter(jvmTypeFactory, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        if (bl) {
            return jvmTypeFactory.boxType(t);
        }
        return t;
    }

    public static final <T> T mapBuiltInType(TypeSystemCommonBackendContext object, KotlinTypeMarker object2, JvmTypeFactory<T> jvmTypeFactory, TypeMappingMode object3) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        Intrinsics.checkNotNullParameter(jvmTypeFactory, (String)"");
        Intrinsics.checkNotNullParameter((Object)object3, (String)"");
        Object object4 = object.typeConstructor((KotlinTypeMarker)object2);
        if (!object.isClassTypeConstructor((TypeConstructorMarker)object4)) {
            return null;
        }
        PrimitiveType primitiveType = object.getPrimitiveType((TypeConstructorMarker)object4);
        if (primitiveType != null) {
            primitiveType = jvmTypeFactory.createPrimitiveType(primitiveType);
            boolean bl = object.isNullableType((KotlinTypeMarker)object2) || TypeEnhancementUtilsKt.hasEnhancedNullability((TypeSystemCommonBackendContext)object, (KotlinTypeMarker)object2);
            return (T)((Object)TypeSignatureMappingKt.boxTypeIfNeeded(jvmTypeFactory, primitiveType, bl));
        }
        primitiveType = object.getPrimitiveArrayType((TypeConstructorMarker)object4);
        if (primitiveType != null) {
            return jvmTypeFactory.createFromString("[" + JvmPrimitiveType.get(primitiveType).getDesc());
        }
        if (object.isUnderKotlinPackage((TypeConstructorMarker)object4)) {
            Object object5;
            FqNameUnsafe fqNameUnsafe = object.getClassFqNameUnsafe((TypeConstructorMarker)object4);
            if (fqNameUnsafe != null) {
                object = fqNameUnsafe;
                object2 = JavaToKotlinClassMap.INSTANCE;
                object4 = object;
                object5 = ((JavaToKotlinClassMap)object2).mapKotlinToJava((FqNameUnsafe)object4);
            } else {
                object5 = object = null;
            }
            if (object5 != null) {
                if (!((TypeMappingMode)object3).getKotlinCollectionsToJavaCollections()) {
                    boolean bl;
                    object2 = JavaToKotlinClassMap.INSTANCE.getMutabilityMappings();
                    if (!(object2 instanceof Collection) || !((Collection)object2).isEmpty()) {
                        object2 = object2.iterator();
                        while (object2.hasNext()) {
                            object4 = object2.next();
                            object3 = (JavaToKotlinClassMap$PlatformMutabilityMapping)object4;
                            if (!Intrinsics.areEqual((Object)((JavaToKotlinClassMap$PlatformMutabilityMapping)object3).getJavaClass(), (Object)object)) continue;
                            bl = true;
                            break;
                        }
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        return null;
                    }
                }
                String string = JvmClassName.byClassId((ClassId)object).getInternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                return jvmTypeFactory.createObjectType(string);
            }
        }
        return null;
    }
}

